/*
 *  polyFactor.h
 *  fp
 *
 *  Created by Robert Delaney on 6/4/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

void polySquareFree(poly*& z, int& numPolys, const poly& x);
void polySquareFreeModq(poly*& z, int& numPolys, const poly& x, double q);
void findPowersOfSquareFreeFactors(char*& zString, int& numPolys, const poly& x);
void findPowersOfSquareFreeFactors(poly*& z1, int*& theExp, int& numPolys, const poly& x);
void polyFactorOverIntegers(poly*& factors, int& numFactors, int*& power, const poly& f);
//void polyFactorOverpActual(poly*& factors, int& numFactors, const poly& f, double p);
//bool findPolyPower(poly& g, int& e, const poly& f, double q);
//void polyFactorOverpFirst(poly*& factors, int& numFactors, int* power, const poly& f, double p);
void polyFactorOverpPenUlt(poly*& factors, int& numFactors, int*& power, const poly& f, double p);
void polyCalcQmatrix(matq& Q, const poly& a, double q);
void polySquareFree2(matq& z, const poly& x);
void polySFfindFactor(poly& z, const poly& a, const matq& nullVectors, double q);
void polySFfindAllFactors(INT32& numFactors, poly*& factor, const poly& a, const matq& nullVectors, double q);
void polySFfindTrueFactors(INT32& numFactors, poly*& factor, const poly& x);
void polySFfindTrueFactors2(matq& factorMatrix, const poly& x);
void polyFromMatrixRow(poly& z, int theRow, const matq& x);
void findPowersOfSquareFreeFactors(matq& z, int*& theExp, int& numPolys, const poly& x);
void findPowersOfSquareFreeFactors(matq& z, matq& theExpColM, int& numPolys, const poly& x);
bool polyFindOneFactor(poly& z, const poly& a, const poly& v, double p);
bool polyFindAllFactors(poly*& factors, const poly& a, poly* polyNV, int& numFactors, int numNV, double q);
void polyFactorOverpForPlugin(matq& z, const poly& f, double p);
void polyFromMatq(poly& z, int& power, const matq& x, int rowNum);
void polyArrayToMatq(matq& z, const poly*& x, const int* power, int numPolys);
void polyArrayToString(char*& zString, const poly* x, const int* power, int numPolys);
void numPrimPolys(mb& z, const mb& p, const mb& m);
mb numPrimPolys(const mb& p, const mb& m);
void polyFactorOverp(poly*& factors, int& numFactors, int*& power, const poly& f, double p);
void polyFactorOverp(char*& outString, const poly& f, double p);
bool findPrimitivePolys(poly*& z, int& numPolys, int m, double p);
bool findPrimitivePolys(char*& outString, int m, double p);
bool findPolyRoots(fpComplex*& root, fpComplex*& Parray, const poly& x, bool doRoundToZero);
void polyFactorOverIntegers(poly*& z, int*& power, int& numFactors, bool& isGood, const poly& x);
void polyFactorOverIntegers(char*& outString, const poly& x);

