/*
 *  poly.cpp
 *  fp
 *
 *  Created by Robert Delaney on 4/27/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "bfMath.h"

// Constructor
poly::poly()
{
	deg = -1;
    array = NULL;
}

poly::~poly()
{
    INT32   i;
    
    if(array)
    {
        for(i=0;i<=deg;++i)
        {
            free(array[i].num.b);
            array[i].num.b = NULL;
            free(array[i].den.b);
            array[i].den.b = NULL;
        }
        free(array);
        array = NULL;
    }
}

poly::poly(const char *inString)
{
	if(!polyConvFromString(*this, inString))
	{
		deg = -1;
		array = NULL;
	}
}

poly poly::operator- ()
{
	poly		z;
	INT32		i;
	
	z = *this;
	
	for(i=0;i<=z.deg;i++)
		z.array[i] = -z.array[i];
	
	return z;
}


poly poly::operator- () const
{
	poly		z;
	INT32		i;
	
	z = *this;
	
	for(i=0;i<=z.deg;i++)
		z.array[i] = -z.array[i];
	
	return z;
}


poly& poly::operator= (const poly& x)
{
	INT32	i;
	
    if(array)
    {
        for(i=0;i<=deg;++i)
        {
            array[i].num.n = array[i].num.nn = 0;
            free(array[i].num.b);
            array[i].num.b = NULL;
            array[i].den.n = array[i].den.nn = 0;
            free(array[i].den.b);
            array[i].den.b = NULL;
        }
        free(array);
        array = NULL;
    }
	
	if(x.deg<0)
	{
		deg = -1;
		array = NULL;
		return *this;
	}
	
	deg = x.deg;
	array = (bf*)malloc((deg+1)*sizeof(bf));
	if(!array)
		exit(1);
	
	for(i=0;i<=deg;i++)
    {
        init(array[i]);
        array[i] = x.array[i];
    }
	
	return *this;
}

poly& poly::operator= (const bf& x)
{
    INT32       i;
    
    if(array)
    {
        for(i=0;i<=deg;++i)
        {
            free(array[i].num.b);
            array[i].num.b = NULL;
            free(array[i].den.b);
            array[i].den.b = NULL;
        }
        free(array);
        array = NULL;
    }
    
	
	deg = 0;
	array = (bf*)malloc((deg+1)*sizeof(bf));
	if(!array)
		exit(1);
    
	init(array[0]);
	array[0] = x;
	
	return *this;
}

poly& poly::operator= (const mb& x)
{
    INT32   i;
    
    if(array)
    {
        for(i=0;i<=deg;++i)
        {
            free(array[i].num.b);
            array[i].num.b = NULL;
            free(array[i].den.b);
            array[i].den.b = NULL;
        }
        free(array);
        array = NULL;
    }
	
	deg = 0;
	array = (bf*)malloc((deg+1)*sizeof(bf));
	if(!array)
		exit(1);
	
    init(array[0]);
	array[0] = x;
	
	return *this;
}


poly& poly::operator= (double x)
{
    INT32   i;
    
    if(array)
    {
        for(i=0;i<=deg;++i)
        {
            free(array[i].num.b);
            array[i].num.b = NULL;
            free(array[i].den.b);
            array[i].den.b = NULL;
        }
        free(array);
        array = NULL;
    }
	
	deg = 0;
	array = (bf*)malloc((deg+1)*sizeof(bf));
	if(!array)
		exit(1);
	
    init(array[0]);
    array[0] = x;
	
	return *this;
}

bool poly::operator== (const poly& y)
{
	if(compare(*this, y))
		return true;
	
	return false;
}

bool poly::operator!= (const poly& y)
{
	
	if(compare(*this, y))
		return false;
	
	return true;
}

bool poly::operator== (INT32 y)
{
    if((*this).deg>0)
        return false;
    
    if(array[deg]==y)
        return true;
    else
        return false;
}

bool poly::operator!= (INT32 y)
{
    if((*this).deg>0)
        return true;
    
    if(array[deg]==y)
        return false;
    else
        return true;
}

bool poly::operator== (const poly& y) const
{
    if(compare(*this, y))
        return true;
    
    return false;
}

bool poly::operator!= (const poly& y) const
{
    
    if(compare(*this, y))
        return false;
    
    return true;
}

bool poly::operator== (INT32 y) const
{
    if((*this).deg>0)
        return false;
    
    if(array[deg]==y)
        return true;
    else
        return false;
}

bool poly::operator!= (INT32 y) const
{
    if((*this).deg>0)
        return true;
    
    if(array[deg]==y)
        return false;
    else
        return true;
}

poly poly::operator% (const mb& y)
{
    poly        z;
    
    z = polyMod(*this, y);
    
    return z;
}

poly poly::operator% (const mb& y) const
{
    poly        z;
    
    z = polyMod(*this, y);
    
    return z;
}

poly poly::operator% (double y)
{
	poly		z;

	z = polyMod(*this, y);
	
	return z;
}

poly poly::operator% (double y) const
{
	poly		z;
	
	z = polyMod(*this, y);
	
	return z;
}


ostream& operator<< (ostream &s, const poly& x)
{
	char	*xString;
	
	polyConvToString(xString, x);
	s << xString;
	
	free(xString);
	
	return s;
}


istream& operator >>(istream &s, poly& x)
{
	char	xStr[1000]; // increase if needed
	bool	isGood;
	
	s.width(256); // increase if needed
	
	s >> xStr;
	
	isGood = polyConvFromString(x, xStr);
	
	if(!isGood)
		cerr << "conversion error!" << endl;
	
	return s;
}


poly poly::operator+ (const poly& y)
{
	poly		z;
	
	add(z, *this, y);
	
	return z;
}

poly poly::operator- (const poly& y)
{
	poly		z;
	
	sub(z, *this, y);
	
	return z;
}

poly poly::operator* (const poly& y)
{
	poly		z;
	
	mul(z, *this, y);
	
	return z;
}

poly poly::operator/ (const poly& y)
{
	poly		z;
	
	div(z, *this, y);
	
	return z;
}

poly poly::operator+ (const poly& y) const
{
	poly		z;
	
	add(z, *this, y);
	
	return z;
}

poly poly::operator- (const poly& y) const
{
	poly		z;
	
	sub(z, *this, y);
	
	return z;
}

poly poly::operator* (const poly& y) const
{
	poly		z;
	
	mul(z, *this, y);
	
	return z;
}

poly poly::operator/ (const poly& y) const
{
	poly		z;
	
	div(z, *this, y);
	
	return z;
}


poly poly::operator+ (const bf& y)
{
	poly		z;
	
	add(z, *this, y);
	
	return z;
}

poly poly::operator- (const bf& y)
{
	poly		z;
	
	sub(z, *this, y);
	
	return z;
}

poly poly::operator* (const bf& y)
{
	poly		z;
	
	mul(z, *this, y);
	
	return z;
}

poly poly::operator/ (const bf& y)
{
	poly		z;
	
	div(z, *this, y);
	
	return z;
}


poly poly::operator+ (const bf& y) const
{
	poly		z;
	
	add(z, *this, y);
	
	return z;
}

poly poly::operator- (const bf& y) const
{
	poly		z;
	
	sub(z, *this, y);
	
	return z;
}

poly poly::operator* (const bf& y) const
{
	poly		z;
	
	mul(z, *this, y);
	
	return z;
}

poly poly::operator/ (const bf& y) const
{
	poly		z;
	
	div(z, *this, y);
	
	return z;
}


poly operator+ (const bf& x, const poly& y)
{
	poly		z;
	
	add(z, x, y);
	
	return z;
}

poly operator- (const bf& x, const poly& y)
{
	poly		z;
	
	sub(z, x, y);
	
	return z;
}

poly operator* (const bf& x, const poly& y)
{
	poly		z;
	
	mul(z, x, y);
	
	return z;
}

poly operator/ (const bf& x, const poly& y)
{
	poly		z;
	
	div(z, x, y);
	
	return z;
}

