/*
 *  mbConv.h
 *  fp
 *
 *  Created by Robert Delaney on 4/24/09.
 *  Copyright 2009 __Bob Delaney's Science Software__. All rights reserved.
 *
 */

#pragma once

#include "mb.h"

void myFree(mb& x);
bool init(mb& x);
bool mbConvFromStr(mb& z, const char* decString);
void mbConvToStr(char*& xString, const mb& x);
void equateWithCare(mb& z, const mb& x);
void equate(mb& z, const mb& s);
void equate(mb& z, double x);
void equate(double& z, const mb& x);
bool equate(UINT8& z, const mb& x);
bool equate(INT8& z, const mb& x);
bool equate(UINT16& z, const mb& x);
bool equate(INT16& z, const mb& x);
bool equate(UINT32& z, const mb& x);
bool equate(INT32& z, const mb& x);
bool equate(UINT64& z, const mb& x);
bool equate(INT64& z, const mb& x);
bool equate(mb& z, char *xString);
void equate(mb& z, UINT8 x);
void equate(mb& z, INT8 x);
void equate(mb& z, UINT16 x);
void equate(mb& z, INT16 x);
void equate(mb& z, UINT32 x);
void equate(mb& z, INT32 x);
void equate(mb& z, UINT64 x);
void equate(mb& z, INT64 x);
void equate(char*& xString, const mb& x);
bool init(mb& x);
bool init(mb& x, char *inString);
bool init(mb& x, INT32 y);
bool init(mb& x, INT64 y);
void long32tomb(mb& z, long x);
void long64tomb(mb& z, long x);
