/*
 *  mb.h
 *  fp
 *
 *  Created by Robert Delaney on 4/22/09.
 *  Copyright 2009 __Bob Delaney's Science Software__. All rights reserved.
 *
 */

#pragma once

#define blockBits 32

#define INT8 char
#define UINT8 unsigned char
#define INT16 short
#define UINT16 unsigned short
#define INT32 int
#define UINT32 unsigned int
#define	INT64 long long int
#define UINT64 unsigned long long int

#include <iostream>

using namespace std;

class mb
{
	public:
	INT32				nn; // number of blocks malloced
	
	INT32				n;  // abs(n) = number of blocks in use; sign of n = sign of mb number
							// if n = 0 then mb = 0, b is not instantiated
	UINT32 				*b;  // b[0] is low order block; b[abs(n)-1] is high order block

	mb();
	mb(const char*);
	mb(double);
	
	~mb();
	
	mb operator- ();
	mb operator- () const;
	mb& operator= (const mb&);
	mb& operator= (double);
    mb& operator= (INT32);
    mb& operator= (INT64);
    mb& operator= (UINT32);
    mb& operator= (UINT64);
	bool operator> (const mb&);
	bool operator>= (const mb&);
	bool operator== (const mb&);
	bool operator!= (const mb&);
	bool operator> (INT32);
	bool operator>= (INT32);
	bool operator== (INT32);
	bool operator!= (INT32);
	bool operator! ();
	bool operator<= (const mb&);
	bool operator< (const mb&);
	bool operator> (const mb&) const;
	bool operator>= (const mb&) const;
	bool operator== (const mb&) const;
	bool operator!= (const mb&) const;
	bool operator! () const;
	bool operator<= (const mb&) const;
	bool operator< (const mb&) const;
	mb operator+ (const mb&);
	mb operator- (const mb&);
	mb operator* (const mb&);
	mb operator/ (const mb&);
	mb operator+ (const mb&) const;
	mb operator- (const mb&) const;
	mb operator* (const mb&) const;
	mb operator/ (const mb&) const;
	mb& operator+= (const mb&);
	mb& operator-= (const mb&);
	mb& operator*= (const mb&);
	mb& operator/= (const mb&);
	mb operator+ (double);
	mb operator- (double);
	mb operator* (double);
	mb operator/ (double);
	mb operator+ (double) const;
	mb operator- (double) const;
	mb operator* (double) const;
	mb operator/ (double) const;
	mb& operator+= (double);
	mb& operator-= (double);
	mb& operator*= (double);
	mb& operator/= (double);
	mb& operator&= (const mb&);
	mb& operator&= (INT32);
	mb operator& (const mb&);
	mb operator& (const mb&) const;
	mb operator& (INT32);
	mb operator& (INT32) const;
	mb& operator|= (const mb&);
	mb& operator|= (INT32);
	mb operator| (const mb&);
	mb operator| (const mb&) const;
	mb operator| (INT32);
	mb operator| (INT32) const;
	mb& operator^= (const mb&);
	mb& operator^= (INT32);
	mb operator^ (const mb&);
	mb operator^ (const mb&) const;
	mb operator^ (INT32);
	mb operator^ (INT32) const;
	mb operator<< (INT32);
	mb operator>> (INT32);
	mb& operator++ ();
	mb operator++ (int);
	mb& operator-- ();
	mb operator-- (int);
	mb operator% (const mb&);
	mb operator% (double);
	mb operator% (const mb&) const;
	mb operator% (double) const;
	//mb operator[] (int);
	//void* operator new[] (size_t);
	friend ostream& operator <<(ostream &s,const mb& x);
	friend istream& operator >>(istream &s, mb& x);
};

mb operator+ (double, mb&);
mb operator- (double, mb&);
mb operator* (double, mb&);
mb operator/ (double, mb&);

