/*
 *  matqConv.cpp
 *  fp
 *
 *  Created by Robert Delaney on 5/28/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#include "matq.h"
#include "matqConv.h"
#include "matmb.hpp"
#include "bfConv.h"
#include "stringUtils.h"

static char* matNULL()
{
    char    *z;
    
    z = (char*)malloc(5*sizeof(char));
    strcpy(z, "NULL");
    return z;
    
}/* matNULL */

void init(matq& z, INT32 nr, INT32 nc)
{
    INT32   i, j;
    
    if(!nr || !nc)
        return;
    
    z.nr = nr;
    z.nc = nc;
    z.array = (bf**)malloc(z.nr*sizeof(bf*));
    for(i=0;i<z.nr;i++)
        z.array[i] = (bf*)malloc(z.nc*sizeof(bf));
    
    for(i=0;i<z.nr;i++)
        for(j=0;j<z.nc;j++)
        {
            init(z.array[i][j]);
        }
    
}/* init */

void init(matq*& z, int nr, int nc, int numMats)
{
    int     i;
    
    z = (matq*)malloc(numMats*sizeof(matq));
    for(i=0;i<numMats;++i)
        init(z[i], nr, nc);
    
}/* init */

// fills matrix with bf rationals
// in xString row elements seperated by commas and rows seperated by semicolons
bool matqConvFromStr(matq& z, const char *xString)
{
    INT32		i, j, k;
    char		*rowString, *numString;
    char		*zString, ch;
    INT32		length, nr, nc;
    
    length = strlen(xString);
    
    if(!xString || !length)
    {
        z.nr = z.nc = 0;
        z.array = NULL;
        return false;
    }
    
    zString = (char*)malloc((length+1)*sizeof(char));
    zString[0] = 0;
    
    strcpy(zString, xString);
    
    // trim non-numerics from end of xtString
    i = length - 1;
    ch = zString[i];
    while((ch<'0' || ch>'9') && i>0)
    {
        ch = zString[--i];
    }
    zString[i+1] = 0;
    
    nr = CountFields(zString, ";");
    
    rowString = NthField(zString, ";", 1);
    
    nc = CountFields(rowString, ",");
    
    init(z, nr, nc);
    
    for(i=0;i<nr;i++)
    {
        for(j=0;j<nc;j++)
        {
            numString = NthField(rowString, ",", j+1);
            if(!bfConvFromStr(z.array[i][j], numString))
            {
                for(k=0;k<nr;k++)
                    free(z.array[k]);
                free(z.array);
                z.nr = z.nc = 0;
                z.array = NULL;
                return false;
            }
            free(numString);
        }
        
        free(rowString);
        if(i<(nr-1))
            rowString = NthField(zString, ";", i+2);
    }
    
    free(zString);
    
    return true;
    
}/* matqConvFromStr */


void matqConvToStr(char*& matqStr, const matq& x)
{
	INT32		i, j;
	char		*numStr;
	INT32		allNumLen;
    
    
    if(!&x)
    {
        matqStr = matNULL();
        return;
    }
	
	allNumLen = 0;
	
	for(i=0;i<x.nr;i++)
		for(j=0;j<x.nc;j++)
		{
			bfConvToStr(numStr, x.array[i][j]);
			allNumLen = allNumLen + strlen(numStr);
			free(numStr);
		}
	// account for commas, spaces, and semicolons	
	allNumLen = allNumLen + x.nr*x.nc + x.nr + 20;
	matqStr = (char*)malloc(allNumLen*sizeof(char));
	matqStr[0] = 0;
	
	for(i=0;i<x.nr;i++)
	{
		for(j=0;j<x.nc;j++)
		{
			bfConvToStr(numStr, x.array[i][j]);
			strcat(matqStr, numStr);
			if(j<(x.nc-1))
				strcat(matqStr, ",");
			free(numStr);
		}
		if(i<(x.nr-1))
			strcat(matqStr, ";");
	}
	
}/* matqConvToStr */

// should do z=x so memory is freed if necesssary
void matqConvFromMatmb(matq& z, const matmb& x)
{
    INT32   i, j;
    
    init(z, x.nr, x.nc);
    
    for(i=0;i<z.nr;++i)
        for(j=0;j<z.nc;++j)
            z.array[i][j] = x.array[i][j];

}/* matqConvFromMatmb */

