/*
 *  matq.cpp
 *  fp
 *
 *  Created by Robert Delaney on 5/28/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"

// Constructor
matq::matq()
{
    nr = 0;
    nc = 0;
    array = NULL;
}

matq::matq(INT32 nrows, INT32 ncols)
{
    if(nrows<1 || ncols<1)
    {
        nr = 0;
        nc = 0;
        array = NULL;
        return;
    }
    
    init(*this, nrows, ncols);
}

// destructor
matq::~matq()
{
    int       i, j;
    
    for(i=0;i<nr;++i)
    {
        for(j=0;j<nc;++j)
        {
            myFree(array[i][j]);
        }
        free(array[i]);
        array[i] = NULL;
    }
    free(array);
    array = NULL;
}

matq::matq(const char *inString)
{
	//matq		z;
	//INT32		i, j;
    
    nr = 0;
    nc = 0;
    array = NULL;
	
	if(!matqConvFromStr(*this, inString))
		exit(1);
}

matq& matq::operator= (const matq& x)
{
	INT32	i, j;
    
    myFree(*this);
	
	if(!x.array)
	{
		return *this;
	}
	
    init(*this, x.nr, x.nc);
	
	for(i=0;i<nr;i++)
		for(j=0;j<nc;j++)
			array[i][j] = x.array[i][j];
	
	return *this;
}

matq& matq::operator= (const matmb& x)
{
    myFree(*this);
    
    matqConvFromMatmb(*this, x);
    
    return *this;
}


matq matq::operator- ()
{
	matq		z;
	INT32		i, j;
	
	z = *this;
	for(i=0;i<z.nr;i++)
		for(j=0;j<z.nc;j++)
			z.array[i][j] = -z.array[i][j];
	
	return z;
}

matq matq::operator- () const
{
	matq		z;
	INT32		i, j;
	
	z = *this;
	for(i=0;i<z.nr;i++)
		for(j=0;j<z.nc;j++)
			z.array[i][j] = -z.array[i][j];
	
	return z;
}

bool matq::operator== (const matq& y)
{
	INT32		i, j;
	
	if((*this).nr!=y.nr || (*this).nc!=y.nc)
		return false;
	
	for(i=0;i<y.nr;i++)
		for(j=0;j<y.nc;j++)
			if((*this).array[i][j]!=y.array[i][j])
				return false;
	
	return true;
}

bool matq::operator!= (const matq& y)
{
	INT32		i, j;
	
	if((*this).nr!=y.nr || (*this).nc!=y.nc)
		return true;
	
	for(i=0;i<y.nr;i++)
		for(j=0;j<y.nc;j++)
			if((*this).array[i][j]!=y.array[i][j])
				return true;
	
	return false;
}

bool matq::operator! ()
{
	INT32		i, j;
	
	for(i=0;i<(*this).nr;i++)
		for(j=0;j<(*this).nc;j++)
			if((*this).array[i][j].num.n)
				return false;
	
	return true;
}

bool matq::operator== (const matq& y) const
{
	INT32		i, j;
	
	if((*this).nr!=y.nr || (*this).nc!=y.nc)
		return false;
	
	for(i=0;i<y.nr;i++)
		for(j=0;j<y.nc;j++)
			if((*this).array[i][j]!=y.array[i][j])
				return false;
	
	return true;
}

bool matq::operator!= (const matq& y) const
{
	INT32		i, j;
	
	if((*this).nr!=y.nr || (*this).nc!=y.nc)
		return true;
	
	for(i=0;i<y.nr;i++)
		for(j=0;j<y.nc;j++)
			if((*this).array[i][j]!=y.array[i][j])
				return true;
	
	return false;
}

bool matq::operator! () const
{
	INT32		i, j;
	
	for(i=0;i<(*this).nr;i++)
		for(j=0;j<(*this).nc;j++)
			if((*this).array[i][j].num.n)
				return false;
	
	return true;
}

matq matq::operator+ (const matq& y)
{
	matq		z;
	
	add(z, *this, y);
	
	return z;
}

matq matq::operator- (const matq& y)
{
	matq		z;
	
	sub(z, *this, y);
	
	return z;
}


matq matq::operator* (const matq& y)
{
	matq		z;
	
	mul(z, *this, y);
	
	return z;
}

matq matq::operator+ (const matq& y) const
{
	matq		z;
	
	add(z, *this, y);
	
	return z;
}

matq matq::operator- (const matq& y) const
{
	matq		z;
	
	sub(z, *this, y);
	
	return z;
}

matq matq::operator* (const matq& y) const
{
	matq		z;
	
	mul(z, *this, y);
	
	return z;
}

matq matq::operator* (const bf& y)
{
	matq		z;
	
	mul(z, *this, y);
	
	return z;
}

matq matq::operator/ (const matq& y)
{
    matq		z;
    
    div(z, *this, y);
    
    return z;
}


matq matq::operator% (const mb& y)
{
	matq		z;
	
	matqMod(z, *this, y);
	
	return z;
}


matq matq::operator% (const mb& y) const
{
	matq		z;
	
	matqMod(z, *this, y);
	
	return z;
}


matq matq::operator% (double y)
{
	matq		z;
	
	matqMod(z, *this, y);
	
	return z;
}


ostream& operator <<(ostream &s, const matq& x)
{
	char	*xString;
	
	matqConvToStr(xString, x);
	s << xString;
	
	free(xString);
	
	return s;
}


istream& operator >>(istream &s, matq& x)
{
	char	xStr[10000]; // increase if needed
	
	s.width(10000); // increase if needed
	
	s >> xStr;
	
	if(!matqConvFromStr(x, xStr))
		cerr << "conversion error!" << endl;
	
	return s;
}


matq operator* (const bf& x, const matq& y)
{
	matq		z;
	
	mul(z, y, x);
	
	return z;
}

matq operator* (const mb& x, const matq& y)
{
	matq		z;
	
	mul(z, y, x);
	
	return z;
}


matq operator* (double x, const matq& y)
{
	matq		z;
	
	mul(z, y, x);
	
	return z;
}

