//
//  matmb.cpp
//  fp
//
//  Created by Robert Delaney on 9/9/17.
//
//

#include "mbConv.h"
#include "matmb.hpp"
#include "matmbConv.hpp"
#include "matmbMath.hpp"

// Constructor
matmb::matmb()
{
    /*
     nr = 1;
     nc = 1;
     array = (mb**)malloc(nr*sizeof(mb*));
     array[0] = (mb*)malloc(nc*sizeof(mb));
     array[0][0] = 0;
     */
    nr = 0;
    nc = 0;
    array = NULL;
}

matmb::matmb(INT32 nrows, INT32 ncols)
{
    if(nrows<1 || ncols<1)
    {
        nr = 0;
        nc = 0;
        array = NULL;
        return;
    }
    
    init(*this, nrows, ncols);
}

// destructor
matmb::~matmb()
{
    INT32		i, j;
    
    if(array)
    {
        for(i=0;i<nr;i++)
            if(array[i])
            {
                for(j=0;j<nc;j++)
                {
                    free(array[i][j].b);
                    array[i][j].b = NULL;
                }
                free(array[i]);
            }
        free(array);
    }
}

matmb::matmb(const char *inString)
{
    //matmb		z;
    //INT32		i, j;
    
    nr = 0;
    nc = 0;
    array = NULL;
    
    if(!matmbConvFromStr(*this, inString))
        exit(1);
    /*
     nr = z.nr;
     nc = z.nc;
     
     array = (mb**)malloc(nr*sizeof(mb*));
     for(i=0;i<nr;i++)
     array[i] = (mb*)malloc(nc*sizeof(mb));
     
     for(i=0;i<nr;i++)
     for(j=0;j<nc;j++)
     array[i][j] = z.array[i][j];
     */
}

matmb& matmb::operator= (const matmb& x)
{
    INT32	i, j;
    
    if(!x.array)
    {
        return *this;
    }
    
    nr = x.nr;
    nc = x.nc;
    
    array = (mb**)malloc(nr*sizeof(mb*));
    for(i=0;i<nr;i++)
        array[i] = (mb*)malloc(nc*sizeof(mb));
    
    for(i=0;i<nr;i++)
        for(j=0;j<nc;j++)
        {
            init(array[i][j]);
        }
    
    for(i=0;i<nr;i++)
        for(j=0;j<nc;j++)
            array[i][j] = x.array[i][j];
    
    return *this;
}

matmb matmb::operator- ()
{
    matmb		z;
    INT32		i, j;
    
    z = *this;
    for(i=0;i<z.nr;i++)
        for(j=0;j<z.nc;j++)
            z.array[i][j] = -z.array[i][j];
    
    return z;
}

matmb matmb::operator- () const
{
    matmb		z;
    INT32		i, j;
    
    z = *this;
    for(i=0;i<z.nr;i++)
        for(j=0;j<z.nc;j++)
            z.array[i][j] = -z.array[i][j];
    
    return z;
}

bool matmb::operator== (const matmb& y)
{
    INT32		i, j;
    
    if((*this).nr!=y.nr || (*this).nc!=y.nc)
        return false;
    
    for(i=0;i<y.nr;i++)
        for(j=0;j<y.nc;j++)
            if((*this).array[i][j]!=y.array[i][j])
                return false;
    
    return true;
}

bool matmb::operator!= (const matmb& y)
{
    INT32		i, j;
    
    if((*this).nr!=y.nr || (*this).nc!=y.nc)
        return true;
    
    for(i=0;i<y.nr;i++)
        for(j=0;j<y.nc;j++)
            if((*this).array[i][j]!=y.array[i][j])
                return true;
    
    return false;
}

bool matmb::operator! ()
{
    INT32		i, j;
    
    for(i=0;i<(*this).nr;i++)
        for(j=0;j<(*this).nc;j++)
            if((*this).array[i][j].n)
                return false;
    
    return true;
}

bool matmb::operator== (const matmb& y) const
{
    INT32		i, j;
    
    if((*this).nr!=y.nr || (*this).nc!=y.nc)
        return false;
    
    for(i=0;i<y.nr;i++)
        for(j=0;j<y.nc;j++)
            if((*this).array[i][j]!=y.array[i][j])
                return false;
    
    return true;
}

bool matmb::operator!= (const matmb& y) const
{
    INT32		i, j;
    
    if((*this).nr!=y.nr || (*this).nc!=y.nc)
        return true;
    
    for(i=0;i<y.nr;i++)
        for(j=0;j<y.nc;j++)
            if((*this).array[i][j]!=y.array[i][j])
                return true;
    
    return false;
}

bool matmb::operator! () const
{
    INT32		i, j;
    
    for(i=0;i<(*this).nr;i++)
        for(j=0;j<(*this).nc;j++)
            if((*this).array[i][j].n)
                return false;
    
    return true;
}

matmb matmb::operator+ (const matmb& y)
{
    matmb		z;
    
    add(z, *this, y);
    
    return z;
}

matmb matmb::operator- (const matmb& y)
{
    matmb		z;
    
    sub(z, *this, y);
    
    return z;
}


matmb matmb::operator* (const matmb& y)
{
    matmb		z;
    
    mul(z, *this, y);
    
    return z;
}

matmb matmb::operator+ (const matmb& y) const
{
    matmb		z;
    
    add(z, *this, y);
    
    return z;
}

matmb matmb::operator- (const matmb& y) const
{
    matmb		z;
    
    sub(z, *this, y);
    
    return z;
}

matmb matmb::operator* (const matmb& y) const
{
    matmb		z;
    
    mul(z, *this, y);
    
    return z;
}

matmb matmb::operator* (const mb& y)
{
    matmb		z;
    
    mul(z, *this, y);
    
    return z;
}

matmb matmb::operator/ (const matmb& y)
{
    matmb		z;
    mb          maxDen;
    
    div(z, *this, y, maxDen);
    
    return z;
}

matmb matmb::operator/ (const mb& y)
{
    matmb		z;
    
    div(z, *this, y);
    
    return z;
}


matmb matmb::operator% (const mb& y)
{
    matmb		z;
    
    matmbMod(z, *this, y);
    
    return z;
}


matmb matmb::operator% (const mb& y) const
{
    matmb		z;
    
    matmbMod(z, *this, y);
    
    return z;
}


matmb matmb::operator% (double y)
{
    matmb		z;
    
    matmbMod(z, *this, y);
    
    return z;
}


ostream& operator <<(ostream &s, const matmb& x)
{
    char	*xString;
    
    matmbConvToStr(xString, x);
    s << xString;
    
    free(xString);
    
    return s;
}


istream& operator >>(istream &s, matmb& x)
{
    char	xStr[10000]; // increase if needed
    
    s.width(10000); // increase if needed
    
    s >> xStr;
    
    if(!matmbConvFromStr(x, xStr))
        cerr << "conversion error!" << endl;
    
    return s;
}


matmb operator* (const mb& x, const matmb& y)
{
    matmb		z;
    
    mul(z, y, x);
    
    return z;
}

matmb operator* (double x, const matmb& y)
{
    matmb		z;
    
    mul(z, y, x);
    
    return z;
}

