//
//  matfpMath.hpp
//  fp
//
//  Created by Robert Delaney on 2/1/17.
//
//

#ifndef matfpMath_hpp
#define matfpMath_hpp

#include <stdio.h>

#endif /* matfpMath_hpp */

#include "matfp.hpp"
#include "mb.h"
#include "matc.hpp"

void myFree(matfp& x);
INT32 matfpCompare(const matfp& x, const matfp& y);
void add(matfp& z, const matfp& x, const matfp& y);
void sub(matfp& z, const matfp& x, const matfp& y);
void mul(matfp& z, const matfp& x, const matfp& y);
void mul(matfp& z, const matfp& x, const fp& y);
void mul(matfp& z, const fp& x, const matfp& y);
void div(matfp& z, const matfp& x, const matfp& y);
void div(matfp& z, const matfp& x, const fp& y);
void mul(matfp& z, const matfp& x, const mb& y);
void mul(matfp& z, const mb& x, const matfp& y);
void div(matfp& z, const matfp& x, const mb& y);
void mul(matfp& z, const matfp& x, double y);
void mul(matfp& z, const double x, const matfp& y);
void div(matfp& z, const matfp& x, double y);
void matfpUnit(matfp& z, INT32 n);
matfp matfpUnit(INT32 n);
void transpose(matfp& z, const matfp& x);
matfp transpose(const matfp& x);
bool trace(fp& z, const matfp& x);
fp trace(const matfp& x);
void matfpGaussElim(matfp& z, INT32& swapParity, const matfp& x);
void matfpReduce(matfp& z, const matfp& x);
void inv(matfp& z, fp& determinant, const matfp& x);
matfp inv(const matfp& x);
fp determinant(const matfp& x);
bool power(matfp& z, const matfp& x, INT32 y);
void matfpRowAugment(matfp& z, const matfp& x, const matfp& y);
matfp matfpRowAugment(const matfp& x, const matfp& y);
void matfpColAugment(matfp& z, const matfp& x, const matfp& y);
matfp matfpColAugment(const matfp& x, const matfp& y);
bool LUdecomp(const matfp& A, matfp& P, matfp& L, matfp& U, INT32& swapParity);
long matfpRank(const matfp& x, const fp& zeroSet);
void matfpEigenvectors(matc& eigenvectors, matc& eigenvalues, long*& algMultiplicity, long*& geoMultiplicity, const matfp& x, long myDecPrec, const fp& zeroSet);
