//
//  matcMath.hpp
//  fp
//
//  Created by Robert Delaney on 2/2/17.
//
//

#ifndef matcMath_hpp
#define matcMath_hpp

#include <stdio.h>

#endif /* matcMath_hpp */

#include "matc.hpp"
#include "matfp.hpp"

void myFree(matc& x);
INT32 matcCompare(const matc& x, const matc& y);
void add(matc& z, const matc& x, const matc& y);
void add(matc& z, const matc& x, const matfp& y);
void add(matc& z, const matfp& x, const matc& y);
void sub(matc& z, const matc& x, const matc& y);
void sub(matc& z, const matc& x, const matfp& y);
void sub(matc& z, const matfp& x, const matc& y);
void mul(matc& z, const matc& x, const matc& y);
void mul(matc& z, const matc& x, const matfp& y);
void mul(matc& z, const matfp& x, const matc& y);
void mul(matc& z, const matc& x, const fp& y);
void mul(matc& z, const matc& x, const fp& y);
void mul(matc& z, const fp& x, const matc& y);
void mul(matc& z, const fpComplex& x, const matc& y);
void mul(matc& z, const matc& x, const fpComplex& y);
void div(matc& z, const matc& x, const fp& y);
void mul(matc& z, const matc& x, const mb& y);
void mul(matc& z, const mb& x, const matc& y);
void div(matc& z, const matc& x, const mb& y);
void mul(matc& z, const matc& x, double y);
void mul(matc& z, const double x, const matc& y);
void div(matc& z, const matc& x, double y);
void matcUnit(matc& z, INT32 n);
matc matcUnit(INT32 n);
void transpose(matc& z, const matc& x);
matc transpose(const matc& x);
bool trace(fpComplex& z, const matc& x);
fpComplex trace(const matc& x);
void matcGaussElim(matc& z, INT32& swapParity, const matc& x, const fp& zeroSet);
void matcReduce(matc& z, const matc& x, const fp& zeroSet);
void inv(matc& z, fpComplex& determinant, const matc& x);
matc inv(const matc& x);
fpComplex determinant(const matc& x);
bool power(matc& z, const matc& x, INT32 y);
void matcRowAugment(matc& z, const matc& x, const matc& y);
matc matcRowAugment(const matc& x, const matc& y);
void matcColAugment(matc& z, const matc& x, const matc& y);
matc matcColAugment(const matc& x, const matc& y);
bool LUdecomp(const matc& A, matc& P, matc& L, matc& U, INT32& swapParity);
long matcRank(const matc& x, const fp& zeroSet);
bool charPoly(fpComplex*& z, const matc& x);
bool matcEigenvalues(fpComplex*& z, fpComplex*& pArray, const matc& x, long myDecPrec);
void matcNullSpace(INT32& numNV, matc& nullVectors, const matc& x, const fp& zeroSet);
void matcEigenvectors(matc& eigenvectors, matc& eigenvalues, long*& algMultiplicity, long*& geoMultiplicity, const matc& x, long myDecPrec, const fp& zeroSet);

