/*
 *  fpPluginTypeDefs.h
 *  fp Plugin
 *
 *  Created by Robert Delaney on 1/21/11.
 *  Copyright 2011 Bob Delaney's Science Software. All rights reserved.
 *
 */

#include "bf.h"
#include "poly.h"
#include "matmb.hpp"
#include "matq.h"
#include "matfp.hpp"
#include "matc.hpp"
#include "matmbConv.hpp"
#include "matmbMath.hpp"

typedef struct
{
	mb 		i;
	
} BigIntegerData;

typedef struct
{
	fp 		f;
	
} BigFloatData;

typedef struct
{
	fpComplex 		c;
	
} BigComplexData;


typedef struct
{
	fpComplex* 		v; // complex vector
	int				n; // number of elements; 0 <= index <= n-1
	
} ComplexVectorData;


typedef struct
{
	bf		bfr;
	
} BigFractionData;


typedef struct
{
	poly		bp;
	
} BigPolyData;

typedef struct
{
    matmb		bm;
    
} BigIntegerMatrixData;

typedef struct
{
	matq		bm;
	
} BigFractionMatrixData;

typedef struct
{
    matfp		bm;
    
} BigFloatMatrixData;

typedef struct
{
    matc		bm;
    
} BigComplexMatrixData;

