#include "rb_plugin.h"
#include "fpComplex.h"
#include "fpComplexConv.h"
#include "fpPluginTypeDefs.h"
#include <iostream>
#include "DealWithGray.h"
#include "findPolyRoots.h"
#include "newRandom.h"
#include "polyConv.h"
#include "polyMath.h"
#include "matqConv.h"
#include "matqMath.h"
#include "polyFactor.h"
#include "matfpConv.hpp"
#include "matfpMath.hpp"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "intarray.hpp"


// BigMatrix -> BigFractionMatrix
// added BigFloatMatrix and BigComplexMatrix


using namespace std;

extern int	blockPrec;
extern int	decPrec;
int	precision = 16;
static REALstring nullString;

//#define kREALTextEncodingASCII	0x0600
//#define kREALTextEncodingUTF8	0x08000100

#define BadInputExcName	"fpBadInputException"
#define DivideByZeroExcName "fpDivideByZeroException"
#define	NilObjectExcName "fpNilObjectException"
#define NegativeNumberExcName "fpNegativeNumberException"
#define NegativeOrZeroExcName "fpNegativeOrZeroException"
#define BadEntryNumberExcName "fpBadEntryNumberException"
#define OverflowOrNegativeExcName "fpOverflowOrNegativeException"
#define PrecisionNotMetExcName "fpPrecisionNotMetException"

extern REALclassDefinition      IntArrayClass;
extern REALclassDefinition		BigIntegerClass;
extern REALclassDefinition		BigFloatClass;
extern REALclassDefinition		BigComplexClass;
extern REALclassDefinition		ComplexVectorClass;
extern REALclassDefinition		BigFractionClass;
extern REALclassDefinition		BigPolyClass;
extern REALclassDefinition		BigFractionMatrixClass;
//extern REALclassDefinition		BigIntegerMatrixClass;
extern REALclassDefinition		BigFloatMatrixClass;
extern REALclassDefinition		BigComplexMatrixClass;

REALclassRef  globalIntArrayref;
REALclassRef  globalBigIntegerRef;
REALclassRef  globalBigFloatRef;
REALclassRef  globalBigComplexRef;
REALclassRef  globalComplexVectorRef;
REALclassRef  globalBigFractionRef;
REALclassRef  globalBigPolyRef;
REALclassRef  globalBigFractionMatrixRef;
//REALclassRef  globalBigIntegerMatrixRef;
REALclassRef  globalBigFloatMatrixRef;
REALclassRef  globalBigComplexMatrixRef;
REALclassRef  globalBadInputRef;
REALclassRef  globalDivideByZeroRef;
REALclassRef  globalNilObjectRef;
REALclassRef  globalNegativeNumberRef;
REALclassRef  globalNegativeorZeroRef;
REALclassRef  globalBadEntryNumberRef;
REALclassRef  globalOverflowOrNegativeRef;
REALclassRef  globalPrecisionNotMetRef;

static void initNullString()
{
    nullString = REALBuildStringWithEncoding (nil, 0, kREALTextEncodingUTF8);
    
}/* initNullString */

static void IntArrayConstructor(REALobject instance)
{
    intarray        *data;
    
    // Get the class data
    data = (intarray *) REALGetClassData(instance, &IntArrayClass);
    
    if (data == nil)
        return;
    
    data->n = 0;
    data->array = nil;
    
}/* IntArrayConstructor */

static void IntArrayDestructor(REALobject instance)
{
    intarray        *data;
    
    // Get the class data
    data = (intarray *) REALGetClassData(instance, &IntArrayClass);
    
    if (data == nil)
        return;
    
    data->n = 0;
    free(data->array);
    
}/* IntArrayDestructor */

static long IAgetElement(REALobject instance, long index)
{
    intarray        *data;
    long            n;
    
    // Get the class data
    data = (intarray *) REALGetClassData(instance, &IntArrayClass);
    
    if (data == nil)
        return 0;
    
    n = data->n;
    if(index<0 || index>=n)
        return 0;
    
    return data->array[index];
    
}/* IAgetElement */

static long IAgetSize(REALobject instance)
{
    intarray        *data;
    
    // Get the class data
    data = (intarray *) REALGetClassData(instance, &IntArrayClass);
    
    if (data == nil)
        return 0;
    
    return data->n;
    
}/* IAgetSize */

static REALmethodDefinition IntArrayMethods[] = {
    { (REALproc) IntArrayConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
    { (REALproc) IntArrayDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) IAgetElement, REALnoImplementation, "GetElement(index As Integer) As Integer", REALconsoleSafe },
    { (REALproc) IAgetSize, REALnoImplementation, "GetSize() As Integer", REALconsoleSafe },
    
};

REALclassDefinition IntArrayClass = {
    kCurrentREALControlVersion,
    "IntArray",        // name of class
    nil,                // no superclasses
    sizeof(intarray),        // size of our data
    0,                            // for system use
    nil,                        // initializer
    nil,                        // finializer
    nil,                        // properties
    0,                            // property count
    IntArrayMethods,           // methods
    sizeof(IntArrayMethods) / sizeof(REALmethodDefinition),    // method count
    nil,                        // Events
    0,                            // Event count
    nil,                        // eventInstances
    0,                            // eventInstanceCount
    nil,                        // interface strings
    nil,                        // obsolete1
    0,                        // obsolete2
    nil,                        // constants
    0,                            // constantCount
    REALconsoleSafe,            // flags
    nil,                        // shared properties
    0,                            // sharedPropertyCount
    nil,                        // shared methods
    0,                            // sharedMethodCount
};


static void BigIntegerConstructor(REALobject instance)
{
	BigIntegerData		*data;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if (data == nil)
		return;
	
	init(data->i);
	
}/* BigIntegerConstructor */


static void BigIntegerConstructor2(REALobject instance, REALstring CStr)
{
	BigIntegerData		*data;
	char				*dataString;
	long                length;
    REALstringData      *outData;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if (data == nil)
		return;
    init(data->i);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        data->i.n = 0;
        return;
    }
    
	// now get the BigInteger number from CStr
    length = outData->length;
	dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
	dataString[length] = 0; // makes it a C string
    
	if(!mbConvFromStr(data->i, dataString))
	{
        REALDisposeStringData(outData);
        free(dataString);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return;
	}
	
    REALDisposeStringData(outData);
	free(dataString);
	
}/* BigIntegerConstructor2 */


static void BigIntegerConstructor3(REALobject instance, INT64 x)
{
	BigIntegerData		*data;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if (data == nil)
		return;

    data->i = x;
	
}/* BigIntegerConstructor3 */


static void BigIntegerConstructor4(REALobject instance, REALstring CStr, long baseFrom)
{
	BigIntegerData          *data;
	char                    *dataString, *inStr;
	long                    length;
    REALstringData      	*outData;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if (data == nil)
		return;
	
	init(data->i);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        data->i.n = 0;
        return;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
	inStr = BaseFromBase(dataString, 10, (int)baseFrom, 0, true);
	
	if(!mbConvFromStr(data->i, inStr))
	{
        REALDisposeStringData(outData);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return;
	}
	
    REALDisposeStringData(outData);
	free(dataString);
	free(inStr);
	
}/* BigIntegerConstructor4 */


static void BigIntegerDestructor(REALobject instance)
{
	BigIntegerData		*data;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if (data == nil)
		return;
    
    myFree(data->i);
	
}/* BigIntegerDestructor */


static REALstring BigIntegerToS(REALobject instance)
{
	BigIntegerData	*data;
	REALstring		str;
	char*			dataString;
	INT64           length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	
	if(data==nil)
	{
		return nullString;
	}
	
	dataString = mb2Str(data->i);
    length = strlen(dataString);
	
	str=REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	//memcpy ((char*)str->CString(), dataString, length); // to, from
	//REALSetStringEncoding(str, kREALTextEncodingUTF8); // kREALTextEncodingUTF8=0x08000100
	
	free(dataString);
	return str;
	
}/* BigIntegerToS */


static REALstring BigIntegerToS2(REALobject instance, long baseTo)
{
	BigIntegerData		*data;
	REALstring		str;
	char			*dataString, *outStr;
	INT64           length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	
	if(data==nil)
	{
		return nullString;
	}
	
	dataString = mb2Str(data->i);
	outStr = BaseFromBase(dataString, (int)baseTo, 10, 0, true);
	
	length = strlen(outStr);
	
	str=REALBuildStringWithEncoding (outStr, length, kREALTextEncodingUTF8);
	//memcpy ((char*)str->CString(), outStr, length); // to, from
	//REALSetStringEncoding(str, kREALTextEncodingUTF8); // kREALTextEncodingUTF8=0x08000100
	
	free(dataString);
	free(outStr);
	
	return str;
	
}/* BigIntegerToS2 */


static void convertBigIntegerToBigInteger(REALobject instance, REALobject x)
{
	BigIntegerData		*data, *xData;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
	{
		return;
	}
	
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(xData==nil)
		return;
	
    data->i = xData->i;
	
	return;
	
}/* convertBigIntegerToBigInteger */



 static void convertIntToBigInteger(REALobject instance, long x)
 {
	BigIntegerData			*data;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
	{
        return;
	}
	
     //equate(data->i, x);
     //data->i = x;
     
     if(sizeof(long)==4)
         long32tomb(data->i, x);
     else
         long64tomb(data->i, x);
     
 }/* convertIntToBigInteger */

/*
static void convertInt32ToBigInteger(REALobject instance, INT32 x)
{
	BigIntegerData			*data;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
	{
		return;
	}
 
    data->i = x;
	
}*//* convertInt32ToBigInteger */

/*
static void convertInt64ToBigInteger(REALobject instance, INT64 x)
{
    BigIntegerData			*data;
    
    // Get the class data
    data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
    
    if(data==nil)
    {
        return;
    }
 
    data->i = x;
    
}*//* convertInt64ToBigInteger */


static void convertDoubleToBigInteger(REALobject instance, double x)
{
	BigIntegerData			*data;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
	{
		return;
	}

    data->i = x;
	
}/* convertDoubleToBigInteger */


static void convertStringToBigInteger(REALobject instance, REALstring CStr)
{
    BigIntegerData		*data;
    char				*dataString;
    long                length;
    REALstringData      *outData;
    
    // Get the class data
    data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
    init(data->i);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        data->i.n = 0;
        return;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
    if(!mbConvFromStr(data->i, dataString))
    {
        REALDisposeStringData(outData);
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        free(dataString);
        return;
    }
    
    REALDisposeStringData(outData);
    free(dataString);
    
}/* convertStringToBigInteger */


/*static double convertBigIntegerToDouble(REALobject instance)
{
	BigIntegerData			*data;
	static fp			x;
	static bool			arrayGood=false;
	int				i;
	double				z;
	
	if(!arrayGood)
	{
		init(x);
		arrayGood = true;
	}
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
	{
		return 0;
	}
	
	x.i.n = data->i.n;
	update(x.i);
	for(i=0;i<abs(x.i.n);i++)
		x.i.b[i] = data->i.b[i];
	x.e = 0;
	
	z = x;  // if returns false?
	
	return z;
	
}*//* convertBigIntegerToDouble */

/*
static void convertUINT64ToBigInteger(REALobject instance, UINT64 x)
{
	BigIntegerData			*data;
	
	// Get the class data
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
	{
		return;
	}
	
    data->i = x;
	
}*//* convertUINT64ToBigInteger */


static REALobject NegateBigInteger(REALobject instance)
{
	REALobject	z;
	BigIntegerData		*data, *zData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return instance;
	
    zData->i = data->i;
	
	zData->i.n = -zData->i.n;
	
	return z;
	
}/* NegateBigInteger */


static REALobject AddBigInteger_BigInteger(REALobject instance, REALobject x)
{
	REALobject	z;
	BigIntegerData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	add(zData->i, data->i, xData->i);
	
	return z;
	
}/* AddBigInteger_BigInteger */


static REALobject SubBigInteger_BigInteger(REALobject instance, REALobject x)
{
	REALobject	z;
	BigIntegerData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->i, data->i, xData->i);
	
	return z;
	
}/* SubBigInteger_BigInteger */


static REALobject MulBigInteger_BigInteger(REALobject instance, REALobject x)
{
	REALobject	z;
	BigIntegerData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->i, data->i, xData->i);
	
	return z;
	
}/* MulBigInteger_BigInteger */


static REALobject DivBigInteger_BigInteger(REALobject instance, REALobject x)
{
	REALobject		z;
	BigIntegerData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(xData->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	div(zData->i, data->i, xData->i);
	
	return z;
	
}/* DivBigInteger_BigInteger */


static REALobject AddBigInteger_Int(REALobject instance, INT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	add(zData->i, data->i, x);
	
	return z;
	
}/* AddBigInteger_Int */


static REALobject AddBigInteger_D(REALobject instance, double x)
{
	REALobject			z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	add(zData->i, data->i, (int)x);
	
	return z;
	
}/* AddBigInteger_D */


static REALobject AddBigInteger_UINT8(REALobject instance, UINT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
    xt = x;
	
	add(zData->i, data->i, xt);
	
	return z;
	
}/* AddBigInteger_UINT8 */


static REALobject AddBigInteger_INT8(REALobject instance, INT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
    xt = x;
	
	add(zData->i, data->i, xt);
	
	return z;
	
}/* AddBigInteger_INT8 */


static REALobject AddBigInteger_UINT16(REALobject instance, UINT16 x)
{
	REALobject		z;
	BigIntegerData	*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
    xt = x;
	
	add(zData->i, data->i, xt);
	
	return z;
	
}/* AddBigInteger_UINT16 */


static REALobject AddBigInteger_INT16(REALobject instance, INT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	add(zData->i, data->i, xt);
	
	return z;
	
}/* AddBigInteger_INT16 */


static REALobject AddBigInteger_UINT32(REALobject instance, UINT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	add(zData->i, data->i, xt);
	
	return z;
	
}/* AddBigInteger_UINT32 */


static REALobject AddBigInteger_UINT64(REALobject instance, UINT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	add(zData->i, data->i, xt);
	
	return z;
	
}/* AddBigInteger_UINT64 */


static REALobject AddBigInteger_INT64(REALobject instance, INT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	add(zData->i, data->i, xt);
	
	return z;
	
}/* AddBigInteger_INT64 */


static REALobject SubBigInteger_Int(REALobject instance, INT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->i, data->i, x);
	
	return z;
	
}/* SubBigInteger_Int */


static REALobject SubInt_BigInteger(REALobject instance, INT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->i, x, data->i);
	
	return z;
	
}/* SubInt_BigInteger */


static REALobject SubBigInteger_D(REALobject instance, double x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->i, data->i, x);
	
	return z;
	
}/* SubBigInteger_D */


static REALobject SubD_BigInteger(REALobject instance, double x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->i, x, data->i);
	
	return z;
	
}/* SubD_BigInteger */


static REALobject SubBigInteger_UINT8(REALobject instance, UINT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, data->i, xt);
	
	return z;
	
}/* SubBigInteger_UINT8 */


static REALobject SubUINT8_BigInteger(REALobject instance, UINT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, xt, data->i);
	
	return z;
	
}/* SubUINT8_BigInteger */


static REALobject SubBigInteger_INT8(REALobject instance, INT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, data->i, xt);
	
	return z;
	
}/* SubBigInteger_INT8 */


static REALobject SubINT8_BigInteger(REALobject instance, INT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, xt, data->i);
	
	return z;
	
}/* SubINT8_BigInteger */


static REALobject SubBigInteger_UINT16(REALobject instance, UINT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, data->i, xt);
	
	return z;
	
}/* SubBigInteger_UINT16 */


static REALobject SubUINT16_BigInteger(REALobject instance, UINT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, xt, data->i);
	
	return z;
	
}/* SubUINT16_BigInteger */


static REALobject SubBigInteger_INT16(REALobject instance, INT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, data->i, xt);
	
	return z;
	
}/* SubBigInteger_INT16 */


static REALobject SubINT16_BigInteger(REALobject instance, INT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, xt, data->i);
	
	return z;
	
}/* SubINT16_BigInteger */


static REALobject SubBigInteger_UINT32(REALobject instance, UINT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, data->i, xt);
	
	return z;
	
}/* SubBigInteger_UINT32 */


static REALobject SubUINT32_BigInteger(REALobject instance, UINT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, xt, data->i);
	
	return z;
	
}/* SubUINT32_BigInteger */



static REALobject SubBigInteger_UINT64(REALobject instance, UINT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, data->i, xt);
	
	return z;
	
}/* SubBigInteger_UINT64 */


static REALobject SubUINT64_BigInteger(REALobject instance, UINT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, xt, data->i);
	
	return z;
	
}/* SubUINT64_BigInteger */


static REALobject SubBigInteger_INT64(REALobject instance, INT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, data->i, xt);
	
	return z;
	
}/* SubBigInteger_INT64 */


static REALobject SubINT64_BigInteger(REALobject instance, INT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	sub(zData->i, xt, data->i);
	
	return z;
	
}/* SubINT64_BigInteger */


static REALobject MulBigInteger_Int(REALobject instance, INT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->i, data->i, x);
	
	return z;
	
}/* MulBigInteger_Int */


static REALobject MulInt_BigInteger(REALobject instance, INT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->i, x, data->i);
	
	return z;
	
}/* MulInt_BigInteger */


static REALobject MulBigInteger_D(REALobject instance, double x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->i, data->i, x);
	
	return z;
	
}/* mulBigInteger_D */


static REALobject MulBigInteger_UINT8(REALobject instance, UINT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	mul(zData->i, data->i, xt);
	
	return z;
	
}/* MulBigInteger_UINT8 */


static REALobject MulBigInteger_INT8(REALobject instance, INT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	mul(zData->i, data->i, xt);
	
	return z;
	
}/* MulBigInteger_INT8 */


static REALobject MulBigInteger_UINT16(REALobject instance, UINT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	mul(zData->i, data->i, xt);
	
	return z;
	
}/* MulBigInteger_UINT16 */


static REALobject MulBigInteger_INT16(REALobject instance, INT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	mul(zData->i, data->i, xt);
	
	return z;
	
}/* MulBigInteger_INT16 */


static REALobject MulBigInteger_UINT32(REALobject instance, UINT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	mul(zData->i, data->i, xt);
	
	return z;
	
}/* MulBigInteger_UINT32 */


static REALobject MulBigInteger_UINT64(REALobject instance, UINT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	mul(zData->i, data->i, xt);
	
	return z;
	
}/* MulBigInteger_UINT64 */


static REALobject MulBigInteger_INT64(REALobject instance, INT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	mul(zData->i, data->i, xt);
	
	return z;
	
}/* MulBigInteger_INT64 */


static REALobject DivBigInteger_Int(REALobject instance, INT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	div(zData->i, data->i, x);
	
	return z;
	
}/* DivBigInteger_Int */


static REALobject DivInt_BigInteger(REALobject instance, INT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	div(zData->i, x, data->i);
	
	return z;
	
}/* DivInt_BigInteger */


static REALobject DivBigInteger_D(REALobject instance, double x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	div(zData->i, data->i, (int)x);
	
	return z;
	
}/* DivBigInteger_D */


static REALobject DivD_BigInteger(REALobject instance, double x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	div(zData->i, x, data->i);
	
	return z;
	
}/* DivD_BigInteger */


static REALobject DivBigInteger_UINT8(REALobject instance, UINT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, data->i, xt);
	
	return z;
	
}/* DivBigInteger_UINT8 */


static REALobject DivUINT8_BigInteger(REALobject instance, UINT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, xt, data->i);
	
	return z;
	
}/* DivUINT8_BigInteger */


static REALobject DivBigInteger_INT8(REALobject instance, INT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, data->i, xt);
	
	return z;
	
}/* DivBigInteger_INT8 */


static REALobject DivINT8_BigInteger(REALobject instance, INT8 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, xt, data->i);
	
	return z;
	
}/* DivINT8_BigInteger */


static REALobject DivBigInteger_UINT16(REALobject instance, UINT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, data->i, xt);
	
	return z;
	
}/* DivBigInteger_UINT16 */


static REALobject DivUINT16_BigInteger(REALobject instance, UINT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, xt, data->i);
	
	return z;
	
}/* DivUINT16_BigInteger */


static REALobject DivBigInteger_INT16(REALobject instance, INT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, data->i, xt);
	
	return z;
	
}/* DivBigInteger_INT16 */


static REALobject DivINT16_BigInteger(REALobject instance, INT16 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, xt, data->i);
	
	return z;
	
}/* DivINT16_BigInteger */


static REALobject DivBigInteger_UINT32(REALobject instance, UINT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, data->i, xt);
	
	return z;
	
}/* DivBigInteger_UINT32 */


static REALobject DivUINT32_BigInteger(REALobject instance, UINT32 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, xt, data->i);
	
	return z;
	
}/* DivUINT32_BigInteger */


static REALobject DivBigInteger_UINT64(REALobject instance, UINT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, data->i, xt);
	
	return z;
	
}/* DivBigInteger_UINT64 */


static REALobject DivUINT64_BigInteger(REALobject instance, UINT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, xt, data->i);
	
	return z;
	
}/* DivUINT64_BigInteger */


static REALobject DivBigInteger_INT64(REALobject instance, INT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, data->i, xt);
	
	return z;
	
}/* DivBigInteger_INT64 */


static REALobject DivINT64_BigInteger(REALobject instance, INT64 x)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return instance;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	equate(xt, x);
	
	div(zData->i, xt, data->i);
	
	return z;
	
}/* DivINT64_BigInteger */


static REALobject AbsBigInteger(REALobject instance)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return instance;
	
    zData->i = data->i;
	if(zData->i.n<0)
		zData->i.n = -zData->i.n;
	
	return z;
	
}/* AbsBigInteger */


static REALobject SqrBigInteger(REALobject instance)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return instance;
	
	mul(zData->i, data->i, data->i);
	
	return z;
	
}/* SqrBigInteger */


static REALobject SqrtBigInteger(REALobject instance)
{
	REALobject		z;
	BigIntegerData		*data, *zData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	if(data->i.n<0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return instance;
	
	sqrt(zData->i, data->i);
	
	return z;
	
}/* SqrtBigInteger */


// x^y
static REALobject PowBigInteger_D(REALobject instance, double y)
{
	REALobject		z;
	BigIntegerData		*xData, *zData;
	
	if(y==1)
		return instance;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	if(!power(zData->i, xData->i, (int)y))
	{
		REALobject err = REALnewInstanceWithClass(globalBadEntryNumberRef);
		REALRaiseException(err);
		return instance;
	}
	
	return z;
	
}/* PowBigInteger_D */


static REALobject BigInteger_mod_BigInteger(REALobject instance, REALobject x)
{
	REALobject			r;
	BigIntegerData		*data, *rData, *xData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	r = REALnewInstanceWithClass(globalBigIntegerRef);
	rData = (BigIntegerData *) REALGetClassData(r, &BigIntegerClass);
	
	if(rData==nil)
		return instance;
	
	if(xData->i.n==0)
	{
        rData->i = data->i;
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return r;
		
	}
	
	myModulus(rData->i, data->i, xData->i);
	
	return r;
	
}/* BigInteger_mod_BigInteger */


static REALobject BigInteger_mod_Int(REALobject instance, long x)
{
	REALobject			r;
	BigIntegerData		*data, *rData;
    mb                  xmb;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	r = REALnewInstanceWithClass(globalBigIntegerRef);
	rData = (BigIntegerData *) REALGetClassData(r, &BigIntegerClass);
	
	if(rData==nil)
		return instance;
	
	if(x==0)
	{
		equate(rData->i, data->i);
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return r;
		
	}
    
    if(sizeof(long)==4)
        long32tomb(xmb, x);
    else
        long64tomb(xmb, x);
	
	myModulus(rData->i, data->i, xmb);
	
	return r;
	
}/* BigInteger_mod_Int */


static long CompareBigInteger_BigInteger(REALobject instance, REALobject x)
{
	BigIntegerData		*data, *xData;
	
	if(instance==nil || x==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return 0;
	
	return compare(data->i, xData->i);
	
}/* CompareBigInteger_BigInteger */


static long CompareBigInteger_Int(REALobject instance, long x)
{
	BigIntegerData		*data;
	static mb		xmb;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xmb);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
    xmb = (int)x;
	return compare(data->i, xmb);
	
}/* CompareBigInteger_Int */


static long CompareBigInteger_D(REALobject instance, double x)
{
	BigIntegerData		*data;
	static mb		xmb;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xmb);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;

    xmb = x;
    
	return compare(data->i, xmb);
	
}/* CompareBigInteger_D */


static long CompareBigInteger_UINT8(REALobject instance, UINT8 x)
{
	BigIntegerData		*data;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
    xt = x;
    
	return compare(data->i, xt);
	
}/* CompareBigInteger_UINT8 */


static long CompareBigInteger_INT8(REALobject instance, INT8 x)
{
	BigIntegerData		*data;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
	equate(xt, x);
	
	return compare(data->i, xt);
	
}/* CompareBigInteger_INT8 */


static long CompareBigInteger_UINT16(REALobject instance, UINT16 x)
{
	BigIntegerData		*data;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
	equate(xt, x);
	
	return compare(data->i, xt);
	
}/* CompareBigInteger_UINT16 */


static long CompareBigInteger_INT16(REALobject instance, INT16 x)
{
	BigIntegerData		*data;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
	equate(xt, x);
	
	return compare(data->i, xt);
	
}/* CompareBigInteger_INT16 */


static long CompareBigInteger_UINT32(REALobject instance, UINT32 x)
{
	BigIntegerData		*data;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
	equate(xt, x);
	
	return compare(data->i, xt);
	
}/* CompareBigInteger_UINT32 */


static long CompareBigInteger_UINT64(REALobject instance, UINT64 x)
{
	BigIntegerData		*data;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
	equate(xt, x);
	
	return compare(data->i, xt);
	
}/* CompareBigInteger_UINT64 */


static long CompareBigInteger_INT64(REALobject instance, INT64 x)
{
	BigIntegerData		*data;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
	equate(xt, x);
	
	return compare(data->i, xt);
	
}/* CompareBigInteger_INT64 */


// returns random mb from 0 to 1 less than instance
static REALobject mbRand(REALobject instance)
{
	REALobject			z;
	BigIntegerData		*data, *zData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return instance;
	
    srand(time(NULL));
	if(!mbRandom(zData->i, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* mbRand */


// comstructs a random BigInteger of bit length n
static REALobject mbRand2(long n)
{
	REALobject			z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	if(n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	mbRandom(zData->i, (int)n);
	
	return z;
	
}/* mbRand2 */



static bool mbIsItPrime(REALobject instance, long numTrials)
{
	BigIntegerData		*data;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return instance;
	
	return isItPrime(data->i, (int)numTrials);
	
}/* mbIsItPrime */


// counts the bits in instance
static int mbNumBits(REALobject instance)
{
	BigIntegerData		*data;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	
	if(data==nil)
		return 0;
	
	return NumBits(data->i);
	
}/* NumBits */


static REALobject myAnd(REALobject instance, REALobject x)
{
	REALobject			z;
	BigIntegerData		*data, *xData, *zData;
	
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = (data->i & xData->i);
	
	return z;
	
}/* myAnd */


static REALobject myAndInt(REALobject instance, long x)
{
	REALobject			z;
	BigIntegerData		*data, *zData;
	
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = (data->i & (int)x);
	
	return z;
	
}/* myAndInt */


static REALobject myOr(REALobject instance, REALobject x)
{
	REALobject			z;
	BigIntegerData		*data, *xData, *zData;
	
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = (data->i | xData->i);
	
	return z;
	
}/* myOr */


static REALobject myOrInt(REALobject instance, long x)
{
	REALobject			z;
	BigIntegerData		*data, *zData;
	
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = (data->i | (int)x);
	
	return z;
	
}/* myOrInt */


static REALobject myXor(REALobject instance, REALobject x)
{
	REALobject			z;
	BigIntegerData		*data, *xData, *zData;
	
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = (data->i ^ xData->i);
	
	return z;
	
}/* myXor */


static REALobject myXorInt(REALobject instance, long x)
{
	REALobject			z;
	BigIntegerData		*data, *zData;
	
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = (data->i ^ (int)x);
	
	return z;
	
}/* myXorInt */


static REALobject fpTwosComplement(REALobject instance)
{
	REALobject			z;
	BigIntegerData		*data, *zData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = twosComplement(data->i);
	
	return z;
	
}/* fpTwosComplement */


static REALobject fpTwosComplement2(REALobject instance, long numBlocks)
{
	REALobject			z;
	BigIntegerData		*data, *zData;
	
	data = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = twosComplement(data->i, (int)numBlocks);
	
	return z;
	
}/* fpTwosComplement2 */



static REALmethodDefinition BigIntegerMethods[] = {
	// defines methods:
	{ (REALproc) BigIntegerConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
	{ (REALproc) BigIntegerConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
	{ (REALproc) BigIntegerConstructor3, REALnoImplementation, "Constructor(x As Integer)", REALconsoleSafe },
	{ (REALproc) BigIntegerConstructor4, REALnoImplementation, "Constructor(inputString As String, baseFrom As Integer)", REALconsoleSafe },
    { (REALproc) BigIntegerDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
	{ (REALproc) BigIntegerToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
	{ (REALproc) BigIntegerToS2, REALnoImplementation, "Str(baseTo As Integer) As String", REALconsoleSafe },
	{ (REALproc) convertBigIntegerToBigInteger, REALnoImplementation, "Operator_Convert(x As BigInteger)", REALconsoleSafe },
    { (REALproc) convertStringToBigInteger, REALnoImplementation, "Operator_Convert(x As String)" , REALconsoleSafe },
    { (REALproc) convertIntToBigInteger, REALnoImplementation, "Operator_Convert(x As Integer)" , REALconsoleSafe },
	//{ (REALproc) convertInt32ToBigInteger, REALnoImplementation, "Operator_Convert(x As INT32)" , REALconsoleSafe },
    //{ (REALproc) convertInt64ToBigInteger, REALnoImplementation, "Operator_Convert(x As INT64)" , REALconsoleSafe },
    //{ (REALproc) convertDoubleToBigInteger, REALnoImplementation, "Operator_Convert(x As Double)", REALconsoleSafe },
	//{ (REALproc) convertBigIntegerToDouble, REALnoImplementation, "Operator_Convert() As Double", REALconsoleSafe },
	//{ (REALproc) convertUINT64ToBigInteger, REALnoImplementation, "Operator_Convert(x As UINT64)", REALconsoleSafe },
	{ (REALproc) NegateBigInteger, REALnoImplementation, "Operator_Negate() As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_BigInteger, REALnoImplementation, "Operator_Add(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_BigInteger, REALnoImplementation, "Operator_Subtract(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_BigInteger, REALnoImplementation, "Operator_Multiply(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_BigInteger, REALnoImplementation, "Operator_Divide(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_Int, REALnoImplementation, "Operator_Add(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_Int, REALnoImplementation, "Operator_AddRight(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_D, REALnoImplementation, "Operator_Add(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_D, REALnoImplementation, "Operator_AddRight(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT8, REALnoImplementation, "Operator_Add(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT8, REALnoImplementation, "Operator_AddRight(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_INT8, REALnoImplementation, "Operator_Add(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_INT8, REALnoImplementation, "Operator_AddRight(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT16, REALnoImplementation, "Operator_Add(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT16, REALnoImplementation, "Operator_AddRight(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_INT16, REALnoImplementation, "Operator_Add(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_INT16, REALnoImplementation, "Operator_AddRight(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT32, REALnoImplementation, "Operator_Add(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT32, REALnoImplementation, "Operator_AddRight(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT64, REALnoImplementation, "Operator_Add(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_UINT64, REALnoImplementation, "Operator_AddRight(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_INT64, REALnoImplementation, "Operator_Add(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) AddBigInteger_INT64, REALnoImplementation, "Operator_AddRight(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_Int, REALnoImplementation, "Operator_Subtract(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubInt_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_D, REALnoImplementation, "Operator_Subtract(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubD_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_UINT8, REALnoImplementation, "Operator_Subtract(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubUINT8_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_INT8, REALnoImplementation, "Operator_Subtract(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubINT8_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_UINT16, REALnoImplementation, "Operator_Subtract(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubUINT16_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_INT16, REALnoImplementation, "Operator_Subtract(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubINT16_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_UINT32, REALnoImplementation, "Operator_Subtract(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubUINT32_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_UINT64, REALnoImplementation, "Operator_Subtract(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubUINT64_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubBigInteger_INT64, REALnoImplementation, "Operator_Subtract(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) SubINT64_BigInteger, REALnoImplementation, "Operator_SubtractRight(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_Int, REALnoImplementation, "Operator_Multiply(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulInt_BigInteger, REALnoImplementation, "Operator_MultiplyRight(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_D, REALnoImplementation, "Operator_Multiply(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_D, REALnoImplementation, "Operator_MultiplyRight(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT8, REALnoImplementation, "Operator_Multiply(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT8, REALnoImplementation, "Operator_MultiplyRight(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_INT8, REALnoImplementation, "Operator_Multiply(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_INT8, REALnoImplementation, "Operator_MultiplyRight(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT16, REALnoImplementation, "Operator_Multiply(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT16, REALnoImplementation, "Operator_MultiplyRight(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_INT16, REALnoImplementation, "Operator_Multiply(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_INT16, REALnoImplementation, "Operator_MultiplyRight(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT32, REALnoImplementation, "Operator_Multiply(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT32, REALnoImplementation, "Operator_MultiplyRight(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT64, REALnoImplementation, "Operator_Multiply(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_UINT64, REALnoImplementation, "Operator_MultiplyRight(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_INT64, REALnoImplementation, "Operator_Multiply(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) MulBigInteger_INT64, REALnoImplementation, "Operator_MultiplyRight(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_Int, REALnoImplementation, "Operator_Divide(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivInt_BigInteger, REALnoImplementation, "Operator_DivideRight(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_D, REALnoImplementation, "Operator_Divide(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivD_BigInteger, REALnoImplementation, "Operator_DivideRight(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_UINT8, REALnoImplementation, "Operator_Divide(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivUINT8_BigInteger, REALnoImplementation, "Operator_DivideRight(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_INT8, REALnoImplementation, "Operator_Divide(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivINT8_BigInteger, REALnoImplementation, "Operator_DivideRight(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_UINT16, REALnoImplementation, "Operator_Divide(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivUINT16_BigInteger, REALnoImplementation, "Operator_DivideRight(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_INT16, REALnoImplementation, "Operator_Divide(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivINT16_BigInteger, REALnoImplementation, "Operator_DivideRight(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_UINT32, REALnoImplementation, "Operator_Divide(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivUINT32_BigInteger, REALnoImplementation, "Operator_DivideRight(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_UINT64, REALnoImplementation, "Operator_Divide(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivUINT64_BigInteger, REALnoImplementation, "Operator_DivideRight(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivBigInteger_INT64, REALnoImplementation, "Operator_Divide(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) DivINT64_BigInteger, REALnoImplementation, "Operator_DivideRight(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) AbsBigInteger, REALnoImplementation, "fpAbs() As BigInteger", REALconsoleSafe },
	{ (REALproc) SqrBigInteger, REALnoImplementation, "fpSqr() As BigInteger", REALconsoleSafe },
	{ (REALproc) SqrtBigInteger, REALnoImplementation, "fpSqrt() As BigInteger", REALconsoleSafe },
	{ (REALproc) PowBigInteger_D, REALnoImplementation, "Operator_Power(x As double) As BigInteger", REALconsoleSafe },
	{ (REALproc) BigInteger_mod_BigInteger, REALnoImplementation, "Operator_Modulo(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) BigInteger_mod_Int, REALnoImplementation, "Operator_Modulo(x As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_BigInteger, REALnoImplementation, "Operator_Compare(x As BigInteger) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_Int, REALnoImplementation, "Operator_Compare(x As Integer) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_D, REALnoImplementation, "Operator_Compare(x As Double) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_UINT8, REALnoImplementation, "Operator_Compare(x As UINT8) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_INT8, REALnoImplementation, "Operator_Compare(x As INT8) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_UINT16, REALnoImplementation, "Operator_Compare(x As UINT16) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_INT16, REALnoImplementation, "Operator_Compare(x As INT16) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_UINT32, REALnoImplementation, "Operator_Compare(x As UINT32) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigInteger_UINT64, REALnoImplementation, "Operator_Compare(x As UINT64) As Integer", REALconsoleSafe },
	//{ (REALproc) CompareBigInteger_INT64, REALnoImplementation, "Operator_Compare(x As INT64) As Integer", REALconsoleSafe },
	{ (REALproc) mbRand, REALnoImplementation, "fpRandom() As BigInteger", REALconsoleSafe },
	{ (REALproc) mbIsItPrime, REALnoImplementation, "fpIsItPrime(numTrials As Integer) As Boolean", REALconsoleSafe },
	{ (REALproc) mbNumBits, REALnoImplementation, "fpNumBits() As Integer", REALconsoleSafe },
	{ (REALproc) myAnd, REALnoImplementation, "Operator_And(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) myAndInt, REALnoImplementation, "Operator_And(x As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myAndInt, REALnoImplementation, "Operator_AndRight(x As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myOr, REALnoImplementation, "Operator_Or(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) myOrInt, REALnoImplementation, "Operator_Or(x As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myOrInt, REALnoImplementation, "Operator_OrRight(x As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myXor, REALnoImplementation, "Operator_Xor(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) myXorInt, REALnoImplementation, "Operator_Xor(x As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myXorInt, REALnoImplementation, "Operator_XorRight(x As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpTwosComplement, REALnoImplementation, "fpTwosComplement() As BigInteger", REALconsoleSafe },
	{ (REALproc) fpTwosComplement2, REALnoImplementation, "fpTwosComplement(numBlocks As Integer) As BigInteger", REALconsoleSafe },
	
};

REALclassDefinition BigIntegerClass = {
	kCurrentREALControlVersion,
	"BigInteger",		// name of class
	nil,				// no superclasses
	sizeof(BigIntegerData),		// size of our data
	0,							// for system use
	nil,						// initializer
	nil,						// finializer
	nil,            			// properties
	0,							// property count
	BigIntegerMethods,           // methods
	sizeof(BigIntegerMethods) / sizeof(REALmethodDefinition),	// method count
	nil,						// Events
	0,							// Event count
	nil,						// eventInstances
	0,							// eventInstanceCount
	nil,						// interface strings
	nil,						// obsolete1
	nil,						// obsolete2
	nil,						// constants
	0,							// constantCount
	REALconsoleSafe,			// flags
	nil,						// shared properties
	0,							// sharedPropertyCount
	nil,						// shared methods
	0,							// sharedMethodCount
};

// other BigInteger methods

static REALobject fpEquateBI_BI(REALobject x)
{
	REALobject		z;
	BigIntegerData		*zData, *xData;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = xData->i;
    
	return z;
	
}/* fpEquateBI_BI */


static REALobject fpEquateBI_D(double x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_D */


static double fpEquateD_BI(REALobject x)
{
	BigIntegerData		*xData;
	double			z;
	
	z = 0;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	equate(z, xData->i);
	
	return z;
	
}/* fpEquateD_BI */


static REALobject fpEquateBI_S(REALstring CStr)
{
	REALobject		z;
	BigIntegerData	*zData;
	char			*dataString;
	long            length;
    REALstringData  *outData;
    
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
    
    init(zData->i);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        zData->i.n = 0;
        return z;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
	
	if(!equate(zData->i, dataString))
	{
        REALDisposeStringData(outData);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		zData->i.n = 0;
		return z;
	}
	
    REALDisposeStringData(outData);
	return z;
	
}/* fpEquateBI_S */


static REALobject fpEquateBI_UINT8(UINT8 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_UINT8 */


static REALobject fpEquateBI_INT8(INT8 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_INT8 */


static REALobject fpEquateBI_UINT16(UINT16 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_UINT16 */


static REALobject fpEquateBI_INT16(INT16 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_INT16 */


static REALobject fpEquateBI_UINT32(UINT32 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_UINT32 */


static REALobject fpEquateBI_INT32(INT32 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_INT32 */


static REALobject fpEquateBI_UINT64(UINT64 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_UINT64 */


static REALobject fpEquateBI_INT64(INT64 x)
{
	REALobject		z;
	BigIntegerData		*zData;
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->i = x;
    
	return z;
	
}/* fpEquateBI_INT64 */


static UINT8 fpEquateUINT8_BI(REALobject x)
{
	BigIntegerData		*data;
	UINT8			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateUINT8_BI */


static INT8 fpEquateINT8_BI(REALobject x)
{
	BigIntegerData		*data;
	INT8			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateINT8_BI */


static UINT16 fpEquateUINT16_BI(REALobject x)
{
	BigIntegerData		*data;
	UINT16			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateUINT16_BI */


static INT16 fpEquateINT16_BI(REALobject x)
{
	BigIntegerData		*data;
	INT16			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateINT16_BI */


static UINT32 fpEquateUINT32_BI(REALobject x)
{
	BigIntegerData		*data;
	UINT32			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateUINT32_BI */


static INT32 fpEquateINT32_BI(REALobject x)
{
	BigIntegerData		*data;
	INT32			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateINT32_BI */


static UINT64 fpEquateUINT64_BI(REALobject x)
{
	BigIntegerData		*data;
	UINT64			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateUINT64_BI */


static INT64 fpEquateINT64_BI(REALobject x)
{
	BigIntegerData		*data;
	INT64			z;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	if(!equate(z, data->i))
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return 0;
	}
	
	return z;
	
}/* fpEquateINT64_BI */


static double logBI(REALobject x)
{
	BigIntegerData		*xData;
	double			z;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(xData==nil)
		return 0.;
	
	if(xData->i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return 0.;
	}
	
	log(z, xData->i);
	
	return z;
	
}/* logBI */


static double fpLg2BI(REALobject x)
{
	BigIntegerData	*xData;
	double			z;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
		return 0;
	
	if(xData->i.n<0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return 0;
	}
	
	z = Lg2(xData->i);
	
	return z;
	
}/* fpLg2BI */


// Finds z = b^(m*2^k)(mod n) where m is an integer mb
static REALobject mbPowerMod(REALobject b, REALobject m, long k, REALobject n)
{
	REALobject		z;
	BigIntegerData		*zData, *bData, *mData, *nData;
	bool			isNegative;
	
	bData = (BigIntegerData *) REALGetClassData(b, &BigIntegerClass);
	mData = (BigIntegerData *) REALGetClassData(m, &BigIntegerClass);
	nData = (BigIntegerData *) REALGetClassData(n, &BigIntegerClass);
	
	if(bData==nil || mData==nil || nData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return b;
	}
	
	if(bData->i.n<0 || (!bData->i.n && !mData->i.n) || nData->i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return b;
	}
		
		
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	if(mData->i.n<0)
	{
		isNegative = true;
		mData->i.n = -mData->i.n;
	}
	else
		isNegative = false;
	
	powerMod(zData->i, bData->i, mData->i, (int)k, nData->i);
	
	if(isNegative)
	{
		mData->i.n = -mData->i.n;
		if(!invMod(zData->i, zData->i, nData->i))
		{
			zData->i.n = 0;
		}
	}
	
	return z;
			 
}/* mbPowerMod */


static REALobject mbGCD(REALobject x, REALobject y)
{
	REALobject		z;
	BigIntegerData		*zData, *xData, *yData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	yData = (BigIntegerData *) REALGetClassData(y, &BigIntegerClass);
	
	if(xData==nil || yData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	gcd(zData->i, xData->i, yData->i);
	
	return z;
	
}/* mbGCD */


static void mbExtendedGCD(REALobject x, REALobject y, REALobject gcd, REALobject a, REALobject b)
{
	BigIntegerData		*xData, *yData, *gcdData, *aData, *bData;
	
	aData = (BigIntegerData *) REALGetClassData(a, &BigIntegerClass);
	bData = (BigIntegerData *) REALGetClassData(b, &BigIntegerClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	yData = (BigIntegerData *) REALGetClassData(y, &BigIntegerClass);
	gcdData = (BigIntegerData *) REALGetClassData(gcd, &BigIntegerClass);
	
	extendedGCD(xData->i, yData->i, gcdData->i, aData->i, bData->i);
	
}/* mbExtendedGCD */


// returns 0 if inverse mod doesn't exist
static REALobject mbInvMod(REALobject x, REALobject y)
{
	REALobject			z;
	BigIntegerData		*zData, *xData, *yData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	yData = (BigIntegerData *) REALGetClassData(y, &BigIntegerClass);
	
	if(xData==nil || yData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	if(yData->i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	
	if(zData==nil)
		return z;
	
	if(!invMod(zData->i, xData->i, yData->i))
	{
		zData->i.n = 0;
	}
	
	return z;
	
}/* mbInvMod */


static REALobject fpShiftRight(REALobject x, long n)
{
	REALobject		z;
	BigIntegerData		*zData, *xData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
		return z;
	
	mbShiftRight(zData->i, xData->i, (int)n);
	
	return z;
	
}/* fpShiftRight */


static REALobject fpShiftLeft(REALobject x, long n)
{
	REALobject		z;
	BigIntegerData		*zData, *xData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
		return z;
	
	mbShiftLeft(zData->i, xData->i, (int)n);
	
	return z;
	
}/* fpShiftLeft */


static bool fpIsItEven(REALobject x)
{
	BigIntegerData		*xData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	return isItEven(xData->i);
	
}/* fpIsItEven */


static REALobject fpNthRoot(REALobject x, long n)
{
	REALobject		z;
	BigIntegerData		*zData, *xData;
	
	if(n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return x;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	if(xData->i.n<0 && 2*(n/2)==n)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
		return z;
	
	nthRoot(zData->i, xData->i, (int)n);
	
	return z;
	
}/* fpNthRoot */


static REALobject mbFactorial(REALobject x)
{
	REALobject		z;
	BigIntegerData		*xData, *zData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	if(xData->i.n<0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	factorial(zData->i, xData->i);
	
	return z;
	
}/* mbFactorial */


static REALstring ConvBase(REALstring inStr, long baseTo, long baseFrom, long numPlaces, bool isUpperCase)
{
	REALstring		str;
	char			*myString, *outStr;
	long            length;
    REALstringData   *outData;

    outData = new REALstringData();
    
    if(!REALGetStringData(inStr, kREALTextEncodingUTF8, outData))
    {
        return nullString;
    }

    length = outData->length;
    myString = (char *)malloc((length+1)*sizeof(char));
    memcpy(myString, outData->data, length); // to, from
    myString[length] = 0; // makes it a C string
    
	outStr = DealWithGray(myString, (int)baseTo, (int)baseFrom, (int)numPlaces, isUpperCase); // calls BaseFromBase if not Gray
	
	length = strlen(outStr);
	if(length==0)
	{
        REALDisposeStringData(outData);
		REALobject err = REALnewInstanceWithClass(globalBadEntryNumberRef);
		REALRaiseException(err);
		free(outStr);
		return nullString;
	}
	
	str=REALBuildStringWithEncoding (outStr, length, kREALTextEncodingUTF8);
	//memcpy ((char*)str->CString(), outStr, length+1); // to, from
	
	//REALSetStringEncoding(str, kREALTextEncodingUTF8); // kREALTextEncodingUTF8=0x08000100
	REALDisposeStringData(outData);
	free(outStr);
	return str;
	
}/* ConvBase */


static bool fpIsItSquare(REALobject z, REALobject x)
{
	BigIntegerData		*xData, *zData;
	
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	return isItSquare(zData->i, xData->i);
	
}/* fpIsItSquare */


static int myCompareBits(REALobject x, REALobject y, long lowBitIndex, long highBitIndex)
{
	BigIntegerData		*xData, *yData;
	
	if(x==nil || y==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	yData = (BigIntegerData *) REALGetClassData(y, &BigIntegerClass);
	if(yData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	return mbCompareBits(xData->i, yData->i, (int)lowBitIndex, (int)highBitIndex);
	
}/* myCompareBits */


static REALobject mySetBit(REALobject x, long bitIndex)
{
	REALobject			z;
	BigIntegerData		*xData, *zData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	zData->i = mbSetBit(xData->i, (int)bitIndex);
	
	return z;
	
}/* mySetBit */


static REALobject myClearBit(REALobject x, long bitIndex)
{
	REALobject			z;
	BigIntegerData		*xData, *zData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	zData->i = mbClearBit(xData->i, (int)bitIndex);
	
	return z;
	
}/* myClearBit */


static REALobject myFlipBit(REALobject x, long bitIndex)
{
	REALobject			z;
	BigIntegerData		*xData, *zData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		
		
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	zData->i = mbFlipBit(xData->i, (int)bitIndex);
	
	return z;
	
}/* myFlipBit */


static int myGetBit(REALobject x, long bitIndex)
{
	BigIntegerData		*xData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	return mbGetBit(xData->i, (int)bitIndex);
	
}/* myGetBit */


static double fpRandNum()
{
	return randNum();
	
}/* fpRandNum */


static long fpRandN(long n)
{
	return (long)randN((int)n);
	
}/* fpRandN */


static long fpCountOnes(REALobject x)
{
	BigIntegerData		*xData;
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	return (long)mbCountOnes(xData->i);
	
}/* fpCountOnes */



static REALmethodDefinition otherBigIntegerMethods[] = {
	{ (REALproc) fpEquateBI_BI, REALnoImplementation, "fpEquateBI_BI(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_D, REALnoImplementation, "fpEquateBI_D(x As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateD_BI, REALnoImplementation, "fpEquateD_BI(x As BigInteger) As Double", REALconsoleSafe },
	{ (REALproc) fpEquateBI_S, REALnoImplementation, "fpEquateBI_S(inputString As String) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_UINT8, REALnoImplementation, "fpEquateBI_UINT8(x As UINT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_INT8, REALnoImplementation, "fpEquateBI_INT8(x As INT8) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_UINT16, REALnoImplementation, "fpEquateBI_UINT16(x As UINT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_INT16, REALnoImplementation, "fpEquateBI_INT16(x As INT16) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_UINT32, REALnoImplementation, "fpEquateBI_UINT32(x As UINT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_INT32, REALnoImplementation, "fpEquateBI_INT32(x As INT32) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_UINT64, REALnoImplementation, "fpEquateBI_UINT64(x As UINT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBI_INT64, REALnoImplementation, "fpEquateBI_INT64(x As INT64) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateUINT8_BI, REALnoImplementation, "fpEquateUINT8_BI(x As BigInteger) As UINT8", REALconsoleSafe },
	{ (REALproc) fpEquateINT8_BI, REALnoImplementation, "fpEquateINT8_BI(x As BigInteger) As INT8", REALconsoleSafe },
	{ (REALproc) fpEquateUINT16_BI, REALnoImplementation, "fpEquateUINT16_BI(x As BigInteger) As UINT16", REALconsoleSafe },
	{ (REALproc) fpEquateINT16_BI, REALnoImplementation, "fpEquateINT16_BI(x As BigInteger) As INT16", REALconsoleSafe },
	{ (REALproc) fpEquateUINT32_BI, REALnoImplementation, "fpEquateUINT32_BI(x As BigInteger) As UINT32", REALconsoleSafe },
	{ (REALproc) fpEquateINT32_BI, REALnoImplementation, "fpEquateINT32_BI(x As BigInteger) As INT32", REALconsoleSafe },
	{ (REALproc) fpEquateUINT64_BI, REALnoImplementation, "fpEquateUINT64_BI(x As BigInteger) As UINT64", REALconsoleSafe },
	{ (REALproc) fpEquateINT64_BI, REALnoImplementation, "fpEquateINT64_BI(x As BigInteger) As INT64", REALconsoleSafe },
	{ (REALproc) BigIntegerToS, REALnoImplementation, "Str(x As BigInteger) As String", REALconsoleSafe },
	{ (REALproc) BigIntegerToS2, REALnoImplementation, "Str(x As BigInteger, baseTo As Integer) As String", REALconsoleSafe },
	{ (REALproc) AbsBigInteger, REALnoImplementation, "fpAbsBI(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) SqrBigInteger, REALnoImplementation, "fpSqrBI(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) SqrtBigInteger, REALnoImplementation, "fpSqrtBI(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) PowBigInteger_D, REALnoImplementation, "fpPowBI(x As BigInteger, y As Double) As BigInteger", REALconsoleSafe },
	{ (REALproc) logBI, REALnoImplementation, "fpLogBI(x As BigInteger) As Double", REALconsoleSafe },
	{ (REALproc) fpLg2BI, REALnoImplementation, "fpLg2BI(x As BigInteger) As Double", REALconsoleSafe },
	{ (REALproc) mbRand, REALnoImplementation, "fpRandom(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) mbRand2, REALnoImplementation, "fpRandom2(n As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpRandNum, REALnoImplementation, "fpRandomDouble() As Double", REALconsoleSafe },
	{ (REALproc) fpRandN, REALnoImplementation, "fpRandomInteger(n As Integer) As Integer", REALconsoleSafe },
	{ (REALproc) mbIsItPrime, REALnoImplementation, "fpIsItPrime(x As BigInteger, numTrials As Integer) As Boolean", REALconsoleSafe },
	{ (REALproc) mbPowerMod, REALnoImplementation, "fpPowerMod(b As BigInteger, m As BigInteger, k As Integer, n As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) mbGCD, REALnoImplementation, "fpGCD(x As BigInteger, y As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) mbExtendedGCD, REALnoImplementation, "fpExtendedGCD(x As BigInteger, y As BigInteger, gcd As BigInteger, a As BigInteger, b As BigInteger)", REALconsoleSafe },
	{ (REALproc) mbInvMod, REALnoImplementation, "fpInvMod(x As BigInteger, y As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpShiftRight, REALnoImplementation, "fpShiftRight(x As BigInteger, n As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpShiftLeft, REALnoImplementation, "fpShiftLeft(x As BigInteger, n As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpIsItEven, REALnoImplementation, "fpIsItEven(x As BigInteger) As Boolean", REALconsoleSafe },
	{ (REALproc) fpNthRoot, REALnoImplementation, "fpNthRootBI(x As BigInteger, n As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) mbFactorial, REALnoImplementation, "fpFactorialBI(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) mbNumBits, REALnoImplementation, "fpNumBits(x As BigInteger) As Integer", REALconsoleSafe },
	{ (REALproc) ConvBase, REALnoImplementation, "fpConvBase(inStr As String, baseTo As Integer, baseFrom As Integer, numPlaces As Integer, toUpperCase As Boolean) As String", REALconsoleSafe },
	{ (REALproc) fpIsItSquare, REALnoImplementation, "fpIsItSquare(z As BigInteger, x As BigInteger) As Boolean", REALconsoleSafe },
	{ (REALproc) fpTwosComplement, REALnoImplementation, "fpTwosComplement(x As BigInteger) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpTwosComplement2, REALnoImplementation, "fpTwosComplement(x As BigInteger, numBlocks As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myCompareBits, REALnoImplementation, "fpCompareBits(x As BigInteger, y As BigInteger, lowBitIndex As Integer, highBitIndex As Integer) As Integer", REALconsoleSafe },
	{ (REALproc) mySetBit, REALnoImplementation, "fpSetBit(x As BigInteger, bitIndex As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myClearBit, REALnoImplementation, "fpClearBit(x As BigInteger, bitIndex As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myFlipBit, REALnoImplementation, "fpFlipBit(x As BigInteger, bitIndex As Integer) As BigInteger", REALconsoleSafe },
	{ (REALproc) myGetBit, REALnoImplementation, "fpGetBit(x As BigInteger, bitIndex As Integer) As Integer", REALconsoleSafe },
	{ (REALproc) fpCountOnes, REALnoImplementation, "fpCountOnes(x As BigInteger) As Integer", REALconsoleSafe },
	
};


// BigFloat Class

static void BigFloatConstructor(REALobject instance)
{
	BigFloatData		*data;
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if (data == nil)
		return;
	
	init(data->f);
	
}/* BigFloatConstructor */


static void BigFloatConstructor2(REALobject instance, REALstring CStr)
{
	BigFloatData	*data;
	char			*dataString;
	long            length;
    REALstringData  *outData;
    
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if (data == nil)
		return;
	
	init(data->f);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        data->f.i.n = 0;
        return;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
	if(!init(data->f, dataString))
	{
        free(dataString);
        REALDisposeStringData(outData);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return;
	}
	
    REALDisposeStringData(outData);
	free(dataString);
	
}/* BigFloatConstructor2 */


static void BigFloatConstructor3(REALobject instance, double x)
{
	BigFloatData		*data;
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if (data == nil)
		return;
	
	init(data->f, x);
	
}/* BigFloatConstructor3 */


static void BigFloatDestructor(REALobject instance)
{
	BigFloatData		*data;
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if (data == nil)
		return;
    
    myFree(data->f);
		
}/* BigFloatDestructor */


static REALstring BigFloatToS(REALobject instance)
{
	BigFloatData	*data;
	REALstring		str;
	char*			dataString;
	INT64           length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	
	if(data==nil)
	{
		return nullString;
	}
	
	dataString = fpToStr(data->f, decPrec);
	length = strlen(dataString);
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
}/* BigFloatToS */


static void convertBigFloatToBigFloat(REALobject instance, REALobject x)
{
	BigFloatData		*data, *xData;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return;
	}
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return;
	}
	
    data->f = xData->f;
	
}/* convertBigFloatToBigFloat */


/*static void convertIntToBigFloat(REALobject instance, INT32 x)
{
	BigFloatData			*data;
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
	{
		return;
	}
	
	data->f = x;
 
}*//* convertIntToBigFloat */


static void convertDoubleToBigFloat(REALobject instance, double x)
{
	BigFloatData			*data;
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
	{
		return;
	}
	
    data->f = x;
    
}/* convertDoubleToBigFloat */

static void convertStringToBigFloat(REALobject instance, REALstring CStr)
{
    BigFloatData	*data;
    char			*dataString;
    long             length;
    REALstringData   *outData;
    
    // Get the class data
    data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
    
    if(data==nil)
    {
        return;
    }
    
    init(data->f);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        data->f.i.n = 0;
        return;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
    if(!init(data->f, dataString))
    {
        REALDisposeStringData(outData);
        free(dataString);
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return;
    }
    
    REALDisposeStringData(outData);
    free(dataString);
    
}/* convertStringToBigFloat */


/*static double convertBigFloatToDouble(REALobject instance)
{
	BigFloatData		*data;
	double				z;
	
	
	// Get the class data
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
	{
		return 0;
	}
	
	equate(z, data->f);  // if returns false?
	
	return z;
	
}*//* convertBigFloatToDouble */


static REALobject NegateBigFloat(REALobject instance)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return instance;
	
    zData->f = data->f;
	zData->f.i.n = -zData->f.i.n;
	
	return z;
	
}/* NegateBigFloat*/


static REALobject AddBigFloat_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFloatData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	add(zData->f, data->f, xData->f);
	
	return z;
	
}/* AddBigFloat_BigFloat */


static REALobject SubBigFloat_BigFloat(REALobject instance, REALobject x)
{
	REALobject	z;
	BigFloatData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->f, data->f, xData->f);
	
	return z;
	
}/* SubBigFloat_BigFloat */


static REALobject MulBigFloat_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFloatData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->f, data->f, xData->f);
	
	return z;
	
}/* MulBigFloat_BigFloat */


static REALobject DivBigFloat_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFloatData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(xData->f.i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	div(zData->f, data->f, xData->f);
	
	return z;
	
}/* DivBigFloat_BigFloat */


static REALobject AddBigFloat_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	add(zData->f, data->f, xData->i);
	
	return z;
	
}/* AddBigFloat_BigInteger */


static REALobject SubBigFloat_BigInteger(REALobject instance, REALobject x)
{
	REALobject	z;
	BigFloatData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->f, data->f, xData->i);
	
	return z;
	
}/* SubBigFloat_BigInteger */


static REALobject SubBigInteger_BigFloat(REALobject instance, REALobject x)
{
	REALobject	z;
	BigFloatData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->f, xData->i, data->f);
	
	return z;
	
}/* SubBigInteger_BigFloat */


static REALobject MulBigFloat_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->f, data->f, xData->i);
	
	return z;
	
}/* MulBigFloat_BigInteger */


static REALobject DivBigFloat_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(xData->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	div(zData->f, data->f, xData->i);
	
	return z;
	
}/* DivBigFloat_BigInteger */


static REALobject DivBigInteger_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(data->f.i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	div(zData->f, xData->i, data->f);
	
	return z;
	
}/* DivBigInteger_BigFloat */


static REALobject AddBigFloat_I(REALobject instance, long x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
    fp                  xfp;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	if(sizeof(long)==4)
        long32tofp(xfp, x);
    else
        long64tofp(xfp, x);
    
	add(zData->f, data->f, xfp);
	
	return z;
	
}/* AddBigFloat_I */


static REALobject SubBigFloat_I(REALobject instance, long x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	fp                  xfp;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
    if(sizeof(long)==4)
        long32tofp(xfp, x);
    else
        long64tofp(xfp, x);
    
	sub(zData->f, data->f, xfp);
	
	return z;
	
}/* SubBigFloat_I */


static REALobject SubI_BigFloat(REALobject instance, long x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	fp                  xfp;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
    if(sizeof(long)==4)
        long32tofp(xfp, x);
    else
        long64tofp(xfp, x);
    
	sub(zData->f, xfp, data->f);
	
	return z;
	
}/* SubI_BigFloat */


static REALobject MulBigFloat_I(REALobject instance, long x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	fp                  xfp;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
    if(sizeof(long)==4)
        long32tofp(xfp, x);
    else
        long64tofp(xfp, x);
    
	mul(zData->f, data->f, xfp);
	
	return z;
	
}/* MulBigFloat_I */


static REALobject DivBigFloat_I(REALobject instance, long x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	fp                  xfp;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
    if(sizeof(long)==4)
        long32tofp(xfp, x);
    else
        long64tofp(xfp, x);
    
	div(zData->f, data->f, xfp);
	
	return z;
	
}/* DivBigFloat_I */


static REALobject DivI_BigFloat(REALobject instance, long x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	fp                  xfp;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	if(data->f.i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
    if(sizeof(long)==4)
        long32tofp(xfp, x);
    else
        long64tofp(xfp, x);
    
	div(zData->f, xfp, data->f);
	
	return z;
	
}/* DivI_BigFloat */



static REALobject AddBigFloat_D(REALobject instance, double x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	add(zData->f, data->f, x);
	
	return z;
	
}/* AddBigFloat_D */


static REALobject SubBigFloat_D(REALobject instance, double x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->f, data->f, x);
	
	return z;
	
}/* SubBigFloat_D */


static REALobject SubD_BigFloat(REALobject instance, double x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->f, x, data->f);
	
	return z;
	
}/* SubD_BigFloat */


static REALobject MulBigFloat_D(REALobject instance, double x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->f, data->f, x);
	
	return z;
	
}/* MulBigFloat_D */


static REALobject DivBigFloat_D(REALobject instance, double x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	div(zData->f, data->f, x);
	
	return z;
	
}/* DivBigFloat_D */


static REALobject DivD_BigFloat(REALobject instance, double x)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	if(data->f.i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	div(zData->f, x, data->f);
	
	return z;
	
}/* DivD_BigFloat */


static REALobject SqrBigFloat(REALobject instance)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return instance;
	
	mul(zData->f, data->f, data->f);
	
	return z;
	
}/* SqrBigFloat */


static REALobject SqrtBigFloat(REALobject instance)
{
	REALobject			z;
	BigFloatData		*data, *zData;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return instance;
	
	if(data->f.i.n<0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return instance;
	
	sqrt(zData->f, data->f);
	
	return z;
	
}/* SqrtBigFloat */


// x^y
static REALobject PowBigFloat_BigFloat(REALobject instance, REALobject y)
{
	REALobject			z;
	BigFloatData		*xData, *yData, *zData;
	INT32				yInt;
	fp					yt;
	bool				isGood;
	
	
	xData = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(xData==nil)
		return instance;
	
	yData = (BigFloatData *) REALGetClassData(y, &BigFloatClass);
	
	if(yData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	equate(yInt, yData->f);
	yt = yInt;
	
	if(yt==yData->f)
	{
		isGood = pow(zData->f, xData->f, yInt);
	}
	else
	{
		if(xData->f.i.n<0)
		{
			REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
			REALRaiseException(err);
			return instance;
		}
		pow(zData->f, xData->f, yData->f);
		isGood = true;
	}
	
	if(!isGood)
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
	}
	
	return z;
	
}/* PowBigFloat_BigFloat */


// x^y
static REALobject PowBigFloat_D(REALobject instance, double y)
{
	REALobject			z;
	BigFloatData		*xData, *zData;
	INT32				yInt;
	double				yt;
	bool				isGood;
	
	xData = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	isGood = true;
	yInt = y;
	yt = yInt;
	
	if(yt==y)
	{
		if(!power(zData->f, xData->f, yInt))
		{
			REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
			REALRaiseException(err);
			return instance;
		}
	}
	else
	{
		if(xData->f.i.n<0)
		{
			REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
			REALRaiseException(err);
			return instance;
		}
		isGood = pow(zData->f, xData->f, y);
	}
	
	if(!isGood)
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
	}
	
	return z;
	
}/* PowBigFloat_D */


// x^y
static REALobject PowBigFloat_Int(REALobject instance, INT32 y)
{
	REALobject			z;
	BigFloatData		*xData, *zData;
	bool				isGood;
	
	xData = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return z;
	
	isGood = pow(zData->f, xData->f, y);
	
	if(!isGood)
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
	}
	
	return z;
	
}/* PowBigFloat_Int */


static long CompareBigFloat_BigFloat(REALobject instance, REALobject x)
{
	BigFloatData		*data, *xData;
	
	if(instance==nil || x==nil)
		return 0;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return 0;
	
	return compare(data->f, xData->f);
	
}/* CompareBigFloat_BigFloat */


static long CompareBigFloat_Int(REALobject instance, int x)
{
	BigFloatData		*data;
	static fp			xfp;
	static bool			arrayGood=false;
	
	if(!arrayGood)
	{
		init(xfp);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return 0;
	
	equate(xfp, x);
	
	return compare(data->f, xfp);
	
}/* CompareBigFloat_Int */


static long CompareBigFloat_D(REALobject instance, double x)
{
	BigFloatData		*data;
	static fp			xfp;
	static bool			arrayGood=false;
	
	if(!arrayGood)
	{
		init(xfp);
		arrayGood = true;
	}
	
	if(instance==nil)
		return 0;
	
	data = (BigFloatData *) REALGetClassData(instance, &BigFloatClass);
	
	if(data==nil)
		return 0;
	
	equate(xfp, x);
	
	return compare(data->f, xfp);
	
}/* CompareBigFloat_D */


static REALmethodDefinition BigFloatMethods[] = {
	// defines methods:
	{ (REALproc) BigFloatConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
	{ (REALproc) BigFloatConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
	{ (REALproc) BigFloatConstructor3, REALnoImplementation, "Constructor(x As Double)", REALconsoleSafe },
    { (REALproc) BigFloatDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
	{ (REALproc) BigFloatToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
	{ (REALproc) convertBigFloatToBigFloat, REALnoImplementation, "Operator_Convert(x As BigFloat)", REALconsoleSafe },
    { (REALproc) convertStringToBigFloat, REALnoImplementation, "Operator_Convert(x As String)", REALconsoleSafe },
	{ (REALproc) convertDoubleToBigFloat, REALnoImplementation, "Operator_Convert(x As Double)", REALconsoleSafe },
	//{ (REALproc) convertBigFloatToDouble, REALnoImplementation, "Operator_Convert() As Double", REALconsoleSafe },
	{ (REALproc) NegateBigFloat, REALnoImplementation, "Operator_Negate() As BigFloat", REALconsoleSafe },
	{ (REALproc) AddBigFloat_BigFloat, REALnoImplementation, "Operator_Add(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) SubBigFloat_BigFloat, REALnoImplementation, "Operator_Subtract(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) MulBigFloat_BigFloat, REALnoImplementation, "Operator_Multiply(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) DivBigFloat_BigFloat, REALnoImplementation, "Operator_Divide(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) AddBigFloat_BigInteger, REALnoImplementation, "Operator_Add(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) AddBigFloat_BigInteger, REALnoImplementation, "Operator_AddRight(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) SubBigFloat_BigInteger, REALnoImplementation, "Operator_Subtract(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) SubBigInteger_BigFloat, REALnoImplementation, "Operator_SubtractRight(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) MulBigFloat_BigInteger, REALnoImplementation, "Operator_Multiply(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) MulBigFloat_BigInteger, REALnoImplementation, "Operator_MultiplyRight(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) DivBigFloat_BigInteger, REALnoImplementation, "Operator_Divide(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) DivBigInteger_BigFloat, REALnoImplementation, "Operator_DivideRight(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) AddBigFloat_D, REALnoImplementation, "Operator_Add(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) AddBigFloat_D, REALnoImplementation, "Operator_AddRight(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) SubBigFloat_D, REALnoImplementation, "Operator_Subtract(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) SubD_BigFloat, REALnoImplementation, "Operator_SubtractRight(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) MulBigFloat_D, REALnoImplementation, "Operator_Multiply(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) MulBigFloat_D, REALnoImplementation, "Operator_MultiplyRight(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) DivBigFloat_D, REALnoImplementation, "Operator_Divide(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) DivD_BigFloat, REALnoImplementation, "Operator_DivideRight(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) AddBigFloat_I, REALnoImplementation, "Operator_Add(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) AddBigFloat_I, REALnoImplementation, "Operator_AddRight(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) SubBigFloat_I, REALnoImplementation, "Operator_Subtract(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) SubI_BigFloat, REALnoImplementation, "Operator_SubtractRight(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) MulBigFloat_I, REALnoImplementation, "Operator_Multiply(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) MulBigFloat_I, REALnoImplementation, "Operator_MultiplyRight(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) DivBigFloat_I, REALnoImplementation, "Operator_Divide(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) DivI_BigFloat, REALnoImplementation, "Operator_DivideRight(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) SqrBigFloat, REALnoImplementation, "fpSqr() As BigFloat", REALconsoleSafe },
	{ (REALproc) SqrtBigFloat, REALnoImplementation, "fpSqrt() As BigFloat", REALconsoleSafe },
	{ (REALproc) PowBigFloat_D, REALnoImplementation, "Operator_Power(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) PowBigFloat_Int, REALnoImplementation, "Operator_Power(x As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) PowBigFloat_BigFloat, REALnoImplementation, "Operator_Power(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) CompareBigFloat_BigFloat, REALnoImplementation, "Operator_Compare(x As BigFloat) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigFloat_Int, REALnoImplementation, "Operator_Compare(x As Integer) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigFloat_D, REALnoImplementation, "Operator_Compare(x As Double) As Integer", REALconsoleSafe },
	
};


REALclassDefinition BigFloatClass = {
	kCurrentREALControlVersion,
	"BigFloat",		// name of class
	nil,				// no superclasses
	sizeof(BigFloatData),		// size of our data
	0,							// for system use
	nil,						// initializer
	nil,						// finializer
	nil,            			// properties
	0,							// property count
	BigFloatMethods,           // methods
	sizeof(BigFloatMethods) / sizeof(REALmethodDefinition),	// method count
	nil,						// Events
	0,							// Event count
	nil,						// eventInstances
	0,							// eventInstanceCount
	nil,						// interface strings
	nil,						// obsolete1
	nil,						// obsolete2
	nil,						// constants
	0,							// constantCount
	REALconsoleSafe,			// flags
	nil,						// shared properties
	0,							// sharedPropertyCount
	nil,						// shared methods
	0,							// sharedMethodCount
};


// other BigFloat methods

/*
static bool fpEquateBF_Str(REALobject z, REALstring CStr)
{
    BigFloatData	*zData;
    char			*dataString;
    long            length;
    REALstringData  *outData;
    
    
    // Get the class data
    zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
    
    if (zData == nil)
        return false;
    
    init(zData->f);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        zData->f.i.n = 0;
        return false;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
    if(!fpConvFromString(zData->f, dataString))
    {
        free(dataString);
        REALDisposeStringData(outData);
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return false;
    }
    
    REALDisposeStringData(outData);
    free(dataString);
    
    return true;
    
}*//* fpEquateBF_Str */


static REALobject fpEquateBF_BF(REALobject x)
{
	REALobject			z;
	BigFloatData		*zData, *xData;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->f = xData->f;
    
	return z;
	
}/* fpEquateBF_BF */


static REALobject fpEquateBF_D(double x)
{
	REALobject			z;
	BigFloatData		*zData;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->f = x;
    
	return z;
	
}/* fpEquateBF_D */


static double fpEquateD_BF(REALobject x)
{
	double				z;
	BigFloatData		*xData;
	
	z = 0;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	equate(z, xData->f);
	
	return z;
	
}/* fpEquateD_BF */


static REALobject fpEquateBF_S(REALstring CStr)
{
	REALobject			z;
	BigFloatData		*zData;
	char				*dataString;
	long                length;
    REALstringData      *outData;
   
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        zData->f.i.n = 0;
        return z;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
	
	if(!equate(zData->f, dataString))
	{
        free(dataString);
        REALDisposeStringData(outData);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return z;
	}
	
    REALDisposeStringData(outData);
    free(dataString);
	return z;
	
}/* fpEquateBF_S */


static REALobject fpEquateBI_BF(REALobject x)
{
	REALobject			z;
	BigFloatData		*xData;
	BigIntegerData			*zData;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	equate(zData->i, xData->f);

    return z;
	
}/* fpEquateBI_BF */


static REALobject fpEquateBF_BI(REALobject x)
{
	REALobject			z;
	BigFloatData		*zData;
	BigIntegerData			*xData;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
    zData->f = xData->i;
    
	return z;
	
}/* fpEquateBF_BI */


static void fpResetSeed(long seed)
{
	InitArray((int)seed);
	/*
	if(seed==0)
	{
		srand(time(NULL));
		return;
	}
	srand(seed);
	 */
	
}/* fpResetSeed */


static void SetPrecision(long prec)
{
	precision = (int)prec;
	blockPrec = precision/8 + 1;
	
}/* SetPrecision */


static int GetPrecision(void)
{
	return (long)precision;
	
}/* GetPrecision */


static void SetOutputPrecision(long prec)
{
	decPrec = (int)prec;
	
}/* SetOutputPrecision */


static int GetOutputPrecision(void)
{
	return (long)decPrec;
	
}/* GetOutputPrecision */


static REALobject LogBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	if(xData->f.i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	log(zData->f, xData->f);
	
	return z;
	
}/* LogBF */


static REALobject ExpBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	exp(zData->f, xData->f);
	
	return z;
	
}/* ExpBF */


static REALobject SinBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	sin(zData->f, xData->f);
	
	return z;
	
}/* SinBF */


static REALobject CosBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	cos(zData->f, xData->f);
	
	return z;
	
}/* CosBF */


static REALobject TanBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	tan(zData->f, xData->f);
	
	return z;
	
}/* TanBF */


static REALobject ASinBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	static fp		one;
	static bool		arrayGood=false;
	bool			isNegative;
	
	if(!arrayGood)
	{
		init(one, 1.);
		arrayGood = true;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	if(xData->f.i.n<0)
	{
		isNegative = true;
		xData->f.i.n = -xData->f.i.n;
	}
	else
		isNegative = false;
	
	if(compare(xData->f, one)==1)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		if(isNegative)
			xData->f.i.n = -xData->f.i.n;
		return x;
	}
	
	if(isNegative)
		xData->f.i.n = -xData->f.i.n;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	asin(zData->f, xData->f);
	
	return z;
	
}/* ASinBF */


static REALobject ACosBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	static fp		one;
	static bool		arrayGood=false;
	bool			isNegative;
	
	if(!arrayGood)
	{
		init(one, 1.);
		arrayGood = true;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	if(xData->f.i.n<0)
	{
		isNegative = true;
		xData->f.i.n = -xData->f.i.n;
	}
	else
		isNegative = false;
	
	if(compare(xData->f, one)==1)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		if(isNegative)
			xData->f.i.n = -xData->f.i.n;
		return x;
	}
	
	if(isNegative)
		xData->f.i.n = -xData->f.i.n;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	acos(zData->f, xData->f);
	
	return z;
	
}/* ACosBF */


static REALobject ATanBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	atan(zData->f, xData->f);
	
	return z;
	
}/* ATanBF */


static REALobject ATan2BF(REALobject y, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *yData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	yData = (BigFloatData *) REALGetClassData(y, &BigFloatClass);
	if(yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	atan2(zData->f, yData->f, xData->f);
	
	return z;
	
}/* ATan2BF */


static REALobject SinhBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	sinh(zData->f, xData->f);
	
	return z;
	
}/* SinhBF */


static REALobject CoshBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	cosh(zData->f, xData->f);
	
	return z;
	
}/* CoshBF */


static REALobject TanhBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	tanh(zData->f, xData->f);
	
	return z;
	
}/* TanhBF */


static REALobject ASinhBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
		
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	asinh(zData->f, xData->f);
	
	return z;
	
}/* ASinhBF */


static REALobject ACoshBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	static fp		one;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(one, 1.);
		arrayGood = true;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	if(compare(one, xData->f)==1)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	acosh(zData->f, xData->f);
	
	return z;
	
}/* ACoshBF */


static REALobject ATanhBF(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	static fp		one;
	static bool		arrayGood=false;
	bool			isNegative;
	
	if(!arrayGood)
	{
		init(one, 1.);
		arrayGood = true;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	if(xData->f.i.n<0)
	{
		isNegative = true;
		xData->f.i.n = -xData->f.i.n;
	}
	else
		isNegative = false;
	
	if(compare(xData->f, one)==1)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		if(isNegative)
			xData->f.i.n = -xData->f.i.n;
		return x;
	}
	
	if(isNegative)
		xData->f.i.n = -xData->f.i.n;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	atanh(zData->f, xData->f);
	
	return z;
	
}/* ATanhBF */


static REALobject fpGamma(REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *xData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	Gamma(zData->f, xData->f);
	
	return z;
	
}/* fpGamma */


static REALobject fpBesselJ(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = besselJ(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpBesselJ */


static REALobject fpBesselY(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = besselY(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpBesselY */


static REALobject fpBesselI(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = besselI(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpBesselI */


static REALobject fpBesselK(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = besselK(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpBesselK */


static REALobject fpBesselJzero(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = besselJzero(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpBesselJzero */


static REALobject fpBesselYzero(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = besselYzero(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpBesselYzero */


static REALobject fpSphericalBesselJ(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = sphericalBesselJ(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpSphericalBesselJ */


static REALobject fpSphericalBesselY(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *nData, *zData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = sphericalBesselY(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpSphericalBesselY */


static REALobject fpBeta(REALobject a, REALobject b)
{
	REALobject		z;
	BigFloatData	*zData, *aData, *bData;
	bool			isPrecisionGood;
	
	aData = (BigFloatData *) REALGetClassData(a, &BigFloatClass);
	if(aData==nil)
		return a;
	
	if((aData->f).i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return a;
	}
	
	bData = (BigFloatData *) REALGetClassData(b, &BigFloatClass);
	if(bData==nil)
		return b;
	
	if((bData->f).i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return b;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = beta(zData->f, aData->f, bData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpBeta */


static REALobject fpIbeta(REALobject a, REALobject b, REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *aData, *bData, *xData;
	bool			isPrecisionGood;
	fp				one=1.;
	
	aData = (BigFloatData *) REALGetClassData(a, &BigFloatClass);
	if(aData==nil)
		return a;
	
	if((aData->f).i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return a;
	}
	
	bData = (BigFloatData *) REALGetClassData(b, &BigFloatClass);
	if(bData==nil)
		return b;
	
	if((bData->f).i.n<=0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return b;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	if((xData->f).i.n<0 || xData->f>one)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return b;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = iBeta(zData->f, aData->f, bData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpIbeta */


static REALobject fpErf(REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *xData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = myErf(zData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpErf */


static REALobject fpErfc(REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *xData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = myErfc(zData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpErfc */


static REALobject fpFresnelS(REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *xData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = fresnelS(zData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpFresnelS */


static REALobject fpFresnelC(REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *xData;
	bool			isPrecisionGood;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = fresnelC(zData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpFresnelC */


static REALobject fpExpInt(REALobject n, REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *nData, *xData;
	fp				one=1.;
	bool			isPrecisionGood;
	
	nData = (BigFloatData *) REALGetClassData(n, &BigFloatClass);
	if(nData==nil)
		return n;
	
	if((nData->f).i.n<0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
		REALRaiseException(err);
		return n;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	if((xData->f).i.n<0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeNumberRef);
		REALRaiseException(err);
		return x;
	}
	
	if((nData->f).i.n==0 && (xData->f).i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return x;
	}
	
	if((xData->f).i.n==0 && nData->f<=one)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = expInt(zData->f, nData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalPrecisionNotMetRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpExpInt */


static REALobject fpKummerM(REALobject a, REALobject b, REALobject x)
{
	REALobject		z;
	BigFloatData	*zData, *aData, *bData, *xData;
	bool			isPrecisionGood;
	fp				one=1.;
	
	aData = (BigFloatData *) REALGetClassData(a, &BigFloatClass);
	if(aData==nil)
		return a;
	
	bData = (BigFloatData *) REALGetClassData(b, &BigFloatClass);
	if(bData==nil)
		return b;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	isPrecisionGood = kummerM(zData->f, aData->f, bData->f, xData->f);
	
	if(!isPrecisionGood)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpKummerM */


static REALobject fpPi()
{
	REALobject				z;
	BigFloatData			*zData;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	ComputePi(zData->f);
	
	return z;
	
}/* fpPi */


static REALobject fpEulerGamma()
{
	REALobject				z;
	BigFloatData			*zData;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	EulerGamma(zData->f);
	
	return z;
	
}/* fpEulerGamma */


static REALobject fpTrunc(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	static mb		xt;
	static bool		arrayGood=false;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	equate(xt, xData->f);
    zData->f = xt;
	return z;
	
}/* fpTrunc */


static REALobject fpRound(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	static mb		xt;
	static fp		xtt;
	static bool		arrayGood=false;
	bool			isNegative;
	
	if(!arrayGood)
	{
		init(xt);
		arrayGood = true;
	}
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	equate(xtt, xData->f);
	if(xtt.i.n<0)
	{
		xtt.i.n = -xtt.i.n;
		isNegative = true;
	}
	else
		isNegative = false;
	
	add(xtt, xtt, .5);
	if(isNegative)
		xtt.i.n = -xtt.i.n;
	
	equate(xt, xtt);
		
    zData->f = xt;
	return z;
	
}/* fpRound */


static REALobject fpAbs(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
    zData->f = xData->f;
	if(zData->f.i.n<0)
		zData->f.i.n = -zData->f.i.n;
	
	return z;
	
}/* fpAbs */


static REALobject fpFloor(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	zData->f = floor(xData->f);
	
	return z;
	
}/* fpFloor */


static REALobject fpCeil(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	zData->f = ceil(xData->f);
	
	return z;
	
}/* fpCeil */


static double fpLg2(REALobject x)
{
	BigFloatData	*xData;
	double			z;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
		return 0;

	if(xData->f.i.n<0)
	{
		REALobject err = REALnewInstanceWithClass(globalNegativeorZeroRef);
		REALRaiseException(err);
		return 0;
	}
	
	z = Lg2(xData->f);
	
	return z;
	
}/* fpLg2 */


static bool fpIsItInteger(REALobject x)
{
	BigFloatData		*xData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	return isItInteger(xData->f);
	
}/* fpIsItInteger */


static REALobject fpFactorial(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	if(xData->f.i.n<0 && isItInteger(xData->f))
	{
		REALobject err = REALnewInstanceWithClass(globalBadEntryNumberRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	factorial(zData->f, xData->f);
	
	if(zData->f.i.n == 0)
	{
		REALobject err = REALnewInstanceWithClass(globalOverflowOrNegativeRef);
		REALRaiseException(err);
		return z;
	}
	
	return z;
	
}/* fpFactorial */



static REALstring fpGetNumberFromLog(REALobject x)
{
	BigFloatData	*xData;
	REALstring		str;
	char*			dataString;
	INT64           length;
	
	if(x==nil)
	{
		return nullString;
	}
	
	// Get the class data
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		return nullString;
	}
	
	dataString = GetNumberFromLog(xData->f);
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
}/* fpGetNumberFromLog */


static REALstring fpBigFactorial2(REALobject x, bool& calcGood)
{
	BigFloatData	*xData;
	REALstring		str;
	char*			dataString;
	INT64           length;
	//bool			calcGood;
	
	if(x==nil)
	{
		return nullString;
	}
	
	// Get the class data
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		return nullString;
	}
	
	dataString = TenToLogTenFactorial(xData->f, calcGood);
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
	
}/* fpBigFactorial2 */


static REALstring fpBigFactorial(REALobject x)
{
	BigFloatData	*xData;
	REALstring		str;
	char*			dataString;
	INT64           length;
	bool			calcGood;
	
	if(x==nil)
	{
		return nullString;
	}
	
	// Get the class data
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
    {
		return nullString;
	}
	
	dataString = TenToLogTenFactorial(xData->f, calcGood);
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
	
}/* fpBigFactorial */



static REALobject fpLnFactorial2(REALobject x, bool& calcGood)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	if(xData->f.i.n<0 && isItInteger(xData->f))
	{
		REALobject err = REALnewInstanceWithClass(globalBadEntryNumberRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	calcGood = LnFactorial(zData->f, xData->f);
	
	return z;
	
}/* fpLnFactorial2 */


static REALobject fpLnFactorial(REALobject x)
{
	REALobject		z;
	BigFloatData	*xData, *zData;
	
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	if(xData->f.i.n<0 && isItInteger(xData->f))
	{
		REALobject err = REALnewInstanceWithClass(globalBadEntryNumberRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	LnFactorial(zData->f, xData->f);
	
	return z;
	
}/* fpLnFactorial */



static REALmethodDefinition otherBigFloatMethods[] = {
	{ (REALproc) fpResetSeed, REALnoImplementation, "fpResetSeed(seed As Integer)", REALconsoleSafe },
	{ (REALproc) fpEquateBF_BF, REALnoImplementation, "fpEquateBF_BF(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpEquateBF_D, REALnoImplementation, "fpEquateBF_D(x As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpEquateD_BF, REALnoImplementation, "fpEquateD_BF(x As BigFloat) As Double", REALconsoleSafe },
	{ (REALproc) fpEquateBF_S, REALnoImplementation, "fpEquateBF_S(inputString As String) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpEquateBI_BF, REALnoImplementation, "fpEquateBI_BF(x As BigFloat) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpEquateBF_BI, REALnoImplementation, "fpEquateBF_BI(x As BigInteger) As BigFloat", REALconsoleSafe },
	{ (REALproc) SetPrecision, REALnoImplementation, "fpSetPrecision(prec As Integer)", REALconsoleSafe },
	{ (REALproc) SetOutputPrecision, REALnoImplementation, "fpSetOutputPrecision(prec As Integer)", REALconsoleSafe },
	{ (REALproc) GetPrecision, REALnoImplementation, "fpGetPrecision() As Integer", REALconsoleSafe },
	{ (REALproc) GetOutputPrecision, REALnoImplementation, "fpGetOutputPrecision() As Integer", REALconsoleSafe },
	{ (REALproc) BigFloatToS, REALnoImplementation, "Str(x As BigFloat) As String", REALconsoleSafe },
	{ (REALproc) SqrBigFloat, REALnoImplementation, "fpSqr(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) SqrtBigFloat, REALnoImplementation, "fpSqrt(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) PowBigFloat_D, REALnoImplementation, "fpPow(x As BigFloat, y As Double) As BigFloat", REALconsoleSafe },
	{ (REALproc) PowBigFloat_Int, REALnoImplementation, "fpPow(x As BigFloat, y As Integer) As BigFloat", REALconsoleSafe },
	{ (REALproc) PowBigFloat_BigFloat, REALnoImplementation, "fpPow(x As BigFloat, y As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) LogBF, REALnoImplementation, "fpLog(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ExpBF, REALnoImplementation, "fpExp(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) SinBF, REALnoImplementation, "fpSin(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) CosBF, REALnoImplementation, "fpCos(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) TanBF, REALnoImplementation, "fpTan(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ASinBF, REALnoImplementation, "fpASin(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ACosBF, REALnoImplementation, "fpACos(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ATanBF, REALnoImplementation, "fpATan(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ATan2BF, REALnoImplementation, "fpATan2(y As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) SinhBF, REALnoImplementation, "fpSinh(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) CoshBF, REALnoImplementation, "fpCosh(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) TanhBF, REALnoImplementation, "fpTanh(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ASinhBF, REALnoImplementation, "fpASinh(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ACoshBF, REALnoImplementation, "fpACosh(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) ATanhBF, REALnoImplementation, "fpATanh(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpGamma, REALnoImplementation, "fpGamma(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpBesselJ, REALnoImplementation, "fpBesselJ(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpBesselY, REALnoImplementation, "fpBesselY(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpBesselI, REALnoImplementation, "fpBesselI(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpBesselK, REALnoImplementation, "fpBesselK(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpBesselJzero, REALnoImplementation, "fpBesselJzero(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpBesselYzero, REALnoImplementation, "fpBesselYzero(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpSphericalBesselJ, REALnoImplementation, "fpSphericalBesselJ(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpSphericalBesselY, REALnoImplementation, "fpSphericalBesselY(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpBeta, REALnoImplementation, "fpBeta(a As BigFloat, b As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpIbeta, REALnoImplementation, "fpIbeta(a As BigFloat, b As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpErf, REALnoImplementation, "fpErf(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpErfc, REALnoImplementation, "fpErfc(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpFresnelS, REALnoImplementation, "fpFresnelS(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpFresnelC, REALnoImplementation, "fpFresnelC(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpExpInt, REALnoImplementation, "fpExpInt(n As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpKummerM, REALnoImplementation, "fpKummerM(a As BigFloat, b As BigFloat, x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpPi, REALnoImplementation, "fpPi() As BigFloat", REALconsoleSafe },
	{ (REALproc) fpEulerGamma, REALnoImplementation, "fpEulerGamma() As BigFloat", REALconsoleSafe },
	{ (REALproc) fpTrunc, REALnoImplementation, "fpTrunc(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpRound, REALnoImplementation, "fpRound(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpAbs, REALnoImplementation, "fpAbs(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpFloor, REALnoImplementation, "fpFloor(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpCeil, REALnoImplementation, "fpCeil(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpLg2, REALnoImplementation, "fpLg2(x As BigFloat) As Double", REALconsoleSafe },
	{ (REALproc) fpIsItInteger, REALnoImplementation, "fpIsItInteger(x As BigFloat) As Boolean", REALconsoleSafe },
	{ (REALproc) fpFactorial, REALnoImplementation, "fpFactorial(x As BigFloat) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpGetNumberFromLog, REALnoImplementation, "fpGetNumberFromLog(logNumber As BigFloat) As String", REALconsoleSafe },
	{ (REALproc) fpBigFactorial2, REALnoImplementation, "fpBigFactorial(x As BigFloat, ByRef calcGood As Boolean) As String", REALconsoleSafe },
	{ (REALproc) fpBigFactorial, REALnoImplementation, "fpBigFactorial(x As BigFloat) As String", REALconsoleSafe },
	{ (REALproc) fpLnFactorial2, REALnoImplementation, "fpLnFactorial(x As BigFloat, ByRef calcGood As Boolean) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpLnFactorial, REALnoImplementation, "fpLnFactorial(x As BigFloat) As BigFloat", REALconsoleSafe },
	
};


// BigComplex

static void BigComplexConstructor(REALobject instance)
{
	
}/* BigComplexConstructor */


static void BigComplexConstructor2(REALobject instance, REALstring CStr)
{
	BigComplexData	*data;
	char			*dataString;
	long             length;
    REALstringData   *outData;
	
	// Get the class data
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if (data == nil)
		return;
	
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        return;
    }
    
    // now get the BigInteger number from CStr
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
	if(!fpConvFromString(data->c, dataString))
	{
        REALDisposeStringData(outData);
        free(dataString);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return;
	}
	
    REALDisposeStringData(outData);
	free(dataString);
	
}/* BigComplexConstructor2 */


static void BigComplexConstructor3(REALobject instance, double x)
{
	BigComplexData		*data;
	
	// Get the class data
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if (data == nil)
		return;
	
    equate(data->c, x);
	
}/* BigComplexConstructor3 */


static void BigComplexConstructor4(REALobject instance, double x, double y)
{
	BigComplexData		*data;
	
	// Get the class data
    data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	if (data == nil)
		return;
	
	equate(data->c, x, y);
	
}/* BigComplexConstructor4 */


static void BigComplexDestructor(REALobject instance)
{
    BigComplexData		*data;
    
    data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
    if (data == nil)
        return;
    
    myFree(data->c);
		
}/* BigComplexDestructor */


static REALstring BigComplexToS(REALobject instance)
{
	BigComplexData	*data;
	REALstring		str;
	char*			dataString;
	INT64           length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	
	if(data==nil)
	{
		return nullString;
	}
	
	dataString = fpComplexToStr(data->c, decPrec);
	length = strlen(dataString);
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);

	free(dataString);
	return str;
	
}/* BigComplexToS */


static REALobject NegateBigComplex(REALobject instance)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return instance;
	
    zData->c = data->c;
	zData->c = -zData->c;
	
	return z;
	
}/* NegateBigComplex */


static REALobject ConjugateBigComplex(REALobject instance)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return instance;
	
	zData->c = conj(data->c);
	
	return z;
	
}/* ConjugateBigComplex */


static REALobject AbsBigComplex(REALobject instance)
{
	REALobject			z;
	BigFloatData		*zData;
	BigComplexData		*data;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return instance;
	
	zData->f = abs(data->c);
	
	return z;
	
}/* AbsBigComplex */


static REALobject ArgBigComplex(REALobject instance)
{
	REALobject			z;
	BigFloatData		*zData;
	BigComplexData		*data;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	if(zData==nil)
		return instance;
	
	zData->f = atan2(data->c.im, data->c.re);;
	
	return z;
	
}/* ArgBigComplex */


static REALobject RealOut(REALobject instance)
{
	BigComplexData		*data;
	REALobject			z;
	BigFloatData		*zData;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil || data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	zData->f = data->c.re;
	
	return z;
	
}/* RealOut */


static REALobject ImagOut(REALobject instance)
{
	BigComplexData		*data;
	REALobject			z;
	BigFloatData		*zData;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil || data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	
	zData->f = data->c.im;
	
	return z;
	
}/* ImagOut */


static void convertBigComplexToBigComplex(REALobject instance, REALobject x)
{
	BigComplexData		*data, *xData;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return;
	}
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return;
	}
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return;
	}
	
    data->c = xData->c;
    
}/* convertBigComplexToBigComplex */


static REALobject AddBigComplex_BigComplex(REALobject instance, REALobject x)
{
	REALobject	z;
	BigComplexData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	add(zData->c, data->c, xData->c);
	
	return z;
	
}/* AddBigComplex_BigComplex */


static REALobject SubBigComplex_BigComplex(REALobject instance, REALobject x)
{
	REALobject	z;
	BigComplexData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->c, data->c, xData->c);
	
	return z;
	
}/* SubBigComplex_BigComplex */


static REALobject MulBigComplex_BigComplex(REALobject instance, REALobject x)
{
	REALobject	z;
	BigComplexData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->c, data->c, xData->c);
	
	return z;
	
}/* MulBigComplex_BigComplex */


static REALobject DivBigComplex_BigComplex(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(xData->c==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	div(zData->c, data->c, xData->c);
	
	return z;
	
}/* DivBigComplex_BigComplex */


static REALobject AddBigComplex_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	add(zData->c, data->c, xData->i);
	
	return z;
	
}/* AddBigComplex_BigInteger */


static REALobject SubBigComplex_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->c, data->c, xData->i);
	
	return z;
	
}/* SubBigComplex_BigInteger */


static REALobject SubBigInteger_BigComplex(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->c, xData->i, data->c);
	
	return z;
	
}/* SubBigInteger_BigComplex */


static REALobject MulBigComplex_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->c, data->c, xData->i);
	
	return z;
	
}/* MulBigComplex_BigInteger */


static REALobject DivBigComplex_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(xData->i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	div(zData->c, data->c, xData->i);
	
	return z;
	
}/* DivBigComplex_BigInteger */


static REALobject DivBigInteger_BigComplex(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigIntegerData			*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(data->c==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	div(zData->c, xData->i, data->c);
	
	return z;
	
}/* DivBigInteger_BigComplex */


static REALobject AddBigComplex_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigFloatData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	add(zData->c, data->c, xData->f);
	
	return z;
	
}/* AddBigComplex_BigFloat */


static REALobject SubBigComplex_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigFloatData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->c, data->c, xData->f);
	
	return z;
	
}/* SubBigComplex_BigFloat */


static REALobject SubBigFloat_BigComplex(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigFloatData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->c, xData->f, data->c);
	
	return z;
	
}/* SubBigFloat_BigComplex */


static REALobject MulBigComplex_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigFloatData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->c, data->c, xData->f);
	
	return z;
	
}/* MulBigComplex_BigFloat */


static REALobject DivBigComplex_BigFloat(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigFloatData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(xData->f.i.n==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	div(zData->c, data->c, xData->f);
	
	return z;
	
}/* DivBigComplex_BigFloat */


static REALobject DivBigFloat_BigComplex(REALobject instance, REALobject x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	BigFloatData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(data->c==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	div(zData->c, xData->f, data->c);
	
	return z;
	
}/* DivBigFloat_BigComplex */



static REALobject AddBigComplex_D(REALobject instance, double x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	add(zData->c, data->c, x);
	
	return z;
	
}/* AddBigComplex_D */


static REALobject SubBigComplex_D(REALobject instance, double x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->c, data->c, x);
	
	return z;
	
}/* SubBigComplex_D */


static REALobject SubD_BigComplex(REALobject instance, double x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->c, x, data->c);
	
	return z;
	
}/* SubD_BigComplex */


static REALobject MulBigComplex_D(REALobject instance, double x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->c, data->c, x);
	
	return z;
	
}/* MulBigComplex_D */


static REALobject DivBigComplex_D(REALobject instance, double x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	if(x==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	div(zData->c, data->c, x);
	
	return z;
	
}/* DivBigComplex_D */


static REALobject DivD_BigComplex(REALobject instance, double x)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	if(data->c==0)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	div(zData->c, x, data->c);
	
	return z;
	
}/* DivD_BigComplex */


static REALobject SqrBigComplex(REALobject instance)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return instance;
	
	mul(zData->c, data->c, data->c);
	
	return z;
	
}/* SqrBigComplex */


static REALobject SqrtBigComplex(REALobject instance)
{
	REALobject			z;
	BigComplexData		*data, *zData;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return instance;
	
	sqrt(zData->c, data->c);
	
	return z;
	
}/* SqrtBigComplex */


// x^y
static REALobject PowBigComplex_D(REALobject instance, double y)
{
	REALobject			z;
	BigComplexData		*xData, *zData;
	INT32				yInt;
	double				yt;
	
	xData = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	yInt = y;
	yt = yInt;
	
	if(yt==y)
	{
		pow(zData->c, xData->c, yInt);
	}
	else
	{
		pow(zData->c, xData->c, y);
	}
	
	return z;
	
}/* PowBigComplex_D */


// x^y
static REALobject PowBigComplex_Int(REALobject instance, long y)
{
	REALobject			z;
	BigComplexData		*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	pow(zData->c, xData->c, (int)y);
	
	return z;
	
}/* PowBigComplex_Int */


// x^y
static REALobject PowBigComplex_BigComplex(REALobject instance, REALobject y)
{
	REALobject			z;
	BigComplexData		*xData, *yData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(xData==nil)
		return instance;
	
	yData = (BigComplexData *) REALGetClassData(y, &BigComplexClass);
	
	if(yData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(zData==nil)
		return z;
	
	pow(zData->c, xData->c, yData->c);
	
	return z;
	
}/* PowBigComplex_BigComplex */


static long CompareBigComplex_BigComplex(REALobject instance, REALobject x)
{
	BigComplexData		*data, *xData;
	
	if(instance==nil || x==nil)
		return 0;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	
	if(data==nil || xData==nil)
		return 0;
	
	if(data->c.re<xData->c.re)
		return -1;
	
	if(data->c.re>xData->c.re)
		return 1;
	
	if(data->c.im<xData->c.im)
		return -1;
	
	if(data->c.im>xData->c.im)
		return 1;
	
	return 0;
	
}/* CompareBigComplex_BigComplex */


static long CompareBigComplex_Double(REALobject instance, double x)
{
	BigComplexData		*data;
	fp					xt;
	
	if(instance==nil)
		return 0;
	
	data = (BigComplexData *) REALGetClassData(instance, &BigComplexClass);
	
	if(data==nil)
		return 0;
	
	xt = x;
	
	if(data->c.re<xt)
		return -1;
	
	if(data->c.re>xt)
		return 1;
	
	if(data->c.im<0)
		return -1;
	
	if(data->c.im>0)
		return 1;
	
	return 0;
	
}/* CompareBigComplex_Double */



static REALmethodDefinition BigComplexMethods[] = {
	// defines methods:
	{ (REALproc) BigComplexConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
	{ (REALproc) BigComplexConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
	{ (REALproc) BigComplexConstructor3, REALnoImplementation, "Constructor(x As Double)", REALconsoleSafe },
	{ (REALproc) BigComplexConstructor4, REALnoImplementation, "Constructor(x As Double, y As Double)", REALconsoleSafe },
	{ (REALproc) BigComplexDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) BigComplexToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
	{ (REALproc) NegateBigComplex, REALnoImplementation, "Operator_Negate() As BigComplex", REALconsoleSafe },
	{ (REALproc) ConjugateBigComplex, REALnoImplementation, "fpConjugate() As BigComplex", REALconsoleSafe },
	{ (REALproc) AbsBigComplex, REALnoImplementation, "fpAbs() As BigFloat", REALconsoleSafe },
	{ (REALproc) ArgBigComplex, REALnoImplementation, "fpArg() As BigFloat", REALconsoleSafe },
	{ (REALproc) RealOut, REALnoImplementation, "fpRe() As BigFloat", REALconsoleSafe },
	{ (REALproc) ImagOut, REALnoImplementation, "fpIm() As BigFloat", REALconsoleSafe },
	{ (REALproc) convertBigComplexToBigComplex, REALnoImplementation, "Operator_Convert(x As BigComplex)", REALconsoleSafe },
	{ (REALproc) AddBigComplex_BigComplex, REALnoImplementation, "Operator_Add(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) SubBigComplex_BigComplex, REALnoImplementation, "Operator_Subtract(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) MulBigComplex_BigComplex, REALnoImplementation, "Operator_Multiply(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) DivBigComplex_BigComplex, REALnoImplementation, "Operator_Divide(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) AddBigComplex_BigInteger, REALnoImplementation, "Operator_Add(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) AddBigComplex_BigInteger, REALnoImplementation, "Operator_AddRight(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) SubBigComplex_BigInteger, REALnoImplementation, "Operator_Subtract(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) SubBigInteger_BigComplex, REALnoImplementation, "Operator_SubtractRight(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) MulBigComplex_BigInteger, REALnoImplementation, "Operator_Multiply(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) MulBigComplex_BigInteger, REALnoImplementation, "Operator_MultiplyRight(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) DivBigComplex_BigInteger, REALnoImplementation, "Operator_Divide(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) DivBigInteger_BigComplex, REALnoImplementation, "Operator_DivideRight(x As BigInteger) As BigComplex", REALconsoleSafe },
	{ (REALproc) AddBigComplex_BigFloat, REALnoImplementation, "Operator_Add(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) AddBigComplex_BigFloat, REALnoImplementation, "Operator_AddRight(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) SubBigComplex_BigFloat, REALnoImplementation, "Operator_Subtract(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) SubBigFloat_BigComplex, REALnoImplementation, "Operator_SubtractRight(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) MulBigComplex_BigFloat, REALnoImplementation, "Operator_Multiply(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) MulBigComplex_BigFloat, REALnoImplementation, "Operator_MultiplyRight(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) DivBigComplex_BigFloat, REALnoImplementation, "Operator_Divide(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) DivBigFloat_BigComplex, REALnoImplementation, "Operator_DivideRight(x As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) AddBigComplex_D, REALnoImplementation, "Operator_Add(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) AddBigComplex_D, REALnoImplementation, "Operator_AddRight(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) SubBigComplex_D, REALnoImplementation, "Operator_Subtract(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) SubD_BigComplex, REALnoImplementation, "Operator_SubtractRight(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) MulBigComplex_D, REALnoImplementation, "Operator_Multiply(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) MulBigComplex_D, REALnoImplementation, "Operator_MultiplyRight(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) DivBigComplex_D, REALnoImplementation, "Operator_Divide(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) DivD_BigComplex, REALnoImplementation, "Operator_DivideRight(x As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) SqrBigComplex, REALnoImplementation, "fpSqr() As BigComplex", REALconsoleSafe },
	{ (REALproc) SqrtBigComplex, REALnoImplementation, "fpSqrt() As BigComplex", REALconsoleSafe },
	{ (REALproc) PowBigComplex_D, REALnoImplementation, "Operator_Power(y As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) PowBigComplex_BigComplex, REALnoImplementation, "Operator_Power(y As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) CompareBigComplex_BigComplex, REALnoImplementation, "Operator_Compare(x As BigComplex) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigComplex_Double, REALnoImplementation, "Operator_Compare(x As Double) As Integer", REALconsoleSafe },
	 
};


REALclassDefinition BigComplexClass = {
	kCurrentREALControlVersion,
	"BigComplex",		// name of class
	nil,				// no superclasses
	sizeof(BigComplexData),		// size of our data
	0,							// for system use
	nil,						// initializer
	nil,						// finializer
	nil,            			// properties
	0,							// property count
	BigComplexMethods,           // methods
	sizeof(BigComplexMethods) / sizeof(REALmethodDefinition),	// method count
	nil,						// Events
	0,							// Event count
	nil,						// eventInstances
	0,							// eventInstanceCount
	nil,						// interface strings
	nil,						// obsolete1
	nil,						// obsolete2
	nil,						// constants
	0,							// constantCount
	REALconsoleSafe,			// flags
	nil,						// shared properties
	0,							// sharedPropertyCount
	nil,						// shared methods
	0,							// sharedMethodCount
};


// otherBigComplexMethods

static REALobject fp_I()
{
	REALobject		z;
	BigComplexData	*zData;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	zData->c.re = 0;
	zData->c.im = 1;
	
	return z;
	
}/* fp_I */


static REALobject fpEquateBC_BF(REALobject x, REALobject y)
{
	REALobject		z;
	BigComplexData	*zData;
	BigFloatData	*xData, *yData;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
	yData = (BigFloatData *) REALGetClassData(y, &BigFloatClass);
	if(xData==nil || yData==nil || zData==nil)
		return z;
	
	zData->c.re = xData->f;
	zData->c.im = yData->f;
	
	return z;
	
}/* fpEquateBC_BF */


static REALobject fpEquateBC_DD(double x, double y)
{
	REALobject		z;
	BigComplexData	*zData;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	zData->c.re = x;
	zData->c.im = y;
	
	return z;
	
}/* fpEquateBC_DD */


static REALobject LogBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	log(zData->c, xData->c);
	
	return z;
	
}/* LogBC */


static REALobject ExpBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	exp(zData->c, xData->c);
	
	return z;
	
}/* ExpBC */


static REALobject SinBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	sin(zData->c, xData->c);
	
	return z;
	
}/* SinBC */


static REALobject CosBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	cos(zData->c, xData->c);
	
	return z;
	
}/* CosBC */


static REALobject TanBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	tan(zData->c, xData->c);
	
	return z;
	
}/* TanBC */


static REALobject ASinBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	asin(zData->c, xData->c);
	
	return z;
	
}/* ASinBC */


static REALobject ACosBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	acos(zData->c, xData->c);
	
	return z;
	
}/* ACosBC */


static REALobject ATanBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	atan(zData->c, xData->c);
	
	return z;
	
}/* ATanBC */


static REALobject SinhBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	sinh(zData->c, xData->c);
	
	return z;
	
}/* SinhBC */


static REALobject CoshBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	cosh(zData->c, xData->c);
	
	return z;
	
}/* CoshBC */


static REALobject TanhBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	tanh(zData->c, xData->c);
	
	return z;
	
}/* TanhBC */


static REALobject ASinhBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	asinh(zData->c, xData->c);
	
	return z;
	
}/* ASinhBC */


static REALobject ACoshBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	acosh(zData->c, xData->c);
	
	return z;
	
}/* ACoshBC */


static REALobject ATanhBC(REALobject x)
{
	REALobject		z;
	BigComplexData	*xData, *zData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	atanh(zData->c, xData->c);
	
	return z;
	
}/* ATanhBC */


static REALobject fpGamma_BC(REALobject x)
{
	REALobject		z;
	BigComplexData	*zData, *xData;
	
	xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	Gamma(zData->c, xData->c);
	
	return z;
	
}/* fpGamma_BC */



static REALmethodDefinition otherBigComplexMethods[] = {
	{ (REALproc) fp_I, REALnoImplementation, "fpI() As BigComplex", REALconsoleSafe },
	{ (REALproc) BigComplexToS, REALnoImplementation, "Str(x As BigComplex) As String", REALconsoleSafe },
	{ (REALproc) ConjugateBigComplex, REALnoImplementation, "fpConjugate(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) fpEquateBC_BF, REALnoImplementation, "fpEquateBC_BF(x As BigFloat, y As BigFloat) As BigComplex", REALconsoleSafe },
	{ (REALproc) fpEquateBC_DD, REALnoImplementation, "fpEquateBC_DD(x As Double, y As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) RealOut, REALnoImplementation, "fpRe(x As BigComplex) As BigFloat", REALconsoleSafe },
	{ (REALproc) ImagOut, REALnoImplementation, "fpIm(x As BigComplex) As BigFloat", REALconsoleSafe },
	{ (REALproc) AbsBigComplex, REALnoImplementation, "fpAbs(x As BigComplex) As BigFloat", REALconsoleSafe },
	{ (REALproc) ArgBigComplex, REALnoImplementation, "fpArg(x As BigComplex) As BigFloat", REALconsoleSafe },
	{ (REALproc) LogBC, REALnoImplementation, "fpLog(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) PowBigComplex_D, REALnoImplementation, "fpPow(x As BigComplex, y As Double) As BigComplex", REALconsoleSafe },
	{ (REALproc) PowBigComplex_Int, REALnoImplementation, "fpPow(x As BigComplex, y As Integer) As BigComplex", REALconsoleSafe },
	{ (REALproc) PowBigComplex_BigComplex, REALnoImplementation, "fpPow(x As BigComplex, y As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) SqrBigComplex, REALnoImplementation, "fpSqr(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) SqrtBigComplex, REALnoImplementation, "fpSqrt(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) ExpBC, REALnoImplementation, "fpExp(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) SinBC, REALnoImplementation, "fpSin(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) CosBC, REALnoImplementation, "fpCos(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) TanBC, REALnoImplementation, "fpTan(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) ASinBC, REALnoImplementation, "fpASin(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) ACosBC, REALnoImplementation, "fpACos(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) ATanBC, REALnoImplementation, "fpATan(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) SinhBC, REALnoImplementation, "fpSinh(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) CoshBC, REALnoImplementation, "fpCosh(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) TanhBC, REALnoImplementation, "fpTanh(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) ASinhBC, REALnoImplementation, "fpASinh(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) ACoshBC, REALnoImplementation, "fpACosh(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) ATanhBC, REALnoImplementation, "fpATanh(x As BigComplex) As BigComplex", REALconsoleSafe },
	{ (REALproc) fpGamma_BC, REALnoImplementation, "fpGamma(x As BigComplex) As BigComplex", REALconsoleSafe },

};


static void ComplexVectorConstructor(REALobject instance)
{
	ComplexVectorData		*data;
	
	// Get the class data
	data = (ComplexVectorData*)REALGetClassData(instance, &ComplexVectorClass);
	
	if(data==nil)
		return;
	
	data->v = nil;
	data->n = 0;
	
}/* ComplexVectorConstructor */


static void ComplexVectorConstructor2(REALobject instance, long n)
{
	ComplexVectorData		*data;
	int						i;
	
	// Get the class data
	data = (ComplexVectorData*)REALGetClassData(instance, &ComplexVectorClass);
	
	if(data==nil)
		return;
	
	if(n<=0)
	{
		data->v = nil;
		data->n = 0;
		return;
	}
	
	data->n = (int)n;
	data->v = (fpComplex*)malloc((int)n*sizeof(fpComplex));
	for(i=0;i<(int)n;i++)
		init((data->v)[i]);
	
}/* ComplexVectorConstructor2 */


static void ComplexVectorDestructor(REALobject instance)
{
	ComplexVectorData		*data;
	int					i;
	
	if(instance==nil)
		return;
	
	// Get the class data
	data = (ComplexVectorData*)REALGetClassData(instance, &ComplexVectorClass);
	
	if (data == nil || data->v==nil)
		return;
	
	for(i=0;i<data->n;i++)
	{
		if((data->v)[i].re.i.n && (data->v)[i].re.i.b)
        {
            free((data->v)[i].re.i.b);
            (data->v)[i].re.i.b = NULL;
        }
			
		if((data->v)[i].im.i.n && (data->v)[i].im.i.b)
        {
            free((data->v)[i].im.i.b);
            (data->v)[i].im.i.b = NULL;
        }
			
	}
		
	free(data->v);
    data->v = NULL;
    
}/* ComplexVectorDestructor */


static REALstring ComplexVectorToS(REALobject instance)
{
	ComplexVectorData	*data;
	REALstring			str;
	char				*dataString, *entry;
	INT64               i, length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (ComplexVectorData *) REALGetClassData(instance, &ComplexVectorClass);
	
	
	if(data==nil)
	{
		return nullString;
	}
	
	// we have to estimate the size of dataString as length
	length = (2*decPrec + 100)*data->n;
	
	dataString = (char*)malloc(length*sizeof(char));
	
	dataString[0] = 0;;
	
	for(i=0;i<data->n;i++)
	{
		entry = fpComplexToStr(data->v[i], decPrec);
		strcat(dataString, entry);
		strcat(dataString, "\n\n");
		free(entry);
	}
	
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
}/* ComplexVectorToS */


static REALmethodDefinition ComplexVectorMethods[] = {
	// defines methods:
	{ (REALproc) ComplexVectorConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
	{ (REALproc) ComplexVectorConstructor2, REALnoImplementation, "Constructor(n As Integer)", REALconsoleSafe },
	{ (REALproc) ComplexVectorDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) ComplexVectorToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
	
};


REALclassDefinition ComplexVectorClass = {
	kCurrentREALControlVersion,
	"ComplexVector",		// name of class
	nil,				// no superclasses
	sizeof(ComplexVectorData),		// size of our data
	0,							// for system use
	nil,						// initializer
	nil,						// finializer
	nil,            			// properties
	0,							// property count
	ComplexVectorMethods,           // methods
	sizeof(ComplexVectorMethods) / sizeof(REALmethodDefinition),	// method count
	nil,						// Events
	0,							// Event count
	nil,						// eventInstances
	0,							// eventInstanceCount
	nil,						// interface strings
	nil,						// obsolete1
	nil,						// obsolete2
	nil,						// constants
	0,							// constantCount
	REALconsoleSafe,			// flags
	nil,						// shared properties
	0,							// sharedPropertyCount
	nil,						// shared methods
	0,							// sharedMethodCount
};


// otherComplexVectorMethods


static bool isxPresent(long& n, REALstring inputStr)
{
    char			*dataString;
    long			length;
    bool			isx;
    REALstringData  *outData;
    
    outData = new REALstringData();
    
    if(!REALGetStringData(inputStr, kREALTextEncodingUTF8, outData))
    {
        REALDisposeStringData(outData);
        return false;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
    
    isx = xPresence(n, dataString);
	 
    REALDisposeStringData(outData);
    free(dataString);
    return isx;
 
}/* isxPresent */


static bool xNotPresent(long& n, REALstring sep, REALstring inputStr)
{
    char			*dataString, *sepC;
    long			length;
    bool			isGood;
    REALstringData  *outData;
	 
    outData = new REALstringData();
    
    if(!REALGetStringData(inputStr, kREALTextEncodingUTF8, outData))
    {
        REALDisposeStringData(outData);
        return false;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    REALDisposeStringData(outData);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(sep, kREALTextEncodingUTF8, outData))
    {
        free(dataString);
        REALDisposeStringData(outData);
        return false;
    }
    
    length = outData->length;
    sepC = (char *)malloc((length+1)*sizeof(char));
    memcpy(sepC, outData->data, length); // to, from
    sepC[length] = 0; // makes it a C string
    
    isGood = xNoPresence(n, sepC, dataString);
	 
     REALDisposeStringData(outData);
	 free(dataString);
	 free(sepC);
	 
	 return isGood;
 
}/* xNotPresent */


static bool inputPolyWithx(REALobject x, long n, REALstring inputStr)
{
	char					*dataString;
	int                     length;
	bool					isGood;
	ComplexVectorData		*xData;
    REALstringData      	*outData;
	
    outData = new REALstringData();
    
    if(!REALGetStringData(inputStr, kREALTextEncodingUTF8, outData))
    {
        return false;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string

	// Get the class data
	xData = (ComplexVectorData*)REALGetClassData(x, &ComplexVectorClass);
	if (xData == nil || xData->v==nil)
    {
        REALDisposeStringData(outData);
        free(dataString);
        return false;
    }
		
	isGood = inputPoly_x(xData->v, (int)n, dataString);
	 
    REALDisposeStringData(outData);
	free(dataString);
	 
	return isGood;
 
}/* inputPolyWithx */


static bool inputPolyWithOutx(REALobject x, long n, REALstring sep, REALstring inputStr)
{
	char					*dataString, *sepC;
	long                     length;
	bool					isGood;
	ComplexVectorData		*xData;
    REALstringData      	*outData;
    
    outData = new REALstringData();
    
    if(!REALGetStringData(inputStr, kREALTextEncodingUTF8, outData))
    {
        return false;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    REALDisposeStringData(outData);
    
    outData = new REALstringData();
    
    if(!REALGetStringData(sep, kREALTextEncodingUTF8, outData))
    {
        free(dataString);
        return false;
    }
    
    length = outData->length;
    sepC = (char *)malloc((length+1)*sizeof(char));
    memcpy(sepC, outData->data, length); // to, from
    sepC[length] = 0; // makes it a C string
	
	// Get the class data
	xData = (ComplexVectorData*)REALGetClassData(x, &ComplexVectorClass);
	if (xData == nil || xData->v==nil)
    {
        REALDisposeStringData(outData);
        free(sepC);
        free(dataString);
        return false;
    }
    
	isGood = inputPoly(xData->v, (int)n, sepC, dataString);
    
    REALDisposeStringData(outData);
	free(sepC);
	free(dataString);
	
	return isGood;
	
}/* inputPolyWithx */


static REALobject getCVComp(REALobject x, long index)
{
	ComplexVectorData	*xData;
	REALobject			z;
	BigComplexData		*zData;
	
	// Get the class data
	xData = (ComplexVectorData *) REALGetClassData(x, &ComplexVectorClass);
	
	z = REALnewInstanceWithClass(globalBigComplexRef);
	zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
	
	if(xData==nil || zData==nil)
		return z;
	
	zData->c = xData->v[(int)index];
	
	return z;
	
}/* getCVComp */



static REALobject setCVComp(REALobject x, long index, REALobject y)
{
	ComplexVectorData	*xData, *zData;
	BigComplexData		*yData;
	REALobject			z;
	
	// Get the class data
	xData = (ComplexVectorData *) REALGetClassData(x, &ComplexVectorClass);
	yData = (BigComplexData *) REALGetClassData(y, &BigComplexClass);
	
	z = REALnewInstanceWithClass(globalComplexVectorRef);
	zData = (ComplexVectorData *) REALGetClassData(z, &ComplexVectorClass);
	
	if(xData==nil || yData==nil || zData==nil)
		return z;
	
	zData->v[(int)index] = yData->c;
	
	return z;
	
}/* setCVComp */


static REALobject setCVComp2(REALobject x, long index, double yRe, double yIm)
{
	ComplexVectorData	*xData, *zData;
	REALobject			z;
	
	// Get the class data
	xData = (ComplexVectorData *) REALGetClassData(x, &ComplexVectorClass);
	
	z = REALnewInstanceWithClass(globalComplexVectorRef);
	zData = (ComplexVectorData *) REALGetClassData(z, &ComplexVectorClass);
	
	if(xData==nil || zData==nil)
		return z;
	
	zData->v[(int)index].re = yRe;
	zData->v[(int)index].im = yIm;
	
	return z;
	
}/* setCVComp2 */

// x = root, y = Parray, z = coeffArray
static bool fpFindPolyRoots(REALobject x, REALobject y, REALobject z, long n, bool doRoundToZero)
{
	ComplexVectorData	*xData, *yData, *zData;
	
	// Get the class data
	xData = (ComplexVectorData *) REALGetClassData(x, &ComplexVectorClass);
	yData = (ComplexVectorData *) REALGetClassData(y, &ComplexVectorClass);
	zData = (ComplexVectorData *) REALGetClassData(z, &ComplexVectorClass);
	
	if(xData==nil || yData==nil || zData==nil)
		return false;
	
	return findPolyRoots(xData->v, yData->v, zData->v, (int)n, doRoundToZero);
	
}/* fpFindPolyRoots */


static REALmethodDefinition otherComplexVectorMethods[] = {
	{ (REALproc) isxPresent, REALnoImplementation, "fpIsxPresent(ByRef n As Integer, inputStr As String) As Boolean", REALconsoleSafe },
	{ (REALproc) xNotPresent, REALnoImplementation, "fpxNotPresent(ByRef n As Integer, sep As String, inputStr As String) As Boolean", REALconsoleSafe },
	{ (REALproc) inputPolyWithx, REALnoImplementation, "fpInputPolyWithx(vectorArray As ComplexVector, n As Integer, inputStr As String) As Boolean", REALconsoleSafe },
	{ (REALproc) inputPolyWithOutx, REALnoImplementation, "fpInputPolyWithOutx(vectorArray As ComplexVector, n As Integer, sep As String, inputStr As String) As Boolean", REALconsoleSafe },
	{ (REALproc) ComplexVectorToS, REALnoImplementation, "Str(x As ComplexVector) As String", REALconsoleSafe },
	{ (REALproc) getCVComp, REALnoImplementation, "fpGetComplexVectorComponent(x As ComplexVector, index As Integer) As BigComplex", REALconsoleSafe },
	{ (REALproc) setCVComp, REALnoImplementation, "fpSetComplexVectorComponent(x As ComplexVector, index As Integer, y As BigComplex) As ComplexVector", REALconsoleSafe },
	{ (REALproc) setCVComp2, REALnoImplementation, "fpSetComplexVectorComponent(x As ComplexVector, index As Integer, yRe As Double, yIm As Double) As ComplexVector", REALconsoleSafe },
	{ (REALproc) fpFindPolyRoots, REALnoImplementation, "fpFindPolyRoots(root As ComplexVector, Parray As ComplexVector, coeffArray As ComplexVector, index As Integer, doRoundToZero As Boolean) As Boolean", REALconsoleSafe },
};

static void BigFractionConstructor(REALobject instance)
{
	BigFractionData		*data;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if (data == nil)
		return;
	
	(data->bfr).num = 0;
	(data->bfr).den = 1;
	
}/* BigFractionConstructor */

static void BigFractionConstructor2(REALobject instance, REALstring CStr)
{
	BigFractionData		*data;
	char				*dataString;
	long                length;
    REALstringData      *outData;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if (data == nil)
		return;
	
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        return;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
	
	if(!bfConvFromStr(data->bfr, dataString))
	{
        free(dataString);
        REALDisposeStringData(outData);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return;
	}
	
	if(!(data->bfr).den.n)
	{
		(data->bfr).num = 0;
		(data->bfr).den = 1;
	}
	
    REALDisposeStringData(outData);
	free(dataString);
	
}/* BigFractionConstructor2 */


static void BigFractionConstructor3(REALobject instance, REALobject x, REALobject y)
{
	BigFractionData		*data;
	BigIntegerData		*xData, *yData;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if (data == nil)
		return;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if (xData == nil)
		return;
	
	yData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if (yData == nil)
		return;
	
	if(!(yData->i).n)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return;
	}
	
	(data->bfr).num = xData->i;
	(data->bfr).den = yData->i;
	
}/* BigFractionConstructor3 */


static void BigFractionConstructor31(REALobject instance, REALobject x)
{
	BigFractionData		*data;
	BigIntegerData		*xData;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if (data == nil)
		return;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if (xData == nil)
		return;
	
	(data->bfr).num = xData->i;
	(data->bfr).den = 1;
	
}/* BigFractionConstructor3 */


static void BigFractionConstructor4(REALobject instance, double x, double y)
{
	BigFractionData		*data;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if (data == nil)
		return;
	
	if(!y)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return;
	}
	
	(data->bfr).num = x;
	(data->bfr).den = y;
	
}/* BigFractionConstructor4 */


static void BigFractionConstructor5(REALobject instance, long x, long y)
{
	BigFractionData		*data;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if (data == nil)
		return;
	
	if(!y)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return;
	}
	if(sizeof(long)==4)
    {
        (data->bfr).num = (INT32)x;
        (data->bfr).den = (INT32)y;
    }
    else
    {
        (data->bfr).num = (INT64)x;
        (data->bfr).den = (INT64)y;
    }
	
	
}/* BigFractionConstructor5 */


static void BigFractionConstructor6(REALobject instance, double x)
{
	BigFractionData		*data;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if (data == nil)
		return;
	
	(data->bfr).num = x;
	(data->bfr).den = 1;
	
}/* BigFractionConstructor6 */


static void BigFractionConstructor7(REALobject instance, long x)
{
	BigFractionData		*data;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if (data == nil)
		return;
	if(sizeof(long)==4)
        (data->bfr).num = (INT32)x;
    else
        (data->bfr).num = (INT64)x;
    
	(data->bfr).den = 1;
	
}/* BigFractionConstructor7 */


static void BigFractionDestructor(REALobject instance)
{
    BigFractionData		*data;
    
    // Get the class data
    data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
    if (data == nil)
        return;
    
    if((data->bfr).num.n && (data->bfr).num.b)
    {
        free((data->bfr).num.b);
        (data->bfr).num.b = NULL;
    }
    
    
    if((data->bfr).den.n && (data->bfr).den.b)
    {
        free((data->bfr).den.b);
        (data->bfr).den.b = NULL;
    }
    
	
}/* BigFractionDestructor */


static void convertBigFractionToBigFraction(REALobject instance, REALobject x)
{
	BigFractionData		*data, *xData;
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if(data==nil)
	{
		return;
	}
	
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(xData==nil)
		return;
	
	data->bfr = xData->bfr;
	
}/* convertBigFractionToBigFraction */


static void convertBigIntegerToBigFraction(REALobject instance, REALobject x)
{
    BigFractionData		*data;
    BigIntegerData      *xData;
    
    // Get the class data
    data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
    if(data==nil)
        return;
    
    xData = (BigIntegerData *) REALGetClassData(x, &BigIntegerClass);
    if(xData==nil)
        return;
    
    data->bfr = xData->i;
    
}/* convertBigIntegerToBigFraction */


static REALstring BigFractionToS(REALobject instance)
{
	BigFractionData		*data;
	REALstring			str;
	char*				dataString;
	INT64               length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	
	if(data==nil)
	{
		return nullString;
	}
	
	bfConvToStr(dataString, data->bfr);
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
}/* BigFractionToS */


static REALobject fpNum(REALobject instance)
{
	REALobject			z;
	BigIntegerData		*zData;
	BigFractionData		*data;
	
	if(instance==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = data->bfr.num;
	
	return z;
	
}/* fpNum */


static REALobject fpDen(REALobject instance)
{
	REALobject			z;
	BigIntegerData		*zData;
	BigFractionData		*data;
	
	if(instance==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	
	z = REALnewInstanceWithClass(globalBigIntegerRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData = (BigIntegerData *) REALGetClassData(z, &BigIntegerClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->i = data->bfr.den;
	
	return z;
	
}/* fpDen */


static REALobject NegateBigFraction(REALobject instance)
{
	REALobject				z;
	BigFractionData		*data, *zData;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return instance;
	
	zData->bfr = data->bfr;
	
	zData->bfr.num = -zData->bfr.num;
	
	return z;
	
}/* NegateBigFraction */


static REALobject AddBigFraction_BigFraction(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bfr, data->bfr, xData->bfr);
	
	return z;
	
}/* AddBigFraction_BigFraction */


static REALobject SubBigFraction_BigFraction(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bfr, data->bfr, xData->bfr);
	
	return z;
	
}/* SubBigFraction_BigFraction */


static REALobject MulBigFraction_BigFraction(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bfr, data->bfr, xData->bfr);
	
	return z;
	
}/* MulBigFraction_BigFraction */


static REALobject DivBigFraction_BigFraction(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(!xData->bfr.num.n)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bfr, data->bfr, xData->bfr);
	
	return z;
	
}/* DivBigFraction_BigFraction */


static REALobject AddBigFraction_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	BigIntegerData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bfr, data->bfr, xData->i);
	
	return z;
	
}/* AddBigFraction_BigInteger  */


static REALobject SubBigFraction_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	BigIntegerData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bfr, data->bfr, xData->i);
	
	return z;
	
}/* SubBigFraction_BigInteger  */


static REALobject SubBigInteger_BigFraction(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	BigIntegerData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bfr, xData->i, data->bfr);
	
	return z;
	
}/* SubBigInteger_BigFraction  */


static REALobject MulBigFraction_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	BigIntegerData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bfr, data->bfr, xData->i);
	
	return z;
	
}/* MulBigFraction_BigInteger  */


static REALobject DivBigFraction_BigInteger(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	BigIntegerData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(xData==nil)
		return instance;
	
	if(!xData->i.n)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bfr, data->bfr, xData->i);
	
	return z;
	
}/* DivBigFraction_BigInteger  */


static REALobject DivBigInteger_BigFraction(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	BigIntegerData		*xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	xData = (BigIntegerData *) REALGetClassData(instance, &BigIntegerClass);
	if(xData==nil)
		return instance;
	
	if(!data->bfr.num.n)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bfr, xData->i, data->bfr);
	
	return z;
	
}/* DivBigInteger_BigFraction  */


static REALobject AddBigFraction_D (REALobject instance, double x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bfr, data->bfr, x);
	
	return z;
	
}/* AddBigFraction_D */


static REALobject SubBigFraction_D (REALobject instance, double x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bfr, data->bfr, x);
	
	return z;
	
}/* SubBigFraction_D */


static REALobject SubD_BigFraction (REALobject instance, double x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bfr, x, data->bfr);
	
	return z;
	
}/* SubD_BigFraction */


static REALobject MulBigFraction_D (REALobject instance, double x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bfr, data->bfr, x);
	
	return z;
	
}/* MulBigFraction_D */


static REALobject DivBigFraction_D (REALobject instance, double x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	if(!x)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bfr, data->bfr, x);
	
	return z;
	
}/* DivBigFraction_D */


static REALobject AddBigFraction_Int (REALobject instance, long x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bfr, data->bfr, (int)x);
	
	return z;
	
}/* AddBigFraction_Int */


static REALobject SubBigFraction_Int (REALobject instance, long x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bfr, data->bfr, (int)x);
	
	return z;
	
}/* SubBigFraction_Int */


static REALobject SubInt_BigFraction (REALobject instance, long x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bfr, (int)x, data->bfr);
	
	return z;
	
}/* SubInt_BigFraction */


static REALobject MulBigFraction_Int (REALobject instance, long x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bfr, data->bfr, (int)x);
	
	return z;
	
}/* MulBigFraction_Int */


static REALobject DivBigFraction_Int (REALobject instance, long x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	if(!x)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bfr, data->bfr, (int)x);
	
	return z;
	
}/* DivBigFraction_Int */


static REALobject DivInt_BigFraction (REALobject instance, long x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	if(!data->bfr.num.n)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bfr, (int)x, data->bfr);
	
	return z;
	
}/* DivInt_BigFraction */


static REALobject DivD_BigFraction (REALobject instance, double x)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	if(data==nil)
		return instance;
	
	if(!data->bfr.num.n)
	{
		REALobject err = REALnewInstanceWithClass(globalDivideByZeroRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bfr, x, data->bfr);
	
	return z;
	
}/* DivD_BigFraction */


static REALobject AbsBigFraction(REALobject instance)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return instance;
	
	zData->bfr = data->bfr;
	if(zData->bfr.num.n<0)
		zData->bfr.num = -zData->bfr.num;
	
	return z;
	
}/* AbsBigFraction */


// x^y
static REALobject PowBigFraction_D(REALobject instance, double y)
{
	REALobject			z;
	BigFractionData		*xData, *zData;
	
	if(y==1)
		return instance;
	
	xData = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	if(!power(zData->bfr, xData->bfr, (int)y))
	{
		REALobject err = REALnewInstanceWithClass(globalBadEntryNumberRef);
		REALRaiseException(err);
		return instance;
	}
	
	return z;
	
}/* PowBigFraction_D */


static REALobject SqrBigFraction(REALobject instance)
{
	REALobject			z;
	BigFractionData		*data, *zData;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return instance;
	
	mul(zData->bfr, data->bfr, data->bfr);
	
	return z;
	
}/* SqrBigFraction */



static long CompareBigFraction_BigFraction(REALobject instance, REALobject x)
{
	BigFractionData		*data, *xData;
	
	if(instance==nil || x==nil)
		return 0;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return 0;
	
	return compare(data->bfr, xData->bfr);
	
}/* CompareBigFraction_BigFraction */


static long CompareBigFraction_Int(REALobject instance, long x)
{
	BigFractionData		*data;
	
	if(instance==nil)
		return 0;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if(data==nil)
		return 0;
	
	return compare(data->bfr, (int)x);
	
}/* CompareBigFraction_Int */


static int CompareBigFraction_D(REALobject instance, double x)
{
	BigFractionData		*data;
	mb					xmb;
	
	
	if(instance==nil)
		return 0;
	
	data = (BigFractionData *) REALGetClassData(instance, &BigFractionClass);
	
	if(data==nil)
		return 0;
	
    xmb = x;
	
	return compare(data->bfr, xmb);
	
}/* CompareBigFraction_D */





static REALmethodDefinition BigFractionMethods[] = {
	// defines methods:
	{ (REALproc) BigFractionConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
	{ (REALproc) BigFractionConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
	{ (REALproc) BigFractionConstructor3, REALnoImplementation, "Constructor(x As BigInteger, y As BigInteger)", REALconsoleSafe },
	{ (REALproc) BigFractionConstructor31, REALnoImplementation, "Constructor(x As BigInteger)", REALconsoleSafe },
	{ (REALproc) BigFractionConstructor4, REALnoImplementation, "Constructor(x As Double, y As Double)", REALconsoleSafe },
	{ (REALproc) BigFractionConstructor5, REALnoImplementation, "Constructor(x As Integer, y As Integer)", REALconsoleSafe },
	{ (REALproc) BigFractionConstructor6, REALnoImplementation, "Constructor(x As Double)", REALconsoleSafe },
	{ (REALproc) BigFractionConstructor7, REALnoImplementation, "Constructor(x As Integer)", REALconsoleSafe },
	{ (REALproc) BigFractionDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) convertBigFractionToBigFraction, REALnoImplementation, "Operator_Convert(x As BigFraction)", REALconsoleSafe },
    { (REALproc) convertBigIntegerToBigFraction, REALnoImplementation, "Operator_Convert(x As BigInteger)", REALconsoleSafe },
    { (REALproc) BigFractionToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
	{ (REALproc) fpNum, REALnoImplementation, "Num() As BigInteger", REALconsoleSafe },
	{ (REALproc) fpDen, REALnoImplementation, "Den() As BigInteger", REALconsoleSafe },
	{ (REALproc) NegateBigFraction, REALnoImplementation, "Operator_Negate() As BigFraction", REALconsoleSafe },
	{ (REALproc) AddBigFraction_BigFraction, REALnoImplementation, "Operator_Add(x As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) SubBigFraction_BigFraction, REALnoImplementation, "Operator_Subtract(x As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) MulBigFraction_BigFraction, REALnoImplementation, "Operator_Multiply(x As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) DivBigFraction_BigFraction, REALnoImplementation, "Operator_Divide(x As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) AddBigFraction_BigInteger, REALnoImplementation, "Operator_Add(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) AddBigFraction_BigInteger, REALnoImplementation, "Operator_AddRight(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) SubBigFraction_BigInteger, REALnoImplementation, "Operator_Subtract(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) SubBigInteger_BigFraction, REALnoImplementation, "Operator_SubtractRight(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) MulBigFraction_BigInteger, REALnoImplementation, "Operator_Multiply(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) MulBigFraction_BigInteger, REALnoImplementation, "Operator_MultiplyRight(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) DivBigFraction_BigInteger, REALnoImplementation, "Operator_Divide(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) DivBigInteger_BigFraction, REALnoImplementation, "Operator_DivideRight(x As BigInteger) As BigFraction", REALconsoleSafe },
	{ (REALproc) AddBigFraction_D, REALnoImplementation, "Operator_Add(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) AddBigFraction_D, REALnoImplementation, "Operator_AddRight(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) SubBigFraction_D, REALnoImplementation, "Operator_Subtract(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) SubD_BigFraction, REALnoImplementation, "Operator_SubtractRight(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) MulBigFraction_D, REALnoImplementation, "Operator_Multiply(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) MulBigFraction_D, REALnoImplementation, "Operator_MultiplyRight(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) DivBigFraction_D, REALnoImplementation, "Operator_Divide(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) DivD_BigFraction, REALnoImplementation, "Operator_DivideRight(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) AddBigFraction_Int, REALnoImplementation, "Operator_Add(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) AddBigFraction_Int, REALnoImplementation, "Operator_AddRight(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) SubBigFraction_Int, REALnoImplementation, "Operator_Subtract(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) SubInt_BigFraction, REALnoImplementation, "Operator_SubtractRight(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) MulBigFraction_Int, REALnoImplementation, "Operator_Multiply(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) MulBigFraction_Int, REALnoImplementation, "Operator_MultiplyRight(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) DivBigFraction_Int, REALnoImplementation, "Operator_Divide(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) DivInt_BigFraction, REALnoImplementation, "Operator_DivideRight(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) AbsBigFraction, REALnoImplementation, "Abs() As BigFraction", REALconsoleSafe },
	{ (REALproc) PowBigFraction_D, REALnoImplementation, "Operator_Power(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) SqrBigFraction, REALnoImplementation, "Sqr() As BigFraction", REALconsoleSafe },
	{ (REALproc) CompareBigFraction_BigFraction, REALnoImplementation, "Operator_Compare(x As BigFraction) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigFraction_Int, REALnoImplementation, "Operator_Compare(x As Integer) As Integer", REALconsoleSafe },
	{ (REALproc) CompareBigFraction_D, REALnoImplementation, "Operator_Compare(x As Double) As Integer", REALconsoleSafe },
	
};


REALclassDefinition BigFractionClass = {
	kCurrentREALControlVersion,
	"BigFraction",		// name of class
	nil,				// no superclasses
	sizeof(BigFractionData),		// size of our data
	0,							// for system use
	nil,						// initializer
	nil,						// finializer
	nil,            			// properties
	0,							// property count
	BigFractionMethods,           // methods
	sizeof(BigFractionMethods) / sizeof(REALmethodDefinition),	// method count
	nil,						// Events
	0,							// Event count
	nil,						// eventInstances
	0,							// eventInstanceCount
	nil,						// interface strings
	nil,						// obsolete1
	nil,						// obsolete2
	nil,						// constants
	0,							// constantCount
	REALconsoleSafe,			// flags
	nil,						// shared properties
	0,							// sharedPropertyCount
	nil,						// shared methods
	0,							// sharedMethodCount
};


// other BigFraction methods

static REALobject fpEquateBigFloat_BigFraction(REALobject x)
{
	REALobject			z;
	BigFloatData		*zData;
	BigFractionData		*xData;
	fp					xNum, xDen;
	
	if(x==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	if(xData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return x;
	}
	
	z = REALnewInstanceWithClass(globalBigFloatRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	equate(xNum, xData->bfr.num);
	equate(xDen, xData->bfr.den);
	
	zData->f = xNum / xDen;
	
	return z;
	
}/* fpEquateBigFloat_BigFraction */


static REALobject fpEquateBFR_D(double x)
{
	REALobject			z;
	BigFractionData		*zData;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->bfr.num = x;
	zData->bfr.den = 1;
	
	return z;
	
}/* fpEquateBFR_D */


static REALobject fpEquateBFR_Int(long x)
{
	REALobject			z;
	BigFractionData		*zData;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	if(zData==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	
	zData->bfr.num = (int)x;
	zData->bfr.den = 1;
	
	return z;
	
}/* fpEquateBFR_Int */

static REALobject fpBigFracFromRepeatDec(REALstring x, long m)
{
    REALobject              z;
    BigFractionData         *zData;
    char                    *inString;
    long                    length;
    REALstringData          *outData;
    
    z = REALnewInstanceWithClass(globalBigFractionRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
    if(zData==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    
    outData = new REALstringData();
    
    if(!REALGetStringData(x, kREALTextEncodingUTF8, outData))
    {
        return z;
    }
    
    length = outData->length;
    inString = (char *)malloc((length+1)*sizeof(char));
    memcpy(inString, outData->data, length); // to, from
    inString[length] = 0; // makes it a C string
    
    zData->bfr = conv(inString, m);
    
    REALDisposeStringData(outData);
    free(inString);
    return z;
    
}/* fpBigFracFromRepeatDec */


static REALmethodDefinition otherBigFractionMethods[] = {
	{ (REALproc) BigFractionToS, REALnoImplementation, "Str(x As BigFraction) As String", REALconsoleSafe },
	{ (REALproc) AbsBigFraction, REALnoImplementation, "fpAbsBFR(x As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) PowBigFraction_D, REALnoImplementation, "fpPowBFR(x As BigFraction, y As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) SqrBigFraction, REALnoImplementation, "fpSqrBFR(x As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) fpEquateBigFloat_BigFraction, REALnoImplementation, "fpEquateBF_BFR(x As BigFraction) As BigFloat", REALconsoleSafe },
	{ (REALproc) fpEquateBFR_D, REALnoImplementation, "fpEquateBFR_D(x As Double) As BigFraction", REALconsoleSafe },
	{ (REALproc) fpEquateBFR_Int, REALnoImplementation, "fpEquateBFR_Int(x As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) fpNum, REALnoImplementation, "fpNum(x As BigFraction) As BigInteger", REALconsoleSafe },
	{ (REALproc) fpDen, REALnoImplementation, "fpDen(x As BigFraction) As BigInteger", REALconsoleSafe },
    { (REALproc) fpBigFracFromRepeatDec, REALnoImplementation, "fpBigFracFromRepeatDec(x As String, m As Integer) As BigFraction", REALconsoleSafe },
	
};


static void BigPolyConstructor(REALobject instance)
{
	BigPolyData		*data;
	
	// Get the class data
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if (data == nil)
		return;
	
	(data->bp).deg = -1;
	//(data->bp).array = (bf*)malloc(((data->bp).deg+1)*sizeof(bf));
	//(data->bp).array[0] = 0;
    (data->bp).array = NULL;
    
}/* BigPolyConstructor */


static void BigPolyConstructor2(REALobject instance, REALstring CStr)
{
	BigPolyData		*data;
	char			*dataString;
	long             length;
    REALstringData      	*outData;
	
	// Get the class data
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if (data == nil)
		return;
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        (data->bp).deg = 0;
        (data->bp).array = (bf*)malloc(((data->bp).deg+1)*sizeof(bf));
        (data->bp).array[0] = 0;
        return;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
	
	if(!polyConvFromxString(data->bp, dataString))
	{
        REALDisposeStringData(outData);
        free(dataString);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return;
	}
	
    REALDisposeStringData(outData);
	free(dataString);
	
}/* BigPolyConstructor2 */


static void BigPolyDestructor(REALobject instance)
{
	BigPolyData		*data;
	
	// Get the class data
	
    data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
    
    myFree(data->bp);
	
}/* BigPolyDestructor */


static REALstring BigPolyToS(REALobject instance)
{
	BigPolyData		*data;
	REALstring		str;
	char*			dataString;
	INT64           length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	
	if(data==nil)
	{
		return nullString;
	}
	
	
	polyConvToxString(dataString, data->bp);
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
}/* BigPolyToS */


static int DegBigPoly(REALobject instance)
{
	BigPolyData		*data;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return 0;
	
	return (data->bp).deg;
	
}/* DegBigPoly */

// removes high order zeroes
static REALobject NormBigPoly(REALobject instance)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return instance;
    
    polyNormalize(data->bp);
	
	zData->bp = data->bp;
	
	return z;
	
}/* NormBigPoly */


static REALobject GetBigPolyCoeff(REALobject instance, long i)
{
	REALobject		z;
	BigFractionData *zData;
	BigPolyData		*data;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil || i<0 || (int)i>data->bp.deg)
		return 0;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return 0;
	
	zData->bfr = data->bp.array[(int)i];
	
	return z;
	
}/* GetBigPolyCoeff */


static REALobject PutBigPolyCoeff(REALobject instance, REALobject x, int i)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData	*xData;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil || i<0 || i>data->bp.deg)
		return 0;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return 0;
	
	zData->bp = data->bp;
	zData->bp.array[i] = xData->bfr;
	
	return z;
	
}/* PutBigPolyCoeff */


static REALobject NegateBigPoly(REALobject instance)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return instance;
	
	zData->bp = -data->bp;
	
	return z;
	
}/* NegateBigPoly */


static REALobject ModBigPoly(REALobject instance, double q)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return instance;
	
	zData->bp = (data->bp % q);
	
	return z;
	
}/* ModBigPoly */


static REALobject AddBigPoly_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bp, data->bp, xData->bp);
	
	return z;
	
}/* AddBigPoly_BigPoly */


static REALobject SubBigPoly_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bp, data->bp, xData->bp);
	
	return z;
	
}/* SubBigPoly_BigPoly */


static REALobject MulBigPoly_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bp, data->bp, xData->bp);
	
	return z;
	
}/* MulBigPoly_BigPoly */


static REALobject DivBigPoly_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bp, data->bp, xData->bp);
	
	return z;
	
}/* DivBigPoly_BigPoly */


static REALobject AddBigPoly_BigFraction(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bp, data->bp, xData->bfr);
	
	return z;
	
}/* AddBigPoly_BigFraction */


static REALobject AddBigFraction_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bp, xData->bfr, data->bp);
	
	return z;
	
}/* AddBigFraction_BigPoly */


static REALobject SubBigPoly_BigFraction(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bp, data->bp, xData->bfr);
	
	return z;
	
}/* SubBigPoly_BigFraction */


static REALobject SubBigFraction_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bp, xData->bfr, data->bp);
	
	return z;
	
}/* SubBigFraction_BigPoly */


static REALobject MulBigPoly_BigFraction(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bp, data->bp, xData->bfr);
	
	return z;
	
}/* MulBigPoly_BigFraction */


static REALobject MulBigFraction_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bp, xData->bfr, data->bp);
	
	return z;
	
}/* MulBigFraction_BigPoly */


static REALobject DivBigPoly_BigFraction(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bp, data->bp, xData->bfr);
	
	return z;
	
}/* DivBigPoly_BigFraction */


static REALobject DivBigFraction_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	BigFractionData *xData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bp, xData->bfr, data->bp);
	
	return z;
	
}/* DivBigFraction_BigPoly */


static REALobject AddBigPoly_Double(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bp, data->bp, x);
	
	return z;
	
}/* AddBigPoly_Double */


static REALobject AddDouble_BigPoly(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bp, x, data->bp);
	
	return z;
	
}/* AddDouble_BigPoly */


static REALobject SubBigPoly_Double(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bp, data->bp, x);
	
	return z;
	
}/* SubBigPoly_Double */


static REALobject SubDouble_BigPoly(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bp, x, data->bp);
	
	return z;
	
}/* SubDouble_BigPoly */


static REALobject MulBigPoly_Double(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bp, data->bp, x);
	
	return z;
	
}/* MulBigPoly_Double */


static REALobject MulDouble_BigPoly(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bp, x, data->bp);
	
	return z;
	
}/* MulDouble_BigPoly */


static REALobject DivBigPoly_Double(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bp, data->bp, x);
	
	return z;
	
}/* DivBigPoly_Double */


static REALobject DivDouble_BigPoly(REALobject instance, double x)
{
	REALobject		z;
	BigPolyData		*data, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	div(zData->bp, x, data->bp);
	
	return z;
	
}/* DivDouble_BigPoly */


// x^y
static REALobject PowBigPoly_Int(REALobject instance, long y)
{
	REALobject		z;
	BigPolyData		*xData, *zData;
	
	if(y==1)
		return instance;
	
	xData = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	polyPow(zData->bp, xData->bp, (int)y);
	
	return z;
	
}/* PowBigPoly_Int */

// x^y mod q
static REALobject PowBigPoly_Intq(REALobject instance, long y, double q)
{
	REALobject		z;
	BigPolyData		*xData, *zData;
	
	if(y==1)
		return instance;
	
	xData = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	polyPowModq(zData->bp, xData->bp, (int)y, q);
	
	return z;
	
}/* PowBigPoly_Intq */


static REALobject GCDBigPoly_BigPoly(REALobject instance, REALobject x)
{
	REALobject		z;
	BigPolyData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	zData->bp = gcd(data->bp, xData->bp);
	
	return z;
	
}/* GCDBigPoly_BigPoly */


static REALobject GCDBigPoly_BigPolyMod(REALobject instance, REALobject x, double q)
{
	REALobject		z;
	BigPolyData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	zData->bp = gcd(data->bp, xData->bp, q);
	
	return z;
	
}/* GCDBigPoly_BigPolyMod */


static REALstring fpPolyFactor(REALobject instance, double p)
{
    BigPolyData        *data;
    REALstring        str;
    char*            dataString;
    INT64           length;
    
    if(instance==nil)
    {
        return nullString;
    }
    
    // Get the class data
    data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
    
    if(data==nil)
    {
        return nullString;
    }
    
    polyFactorOverp(dataString, data->bp, p);
    length = strlen(dataString);
    
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
    
    free(dataString);
    return str;
    
}/* fpPolyFactor */

static REALstring fpgenPolyCyclicGroup(REALobject instance, double p)
{
    BigPolyData      *data;
    REALstring       str;
    char*            dataString;
    INT64            length;
    
    data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
    if(data==nil)
        return nullString;
    
    genPolyCyclicGroup(dataString, data->bp, p);
    length = strlen(dataString);
    
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
    
    free(dataString);
    return str;
    
}/* fpgenPolyCyclicGroup */

static bool fpisPolyIntMonic(REALobject instance)
{
    BigPolyData      *data;
    
    data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
    
    if(isPolyIntMonic(data->bp))
        return true;
    
    return false;
    
}/* fpisPolyIntMonic */

static bool fpisPolyInteger(REALobject instance)
{
    BigPolyData      *data;
    
    data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
    
    if(isPolyInteger(data->bp))
        return true;
    
    return false;
    
}/* fpisPolyInteger */

static REALobject fpPolyEval(REALobject instance, REALobject x)
{
	REALobject 		    z;
	BigPolyData 		*data;
	BigFractionData 	*xData, *zData;

	data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	if(data==nil || xData==nil)
		return x;

	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
    zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	zData->bfr = polyEval(data->bp, xData->bfr);
	return z;

}/* fpPolyEval */


static REALmethodDefinition BigPolyMethods[] = {
	// defines methods:
	{ (REALproc) BigPolyConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
	{ (REALproc) BigPolyConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
	{ (REALproc) BigPolyDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) BigPolyToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
	{ (REALproc) DegBigPoly, REALnoImplementation, "Deg() As Integer", REALconsoleSafe },
	{ (REALproc) NormBigPoly, REALnoImplementation, "Norm() As BigPoly", REALconsoleSafe },
	{ (REALproc) GetBigPolyCoeff, REALnoImplementation, "GetCoeff(i As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) PutBigPolyCoeff, REALnoImplementation, "PutCoeff(theCoeff As BigFraction, i As Integer) As BigPoly", REALconsoleSafe },
	{ (REALproc) NegateBigPoly, REALnoImplementation, "Operator_Negate() As BigPoly", REALconsoleSafe },
	{ (REALproc) ModBigPoly, REALnoImplementation, "Operator_Modulo(q As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) AddBigPoly_BigPoly, REALnoImplementation, "Operator_Add(x As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) SubBigPoly_BigPoly, REALnoImplementation, "Operator_Subtract(x As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) MulBigPoly_BigPoly, REALnoImplementation, "Operator_Multiply(x As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) DivBigPoly_BigPoly, REALnoImplementation, "Operator_Divide(x As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) AddBigPoly_BigFraction, REALnoImplementation, "Operator_Add(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) AddBigFraction_BigPoly, REALnoImplementation, "Operator_AddRight(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) SubBigPoly_BigFraction, REALnoImplementation, "Operator_Subtract(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) SubBigFraction_BigPoly, REALnoImplementation, "Operator_SubtractRight(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) MulBigPoly_BigFraction, REALnoImplementation, "Operator_Multiply(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) MulBigFraction_BigPoly, REALnoImplementation, "Operator_MultiplyRight(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) DivBigPoly_BigFraction, REALnoImplementation, "Operator_Divide(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) DivBigFraction_BigPoly, REALnoImplementation, "Operator_DivideRight(x As BigFraction) As BigPoly", REALconsoleSafe },
	{ (REALproc) AddBigPoly_Double, REALnoImplementation, "Operator_Add(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) AddDouble_BigPoly, REALnoImplementation, "Operator_AddRight(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) SubBigPoly_Double, REALnoImplementation, "Operator_Subtract(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) SubDouble_BigPoly, REALnoImplementation, "Operator_SubtractRight(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) MulBigPoly_Double, REALnoImplementation, "Operator_Multiply(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) MulDouble_BigPoly, REALnoImplementation, "Operator_MultiplyRight(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) DivBigPoly_Double, REALnoImplementation, "Operator_Divide(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) DivDouble_BigPoly, REALnoImplementation, "Operator_DivideRight(x As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) PowBigPoly_Int, REALnoImplementation, "Operator_Power(y As Integer) As BigPoly", REALconsoleSafe },
	{ (REALproc) fpPolyEval, REALnoImplementation, "Eval(x As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) GCDBigPoly_BigPoly, REALnoImplementation, "GCD(x As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) GCDBigPoly_BigPolyMod, REALnoImplementation, "GCD(x As BigPoly, q As Double) As BigPoly", REALconsoleSafe },
	//{ (REALproc) fpPolyFactor, REALnoImplementation, "PolyFactor(p As Double) As String", REALconsoleSafe },
    //{ (REALproc) fpgenPolyCyclicGroup, REALnoImplementation, "genPolyCyclicGroup(p As Double) As String", REALconsoleSafe },
    { (REALproc) fpisPolyIntMonic, REALnoImplementation, "isPolyIntMonic() As Boolean", REALconsoleSafe },
    { (REALproc) fpisPolyInteger, REALnoImplementation, "isPolyInteger() As Boolean", REALconsoleSafe },
};


REALclassDefinition BigPolyClass = {
	kCurrentREALControlVersion,
	"BigPoly",		// name of class
	nil,				// no superclasses
	sizeof(BigPolyData),		// size of our data
	0,							// for system use
	nil,						// initializer
	nil,						// finializer
	nil,            			// properties
	0,							// property count
	BigPolyMethods,           // methods
	sizeof(BigPolyMethods) / sizeof(REALmethodDefinition),	// method count
	nil,						// Events
	0,							// Event count
	nil,						// eventInstances
	0,							// eventInstanceCount
	nil,						// interface strings
	nil,						// obsolete1
	nil,						// obsolete2
	nil,						// constants
	0,							// constantCount
	REALconsoleSafe,			// flags
	nil,						// shared properties
	0,							// sharedPropertyCount
	nil,						// shared methods
	0,							// sharedMethodCount
};

// z = x / y with remainder r
// x = z * y + r
static REALobject DivBigPoly_BigPolyEuclid(REALobject r, REALobject x, REALobject y)
{
	REALobject		z;
	BigPolyData		*xData, *yData, *zData, *rData;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigPolyData *) REALGetClassData(y, &BigPolyClass);
	
	if(xData==nil || yData==nil)
		return r;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	rData = (BigPolyData *) REALGetClassData(r, &BigPolyClass);
	
	if(zData==nil || rData==nil)
		return z;
	
	divEuclid(zData->bp, rData->bp, xData->bp, yData->bp);
	
	return z;
	
}/* DivBigPoly_BigPolyEuclid */

static REALobject DivBigPoly_BigPolyEuclid2(REALobject r, REALobject x, REALobject y, double q)
{
	REALobject		z;
	BigPolyData		*xData, *yData, *zData, *rData;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigPolyData *) REALGetClassData(y, &BigPolyClass);
	
	if(xData==nil || yData==nil)
		return r;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	rData = (BigPolyData *) REALGetClassData(r, &BigPolyClass);
	
	if(zData==nil || rData==nil)
		return z;
	
    divEuclid(zData->bp, rData->bp, xData->bp, yData->bp, q);
	
	return z;
	
}/* DivBigPoly_BigPolyEuclid2 */


static REALobject PolyMod1(REALobject x, REALobject y)
{
	REALobject		z;
	BigPolyData		*xData, *yData, *zData;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigPolyData *) REALGetClassData(y, &BigPolyClass);
	
	if(xData==nil || yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	zData->bp = polyModPoly(xData->bp, yData->bp);
	return z;
	
}/* PolyMod1 */


static REALobject PolyMod2(REALobject x, REALobject y, double q)
{
	REALobject		z;
	BigPolyData		*xData, *yData, *zData;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigPolyData *) REALGetClassData(y, &BigPolyClass);
	
	if(xData==nil || yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	polyModPolyModq(zData->bp, xData->bp, yData->bp, q);
    
	return z;
	
}/* PolyMod2 */


static REALobject PolyMod3(REALobject x, REALobject y)
{
	REALobject		z;
	BigPolyData		*xData, *zData;
	BigIntegerData	*yData;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigIntegerData *) REALGetClassData(y, &BigIntegerClass);
	
	if(xData==nil || yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	zData->bp = polyMod(xData->bp, yData->i);
	return z;
	
}/* PolyMod3 */


static REALobject PolyMod4(REALobject x, double y)
{
	REALobject		z;
	BigPolyData		*xData, *zData;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	zData->bp = polyMod(xData->bp, y);
	return z;
	
}/* PolyMod4 */


static REALobject PolySquareFree(REALobject x)
{
	REALobject		z;
	BigPolyData		*xData;
	BigFractionMatrixData	*zData;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	polySquareFree2(zData->bm, xData->bp);
	
	return z;
	
}/* PolySquareFree */


static REALobject PolyFromMatrixRow(REALobject x, long theRow)
{
	REALobject		z;
	BigPolyData		*zData;
	BigFractionMatrixData	*xData;
	
	if(x==nil)
		return x;
	
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	polyFromMatrixRow(zData->bp, (int)theRow, xData->bm);
	
	return z;
	
}/* PolyFromMatrixRow */


static REALobject PolyPowerMod1(REALobject x, long p, REALobject y)
{
	REALobject		z;
	BigPolyData		*xData, *yData, *zData;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigPolyData *) REALGetClassData(y, &BigPolyClass);
	
	if(xData==nil || yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	zData->bp = polyPowerMod(xData->bp, (int)p, yData->bp);
	return z;
	
}/* PolyPowerMod1 */


static REALobject PolyPowerMod2(REALobject x, long p, REALobject y, double q)
{
	REALobject		z;
	BigPolyData		*xData, *yData, *zData;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigPolyData *) REALGetClassData(y, &BigPolyClass);
	
	if(xData==nil || yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return z;
	
	zData->bp = polyPowerModPolyModq(xData->bp, (int)p, yData->bp, q);
	return z;
	
}/* PolyPowerMod2 */


static REALstring PowersOfSquareFreeFactors(REALobject x, long& numPolys)
{
	REALstring		str;
	BigPolyData		*xData;
	char*			dataString;
	int             length;
    int             numPolysint;
	
	if(x==nil)
	{
		return nullString;
	}
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(xData==nil)
	{
		return nullString;
	}
	
	findPowersOfSquareFreeFactors(dataString, numPolysint, xData->bp);
    numPolys = numPolysint;
    
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	
	return str;
	
}/* PowersOfSquareFreeFactors */

// y = theExp column matrix; must be initialized
static REALobject PowersOfSquareFreeFactors2(REALobject x, REALobject y, long& numPolys)
{
	REALobject			z;
	BigFractionMatrixData		*yData, *zData;
	BigPolyData			*xData;
    int                 numPolysint;
	
	if(x==nil)
		return x;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigFractionMatrixData *) REALGetClassData(y, &BigFractionMatrixClass);
	
	if(xData==nil || yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	findPowersOfSquareFreeFactors(zData->bm, yData->bm, numPolysint, xData->bp);
    numPolys = numPolysint;
	
	return z;
	
}/* PowersOfSquareFreeFactors2 */

static REALstring fpfindPrimitivePolys(double m, double p)
{
    REALstring          str;
    char*               dataString;
    INT64               length;
    int                 mInt;
    
    mInt = m;
    findPrimitivePolys(dataString, mInt, p);
    length = strlen(dataString);
    
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
    
    free(dataString);
    return str;
    
}/* fpfindPrimitivePolys */

static REALobject fppolyZechLogs(REALobject x, double p)
{
    REALobject              z;
    BigPolyData             *xData, *zData;
    
    z = REALnewInstanceWithClass(globalBigPolyRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    
    xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
    if(xData==nil)
        return x;
    zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
    if(zData==nil)
        return z;
    
    init(zData->bp);
    
    if(!polyZechLogs(zData->bp, xData->bp, p))
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return z;
    }
    
    return z;
    
}/* fppolyZechLogs */

static REALstring fpFindPolyRoots2(REALobject x, bool doRoundToZero)
{
    REALstring        str;
    BigPolyData       *xData;
    char*             dataString;
    INT64             length;
    
    xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
    if(xData==nil)
        return nullString;
    
    if(!findPolyRoots(dataString, xData->bp, doRoundToZero))
        return nullString;
    
    length = strlen(dataString);
    
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
    
    free(dataString);
    return str;
    
}/* fpFindPolyRoots2 */

static REALstring fpPolyFactorOverIntegers(REALobject instance)
{
    BigPolyData         *data;
    REALstring          str;
    char*               dataString;
    INT64               length;
    
    if(instance==nil)
    {
        return nullString;
    }
    
    // Get the class data
    data = (BigPolyData *) REALGetClassData(instance, &BigPolyClass);
    
    if(data==nil)
    {
        return nullString;
    }
    
    polyFactorOverIntegers(dataString, data->bp);
    length = strlen(dataString);
    
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
    
    free(dataString);
    return str;
    
}/* fpPolyFactorOverIntegers */

static REALmethodDefinition otherBigPolyMethods[] = {
	{ (REALproc) BigPolyToS, REALnoImplementation, "Str(x As BigPoly) As String", REALconsoleSafe },
	{ (REALproc) DegBigPoly, REALnoImplementation, "fpDeg(x As BigPoly) As Integer", REALconsoleSafe },
	{ (REALproc) GetBigPolyCoeff, REALnoImplementation, "fpGetBigPolyCoeff(x As BigPoly, i As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) PutBigPolyCoeff, REALnoImplementation, "fpPutBigPolyCoeff(x As BigPoly, theCoeff As BigFraction, i As Integer) As BigPoly", REALconsoleSafe },
    { (REALproc) fpPolyEval, REALnoImplementation, "fpPolyEval(x As BigPoly, y As BigFraction) As BigFraction", REALconsoleSafe },
	{ (REALproc) NormBigPoly, REALnoImplementation, "fpNorm(x As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) DivBigPoly_BigPolyEuclid, REALnoImplementation, "fpDivEuclid(r As BigPoly, x As BigPoly, y As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) DivBigPoly_BigPolyEuclid2, REALnoImplementation, "fpDivEuclidp(r As BigPoly, x As BigPoly, y As BigPoly, p As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) PowBigPoly_Int, REALnoImplementation, "fpPolyPow(x As BigPoly, y As Integer) As BigPoly", REALconsoleSafe },
	{ (REALproc) PowBigPoly_Intq, REALnoImplementation, "fpPolyPowp(x As BigPoly, y As Integer, p As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) GCDBigPoly_BigPoly, REALnoImplementation, "fpGCD(x As BigPoly, y As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) GCDBigPoly_BigPolyMod, REALnoImplementation, "fpGCDp(x As BigPoly, y As BigPoly, p As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) PolyMod1, REALnoImplementation, "fpPolyModPoly(x As BigPoly, y As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) PolyMod2, REALnoImplementation, "fpPolyModPolyModp(x As BigPoly, y As BigPoly, p As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) PolyMod3, REALnoImplementation, "fpPolyModBigInt(x As BigPoly, p As BigInteger) As BigPoly", REALconsoleSafe },
	{ (REALproc) PolyMod4, REALnoImplementation, "fpPolyModp(x As BigPoly, p As Double) As BigPoly", REALconsoleSafe },
	//{ (REALproc) PolySquareFree, REALnoImplementation, "fpPolySquareFree(x As BigPoly) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) PolyFromMatrixRow, REALnoImplementation, "fpPolyFromMatrixRow(x As BigFractionMatrix, theRow As Integer) As BigPoly", REALconsoleSafe },
	{ (REALproc) PolyPowerMod1, REALnoImplementation, "fpPolyPowerModPoly(x As BigPoly, power As Integer, y As BigPoly) As BigPoly", REALconsoleSafe },
	{ (REALproc) PolyPowerMod2, REALnoImplementation, "fpPolyPowerModPolyModp(x As BigPoly, power As Integer, y As BigPoly, p As Double) As BigPoly", REALconsoleSafe },
	//{ (REALproc) PowersOfSquareFreeFactors, REALnoImplementation, "fpPowersOfSquareFreeFactors(x As BigPoly, ByRef numPolys As Integer) As String", REALconsoleSafe },
	//{ (REALproc) PowersOfSquareFreeFactors2, REALnoImplementation, "fpPowersOfSquareFreeFactors2(x As BigPoly, theExp As BigFractionMatrix, ByRef numPolys As Integer) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) fpPolyFactor, REALnoImplementation, "fpPolyFactor(x As BigPoly, p As Double) As String", REALconsoleSafe },
    { (REALproc) fpfindPrimitivePolys, REALnoImplementation, "fpFindPrimitivePolys(m As Double, p As Double) As String", REALconsoleSafe },
    { (REALproc) fpgenPolyCyclicGroup, REALnoImplementation, "fpgenPolyCyclicGroup(primPoly As BigPoly, p As Double) As String", REALconsoleSafe },
    { (REALproc) fpisPolyIntMonic, REALnoImplementation, "fpisPolyIntMonic(x As BigPoly) As Boolean", REALconsoleSafe },
    { (REALproc) fppolyZechLogs, REALnoImplementation, "fppolyZechLogs(x As BigPoly, p As Double) As BigPoly", REALconsoleSafe },
    { (REALproc) fpFindPolyRoots2, REALnoImplementation, "fpFindPolyRoots2(x As BigPoly, doRoundToZero As Boolean) As String", REALconsoleSafe },
    { (REALproc) fpPolyFactorOverIntegers, REALnoImplementation, "fpPolyFactorOverIntegers(x As BigPoly) As String", REALconsoleSafe },
    
};

static void BigFractionMatrixConstructor(REALobject instance)
{
	BigFractionMatrixData		*data;
	
	// Get the class data
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if (data == nil)
		return;
	
	(data->bm).nr = 0;
	(data->bm).nc = 0;
	(data->bm).array = NULL;
	
}/* BigFractionMatrixConstructor */


static void BigFractionMatrixConstructor2(REALobject instance, REALstring CStr)
{
	BigFractionMatrixData	*data;
	char			*dataString;
	long            length;
    REALstringData   *outData;
	
	// Get the class data
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if (data == nil)
		return;
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        (data->bm).nr = 1;
        (data->bm).nc = 1;
        (data->bm).array = (bf**)malloc((data->bm).nr*sizeof(bf*));
        (data->bm).array[0] = (bf*)malloc((data->bm).nc*sizeof(bf));
        (data->bm).array[0][0] = 0;
        return;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
	
	if(!matqConvFromStr(data->bm, dataString))
	{
        REALDisposeStringData(outData);
        free(dataString);
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return;
	}
	
    REALDisposeStringData(outData);
	free(dataString);
	
}/* BigFractionMatrixConstructor2 */


static void BigFractionMatrixConstructor3(REALobject instance, long nRows, long nCols)
{
    BigFractionMatrixData	*data;
    
    // Get the class data
    data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
    
    if (data == nil)
        return;
    
    init(data->bm, nRows, nCols);
    
}/* BigFractionMatrixConstructor3 */


static void BigFractionMatrixDestructor(REALobject instance)
{
    BigFractionMatrixData		*data;
	
	// Get the class data
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if (data == nil)
		return;
    
    myFree(data->bm);
	
}/* BigFractionMatrixDestructor */


static REALstring BigFractionMatrixToS(REALobject instance)
{
	BigFractionMatrixData	*data;
	REALstring		str;
	char*			dataString;
	INT64           length;
	
	if(instance==nil)
	{
		return nullString;
	}
	
	// Get the class data
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
	{
		return nullString;
	}
	
	matqConvToStr(dataString, data->bm);
	length = strlen(dataString);
	
	str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
	
	free(dataString);
	return str;
	
}/* BigFractionMatrixToS */

static void convertBigFractionMatrixToBigFractionMatrix(REALobject instance, REALobject x)
{
    BigFractionMatrixData		*data, *xData;
    
    // Get the class data
    data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
    
    if(data==nil)
    {
        return;
    }
    
    
    xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
    
    if(xData==nil)
        return;
    
    data->bm = xData->bm;
    
    return;
    
}/* convertBigFractionMatrixToBigFractionMatrix */


static int RowsBigFractionMatrix(REALobject instance)
{
	BigFractionMatrixData		*data;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return 0;
	
	return (data->bm).nr;
	
}/* RowsBigFractionMatrix */


static int ColsBigFractionMatrix(REALobject instance)
{
	BigFractionMatrixData		*data;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return 0;
	
	return (data->bm).nc;
	
}/* ColsBigFractionMatrix */


static REALobject GetBigFractionMatrixElement(REALobject instance, long i, long j)
{
	REALobject		z;
	BigFractionData *zData;
	BigFractionMatrixData	*data;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil || i<0 || (int)i>=data->bm.nr || j<0 || (int)j>=data->bm.nc)
		return 0;
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return 0;
	
	zData->bfr = data->bm.array[(int)i][(int)j];
	
	return z;
	
}/* GetBigFractionMatrixElement */


static REALobject PutBigFractionMatrixElement(REALobject instance, REALobject x, long i, long j)
{
	REALobject		z;
	BigFractionMatrixData	*data, *zData;
	BigFractionData	*xData;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	xData = (BigFractionData *) REALGetClassData(x, &BigFractionClass);
	
	if(data==nil || xData==nil || i<0 || (int)i>=data->bm.nr || j<0 || (int)j>=data->bm.nc)
		return 0;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return 0;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return 0;
	
	zData->bm = data->bm;
	zData->bm.array[(int)i][(int)j] = xData->bfr;
	
	return z;
	
}/* PutBigFractionMatrixElement */


static REALobject NegateBigFractionMatrix(REALobject instance)
{
	REALobject	z;
	BigFractionMatrixData		*data, *zData;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
	
	
	zData->bm = -data->bm;
	
	return z;
	
}/* NegateBigFractionMatrix */


static REALobject TransposeBigFractionMatrix(REALobject instance)
{
	REALobject	z;
	BigFractionMatrixData		*data, *zData;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
	
	
	zData->bm = transpose(data->bm);
	
	return z;
	
}/* TransposeBigFractionMatrix */


static REALobject ModBigFractionMatrix(REALobject instance, double q)
{
	REALobject			z;
	BigFractionMatrixData		*data, *zData;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
	
	matqMod(zData->bm, data->bm, q);
	
	return z;
	
}/* ModBigFractionMatrix */


static REALobject AddBigFractionMatrix_BigFractionMatrix(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionMatrixData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(!((data->bm).nr==(xData->bm).nr && (data->bm).nc==(xData->bm).nc))
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	add(zData->bm, data->bm, xData->bm);
	
	return z;
	
}/* AddBigFractionMatrix_BigFractionMatrix */


static REALobject SubBigFractionMatrix_BigFractionMatrix(REALobject instance, REALobject x)
{
	REALobject                  z;
	BigFractionMatrixData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if(!((data->bm).nr==(xData->bm).nr && (data->bm).nc==(xData->bm).nc))
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	sub(zData->bm, data->bm, xData->bm);
	
	return z;
	
}/* SubBigFractionMatrix_BigFractionMatrix */


static REALobject MulBigFractionMatrix_BigFractionMatrix(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionMatrixData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if((data->bm).nc!=(xData->bm).nr)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	mul(zData->bm, data->bm, xData->bm);
	
	return z;
	
}/* MulBigFractionMatrix_BigFractionMatrix */


// x^y
static REALobject PowBigFractionMatrix_Int(REALobject instance, long y)
{
	REALobject          z;
	BigFractionMatrixData		*xData, *zData;
	
	if(y==1)
		return instance;
	
	xData = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(xData==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	if(!power(zData->bm, xData->bm, (int)y))
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return instance;
	}
	
	return z;
	
}/* PowBigFractionMatrix_Int */


static REALobject InvertBigFractionMatrix(REALobject instance)
{
	REALobject			z;
	BigFractionMatrixData		*data, *zData;
	bf					det;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	if((data->bm).nc!=(data->bm).nr)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
	
	
	zData->bm = matqInvert(det, data->bm);
	
	return z;
	
}/* InvertBigFractionMatrix */


static REALobject DetBigFractionMatrix(REALobject instance)
{
	REALobject			z;
	BigFractionMatrixData		*data;
	BigFractionData		*zData;
	matq				x;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return 0;
	
	if((data->bm).nc!=(data->bm).nr)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return 0;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	
	x = matqInvert(zData->bfr, data->bm);
	
	return z;
	
}/* DetBigFractionMatrix */


static REALobject TraceBigFractionMatrix(REALobject instance)
{
	REALobject			z;
	BigFractionMatrixData		*data;
	BigFractionData		*zData;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return 0;
	
	if((data->bm).nc!=(data->bm).nr)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return 0;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionData *) REALGetClassData(z, &BigFractionClass);
	
	if(zData==nil)
		return z;
	
	
	zData->bfr = trace(data->bm);
	
	return z;
	
}/* TraceBigFractionMatrix */


static REALobject RowAugmentBigFractionMatrix(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionMatrixData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if((data->bm).nc!=(xData->bm).nc)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	matqRowAugment(zData->bm, data->bm, xData->bm);
	
	return z;
	
}/* RowAugmentBigFractionMatrix */


static REALobject ColumnAugmentBigFractionMatrix(REALobject instance, REALobject x)
{
	REALobject			z;
	BigFractionMatrixData		*data, *xData, *zData;
	
	if(instance==nil)
		return instance;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	
	if(data==nil || xData==nil)
		return instance;
	
	if((data->bm).nr!=(xData->bm).nr)
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return instance;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	matqColAugment(zData->bm, data->bm, xData->bm);
	
	return z;
	
}/* ColumnAugmentBigFractionMatrix */


static REALobject GaussElimBigFractionMatrix(REALobject instance, long& swapParity)
{
	REALobject			z;
	BigFractionMatrixData		*data, *zData;
	bf					det;
    int                 swapParityint;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
	
	matqGaussElim(zData->bm, swapParityint, data->bm);
    swapParity = swapParityint;
	
	return z;
	
}/* GaussElimBigFractionMatrix */


static REALobject GaussElimBigFractionMatrix2(REALobject instance, double q)
{
	REALobject			z;
	BigFractionMatrixData		*data, *zData;
	bf					det;
    INT32               swapParity, qInt;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
    qInt = q;
	matqGaussElimModq(zData->bm, swapParity, data->bm, qInt);
	
	return z;
	
}/* GaussElimBigFractionMatrix2 */


static REALobject ReduceBigFractionMatrix(REALobject instance)
{
	REALobject			z;
	BigFractionMatrixData		*data, *zData;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
	
	matqReduce(zData->bm, data->bm);
	
	return z;
	
}/* ReduceBigFractionMatrix */


static REALobject ReduceRowEchelonBigFractionMatrix(REALobject instance)
{
	REALobject			z;
	BigFractionMatrixData		*data, *zData;
	int				swapParity;
	
	data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
	
	if(data==nil)
		return instance;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return instance;
	
	matqGaussElim(zData->bm, swapParity, data->bm);
	matqReduce(zData->bm, zData->bm);
	
	return z;
	
}/* ReduceRowEchelonBigFractionMatrix */

static long fpRank(REALobject instance)
{
    BigFractionMatrixData        *data;
    long                         rank;
    
    data = (BigFractionMatrixData *) REALGetClassData(instance, &BigFractionMatrixClass);
    if(data==nil)
        return 0;
    
    rank = matqRank(data->bm);
    return rank;
    
}/* fpRank */

static REALmethodDefinition BigFractionMatrixMethods[] = {
	// defines methods:
	{ (REALproc) BigFractionMatrixConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
	{ (REALproc) BigFractionMatrixConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
    { (REALproc) BigFractionMatrixConstructor3, REALnoImplementation, "Constructor(nRows As Integer, nCols As Integer)", REALconsoleSafe },
	{ (REALproc) BigFractionMatrixDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) BigFractionMatrixToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
    { (REALproc) convertBigFractionMatrixToBigFractionMatrix, REALnoImplementation, "Operator_Convert(x As BigFractionMatrix)", REALconsoleSafe },
	{ (REALproc) RowsBigFractionMatrix, REALnoImplementation, "NumRows() As Integer", REALconsoleSafe },
	{ (REALproc) ColsBigFractionMatrix, REALnoImplementation, "NumColumns() As Integer", REALconsoleSafe },
	{ (REALproc) GetBigFractionMatrixElement, REALnoImplementation, "GetElement(i As Integer, j As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) PutBigFractionMatrixElement, REALnoImplementation, "PutElement(theElement As BigFraction, i As Integer, j As Integer) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) NegateBigFractionMatrix, REALnoImplementation, "Operator_Negate() As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) TransposeBigFractionMatrix, REALnoImplementation, "Transpose() As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) ModBigFractionMatrix, REALnoImplementation, "Operator_Modulo(q As Double) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) AddBigFractionMatrix_BigFractionMatrix, REALnoImplementation, "Operator_Add(x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) SubBigFractionMatrix_BigFractionMatrix, REALnoImplementation, "Operator_Subtract(x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) MulBigFractionMatrix_BigFractionMatrix, REALnoImplementation, "Operator_Multiply(x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) PowBigFractionMatrix_Int, REALnoImplementation, "Operator_Power(y As Integer) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) InvertBigFractionMatrix, REALnoImplementation, "Invert() As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) DetBigFractionMatrix, REALnoImplementation, "Det() As BigFraction", REALconsoleSafe },
    { (REALproc) TraceBigFractionMatrix, REALnoImplementation, "Trace() As BigFraction", REALconsoleSafe },
	{ (REALproc) RowAugmentBigFractionMatrix, REALnoImplementation, "RowAugment(y As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) ColumnAugmentBigFractionMatrix, REALnoImplementation, "ColumnAugment(y As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) GaussElimBigFractionMatrix, REALnoImplementation, "GaussEliminate(ByRef swapParity As Integer) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) GaussElimBigFractionMatrix2, REALnoImplementation, "GaussEliminate(q As Double) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) ReduceBigFractionMatrix, REALnoImplementation, "Reduce() As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) ReduceRowEchelonBigFractionMatrix, REALnoImplementation, "ReduceRowEchelon() As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) fpRank, REALnoImplementation, "Rank() As Integer", REALconsoleSafe },
    
};


REALclassDefinition BigFractionMatrixClass = {
	kCurrentREALControlVersion,
	"BigFractionMatrix",		// name of class
	nil,				// no superclasses
	sizeof(BigFractionMatrixData),		// size of our data
	0,							// for system use
	nil,						// initializer
	nil,						// finializer
	nil,            			// properties
	0,							// property count
	BigFractionMatrixMethods,           // methods
	sizeof(BigFractionMatrixMethods) / sizeof(REALmethodDefinition),	// method count
	nil,						// Events
	0,							// Event count
	nil,						// eventInstances
	0,							// eventInstanceCount
	nil,						// interface strings
	nil,						// obsolete1
	nil,						// obsolete2
	nil,						// constants
	0,							// constantCount
	REALconsoleSafe,			// flags
	nil,						// shared properties
	0,							// sharedPropertyCount
	nil,						// shared methods
	0,							// sharedMethodCount
};


static REALobject UnitBigFractionMatrix(int n)
{
	REALobject			z;
	BigFractionMatrixData		*zData;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	
	zData->bm = matqUnit(n);
	
	return z;
	
}/* UnitBigFractionMatrix */


// z=nullVectors; y=reduced; x=original matrix
static REALobject NullSpaceBigFractionMatrix(long& numNV, REALobject x)
{
	REALobject              z;
	BigFractionMatrixData	*xData, *zData;
    int                     numNVint;
	
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return x;
	
	matqNullSpace(numNVint, zData->bm, xData->bm);
    numNV = numNVint;
	
	return z;
	
}/* NullSpaceBigFractionMatrix */

/*
static REALobject CalcQBigFractionMatrix(REALobject x)
{
	REALobject			z;
	BigFractionMatrixData		*zData;
	BigPolyData			*xData;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return x;
	
	
	polyCalcQmatrix(zData->bm, xData->bp);
	
	return z;
	
}*//* CalcQBigFractionMatrix */


static REALobject CalcQBigFractionMatrix2(REALobject x, double q)
{
	REALobject			z;
	BigFractionMatrixData		*zData;
	BigPolyData			*xData;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(xData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return x;
	
	
	polyCalcQmatrix(zData->bm, xData->bp, q);
	
	return z;
	
}/* CalcQBigFractionMatrix2 */

// x=poly to factor; y=nullVectors
static REALobject FindFactorBigFractionMatrix(REALobject x, REALobject y, double q)
{
	REALobject			z;
	BigFractionMatrixData		*yData;
	BigPolyData			*xData, *zData;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	yData = (BigFractionMatrixData *) REALGetClassData(y, &BigFractionMatrixClass);
	
	if(xData==nil || yData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigPolyRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigPolyData *) REALGetClassData(z, &BigPolyClass);
	
	if(zData==nil)
		return x;
	
	polySFfindFactor(zData->bp, xData->bp, yData->bm, q);
	
	return z;
	
}/* FindFactorBigFractionMatrix */


/// puts polys in rows of matrix where numRows=numPolys and numCols=maxPolyDeg+1; for smaller deg fill row end with zeroes for smaller degrees
// poly x should have integer coefficients and must be square free
// also the highest degree coefficient should be 1
static REALobject FindFactorBigFractionMatrix2(REALobject x)
{
	REALobject			z;
	BigFractionMatrixData		*zData;
	BigPolyData			*xData;
	
	xData = (BigPolyData *) REALGetClassData(x, &BigPolyClass);
	
	if(xData==nil)
	{
		z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
		return z;
	}
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	polySFfindTrueFactors2(zData->bm, xData->bp);
	
	return z;
	
}/* FindFactorBigFractionMatrix2 */


// x^y
static REALobject PowerModBigFractionMatrix(REALobject x, REALobject y, REALobject q)
{
	REALobject          z;
	BigFractionMatrixData		*xData, *zData;
	BigIntegerData		*yData, *qData;
	
	xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
	yData = (BigIntegerData *) REALGetClassData(y, &BigIntegerClass);
	qData = (BigIntegerData *) REALGetClassData(q, &BigIntegerClass);
	
	if(xData==nil || yData==nil || qData==nil)
		return x;
	
	z = REALnewInstanceWithClass(globalBigFractionMatrixRef);
	if(z==nil)
	{
		REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
		REALRaiseException(err);
		return z;
	}
	zData = (BigFractionMatrixData *) REALGetClassData(z, &BigFractionMatrixClass);
	
	if(zData==nil)
		return z;
	
	if(!powerMod(zData->bm, xData->bm, yData->i, qData->i))
	{
		REALobject err = REALnewInstanceWithClass(globalBadInputRef);
		REALRaiseException(err);
		return x;
	}
	
	return z;
	
}/* PowerModBigFractionMatrix */

// LU decomposition A = P L U
static Boolean fpLUdecomp(REALobject A, REALobject P, REALobject L, REALobject U)
{
    BigFractionMatrixData   *Adata, *Pdata, *Ldata, *Udata;
    INT32           swapParity=1;
    
    Adata = (BigFractionMatrixData *) REALGetClassData(A, &BigFractionMatrixClass);
    Pdata = (BigFractionMatrixData *) REALGetClassData(P, &BigFractionMatrixClass);
    Ldata = (BigFractionMatrixData *) REALGetClassData(L, &BigFractionMatrixClass);
    Udata = (BigFractionMatrixData *) REALGetClassData(U, &BigFractionMatrixClass);
    
    if(Adata==nil || Pdata==nil || Ldata==nil || Udata==nil)
        return false;
    
    if (!LUdecomp(Adata->bm, Pdata->bm, Ldata->bm, Udata->bm, swapParity))
    {
        return false;
    }
    
    return true;
    
}/* fpLUdecomp */

// void matqEigenvectors(matc& eigenvectors, matc& eigenvalues, long*& algMultiplicity, long*& geoMultiplicity, const matc& x, long myDecPrec, const fp& zeroSet);
static REALobject fpEigenFrac(REALobject eigenvalues, REALobject algMultiplicity, REALobject geoMultiplicity, REALobject x, long myDecPrec, REALobject zeroSet)
{
    REALobject              z;
    BigComplexMatrixData    *zData, *aData;
    BigFractionMatrixData   *xData;
    intarray                *bData, *cData;
    BigFloatData            *dData;
    long                    numE; // number of distinct eigenvalues
    
    REALUnlockObject(eigenvalues);
    REALUnlockObject(algMultiplicity);
    REALUnlockObject(geoMultiplicity);
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    if(zData==nil)
        return nil;
    
    aData = (BigComplexMatrixData *) REALGetClassData(eigenvalues, &BigComplexMatrixClass);
    if(aData==nil)
        return nil;
    
    bData = (intarray*) REALGetClassData(algMultiplicity, &IntArrayClass);
    if(bData==nil)
        return nil;
    
    cData = (intarray*) REALGetClassData(geoMultiplicity, &IntArrayClass);
    if(cData==nil)
        return nil;
    
    xData = (BigFractionMatrixData *) REALGetClassData(x, &BigFractionMatrixClass);
    if(xData==nil)
        return nil;
    
    dData = (BigFloatData *) REALGetClassData(zeroSet, &BigFloatClass);
    if(dData==nil)
        return nil;
    
    matqEigenvectors(zData->bm, aData->bm, bData->array, cData->array, xData->bm, myDecPrec, dData->f);
    numE = aData->bm.nr;
    bData->n = numE;
    cData->n = numE;
    
    REALLockObject(eigenvalues);
    REALLockObject(algMultiplicity);
    REALLockObject(geoMultiplicity);
    REALLockObject(z);
    
    return z;
    
}/* fpEigenFrac */


static REALmethodDefinition otherBigFractionMatrixMethods[] = {
	{ (REALproc) BigFractionMatrixToS, REALnoImplementation, "Str(x As BigFractionMatrix) As String", REALconsoleSafe },
	{ (REALproc) RowsBigFractionMatrix, REALnoImplementation, "fpNumRows(x As BigFractionMatrix) As Integer", REALconsoleSafe },
	{ (REALproc) ColsBigFractionMatrix, REALnoImplementation, "fpNumColumns(x As BigFractionMatrix) As Integer", REALconsoleSafe },
	{ (REALproc) GetBigFractionMatrixElement, REALnoImplementation, "fpGetBigFractionMatrixElement(x As BigFractionMatrix, i As Integer, j As Integer) As BigFraction", REALconsoleSafe },
	{ (REALproc) PutBigFractionMatrixElement, REALnoImplementation, "fpPutBigFractionMatrixElement(x As BigFractionMatrix, theElement As BigFraction, i As Integer, j As Integer) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) TransposeBigFractionMatrix, REALnoImplementation, "fpTransposeBFRM(x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) ModBigFractionMatrix, REALnoImplementation, "fpModBFTM(x As BigFractionMatrix, q As Double) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) PowBigFractionMatrix_Int, REALnoImplementation, "fpPowBFRM(x As BigFractionMatrix, y As Integer) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) InvertBigFractionMatrix, REALnoImplementation, "fpInvertBFRM(x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) DetBigFractionMatrix, REALnoImplementation, "fpDetBFRM(x As BigFractionMatrix) As BigFraction", REALconsoleSafe },
    { (REALproc) TraceBigFractionMatrix, REALnoImplementation, "fpTraceBFRM(x As BigFractionMatrix) As BigFraction", REALconsoleSafe },
	{ (REALproc) UnitBigFractionMatrix, REALnoImplementation, "fpUnitBFRM(n As Integer) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) RowAugmentBigFractionMatrix, REALnoImplementation, "fpRowAugmentBFRM(x As BigFractionMatrix, y As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) ColumnAugmentBigFractionMatrix, REALnoImplementation, "fpColumnAugmentBFRM(x As BigFractionMatrix, y As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) GaussElimBigFractionMatrix, REALnoImplementation, "fpGaussEliminateBFRM(x As BigFractionMatrix, ByRef swapParity As Integer) As BigFractionMatrix", REALconsoleSafe },
    { (REALproc) GaussElimBigFractionMatrix2, REALnoImplementation, "fpGaussEliminate2BFRM(x As BigFractionMatrix, q As Double) As BigFractionMatrix", REALconsoleSafe },
    { (REALproc) ReduceBigFractionMatrix, REALnoImplementation, "fpReduceBFRM(x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) NullSpaceBigFractionMatrix, REALnoImplementation, "fpNullSpaceBFRM(ByRef numNV As Integer, x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) ReduceRowEchelonBigFractionMatrix, REALnoImplementation, "fpReduceRowEchelonBFRM(x As BigFractionMatrix) As BigFractionMatrix", REALconsoleSafe },
	//{ (REALproc) CalcQBigFractionMatrix, REALnoImplementation, "fpCalcQBFRM(x As BigPoly) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) CalcQBigFractionMatrix2, REALnoImplementation, "fpCalcQBFRM(x As BigPoly, q As Double) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) FindFactorBigFractionMatrix, REALnoImplementation, "fpFindFactorBFRM(x As BigPoly, nullVectors As BigFractionMatrix, q As Double) As BigPoly", REALconsoleSafe },
	{ (REALproc) FindFactorBigFractionMatrix2, REALnoImplementation, "fpFindPolyFactorsBFRM(x As BigPoly) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) PowerModBigFractionMatrix, REALnoImplementation, "fpPowerModBFRM(x As BigFractionMatrix, y As BigInteger, q As BigInteger) As BigFractionMatrix", REALconsoleSafe },
	{ (REALproc) fpLUdecomp, REALnoImplementation, "fpLUdecompositionBFRM(A As BigFractionMatrix, P As BigFractionMatrix, L As BigFractionMatrix, U As BigFractionMatrix) As Boolean", REALconsoleSafe },
	{ (REALproc) fpRank, REALnoImplementation, "fpRank(x As BigFractionMatrix) As Integer", REALconsoleSafe },
    { (REALproc) fpEigenFrac, REALnoImplementation, "fpEigenFrac(eigenvalues As BigComplexMatrix, algMultiplicity As IntArray, geoMultiplicity As IntArray, x As BigFractionMatrix, myDecPrec As Integer, zeroSet As BigFloat) As BigComplexMatrix", REALconsoleSafe },

};


static void BigFloatMatrixConstructor(REALobject instance)
{
    BigFloatMatrixData		*data;
    
    // Get the class data
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if (data == nil)
        return;
    
    (data->bm).nr = 0;
    (data->bm).nc = 0;
    (data->bm).array = NULL;
    
}/* BigFloatMatrixConstructor */


static void BigFloatMatrixConstructor2(REALobject instance, REALstring CStr)
{
    BigFloatMatrixData	*data;
    char			*dataString;
    long            length;
    REALstringData   *outData;
    
    // Get the class data
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if (data == nil)
        return;
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        (data->bm).nr = 1;
        (data->bm).nc = 1;
        (data->bm).array = (fp**)malloc((data->bm).nr*sizeof(fp*));
        (data->bm).array[0] = (fp*)malloc((data->bm).nc*sizeof(fp));
        (data->bm).array[0][0] = 0;
        return;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
    if(!matfpConvFromStr(data->bm, dataString))
    {
        REALDisposeStringData(outData);
        free(dataString);
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return;
    }
    
    REALDisposeStringData(outData);
    free(dataString);
    
}/* BigFloatMatrixConstructor2 */


static void BigFloatMatrixConstructor3(REALobject instance, long nRows, long nCols)
{
    BigFloatMatrixData	*data;
    
    // Get the class data
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if (data == nil)
        return;
    
    init(data->bm, nRows, nCols);
    
}/* BigFloatMatrixConstructor3 */


static void BigFloatMatrixDestructor(REALobject instance)
{
  BigFloatMatrixData		*data;
  INT32				i;
  
  // Get the class data
  data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
  
  if (data == nil)
		return;
  
    myFree(data->bm);
    
}/* BigFloatMatrixDestructor */


static REALstring BigFloatMatrixToS(REALobject instance)
{
    BigFloatMatrixData	*data;
    REALstring		str;
    char*			dataString;
    INT64           length;
    
    if(instance==nil)
    {
        return nullString;
    }
    
    // Get the class data
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
    {
        return nullString;
    }
    
    matfpConvToStr(dataString, data->bm);
    length = strlen(dataString);
    
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
    
    free(dataString);
    return str;
    
}/* BigFloatMatrixToS */

static void convertBigFloatMatrixToBigFloatMatrix(REALobject instance, REALobject x)
{
    BigFloatMatrixData		*data, *xData;
    
    // Get the class data
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
    {
        return;
    }
    
    
    xData = (BigFloatMatrixData *) REALGetClassData(x, &BigFloatMatrixClass);
    
    if(xData==nil)
        return;
    
    data->bm = xData->bm;
    
    return;
    
}/* convertBigFloatMatrixToBigFloatMatrix */


static int RowsBigFloatMatrix(REALobject instance)
{
    BigFloatMatrixData		*data;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return 0;
    
    return (data->bm).nr;
    
}/* RowsBigFloatMatrix */


static int ColsBigFloatMatrix(REALobject instance)
{
    BigFloatMatrixData		*data;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return 0;
    
    return (data->bm).nc;
    
}/* ColsBigFloatMatrix */


static REALobject GetBigFloatMatrixElement(REALobject instance, long i, long j)
{
    REALobject		z;
    BigFloatData *zData;
    BigFloatMatrixData	*data;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil || i<0 || (int)i>=data->bm.nr || j<0 || (int)j>=data->bm.nc)
        return 0;
    
    z = REALnewInstanceWithClass(globalBigFloatRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
    
    if(zData==nil)
        return 0;
    
    zData->f = data->bm.array[(int)i][(int)j];
    
    return z;
    
}/* GetBigFloatMatrixElement */


static REALobject PutBigFloatMatrixElement(REALobject instance, REALobject x, long i, long j)
{
    REALobject		z;
    BigFloatMatrixData	*data, *zData;
    BigFloatData	*xData;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    xData = (BigFloatData *) REALGetClassData(x, &BigFloatClass);
    
    if(data==nil || xData==nil || i<0 || (int)i>=data->bm.nr || j<0 || (int)j>=data->bm.nc)
        return 0;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return 0;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return 0;
    
    zData->bm = data->bm;
    zData->bm.array[(int)i][(int)j] = xData->f;
    
    return z;
    
}/* PutBigFloatMatrixElement */


static REALobject NegateBigFloatMatrix(REALobject instance)
{
    REALobject	z;
    BigFloatMatrixData		*data, *zData;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return instance;
    
    
    zData->bm = -data->bm;
    
    return z;
    
}/* NegateBigFloatMatrix */


static REALobject TransposeBigFloatMatrix(REALobject instance)
{
    REALobject	z;
    BigFloatMatrixData		*data, *zData;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return instance;
    
    
    zData->bm = transpose(data->bm);
    
    return z;
    
}/* TransposeBigFloatMatrix */


static REALobject AddBigFloatMatrix_BigFloatMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigFloatMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    xData = (BigFloatMatrixData *) REALGetClassData(x, &BigFloatMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if(!((data->bm).nr==(xData->bm).nr && (data->bm).nc==(xData->bm).nc))
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return z;
    
    add(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* AddBigFloatMatrix_BigFloatMatrix */


static REALobject SubBigFloatMatrix_BigFloatMatrix(REALobject instance, REALobject x)
{
    REALobject                  z;
    BigFloatMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    xData = (BigFloatMatrixData *) REALGetClassData(x, &BigFloatMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if(!((data->bm).nr==(xData->bm).nr && (data->bm).nc==(xData->bm).nc))
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return z;
    
    sub(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* SubBigFloatMatrix_BigFloatMatrix */


static REALobject MulBigFloatMatrix_BigFloatMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigFloatMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    xData = (BigFloatMatrixData *) REALGetClassData(x, &BigFloatMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if((data->bm).nc!=(xData->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return z;
    
    mul(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* MulBigFloatMatrix_BigFloatMatrix */


// x^y
static REALobject PowBigFloatMatrix_Int(REALobject instance, long y)
{
    REALobject          z;
    BigFloatMatrixData		*xData, *zData;
    
    if(y==1)
        return instance;
    
    xData = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(xData==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return z;
    
    if(!power(zData->bm, xData->bm, (int)y))
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    return z;
    
}/* PowBigFloatMatrix_Int */


static REALobject InvertBigFloatMatrix(REALobject instance)
{
    REALobject			z;
    BigFloatMatrixData	*data, *zData;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return instance;
    
    if((data->bm).nc!=(data->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return instance;
    
    
    zData->bm = inv(data->bm);
    
    return z;
    
}/* InvertBigFloatMatrix */


static REALobject DetBigFloatMatrix(REALobject instance)
{
    REALobject			z;
    BigFloatMatrixData	*data;
    BigFloatData		*zData;
    matfp				x;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return 0;
    
    if((data->bm).nc!=(data->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return 0;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
    
    if(zData==nil)
        return z;
    
    inv(x, zData->f, data->bm);
   //x = matfpInvert(zData->f, data->bm);
    
    return z;
    
}/* DetBigFloatMatrix */


static REALobject TraceBigFloatMatrix(REALobject instance)
{
    REALobject			z;
    BigFloatMatrixData		*data;
    BigFloatData		*zData;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return 0;
    
    if((data->bm).nc!=(data->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return 0;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatData *) REALGetClassData(z, &BigFloatClass);
    
    if(zData==nil)
        return z;
    
    
    zData->f = trace(data->bm);
    
    return z;
    
}/* TraceBigFloatMatrix */


static REALobject RowAugmentBigFloatMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigFloatMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    xData = (BigFloatMatrixData *) REALGetClassData(x, &BigFloatMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if((data->bm).nc!=(xData->bm).nc)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return z;
    
    matfpRowAugment(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* RowAugmentBigFloatMatrix */


static REALobject ColumnAugmentBigFloatMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigFloatMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    xData = (BigFloatMatrixData *) REALGetClassData(x, &BigFloatMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if((data->bm).nr!=(xData->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return z;
    
    matfpColAugment(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* ColumnAugmentBigFloatMatrix */


static REALobject GaussElimBigFloatMatrix(REALobject instance, long& swapParity)
{
    REALobject			z;
    BigFloatMatrixData		*data, *zData;
    bf					det;
    int                 swapParityint;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return instance;
    
    matfpGaussElim(zData->bm, swapParityint, data->bm);
    swapParity = swapParityint;
    
    return z;
    
}/* GaussElimBigFloatMatrix */


static REALobject ReduceBigFloatMatrix(REALobject instance)
{
    REALobject			z;
    BigFloatMatrixData		*data, *zData;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return instance;
    
    matfpReduce(zData->bm, data->bm);
    
    return z;
    
}/* ReduceBigFloatMatrix */


static REALobject ReduceRowEchelonBigFloatMatrix(REALobject instance)
{
    REALobject			z;
    BigFloatMatrixData		*data, *zData;
    int				swapParity;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return instance;
    
    matfpGaussElim(zData->bm, swapParity, data->bm);
    matfpReduce(zData->bm, zData->bm);
    
    return z;
    
}/* ReduceRowEchelonBigFloatMatrix */

static long fpRankFloat(REALobject instance, REALobject zeroSet)
{
    BigFloatMatrixData          *data;
    BigFloatData                *xData;
    long                        rank;
    
    data = (BigFloatMatrixData *) REALGetClassData(instance, &BigFloatMatrixClass);
    if(data==nil)
        return 0;
    
    xData = (BigFloatData *) REALGetClassData(zeroSet, &BigFloatClass);
    if(data==nil)
        return 0;
    
    rank = matfpRank(data->bm, xData->f);
    return rank;
    
}/* fpRankFloat */

static REALmethodDefinition BigFloatMatrixMethods[] = {
    // defines methods:
    { (REALproc) BigFloatMatrixConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
    { (REALproc) BigFloatMatrixConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
    { (REALproc) BigFloatMatrixConstructor3, REALnoImplementation, "Constructor(nRows As Integer, nCols As Integer)", REALconsoleSafe },
    { (REALproc) BigFloatMatrixDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) BigFloatMatrixToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
    { (REALproc) convertBigFloatMatrixToBigFloatMatrix, REALnoImplementation, "Operator_Convert(x As BigFloatMatrix)", REALconsoleSafe },
    { (REALproc) RowsBigFloatMatrix, REALnoImplementation, "NumRows() As Integer", REALconsoleSafe },
    { (REALproc) ColsBigFloatMatrix, REALnoImplementation, "NumColumns() As Integer", REALconsoleSafe },
    { (REALproc) GetBigFloatMatrixElement, REALnoImplementation, "GetElement(i As Integer, j As Integer) As BigFloat", REALconsoleSafe },
    { (REALproc) PutBigFloatMatrixElement, REALnoImplementation, "PutElement(theElement As BigFloat, i As Integer, j As Integer) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) NegateBigFloatMatrix, REALnoImplementation, "Operator_Negate() As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) TransposeBigFloatMatrix, REALnoImplementation, "Transpose() As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) AddBigFloatMatrix_BigFloatMatrix, REALnoImplementation, "Operator_Add(x As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) SubBigFloatMatrix_BigFloatMatrix, REALnoImplementation, "Operator_Subtract(x As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) MulBigFloatMatrix_BigFloatMatrix, REALnoImplementation, "Operator_Multiply(x As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) PowBigFloatMatrix_Int, REALnoImplementation, "Operator_Power(y As Integer) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) InvertBigFloatMatrix, REALnoImplementation, "Invert() As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) DetBigFloatMatrix, REALnoImplementation, "Det() As BigFloat", REALconsoleSafe },
    { (REALproc) TraceBigFloatMatrix, REALnoImplementation, "Trace() As BigFloat", REALconsoleSafe },
    { (REALproc) RowAugmentBigFloatMatrix, REALnoImplementation, "RowAugment(y As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) ColumnAugmentBigFloatMatrix, REALnoImplementation, "ColumnAugment(y As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) GaussElimBigFloatMatrix, REALnoImplementation, "GaussEliminate(ByRef swapParity As Integer) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) ReduceBigFloatMatrix, REALnoImplementation, "Reduce() As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) ReduceRowEchelonBigFloatMatrix, REALnoImplementation, "ReduceRowEchelon() As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) fpRankFloat, REALnoImplementation, "Rank(zeroSet As BigFloat) As Integer", REALconsoleSafe },
    
};


REALclassDefinition BigFloatMatrixClass = {
    kCurrentREALControlVersion,
    "BigFloatMatrix",		// name of class
    nil,				// no superclasses
    sizeof(BigFloatMatrixData),		// size of our data
    0,							// for system use
    nil,						// initializer
    nil,						// finializer
    nil,            			// properties
    0,							// property count
    BigFloatMatrixMethods,           // methods
    sizeof(BigFloatMatrixMethods) / sizeof(REALmethodDefinition),	// method count
    nil,						// Events
    0,							// Event count
    nil,						// eventInstances
    0,							// eventInstanceCount
    nil,						// interface strings
    nil,						// obsolete1
    nil,						// obsolete2
    nil,						// constants
    0,							// constantCount
    REALconsoleSafe,			// flags
    nil,						// shared properties
    0,							// sharedPropertyCount
    nil,						// shared methods
    0,							// sharedMethodCount
};


static REALobject UnitBigFloatMatrix(int n)
{
    REALobject			z;
    BigFloatMatrixData		*zData;
    
    z = REALnewInstanceWithClass(globalBigFloatMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigFloatMatrixData *) REALGetClassData(z, &BigFloatMatrixClass);
    
    if(zData==nil)
        return z;
    
    
    zData->bm = matfpUnit(n);
    
    return z;
    
}/* UnitBigFloatMatrix */


// LU decomposition A = P L U
static Boolean fpLUdecompfp(REALobject A, REALobject P, REALobject L, REALobject U)
{
    BigFloatMatrixData      *Adata, *Pdata, *Ldata, *Udata;
    INT32                   swapParity=1;
    
    Adata = (BigFloatMatrixData *) REALGetClassData(A, &BigFloatMatrixClass);
    Pdata = (BigFloatMatrixData *) REALGetClassData(P, &BigFloatMatrixClass);
    Ldata = (BigFloatMatrixData *) REALGetClassData(L, &BigFloatMatrixClass);
    Udata = (BigFloatMatrixData *) REALGetClassData(U, &BigFloatMatrixClass);
    
    if(Adata==nil || Pdata==nil || Ldata==nil || Udata==nil)
        return false;
    
    if (!LUdecomp(Adata->bm, Pdata->bm, Ldata->bm, Udata->bm, swapParity))
    {
        return false;
    }
    
    return true;
    
}/* fpLUdecompfp */

// void matqEigenvectors(matc& eigenvectors, matc& eigenvalues, long*& algMultiplicity, long*& geoMultiplicity, const matc& x, long myDecPrec, const fp& zeroSet);
static REALobject fpEigenFloat(REALobject eigenvalues, REALobject algMultiplicity, REALobject geoMultiplicity, REALobject x, long myDecPrec, REALobject zeroSet)
{
    REALobject              z;
    BigComplexMatrixData    *zData, *aData;
    BigFloatMatrixData      *xData;
    intarray                *bData, *cData;
    BigFloatData            *dData;
    long                    numE; // number of distinct eigenvalues
    
    REALUnlockObject(eigenvalues);
    REALUnlockObject(algMultiplicity);
    REALUnlockObject(geoMultiplicity);
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    if(zData==nil)
        return nil;
    
    aData = (BigComplexMatrixData *) REALGetClassData(eigenvalues, &BigComplexMatrixClass);
    if(aData==nil)
        return nil;
    
    bData = (intarray*) REALGetClassData(algMultiplicity, &IntArrayClass);
    if(bData==nil)
        return nil;
    
    cData = (intarray*) REALGetClassData(geoMultiplicity, &IntArrayClass);
    if(cData==nil)
        return nil;
    
    xData = (BigFloatMatrixData *) REALGetClassData(x, &BigFloatMatrixClass);
    if(xData==nil)
        return nil;
    
    dData = (BigFloatData *) REALGetClassData(zeroSet, &BigFloatClass);
    if(dData==nil)
        return nil;
    
    matfpEigenvectors(zData->bm, aData->bm, bData->array, cData->array, xData->bm, myDecPrec, dData->f);
    numE = aData->bm.nr;
    bData->n = numE;
    cData->n = numE;
    
    REALLockObject(eigenvalues);
    REALLockObject(algMultiplicity);
    REALLockObject(geoMultiplicity);
    REALLockObject(z);
    
    return z;
    
}/* fpEigenFloat */

static REALmethodDefinition otherBigFloatMatrixMethods[] = {
    { (REALproc) BigFloatMatrixToS, REALnoImplementation, "Str(x As BigFloatMatrix) As String", REALconsoleSafe },
    { (REALproc) RowsBigFloatMatrix, REALnoImplementation, "fpNumRowsBFLM(x As BigFloatMatrix) As Integer", REALconsoleSafe },
    { (REALproc) ColsBigFloatMatrix, REALnoImplementation, "fpNumColumnsBFLM(x As BigFloatMatrix) As Integer", REALconsoleSafe },
    { (REALproc) GetBigFloatMatrixElement, REALnoImplementation, "fpGetBigFloatMatrixElement(x As BigFloatMatrix, i As Integer, j As Integer) As BigFloat", REALconsoleSafe },
    { (REALproc) PutBigFloatMatrixElement, REALnoImplementation, "fpPutBigFloatMatrixElement(x As BigFloatMatrix, theElement As BigFloat, i As Integer, j As Integer) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) TransposeBigFloatMatrix, REALnoImplementation, "fpTransposeBFLM(x As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) PowBigFloatMatrix_Int, REALnoImplementation, "fpPowBFLM(x As BigFloatMatrix, y As Integer) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) InvertBigFloatMatrix, REALnoImplementation, "fpInvertBFLM(x As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) DetBigFloatMatrix, REALnoImplementation, "fpDetBFLM(x As BigFloatMatrix) As BigFloat", REALconsoleSafe },
    { (REALproc) TraceBigFloatMatrix, REALnoImplementation, "fpTraceBFLM(x As BigFloatMatrix) As BigFloat", REALconsoleSafe },
    { (REALproc) UnitBigFloatMatrix, REALnoImplementation, "fpUnitBFLM(x As Integer) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) RowAugmentBigFloatMatrix, REALnoImplementation, "fpRowAugmentBFLM(x As BigFloatMatrix, y As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) ColumnAugmentBigFloatMatrix, REALnoImplementation, "fpColumnAugmentBFLM(x As BigFloatMatrix, y As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) GaussElimBigFloatMatrix, REALnoImplementation, "fpGaussEliminateBFLM(x As BigFloatMatrix, ByRef swapParity As Integer) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) ReduceBigFloatMatrix, REALnoImplementation, "fpReduceBFLM(x As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) ReduceRowEchelonBigFloatMatrix, REALnoImplementation, "fpReduceRowEchelonBFLM(x As BigFloatMatrix) As BigFloatMatrix", REALconsoleSafe },
    { (REALproc) fpLUdecompfp, REALnoImplementation, "fpLUdecompositionBFLM(A As BigFloatMatrix, P As BigFloatMatrix, L As BigFloatMatrix, U As BigFloatMatrix) As Boolean", REALconsoleSafe },
    { (REALproc) fpRankFloat, REALnoImplementation, "fpRank(x As BigFloatMatrix, zeroSet As BigFloat) As Integer", REALconsoleSafe },
    { (REALproc) fpEigenFloat, REALnoImplementation, "fpEigenFloat(eigenvalues As BigComplexMatrix, algMultiplicity As IntArray, geoMultiplicity As IntArray, x As BigFloatMatrix, myDecPrec As Integer, zeroSet As BigFloat) As BigComplexMatrix", REALconsoleSafe },
    
};

static void BigComplexMatrixConstructor(REALobject instance)
{
    BigComplexMatrixData		*data;
    
    // Get the class data
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if (data == nil)
        return;
    
    (data->bm).nr = 0;
    (data->bm).nc = 0;
    (data->bm).array = NULL;
    
}/* BigComplexMatrixConstructor */


static void BigComplexMatrixConstructor2(REALobject instance, REALstring CStr)
{
    BigComplexMatrixData	*data;
    char			*dataString;
    long            length;
    REALstringData   *outData;
    
    // Get the class data
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if (data == nil)
        return;
    
    outData = new REALstringData();
    
    if(!REALGetStringData(CStr, kREALTextEncodingUTF8, outData))
    {
        (data->bm).nr = 0;
        (data->bm).nc = 0;
        (data->bm).array = NULL;        return;
    }
    
    length = outData->length;
    dataString = (char *)malloc((length+1)*sizeof(char));
    memcpy(dataString, outData->data, length); // to, from
    dataString[length] = 0; // makes it a C string
    
    if(!matcConvFromStr(data->bm, dataString))
    {
        REALDisposeStringData(outData);
        free(dataString);
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return;
    }
    
    REALDisposeStringData(outData);
    free(dataString);
    
}/* BigComplexMatrixConstructor2 */


static void BigComplexMatrixConstructor3(REALobject instance, long nRows, long nCols)
{
    BigComplexMatrixData	*data;
    
    // Get the class data
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if (data == nil)
        return;
    
    init(data->bm, nRows, nCols);
    
}/* BigComplexMatrixConstructor3 */


static void BigComplexMatrixDestructor(REALobject instance)
{
  BigComplexMatrixData		*data;
  
  // Get the class data
  data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
  
  if (data == nil)
		return;
  
  myFree(data->bm);
    
}/* BigComplexMatrixDestructor */


static REALstring BigComplexMatrixToS(REALobject instance)
{
    BigComplexMatrixData	*data;
    REALstring		str;
    char*			dataString;
    INT64           length;
    
    if(instance==nil)
    {
        return nullString;
    }
    
    // Get the class data
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
    {
        return nullString;
    }
    
    matcConvToStr(dataString, data->bm);
    length = strlen(dataString);
    
    str = REALBuildStringWithEncoding(dataString, length, kREALTextEncodingUTF8);
    
    free(dataString);
    return str;
    
}/* BigComplexMatrixToS */

static void convertBigComplexMatrixToBigComplexMatrix(REALobject instance, REALobject x)
{
    BigComplexMatrixData		*data, *xData;
    
    // Get the class data
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
    {
        return;
    }
    
    
    xData = (BigComplexMatrixData *) REALGetClassData(x, &BigComplexMatrixClass);
    
    if(xData==nil)
        return;
    
    data->bm = xData->bm;
    
    return;
    
}/* convertBigComplexMatrixToBigComplexMatrix */


static int RowsBigComplexMatrix(REALobject instance)
{
    BigComplexMatrixData		*data;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return 0;
    
    return (data->bm).nr;
    
}/* RowsBigComplexMatrix */


static int ColsBigComplexMatrix(REALobject instance)
{
    BigComplexMatrixData		*data;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return 0;
    
    return (data->bm).nc;
    
}/* ColsBigComplexMatrix */


static REALobject GetBigComplexMatrixElement(REALobject instance, long i, long j)
{
    REALobject              z;
    BigComplexData          *zData;
    BigComplexMatrixData	*data;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil || i<0 || (int)i>=data->bm.nr || j<0 || (int)j>=data->bm.nc)
        return 0;
    
    z = REALnewInstanceWithClass(globalBigComplexRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
    
    if(zData==nil)
        return 0;
    
    zData->c = data->bm.array[(int)i][(int)j];
    
    return z;
    
}/* GetBigComplexMatrixElement */


static REALobject PutBigComplexMatrixElement(REALobject instance, REALobject x, long i, long j)
{
    REALobject		z;
    BigComplexMatrixData	*data, *zData;
    BigComplexData	*xData;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    xData = (BigComplexData *) REALGetClassData(x, &BigComplexClass);
    
    if(data==nil || xData==nil || i<0 || (int)i>=data->bm.nr || j<0 || (int)j>=data->bm.nc)
        return 0;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return 0;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return 0;
    
    zData->bm = data->bm;
    zData->bm.array[(int)i][(int)j] = xData->c;
    
    return z;
    
}/* PutBigComplexMatrixElement */


static REALobject NegateBigComplexMatrix(REALobject instance)
{
    REALobject	z;
    BigComplexMatrixData		*data, *zData;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return instance;
    
    
    zData->bm = -data->bm;
    
    return z;
    
}/* NegateBigComplexMatrix */


static REALobject TransposeBigComplexMatrix(REALobject instance)
{
    REALobject	z;
    BigComplexMatrixData		*data, *zData;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return instance;
    
    
    zData->bm = transpose(data->bm);
    
    return z;
    
}/* TransposeBigComplexMatrix */


static REALobject AddBigComplexMatrix_BigComplexMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigComplexMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    xData = (BigComplexMatrixData *) REALGetClassData(x, &BigComplexMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if(!((data->bm).nr==(xData->bm).nr && (data->bm).nc==(xData->bm).nc))
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return z;
    
    add(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* AddBigComplexMatrix_BigComplexMatrix */


static REALobject SubBigComplexMatrix_BigComplexMatrix(REALobject instance, REALobject x)
{
    REALobject                  z;
    BigComplexMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    xData = (BigComplexMatrixData *) REALGetClassData(x, &BigComplexMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if(!((data->bm).nr==(xData->bm).nr && (data->bm).nc==(xData->bm).nc))
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return z;
    
    sub(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* SubBigComplexMatrix_BigComplexMatrix */


static REALobject MulBigComplexMatrix_BigComplexMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigComplexMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    xData = (BigComplexMatrixData *) REALGetClassData(x, &BigComplexMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if((data->bm).nc!=(xData->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return z;
    
    mul(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* MulBigComplexMatrix_BigComplexMatrix */


// x^y
static REALobject PowBigComplexMatrix_Int(REALobject instance, long y)
{
    REALobject                  z;
    BigComplexMatrixData		*xData, *zData;
    
    if(y==1)
        return instance;
    
    xData = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(xData==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return z;
    
    if(!power(zData->bm, xData->bm, (int)y))
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    return z;
    
}/* PowBigComplexMatrix_Int */


static REALobject InvertBigComplexMatrix(REALobject instance)
{
    REALobject			z;
    BigComplexMatrixData	*data, *zData;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return instance;
    
    if((data->bm).nc!=(data->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return instance;
    
    
    zData->bm = inv(data->bm);
    
    return z;
    
}/* InvertBigComplexMatrix */


static REALobject DetBigComplexMatrix(REALobject instance)
{
    REALobject              z;
    BigComplexMatrixData	*data;
    BigComplexData          *zData;
    matc                   x;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return 0;
    
    if((data->bm).nc!=(data->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return 0;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
    
    if(zData==nil)
        return z;
    
    inv(x, zData->c, data->bm);
   //x = matfpInvert(zData->f, data->bm);
    
    return z;
    
}/* DetBigComplexMatrix */


static REALobject TraceBigComplexMatrix(REALobject instance)
{
    REALobject                  z;
    BigComplexMatrixData		*data;
    BigComplexData              *zData;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return 0;
    
    if((data->bm).nc!=(data->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return 0;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexData *) REALGetClassData(z, &BigComplexClass);
    
    if(zData==nil)
        return z;
    
    
    zData->c = trace(data->bm);
    
    return z;
    
}/* TraceBigComplexMatrix */


static REALobject RowAugmentBigComplexMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigComplexMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    xData = (BigComplexMatrixData *) REALGetClassData(x, &BigComplexMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if((data->bm).nc!=(xData->bm).nc)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return z;
    
    matcRowAugment(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* RowAugmentBigComplexMatrix */


static REALobject ColumnAugmentBigComplexMatrix(REALobject instance, REALobject x)
{
    REALobject			z;
    BigComplexMatrixData		*data, *xData, *zData;
    
    if(instance==nil)
        return instance;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    xData = (BigComplexMatrixData *) REALGetClassData(x, &BigComplexMatrixClass);
    
    if(data==nil || xData==nil)
        return instance;
    
    if((data->bm).nr!=(xData->bm).nr)
    {
        REALobject err = REALnewInstanceWithClass(globalBadInputRef);
        REALRaiseException(err);
        return instance;
    }
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return z;
    
    matcColAugment(zData->bm, data->bm, xData->bm);
    
    return z;
    
}/* ColumnAugmentBigComplexMatrix */


static REALobject GaussElimBigComplexMatrix(REALobject instance, long& swapParity)
{
    REALobject			z;
    BigComplexMatrixData		*data, *zData;
    bf					det;
    int                 swapParityint;
    fp                  zeroSet=1e-16;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return instance;
    
    matcGaussElim(zData->bm, swapParityint, data->bm, zeroSet);
    swapParity = swapParityint;
    
    return z;
    
}/* GaussElimBigComplexMatrix */


static REALobject ReduceBigComplexMatrix(REALobject instance)
{
    REALobject			        z;
    BigComplexMatrixData		*data, *zData;
    fp                          zeroSet=1e-16;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return instance;
    // void matcReduce(matc& z, const matc& x, const fp& zeroSet);
    matcReduce(zData->bm, data->bm, zeroSet);
    
    return z;
    
}/* ReduceBigComplexMatrix */


static REALobject ReduceRowEchelonBigComplexMatrix(REALobject instance)
{
    REALobject			z;
    BigComplexMatrixData		*data, *zData;
    int				            swapParity;
    fp                          zeroSet=1e-16;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    
    if(data==nil)
        return instance;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return instance;
    
    matcGaussElim(zData->bm, swapParity, data->bm,zeroSet);
    matcReduce(zData->bm, zData->bm, zeroSet);
    
    return z;
    
}/* ReduceRowEchelonBigComplexMatrix */

static long fpRankComplex(REALobject instance, REALobject zeroSet)
{
    BigComplexMatrixData            *data;
    BigFloatData                    *xData;
    long                            rank;
    
    data = (BigComplexMatrixData *) REALGetClassData(instance, &BigComplexMatrixClass);
    if(data==nil)
        return 0;
    
    xData = (BigFloatData *) REALGetClassData(zeroSet, &BigFloatClass);
    if(data==nil)
        return 0;
    
    rank = matcRank(data->bm, xData->f);
    return rank;
    
}/* fpRankComplex */

static REALmethodDefinition BigComplexMatrixMethods[] = {
    // defines methods:
    { (REALproc) BigComplexMatrixConstructor, REALnoImplementation, "Constructor()", REALconsoleSafe },
    { (REALproc) BigComplexMatrixConstructor2, REALnoImplementation, "Constructor(inputString As String)", REALconsoleSafe },
    { (REALproc) BigComplexMatrixConstructor3, REALnoImplementation, "Constructor(nRows As Integer, nCols As Integer)", REALconsoleSafe },
    { (REALproc) BigComplexMatrixDestructor, REALnoImplementation, "Destructor()", REALconsoleSafe },
    { (REALproc) BigComplexMatrixToS, REALnoImplementation, "Str() As String", REALconsoleSafe },
    { (REALproc) convertBigComplexMatrixToBigComplexMatrix, REALnoImplementation, "Operator_Convert(x As BigComplexMatrix)", REALconsoleSafe },
    { (REALproc) RowsBigComplexMatrix, REALnoImplementation, "NumRows() As Integer", REALconsoleSafe },
    { (REALproc) ColsBigComplexMatrix, REALnoImplementation, "NumColumns() As Integer", REALconsoleSafe },
    { (REALproc) GetBigComplexMatrixElement, REALnoImplementation, "GetElement(i As Integer, j As Integer) As BigFloat", REALconsoleSafe },
    { (REALproc) PutBigComplexMatrixElement, REALnoImplementation, "PutElement(theElement As BigComplex, i As Integer, j As Integer) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) NegateBigComplexMatrix, REALnoImplementation, "Operator_Negate() As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) TransposeBigComplexMatrix, REALnoImplementation, "Transpose() As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) AddBigComplexMatrix_BigComplexMatrix, REALnoImplementation, "Operator_Add(x As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) SubBigComplexMatrix_BigComplexMatrix, REALnoImplementation, "Operator_Subtract(x As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) MulBigComplexMatrix_BigComplexMatrix, REALnoImplementation, "Operator_Multiply(x As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) PowBigComplexMatrix_Int, REALnoImplementation, "Operator_Power(y As Integer) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) InvertBigComplexMatrix, REALnoImplementation, "Invert() As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) DetBigComplexMatrix, REALnoImplementation, "Det() As BigComplex", REALconsoleSafe },
    { (REALproc) TraceBigComplexMatrix, REALnoImplementation, "Trace() As BigComplex", REALconsoleSafe },
    { (REALproc) RowAugmentBigComplexMatrix, REALnoImplementation, "RowAugment(y As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) ColumnAugmentBigComplexMatrix, REALnoImplementation, "ColumnAugment(y As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) GaussElimBigComplexMatrix, REALnoImplementation, "GaussEliminate(ByRef swapParity As Integer) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) ReduceBigComplexMatrix, REALnoImplementation, "Reduce() As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) ReduceRowEchelonBigComplexMatrix, REALnoImplementation, "ReduceRowEchelon() As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) fpRankComplex, REALnoImplementation, "Rank(zeroSet As BigFloat) As Integer", REALconsoleSafe },
    
};


REALclassDefinition BigComplexMatrixClass = {
    kCurrentREALControlVersion,
    "BigComplexMatrix",		// name of class
    nil,				// no superclasses
    sizeof(BigComplexMatrixData),		// size of our data
    0,							// for system use
    nil,						// initializer
    nil,						// finializer
    nil,            			// properties
    0,							// property count
    BigComplexMatrixMethods,           // methods
    sizeof(BigComplexMatrixMethods) / sizeof(REALmethodDefinition),	// method count
    nil,						// Events
    0,							// Event count
    nil,						// eventInstances
    0,							// eventInstanceCount
    nil,						// interface strings
    nil,						// obsolete1
    nil,						// obsolete2
    nil,						// constants
    0,							// constantCount
    REALconsoleSafe,			// flags
    nil,						// shared properties
    0,							// sharedPropertyCount
    nil,						// shared methods
    0,							// sharedMethodCount
};


static REALobject UnitBigComplexMatrix(int n)
{
    REALobject			z;
    BigComplexMatrixData		*zData;
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    if(z==nil)
    {
        REALobject err = REALnewInstanceWithClass(globalNilObjectRef);
        REALRaiseException(err);
        return z;
    }
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    
    if(zData==nil)
        return z;
    
    
    zData->bm = matcUnit(n);
    
    return z;
    
}/* UnitBigComplexMatrix */


// LU decomposition A = P L U
static Boolean fpLUdecompc(REALobject A, REALobject P, REALobject L, REALobject U)
{
    BigComplexMatrixData      *Adata, *Pdata, *Ldata, *Udata;
    INT32                   swapParity=1;
    
    Adata = (BigComplexMatrixData *) REALGetClassData(A, &BigComplexMatrixClass);
    Pdata = (BigComplexMatrixData *) REALGetClassData(P, &BigComplexMatrixClass);
    Ldata = (BigComplexMatrixData *) REALGetClassData(L, &BigComplexMatrixClass);
    Udata = (BigComplexMatrixData *) REALGetClassData(U, &BigComplexMatrixClass);
    
    if(Adata==nil || Pdata==nil || Ldata==nil || Udata==nil)
        return false;
    
    if (!LUdecomp(Adata->bm, Pdata->bm, Ldata->bm, Udata->bm, swapParity))
    {
        return false;
    }
    
    return true;
    
}/* fpLUdecompfp */

// void matcEigenvectors(matc& eigenvectors, matc& eigenvalues, long*& algMultiplicity, long*& geoMultiplicity, const matc& x, long myDecPrec, const fp& zeroSet);
static REALobject fpEigenComp(REALobject eigenvalues, REALobject algMultiplicity, REALobject geoMultiplicity, REALobject x, long myDecPrec, REALobject zeroSet)
{
    REALobject              z;
    BigComplexMatrixData    *zData, *aData, *xData;
    intarray                *bData, *cData;
    BigFloatData            *dData;
    long                    numE;
   
    REALUnlockObject(eigenvalues);
    REALUnlockObject(algMultiplicity);
    REALUnlockObject(geoMultiplicity);
    
    z = REALnewInstanceWithClass(globalBigComplexMatrixRef);
    zData = (BigComplexMatrixData *) REALGetClassData(z, &BigComplexMatrixClass);
    if(zData==nil)
        return nil;
    
    aData = (BigComplexMatrixData *) REALGetClassData(eigenvalues, &BigComplexMatrixClass);
    if(aData==nil)
        return nil;
    
    bData = (intarray *) REALGetClassData(algMultiplicity, &IntArrayClass);
    if(bData==nil)
        return nil;
    
    cData = (intarray *) REALGetClassData(geoMultiplicity, &IntArrayClass);
    if(cData==nil)
        return nil;
    
    xData = (BigComplexMatrixData *) REALGetClassData(x, &BigComplexMatrixClass);
    if(xData==nil)
        return nil;
    
    dData = (BigFloatData *) REALGetClassData(zeroSet, &BigFloatClass);
    if(dData==nil)
        return nil;
    
    matcEigenvectors(zData->bm, aData->bm, bData->array, cData->array, xData->bm, myDecPrec, dData->f);
    numE = aData->bm.nr;
    bData->n = numE;
    cData->n = numE;
    
    REALLockObject(eigenvalues);
    REALLockObject(algMultiplicity);
    REALLockObject(geoMultiplicity);
    REALLockObject(z);
    
    return z;
    
}/* fpEigenComp */

static REALmethodDefinition otherBigComplexMatrixMethods[] = {
    { (REALproc) BigComplexMatrixToS, REALnoImplementation, "Str(x As BigComplexMatrix) As String", REALconsoleSafe },
    { (REALproc) RowsBigComplexMatrix, REALnoImplementation, "fpNumRowsBCM(x As BigComplexMatrix) As Integer", REALconsoleSafe },
    { (REALproc) ColsBigComplexMatrix, REALnoImplementation, "fpNumColumnsBCM(x As BigComplexMatrix) As Integer", REALconsoleSafe },
    { (REALproc) GetBigComplexMatrixElement, REALnoImplementation, "fpGetBigComplexMatrixElement(x As BigComplexMatrix, i As Integer, j As Integer) As BigFloat", REALconsoleSafe },
    { (REALproc) PutBigComplexMatrixElement, REALnoImplementation, "fpPutBigComplexMatrixElement(x As BigComplexMatrix, theElement As BigFloat, i As Integer, j As Integer) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) TransposeBigComplexMatrix, REALnoImplementation, "fpTransposeBCM(x As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) PowBigComplexMatrix_Int, REALnoImplementation, "fpPowBCM(x As BigComplexMatrix, y As Integer) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) InvertBigComplexMatrix, REALnoImplementation, "fpInvertBCM(x As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) DetBigComplexMatrix, REALnoImplementation, "fpDetBCM(x As BigComplexMatrix) As BigComplex", REALconsoleSafe },
    { (REALproc) TraceBigComplexMatrix, REALnoImplementation, "fpTraceBCM(x As BigComplexMatrix) As BigComplex", REALconsoleSafe },
    { (REALproc) UnitBigComplexMatrix, REALnoImplementation, "fpUnitBCM(n As Integer) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) RowAugmentBigComplexMatrix, REALnoImplementation, "fpRowAugmentBCM(x As BigComplexMatrix, y As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) ColumnAugmentBigComplexMatrix, REALnoImplementation, "fpColumnAugmentBCM(x As BigComplexMatrix, y As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) GaussElimBigComplexMatrix, REALnoImplementation, "fpGaussEliminateBCM(x As BigComplexMatrix, ByRef swapParity As Integer) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) ReduceBigComplexMatrix, REALnoImplementation, "fpReduceBCM(x As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) ReduceRowEchelonBigComplexMatrix, REALnoImplementation, "fpReduceRowEchelonBCM(x As BigComplexMatrix) As BigComplexMatrix", REALconsoleSafe },
    { (REALproc) fpLUdecompc, REALnoImplementation, "fpLUdecompositionBCM(A As BigComplexMatrix, P As BigComplexMatrix, L As BigComplexMatrix, U As BigComplexMatrix) As Boolean", REALconsoleSafe },
    { (REALproc) fpRankComplex, REALnoImplementation, "fpRank(x As BigComplexMatrix, zeroSet As BigFloat) As Integer", REALconsoleSafe },
    { (REALproc) fpEigenComp, REALnoImplementation, "fpEigenComp(eigenvalues As BigComplexMatrix, algMultiplicity As IntArray, geoMultiplicity As IntArray, x As BigComplexMatrix, myDecPrec As Integer, zeroSet As BigFloat) As BigComplexMatrix", REALconsoleSafe },
};

REALclassDefinition BadInputExceptionClass = {
	kCurrentREALControlVersion,
	BadInputExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};

REALclassDefinition DivideByZeroExceptionClass = {
	kCurrentREALControlVersion,
	DivideByZeroExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};

REALclassDefinition NilObjectExceptionClass = {
	kCurrentREALControlVersion,
	NilObjectExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};

REALclassDefinition NegativeNumberExceptionClass = {
	kCurrentREALControlVersion,
	NegativeNumberExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};

REALclassDefinition NegativeorZeroExceptionClass = {
	kCurrentREALControlVersion,
	NegativeOrZeroExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};

REALclassDefinition BadEntryNumberExceptionClass = {
	kCurrentREALControlVersion,
	BadEntryNumberExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};

REALclassDefinition OverflowOrNegativeExceptionClass = {
	kCurrentREALControlVersion,
	OverflowOrNegativeExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};

REALclassDefinition PrecisionNotMetExceptionClass = {
	kCurrentREALControlVersion,
	PrecisionNotMetExcName,                    			// name of class
	"RuntimeException",
	// other fields left nil -- no events etc.
};


void PluginEntry()
{
	unsigned int		i;
	
    SetClassConsoleSafe(&IntArrayClass);
	SetClassConsoleSafe(&BigIntegerClass);
	SetClassConsoleSafe(&BigFloatClass);
	SetClassConsoleSafe(&BigComplexClass);
	SetClassConsoleSafe(&ComplexVectorClass);
	SetClassConsoleSafe(&BigFractionClass);
	SetClassConsoleSafe(&BigPolyClass);
	SetClassConsoleSafe(&BigFractionMatrixClass);
   // SetClassConsoleSafe(&BigIntegerMatrixClass);
    SetClassConsoleSafe(&BigFloatMatrixClass);
    SetClassConsoleSafe(&BigComplexMatrixClass);
	SetClassConsoleSafe(&BadInputExceptionClass);
	SetClassConsoleSafe(&DivideByZeroExceptionClass);
	SetClassConsoleSafe(&NilObjectExceptionClass);
	SetClassConsoleSafe(&NegativeNumberExceptionClass);
	SetClassConsoleSafe(&NegativeorZeroExceptionClass);
	SetClassConsoleSafe(&BadEntryNumberExceptionClass);
	SetClassConsoleSafe(&OverflowOrNegativeExceptionClass);
	SetClassConsoleSafe(&PrecisionNotMetExceptionClass);
    
    globalIntArrayref = REALGetClassRef("IntArray");
    globalBigIntegerRef = REALGetClassRef("BigInteger");
    globalBigFloatRef = REALGetClassRef("BigFloat");
    globalBigComplexRef = REALGetClassRef("BigComplex");
    globalComplexVectorRef = REALGetClassRef("ComplexVector");
    globalBigFractionRef = REALGetClassRef("BigFraction");
    globalBigPolyRef = REALGetClassRef("BigPoly");
    globalBigFractionMatrixRef = REALGetClassRef("BigFractionMatrix");
   // globalBigIntegerMatrixRef = REALGetClassRef("BigIntegerMatrix");
    globalBigFloatMatrixRef = REALGetClassRef("BigFloatMatrix");
    globalBigComplexMatrixRef = REALGetClassRef("BigComplexMatrix");
    globalBadInputRef = REALGetClassRef("fpBadInputException");
    globalDivideByZeroRef = REALGetClassRef("fpDivideByZeroException");
    globalNilObjectRef = REALGetClassRef("fpNilObjectException");
    globalNegativeNumberRef = REALGetClassRef("fpNegativeNumberException");
    globalNegativeorZeroRef = REALGetClassRef("fpNegativeOrZeroException");
    globalBadEntryNumberRef = REALGetClassRef("fpNegativeOrZeroException");
    globalOverflowOrNegativeRef = REALGetClassRef("fpOverflowOrNegativeException");
    globalPrecisionNotMetRef = REALGetClassRef("fpPrecisionNotMetException");
		
    REALRegisterClass(&IntArrayClass);
	REALRegisterClass(&BigIntegerClass);
	REALRegisterClass(&BigFloatClass);
	REALRegisterClass(&BigComplexClass);
	REALRegisterClass(&ComplexVectorClass);
	REALRegisterClass(&BigFractionClass);
	REALRegisterClass(&BigPolyClass);
	REALRegisterClass(&BigFractionMatrixClass);
    //REALRegisterClass(&BigIntegerMatrixClass);
    REALRegisterClass(&BigFloatMatrixClass);
    REALRegisterClass(&BigComplexMatrixClass);
	REALRegisterClass(&BadInputExceptionClass);
	REALRegisterClass(&DivideByZeroExceptionClass);
	REALRegisterClass(&NilObjectExceptionClass);
	REALRegisterClass(&NegativeNumberExceptionClass);
	REALRegisterClass(&NegativeorZeroExceptionClass);
	REALRegisterClass(&BadEntryNumberExceptionClass);
	REALRegisterClass(&OverflowOrNegativeExceptionClass);
	REALRegisterClass(&PrecisionNotMetExceptionClass);

	
	for (i = 0; i < sizeof(otherBigIntegerMethods) / sizeof(REALmethodDefinition); ++i)
		REALRegisterMethod(&otherBigIntegerMethods[i]);
	for (i = 0; i < sizeof(otherBigFloatMethods) / sizeof(REALmethodDefinition); ++i)
		REALRegisterMethod(&otherBigFloatMethods[i]);
	for (i = 0; i < sizeof(otherBigComplexMethods) / sizeof(REALmethodDefinition); ++i)
		REALRegisterMethod(&otherBigComplexMethods[i]);
	for (i = 0; i < sizeof(otherComplexVectorMethods) / sizeof(REALmethodDefinition); ++i)
		REALRegisterMethod(&otherComplexVectorMethods[i]);
	for (i = 0; i < sizeof(otherBigFractionMethods) / sizeof(REALmethodDefinition); ++i)
		REALRegisterMethod(&otherBigFractionMethods[i]);
    for (i = 0; i < sizeof(otherBigPolyMethods) / sizeof(REALmethodDefinition); ++i)
		REALRegisterMethod(&otherBigPolyMethods[i]);
	for (i = 0; i < sizeof(otherBigFractionMatrixMethods) / sizeof(REALmethodDefinition); ++i)
		REALRegisterMethod(&otherBigFractionMatrixMethods[i]);
    //for (i = 0; i < sizeof(otherBigIntegerMatrixMethods) / sizeof(REALmethodDefinition); ++i)
     //   REALRegisterMethod(&otherBigIntegerMatrixMethods[i]);
    for (i = 0; i < sizeof(otherBigFloatMatrixMethods) / sizeof(REALmethodDefinition); ++i)
        REALRegisterMethod(&otherBigFloatMatrixMethods[i]);
    for (i = 0; i < sizeof(otherBigComplexMatrixMethods) / sizeof(REALmethodDefinition); ++i)
        REALRegisterMethod(&otherBigComplexMatrixMethods[i]);
	
	fpResetSeed(0);
	setDecPrec(16);
	setBlockPrec(3);
}
