/*
 *  fpMath.h
 *  fp
 *
 *  Created by Robert Delaney on 4/24/09.
 *  Copyright 2009 __Bob Delaney's Science Software__. All rights reserved.
 *
 */

void setBlockPrec(INT32 prec);
UINT32 getBlockPrec();
fp abs(const fp& x);
void fpNormalize(fp& x);
INT32 NumBits(UINT32 x);
INT32 NumBits(INT32 x);
INT32 compare(const fp& x, const fp& y);
void add(fp& z, const fp& x, const fp& y);
void add(fp& z, const fp& x, const mb& y);
void add(fp& z, const mb& x, const fp& y);
void add(fp& z, const fp& x, double y);
void add(fp& z, double x, const fp& y);
void sub(fp& z, const fp& x, const fp& y);
void sub(fp& z, const fp& x, const mb& y);
void sub(fp& z, const mb& x, const fp& y);
void sub(fp& z, const fp& x, double y);
void sub(fp& z, double x, const fp& y);
void mul(fp& z, const fp& x, const fp& y);
void mul(fp& z, const fp& x, const mb& y);
void mul(fp& z, const mb& x, const fp& y);
void mul(fp& z, const fp& x, double y);
void mul(fp& z, double x, const fp& y);
bool div(fp& z, const fp& x, const fp& y);
void div(fp& z, const fp& x, const mb& y);
void div(fp& z, const mb& x, const fp& y);
bool div(fp& z, const fp& x, double y);
bool div(fp& z, double x, const fp& y);
bool power(fp& z, const fp& x, INT32 y);
mb mbPastDP(const fp& x, int myDecPrec);

