/*
 *  fpFuncs.h
 *  fp
 *
 *  Created by Robert Delaney on 4/24/09.
 *  Copyright 2009 __Bob Delaney's Science Software__. All rights reserved.
 *
 */

void floor(fp& z, const fp& x);
fp floor(const fp& x);
void ceil(fp& z, const fp& x);
fp ceil(const fp& x);
bool isItInteger(const fp& x);
bool isItEven(const fp& x);
INT32 to_long(const fp& x);
void sqr(fp& z, const fp& x);
fp sqr(const fp& x);
void sqrt(fp& z, const fp& x);
fp sqrt(const fp& x);
bool pow(fp& z, const fp& x, const fp& y);
fp pow(const fp& x, const fp& y);
bool pow(fp& z, const fp& x, double y);
fp pow(const fp& x, double y);
bool pow(fp& z, double x, const fp& y);
fp pow(double x, const fp& y);
bool pow(fp& z, const fp& x, INT32 y);
fp pow(const fp& x, INT32 y);
void ComputeE(fp& z);
void ComputePi(fp& z);
fp Pi();
void exp(fp& z, const fp& x);
fp exp(const fp& x);
INT32 Lg2(const fp& x);
void ComputeLn2(fp& z);
void power2(fp& z, INT32 n);
fp power2(INT32 n);
void log(fp& z, const fp& x);
fp log(const fp& x);
void ComputeLog_10(fp& z);
void sin(fp& z, const fp& x);
fp sin(const fp& x);
void cos(fp& z, const fp& x);
fp cos(const fp& x);
void tan(fp& z, const fp& x);
fp tan(const fp& x);
void atan(fp& z, const fp& x);
fp atan(const fp& x);
void atan2(fp& z, const fp& y, const fp& x);
fp atan2(const fp& y, const fp& x);
void asin(fp& z, const fp& x);
fp asin(const fp& x);
void acos(fp& z, const fp& x);
fp acos(const fp& x);
void sinh(fp& z, const fp& x);
fp sinh(const fp& x);
void cosh(fp& z, const fp& x);
fp cosh(const fp& x);
void tanh(fp& z, const fp& x);
fp tanh(const fp& x);
void asinh(fp& z, const fp& x);
fp asinh(const fp& x);
void acosh(fp& z, const fp& x);
fp acosh(const fp& x);
void atanh(fp& z, const fp& x);
fp atanh(const fp& x);
void factorial(fp& z, const fp& x);
fp factorial(const fp& x);
void factorial(fp& z, double x);
fp factorial(double x);

