/*
 *  fp.h
 *  fp
 *
 *  Created by Robert Delaney on 4/24/09.
 *  Copyright 2009 __Bob Delaney's Science Software__. All rights reserved.
 *
 */

#pragma once

#include "mb.h"


class fp
{
public:
	mb					i; // signed integer of unlimited length
	
	INT32				e; // exponent of 2, so fp number = i x 2^e
	
	fp();
	fp(const char*);
	fp(double);
	
	~fp();
	
	fp operator- ();
	fp operator- () const;
	fp& operator= (const fp&);
	fp& operator= (const mb&);
	fp& operator= (double);
	
	bool operator> (const fp&);
	bool operator>= (const fp&);
	bool operator== (const fp&);
	bool operator!= (const fp&);
	bool operator! ();
	bool operator<= (const fp&);
	bool operator< (const fp&);
	
	bool operator> (const fp&) const;
	bool operator>= (const fp&) const;
	bool operator== (const fp&) const;
	bool operator!= (const fp&) const;
	bool operator! () const;
	bool operator<= (const fp&) const;
	bool operator< (const fp&) const;
	
	bool operator> (const mb&);
	bool operator>= (const mb&);
	bool operator== (const mb&);
	bool operator!= (const mb&);
	bool operator<= (const mb&);
	bool operator< (const mb&);
	
	bool operator> (const mb&) const;
	bool operator>= (const mb&) const;
	bool operator== (const mb&) const;
	bool operator!= (const mb&) const;
	bool operator<= (const mb&) const;
	bool operator< (const mb&) const;
	
	bool operator> (double);
	bool operator>= (double);
	bool operator== (double);
	bool operator!= (double);
	bool operator<= (double);
	bool operator< (double);
	
	bool operator> (double) const;
	bool operator>= (double) const;
	bool operator== (double) const;
	bool operator!= (double) const;
	bool operator<= (double) const;
	bool operator< (double) const;
	
	fp operator+ (const fp&);
	fp operator- (const fp&);
	fp operator* (const fp&);
	fp operator/ (const fp&);
	
	fp operator+ (const fp&) const;
	fp operator- (const fp&) const;
	fp operator* (const fp&) const;
	fp operator/ (const fp&) const;
	
	fp& operator+= (const fp&);
	fp& operator-= (const fp&);
	fp& operator*= (const fp&);
	fp& operator/= (const fp&);
	
	fp operator+ (const mb&);
	fp operator- (const mb&);
	fp operator* (const mb&);
	fp operator/ (const mb&);
	
	fp operator+ (const mb&) const;
	fp operator- (const mb&) const;
	fp operator* (const mb&) const;
	fp operator/ (const mb&) const;
	
	fp& operator+= (const mb&);
	fp& operator-= (const mb&);
	fp& operator*= (const mb&);
	fp& operator/= (const mb&);
	
	fp operator+ (double);
	fp operator- (double);
	fp operator* (double);
	fp operator/ (double);
	
	fp operator+ (double) const;
	fp operator- (double) const;
	fp operator* (double) const;
	fp operator/ (double) const;
	
	fp& operator+= (double);
	fp& operator-= (double);
	fp& operator*= (double);
	fp& operator/= (double);
	
	//fp& operator^= (const fp&);
	//fp& operator^= (double);
	//fp operator^ (const fp&);
	//fp operator^ (double);
	//fp operator^ (const fp&) const;
	//fp operator^ (double) const;
	fp& operator<< (INT32);
	fp& operator>> (INT32);
	fp& operator++ ();
	void operator++ (int);
	fp& operator-- ();
	void operator-- (int);
	friend ostream& operator <<(ostream &s, const fp& x);
	friend istream& operator >>(istream &s, fp& x);

};

void setDecPrec(INT32);
INT32 getDecPrec();

fp operator+ (const mb&, const fp&);
fp operator- (const mb&, const fp&);
fp operator* (const mb&, const fp&);
fp operator/ (const mb&, const fp&);

fp operator+ (double, const fp&);
fp operator- (double, const fp&);
fp operator* (double, const fp&);
fp operator/ (double, const fp&);

/*
typedef struct
{
	mb 		i;
	
} BigIntData;

typedef struct
{
	fp 		f;
	
} BigFloatData;
*/

#include "fpMath.h"
#include "fpConv.h"
#include "mbMath.h"
#include "mbConv.h"
#include "fpFuncs.h"
#include "mb2Str.h"
#include "mbMod.h"
#include "mbRand.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include "myGammaFunctions.h"
#include "bessel.h"
#include "euler.h"
#include "ErrorFunctions.h"
#include "fresnel.h"
#include "betaFunctions.h"
#include "expInt.h"
#include "hypergeometric.h"
#include "diagfp.h"
#include "BaseFromBase.h"

