/* diags.cp */

/*
	diagonalizes a symmetric matrix using the Jacobi method. Only the upper triangular
	part, including the diagonal, needs to be inputted.
*/


/*
	array is the matrix to be diagonalized. solution is returned with its columns the
	eigenvectors. n is the size of the matrices, which should be dynamically allocated by
	the calling program. eps is a measure of the acceptable largest off-diagonal element
	in absolute value.
*/

//#include <math.h>
#include "fp.h"


void diagfp(fp **array, fp **solution, long n, fp& eps)
{
	long 	i, j, is, js;
	fp		f, fzero, save, save1, save2, csave1, csave2, flam, fmu, s, pf, c, sa, sc;
	fp		zero, one, two, sig;
	
	zero = 0;
	one = 1;
	two = 2;
	
	if(n==1 || eps<=0)
		return;
		
	for(i=0; i<(n-1); i++)
	{
		solution[i][i] = one;
		
		for(j=(i+1); j<n; j++)
		{
			solution[i][j] = zero;
			solution[j][i] = zero;
		}
	}
	
	solution[n-1][n-1] = one;
	
	f = zero;
	
	for(i=0; i<n; i++)
		f = f + array[i][i] * array[i][i];
		
	for(i=0; i<(n-1); i++)
	{
		for(j=(i+1); j<n; j++)
			f = f + two * array[i][j] * array[i][j];
	}
	
	if(f==zero)
		return;
		
	f = sqrt(f);
	
	for(i=0; i<n; i++)
	{
		for(j=i; j<n; j++) // start with j = i ?
			array[i][j] = array[i][j]/f;
	}
	
	save = eps + 1;
	
	do
	{
		save = abs(array[1][2]);
		
		is = 1;
		js = 2;
	
		/* find the largest off-diagonal element in absolute value */
		for(i=0; i<(n-1); i++)
		{
			for(j=(i+1); j<n; j++)
			{
				save1 = abs(array[i][j]);
				if(save < save1)
				{
					is = i;
					js = j;
					save = save1;
				}
			}
		}
	
		if(save >= eps)
		{
			flam = abs(array[is][js]);
			fmu = (array[is][is] - array[js][js])/two;
			
			if(fmu>zero)
				sig = one;
			else
				sig = -one;
			
			fzero = sig * flam/sqrt(flam*flam + fmu*fmu);
			s = fzero/sqrt(two*(one + sqrt(one - fzero*fzero)));
			c = sqrt(one - s*s);
			pf = array[is][js]/save;
			sa = array[is][is];
			sc = array[js][js];
			csave1 = (sc - sa)*s*s;
			save2 = two*save*c*s;
			array[is][is] = sa + csave1 + save2;
			array[js][js] = sc - csave1 - save2;
			array[is][js] = zero;
			
			if(is!=0)
			{
				for( i=0; i<is; i++)
				{
					csave1 = array[i][is];
					csave2 = array[i][js];
					array[i][is] = c*csave1 + pf*s*csave2;
					array[i][js] = c*csave2 - pf*s*csave1;
				}
			}
			
			if(is<(js-1))
			{
				for( i=is+1; i<js; i++)
				{
					csave1 = array[is][i];
					csave2 = array[i][js];
					array[is][i] = c*csave1 + pf*s*csave2;
					array[i][js] = c*csave2 - pf*s*csave1;
				}
			}
			
			if(js<(n-1))
			{
				for( i=js+1; i<n; i++)
				{
					csave1 = array[is][i];
					csave2 = array[js][i];
					array[is][i] = c*csave1 + pf*s*csave2;
					array[js][i] = c*csave2 - pf*s*csave1;
				}
			}
			
			for( i=0; i<n; i++)
			{
				csave1 = solution[i][is];
				csave2 = solution[i][js];
				solution[i][is] = c*csave1 + pf*s*csave2;
				solution[i][js] = c*csave2 - pf*s*csave1;
			}
		} /* end if(save >= eps) */
	}
	while (save >= eps);
	
	for( i=0; i<n; i++)
		array[i][i] = f*array[i][i];
		
} /* diagfp */

