/*
 *  bfMath.cpp
 *  fp
 *
 *  Created by Robert Delaney on 4/13/13.
 *  Copyright 2013 __MyCompanyName__. All rights reserved.
 *
 */
#include "bf.h"

void myFree(bf& x)
{
    myFree(x.num);
    myFree(x.den);
    
}/* myFree */

/*
 finds greatest common divisor of x,y and divides it out
 */
static void reduce(mb& x, mb& y)
{
	mb	factor;
	
	//if(x==0 || y==0)
	//	return;
	
	factor = gcd(abs(x), y);
	
	x = x/factor;
	y = y/factor;

}/* reduce */

void init(bf& x)
{
    x.num.n = x.num.nn = 0;
    x.num.b = NULL;
    x.den.n = x.den.nn = 1;
    x.den.b = (UINT32*)malloc(sizeof(UINT32));
    x.den.b[0] = 1;
    
}/* init */

bf abs(const bf& x)
{
	bf		z;
	
	z = x;
	
	if(z.num.n<0)
		z.num = -z.num;
	
	return z;
	
}/* abs */


// returns 1 if x>y, 0 if x=y, and -1 if x<y
int compare(const bf& x, const bf& y)
{
	bf		z;
	
	z = x - y;
	
	if(z.num.n>0)
		return 1;
	
	if(z.num.n==0)
		return 0;

	return -1;
	
}/* compare */

// returns 1 if x>y, 0 if x=y, and -1 if x<y
int compare(const bf& x, const mb& y)
{
	bf		z;
	
	z = x - y;
	
	if(z.num.n>0)
		return 1;
	
	if(z.num.n==0)
		return 0;
	
	return -1;
	
}/* compare */

// returns 1 if x>y, 0 if x=y, and -1 if x<y
int compare(const bf& x, int y)
{
	bf		z;
	
	z = x - y;
	
	if(z.num.n>0)
		return 1;
	
	if(z.num.n==0)
		return 0;
	
	return -1;
	
}/* compare */


// z = x + y ; z may be an improper, but always reduced fraction
void add(bf& z, const bf& x, const bf& y)
{
	if(x.den==1 && y.den==1)
	{
		z.den = 1;
		z.num = x.num + y.num;
		return;
	}
	
	z.num = x.num*y.den + x.den*y.num;
	z.den = x.den*y.den;
	
	reduce(z.num, z.den);
	
}/* add */

// z = x - y ; z may be an improper, but always reduced fraction
void sub(bf& z, const bf& x, const bf& y)
{
	if(x.den==1 && y.den==1)
	{
		z.den = 1;
		z.num = x.num - y.num;
		return;
	}
	
	z.num = x.num*y.den - x.den*y.num;
	z.den = x.den*y.den;
	
	reduce(z.num, z.den);
	
}/* sub */

// z = x * y ; z may be an improper, but always reduced fraction
void mul(bf& z, const bf& x, const bf& y)
{
	if(x.den==1 && y.den==1)
	{
		z.den = 1;
		z.num = x.num * y.num;
		return;
	}
	
	z.num = x.num*y.num;
	z.den = x.den*y.den;
	
	reduce(z.num, z.den);
	
}/* mul */

// z = x / y ; z may be an improper, but always reduced fraction
void div(bf& z, const bf& x, const bf& y)
{
	if(!y.num.n)
		return;
	
	if(x.den==1 && y.den==1)
	{
		z.num = x.num;
		z.den = y.num;
		if(z.den.n<0)
		{
			z.den.n = -z.den.n;
			z.num.n = -z.num.n;
		}
		reduce(z.num, z.den);
		return;
	}
	
	z.num = x.num*y.den;
	z.den = x.den*y.num;
	
	if(z.den.n<0)
	{
		z.den.n = -z.den.n;
		z.num.n = -z.num.n;
	}
	
	reduce(z.num, z.den);
	
}/* div */

void add(bf& z, const bf& x, const mb& y)
{
	bf		yy;
	
	yy = y;
	add(z, x, yy);
	
}/* add */

void sub(bf& z, const bf& x, const mb& y)
{
	bf		yy;
	
	yy = y;
	sub(z, x, yy);
	
}/* sub */

void mul(bf& z, const bf& x, const mb& y)
{
	bf		yy;
	
	yy = y;
	mul(z, x, yy);
	
}/* mul */

void div(bf& z, const bf& x, const mb& y)
{
	bf		yy;
	
	yy = y;
	div(z, x, yy);
	
}/* div */

void add(bf& z, const mb& x, const bf& y)
{
	bf		xx;
	
	xx = x;
	add(z, xx, y);
	
}/* add */

void sub(bf& z, const mb& x, const bf& y)
{
	bf		xx;
	
	xx = x;
	sub(z, xx, y);
	
}/* sub */

void mul(bf& z, const mb& x, const bf& y)
{
	bf		xx;
	
	xx = x;
	mul(z, xx, y);
	
}/* mul */

void div(bf& z, const mb& x, const bf& y)
{
	bf		xx;
	
	xx = x;
	div(z, xx, y);
	
}/* div */

void add(bf& z, const bf& x, int y)
{
	bf		yy;
	
	yy.num = y;
	add(z, x, yy);
}

void sub(bf& z, const bf& x, int y)
{
	bf		yy;
	
	yy.num = y;
	sub(z, x, yy);
}

void mul(bf& z, const bf& x, int y)
{
	bf		yy;
	
	yy.num = y;
	mul(z, x, yy);
}

void div(bf& z, const bf& x, int y)
{
	bf		yy;
	
	yy.num = y;
	div(z, x, yy);
}

void add(bf& z, int x, const bf& y)
{
	bf		xx;
	
	xx.num = x;
	add(z, xx, y);
}

void sub(bf& z, int x, const bf& y)
{
	bf		xx;
	
	xx.num = x;
	sub(z, xx, y);
}

void mul(bf& z, int x, const bf& y)
{
	bf		xx;
	
	xx.num = x;
	mul(z, xx, y);
}

void div(bf& z, int x, const bf& y)
{
	bf		xx;
	
	xx.num = x;
	div(z, xx, y);
}


// z = x + y mod q; use only with integers
void add(bf& z, const bf& x, const bf& y, double q)
{
	if(x.den==1 && y.den==1)
	{
		z.den = 1;
		z.num = x.num + y.num;
		return;
	}
	
	z.num = x.num*y.den + x.den*y.num;
	z.den = x.den*y.den;
	
	reduce(z.num, z.den);
	
	z.num = (z.num % q);
	
}/* add */


// z = x - y mod q; use only with integers
void sub(bf& z, const bf& x, const bf& y, double q)
{
	if(x.den==1 && y.den==1)
	{
		z.den = 1;
		z.num = x.num - y.num;
		return;
	}
	
	z.num = x.num*y.den - x.den*y.num;
	z.den = x.den*y.den;
	
	reduce(z.num, z.den);
	
	z.num = (z.num % q);
	
}/* sub */


// z = x * y mod q; use only with integers
void mul(bf& z, const bf& x, const bf& y, double q)
{
	if(x.den==1 && y.den==1)
	{
		z.den = 1;
		z.num = x.num * y.num;
		return;
	}
	
	z.num = x.num*y.num;
	z.den = x.den*y.den;
	
	reduce(z.num, z.den);
	
	z.num = (z.num % q);
	
}/* mul */


//z =x^y
bool power(bf& z, const bf& x, int y)
{
	if(!power(z.num, x.num, y))
	   return false;
	   
	if(!power(z.den, x.den, y))
		return false;
	
	return true;

}/* power */

//z =x^y
bool power(bf& z, const bf& x, const mb& y)
{
	if(!power(z.num, x.num, y))
		return false;
	
	if(!power(z.den, x.den, y))
		return false;
	
	return true;
	
}/* power */

int comparbf(const void* a, const void* b)
{
    if ( *(bf*)a <  *(bf*)b ) return -1;
    if ( *(bf*)a == *(bf*)b ) return 0;
    if ( *(bf*)a >  *(bf*)b ) return 1;
    
}/* comparbf */
