/*
 *  bfConv.cpp
 *  fp
 *
 *  Created by Robert Delaney on 4/13/13.
 *  Copyright 2013 __Bob Delaney's Science Software_.. All rights reserved.
 *
 */


#include "bf.h"
#include "bfConv.h"
#include "fpConv.h"

/*
 finds greatest common divisor of x,y and divides it out
 */
static void reduce(mb& x, mb& y)
{
	mb	factor;
	
	//if(x==0 || y==0)
	//	return;
	
	factor = gcd(abs(x), y);
	
	x = x/factor;
	y = y/factor;
	
}/* reduce */

using namespace std;

// for normal bf string "num/den"
static bool bfConvFromStrNorm(bf& z, const char *bfStr)
{
	int		i, iSave, length;
	char	ch, *tempStr;
	
	length = strlen(bfStr);
	if(!length)
		return false;
	
	if(bfStr[0]=='/')
		return false;
	
	tempStr = (char*)malloc((length+1)*sizeof(char));
	
	
	for(i=0;i<=length;i++)
	{
		iSave = i;
		ch = bfStr[i];
		if(ch=='/')
		{
			tempStr[i] = 0;
			if(!mbConvFromStr(z.num, tempStr))
				goto isFalse;
			break;
		}
		else
			tempStr[i] = ch;
	}
	
	if(iSave==length)
	{
		if(!mbConvFromStr(z.num, tempStr))
			goto isFalse;
		z.den = 1;
		free(tempStr);
		return true;
	}
	
	// now iSave points to '/'
	for(i=iSave+1;i<=length;i++)
		tempStr[i-iSave-1] = bfStr[i];
	
	if(strlen(tempStr)==0)
		goto isFalse;
	
	if(!mbConvFromStr(z.den, tempStr))
		goto isFalse;
	
	if(!z.den.n)
		goto isFalse;
	
	reduce(z.num, z.den);
	
	if(z.den.n<0)
	{
		z.num = -z.num;
		z.den = -z.den;
	}
	
	free(tempStr);
	return true;
	
isFalse:
	z.num = 0;
	z.den = 1;
	free(tempStr);
	return false;
	
}/* bfConvFromStrNorm */

// fpStr has decimal point and no e or E
static bool bfConvFromfpStrWithPeriod(bf& z, const char *fpStr)
{
    INT32   i, k, len, lastNonZeroPos, decPointPos, numZeroes;
    char    ch, *fpStrTemp;
    bool    boolValue;
    
    len = strlen(fpStr);
    fpStrTemp = (char*)malloc((len+1)*sizeof(char));
    strcpy(fpStrTemp, fpStr);
    // have to handle .00xx and .xx and xx.xx and xx. types by removing trailing zeroes if there are any
    lastNonZeroPos = len; // means no trailing zeroes
    for(i=len-1;i>=0;--i)
    {
        ch = fpStrTemp[i];
        if(ch=='0')
            lastNonZeroPos--;
        else
            break;
    }
    fpStrTemp[lastNonZeroPos] = 0;
    len = strlen(fpStrTemp);
    
    // now find position of dec point
    decPointPos = 0; // to avoid warning
    for(i=0;i<len;++i)
    {
        ch = fpStrTemp[i];
        if(ch=='.')
        {
            decPointPos = i;
            break;
        }
    }
    // how many places right to move decimal point to give integer? len-1-decPointPos
    // so z.den will be 1 followed by that many zeroes, z.num will be the string without the dec point
    numZeroes = len-1-decPointPos;
    char  *numStr;
    numStr = (char*)malloc((len+1)*sizeof(char));
    k = 0;
    for(i=0;i<len;++i)
    {
        ch = fpStrTemp[i];
        if(ch!='.')
            numStr[k++] = ch;
    }
    numStr[k] = 0;
    free(fpStrTemp);
    if(!strlen(numStr))
    {
        z = 0;
        free(numStr);
        return false;
    }
    
    boolValue = equate(z.num, numStr);
    free(numStr);
    if(!boolValue)
    {
        z = 0;
        return false;
    }
    
    if(!z.num.n)
    {
        z.den = 1;
        return true;
    }
    
    // now form z.den
    char    *denStr;
    
    denStr = (char*)malloc((numZeroes+2)*sizeof(char));
    
    denStr[0] = '1';
    for(i=0;i<numZeroes;++i)
        denStr[i+1] = '0';
    denStr[numZeroes+1] = 0;
    
    boolValue = equate(z.den, denStr);
    free(denStr);
    if(!boolValue)
    {
        z = 0;
        return false;
    }
    
    reduce(z.num, z.den);
    if(z.den.n<0)
    {
        z.num.n = -z.num.n;
        z.den.n = -z.den.n;
    }
    
    return true;
    
}/* bfConvFromfpStrWithPeriod */

// fpStr has e or E but no decimal point
static bool bfConvFromfpStrWithE(bf& z, const char *fpStr)
{
    INT32   i, k, len;
    char    ch, *fpStrTemp;
    bool    boolValue;
    
    len = strlen(fpStr);
    fpStrTemp = (char*)malloc((len+1)*sizeof(char));
    strcpy(fpStrTemp, fpStr);
    // special cases: exx, Exx. -exx, -Exx z.num = +/-1 ?
    // get z.num first
    char    *numStr, *expStr;
    INT32   iStart, theExp;
    numStr = (char*)malloc((len+1)*sizeof(char));
    k = 0;
    for(i=0;i<len;++i)
    {
        ch = fpStrTemp[i];
        if(ch=='e' || ch=='E')
        {
            iStart = i + 1; // points to exponent
            break;
        }
        
        numStr[k++] = ch;
    }
    numStr[k] = 0;
    
    boolValue = equate(z.num, numStr);
    free(numStr);
    if(!boolValue)
    {
        z = 0;
        free(fpStrTemp);
        return false;
    }
    
    // now form z.den
    expStr = (char*)malloc((len+1)*sizeof(char));
    k = 0;
    for(i=iStart;i<len;++i)
    {
        ch = fpStrTemp[i];
        expStr[k++] = ch;
    }
    expStr[k] = 0;
    
    free(fpStrTemp);
    
    if(!sscanf(expStr, "%d", &theExp))
    {
        free(expStr);
        z = 0;
        return false;
    }
    free(expStr);
    
    if(!theExp)
    {
        z.den = 1;
        return true;
    }
    
    if(theExp>0)
    {
        mb  theTensmb;
        // z.den = 1 and we must multiply z.num by 10^theExp , this is exact
        char  *tensStr;
        tensStr = (char*)malloc((theExp+2)*sizeof(char));
        tensStr[0] = '1';
        for(i=0;i<theExp;++i)
        {
            tensStr[i+1] = '0';
        }
        tensStr[theExp+1] = 0;
        
        if(!equate(theTensmb, tensStr))
        {
            z = 0;
            free(tensStr);
            return false;
        }
        
        z.den = 1;
        z.num = z.num * theTensmb;
        return true;
    }
    
    if(theExp<0)
    {
        char  *tensStr;
        // we calc z.den in usual way
        theExp = -theExp;
        
        tensStr = (char*)malloc((theExp+2)*sizeof(char));
        tensStr[0] = '1';
        for(i=0;i<theExp;++i)
        {
            tensStr[i+1] = '0';
        }
        tensStr[theExp+1] = 0;
        
        if(!equate(z.den, tensStr))
        {
            z = 0;
            free(tensStr);
            return false;
        }
        return true;
    }
    return true;
    
}/* bfConvFromfpStrWithE */

// fpStr has at least one of '.' or 'e' or 'E'
static bool bfConvFromfpStr(bf& z, const char *fpStr)
{
    INT32       i, k, len, numPeriods, numEs;
    char        ch, *fpStrTemp;
    bool        inFront;
    
    len = strlen(fpStr);
    if(!len)
    {
        z = 0;
        return false;
    }
    
    // count
    numPeriods = numEs = 0;
    for(i=0;i<len;++i)
    {
        ch = fpStr[i];
        if(ch=='.')
            numPeriods++;
        if(ch=='e' || ch=='E')
            numEs++;
    }
    if(numPeriods>1 || numEs>1 || (!numPeriods && !numEs))
    {
        z = 0;
        return false;
    }
    
    fpStrTemp = (char*)malloc((len+1)*sizeof(char));
    // remove leading zeroes
    k = 0;
    inFront = true;
    for(i=0;i<len;++i)
    {
        ch = fpStr[i];
        if(!inFront)
            fpStrTemp[k++] = ch;
            
        if(inFront && ch!='0')
        {
            fpStrTemp[k++] = ch;
            inFront = false;
        }
    }
    fpStrTemp[k] = 0;
    len = strlen(fpStrTemp);
    
    if(numPeriods && !numEs)
    {
       if(!bfConvFromfpStrWithPeriod(z, fpStrTemp))
       {
           free(fpStrTemp);
           return false;
       }
        free(fpStrTemp);
        return true;
    }
    
    if(!numPeriods && numEs)
    {
        bool    doInsertOne, hasminusE;
        
        // worry about exx and -exx where insert a 1
        doInsertOne = false;
        hasminusE = false;
        if(fpStrTemp[0]=='e' || fpStrTemp[0]=='E')
            doInsertOne = true;
        
        if(fpStrTemp[0]=='-' && (fpStrTemp[1]=='e' || fpStrTemp[1]=='E'))
            hasminusE = true;
        
        if(doInsertOne)
        {
            char    *fpStrInsert;
            fpStrInsert = (char*)malloc((len+2)*sizeof(char));
            k = 0;
            fpStrInsert[k++] = '1';
            for(i=0;i<len;++i)
                fpStrInsert[k++] = fpStrTemp[i];
            fpStrInsert[k] = 0;
            
            if(!(bfConvFromfpStrWithE(z, fpStrInsert)))
            {
                free(fpStrTemp);
                free(fpStrInsert);
                return false;
            }
            free(fpStrTemp);
            free(fpStrInsert);
            return true;
        }
        
        if(hasminusE)
        {
            char    *fpStrInsert;
            fpStrInsert = (char*)malloc((len+2)*sizeof(char));
            k = 0;
            fpStrInsert[k++] = '-';
            fpStrInsert[k++] = '1';
            for(i=1;i<len;++i) // skip '-'
                fpStrInsert[k++] = fpStrTemp[i];
            fpStrInsert[k] = 0;
            
            if(!(bfConvFromfpStrWithE(z, fpStrInsert)))
            {
                free(fpStrTemp);
                free(fpStrInsert);
                return false;
            }
            free(fpStrTemp);
            free(fpStrInsert);
            return true;
        }
        
        if(!(bfConvFromfpStrWithE(z, fpStrTemp)))
        {
            free(fpStrTemp);
            return false;
        }
        free(fpStrTemp);
        return true;
    }
    
    // now have both dec point and exponent
    // split fpStrTemp into two strings, one with period, other with e or E
    char    *pStr, *eStr;
    INT32   posE;
    bf      zp, ze;
    
    pStr = (char*)malloc((len+1)*sizeof(char));
    eStr = (char*)malloc((len+2)*sizeof(char));
    k = 0;
    for(i=0;i<len;++i)
    {
        ch = fpStrTemp[i];
        if(ch=='e' || ch=='E')
        {
            posE = i;
            break;
        }
        pStr[k++] = ch;
    }
    pStr[k] = 0;
    
    if(!bfConvFromfpStrWithPeriod(zp, pStr))
    {
        z = 0;
        free(pStr);
        free(eStr);
        free(fpStrTemp);
        return false;
    }
    // have zp
    
    // get eStr
    k = 0;
    eStr[k++] = '1';
    for(i=posE;i<len;++i)
    {
        eStr[k++] = fpStrTemp[i];
    }
    eStr[k] = 0;
    
    if(!bfConvFromfpStrWithE(ze, eStr))
    {
        z = 0;
        free(pStr);
        free(eStr);
        free(fpStrTemp);
        return false;
    }
    // have ze
    z = zp * ze;
    
    return true;
    
}/* bfConvFromfpStr */

// takes a bf string without '/' and converts to bf f norm
static bool bfConvFromStr2(bf& z, const char *bfStr)
{
    INT32   i, len;
    bool    isNorm;
    char    ch;
    
    // is it a normal bf string, not if it contains '.', 'e', or 'E'
    len = strlen(bfStr);
    isNorm = true;
    for(i=0;i<len;++i)
    {
        ch = bfStr[i];
        if(ch=='.' || ch=='e' || ch=='E')
        {
            isNorm = false;
            break;
        }
    }
    
    if(isNorm)
        return(bfConvFromStrNorm(z, bfStr));
    
    // isNorm is false
   return(bfConvFromfpStr(z, bfStr));
    
}/* bfConvFromStr2 */

// looks for one or more’/‘.
// if has / split numStr/denStr and numStr-?bf and enStr->bf and divide for z
// if just numStr then numStr->bf = z
bool bfConvFromStr(bf& z, const char *bfStr)
{
    char    *bfStrClean, *numStr, *denStr, ch;
    INT32   i, k, len, slashPos, numSlash;
    bool    boolValue;
    bf      numbf, denbf;
    
    len = strlen(bfStr);
    if(!len)
    {
        z = 0;
        return false;
    }
    
    bfStrClean = (char*)malloc((len+1)*sizeof(char));
    
    // clean out spaces and + signs and any bad chars?
    k = 0;
    for(i=0;i<len;++i)
    {
        ch = bfStr[i];
       // if(!(ch==' ' || ch=='+') || ch=='.' || ch=='-' || ch=='e' || ch=='E' || (ch>='0' && ch<='9'))
        if(!(ch==' ' || ch=='+'))
            bfStrClean[k++] = ch;
    }
    bfStrClean[k] = 0;
    len = strlen(bfStrClean);
    
    // counts the number of '/'
    numSlash = 0;
    for(i=0;i<len;++i)
    {
        if(bfStrClean[i]=='/')
            numSlash++;
    }
    if(numSlash>1)
    {
        z = 0;
        free(bfStrClean);
        return false;
    }
    
    if(!numSlash)
    {
        // bfStrClean is numStr
        boolValue = bfConvFromStr2(z, bfStrClean);
        free(bfStrClean);
        if(!boolValue)
            return false;
        return true;
    }
    
    // has slash, so split after finding slashPos
    slashPos = 0; // avoid warning
    for(i=0;i<len;++i)
    {
        if(bfStrClean[i]=='/')
        {
            slashPos = i;
            break;
        }
    }
    
    numStr = (char*)malloc((len+1)*sizeof(char));
    
    k = 0;
    for(i=0;i<slashPos;i++)
        numStr[k++] = bfStrClean[i];
    numStr[k] = 0;
    
    boolValue = bfConvFromStr2(numbf, numStr);
    free(numStr);
    
    if(!boolValue)
    {
        z = 0;
        free(bfStrClean);
        return false;
    }
    
    denStr = (char*)malloc((len+1)*sizeof(char));
    k = 0;
    for(i=slashPos+1;i<len;i++)
        denStr[k++] = bfStrClean[i];
    denStr[k] = 0;
    free(bfStrClean);
    
    boolValue = bfConvFromStr2(denbf, denStr);
    free(denStr);
    if(!boolValue)
    {
        z = 0;
        return false;
    }
    
    z = numbf / denbf;
    return true;
    
}/* bfConvFromStr */


void bfConvToStr(char*& bfStr, const bf& x)
{
	char		*numStr, *denStr;
	int			numLen, denLen;
	
	equate(numStr, x.num);
	numLen = strlen(numStr);
	if(x.den==1)
	{
		bfStr = (char*)malloc((numLen+1)*sizeof(char));
		strcpy(bfStr, numStr);
		free(numStr);
		return;
	}
	
	equate(denStr, x.den);
	denLen = strlen(denStr);
	
	bfStr = (char*)malloc((numLen+denLen+2)*sizeof(char));
	
	strcpy(bfStr, numStr);
	strcat(bfStr,"/");
	strcat(bfStr,denStr);
	
	free(numStr);
	free(denStr);

}/* bfConvToStr */

void bfConvFromfp(bf& z, const fp& x)
{
    fp      xt;
    INT32   e;
    
    if(!x)
    {
        z = 0;
        return;
    }
    
    if(x.e>=0)
    {
        // x is an integer
        equate(z.num, x);
        z.den = 1;
        return;
    }
    
    // now x.e < 0 so den>1
    // z.num is the integer part and z.den is 2^-x.e
    xt = x;
    e = -xt.e;
    xt.e = 0;
    equate(z.num, xt);
    z.den = power(2, e);
    reduce(z.num, z.den);
    
}/* bfConvFromfp */

void fpConvFrombf(fp& z, const bf& x)
{
    fp      num, den;
    
    equate(num, x.num);
    equate(den, x.den);
    
    z = num / den;
    
}/* fpConvFrombf */

void equate(fp& z, const bf& x)
{
	fp		fpNum, fpDen;
	
	fpNum = x.num;
	fpDen = x.den;
	
	z = fpNum / fpDen;
	
}/* equate */

// bool checkInputString(const char *inString)
// converts rerpeating decimal to fraction
// m is number of digits cycle is to right of decimal point
// for example if 1234 is cycle and inString is 2.751234, m = 2
bool conv(bf& z, const char *inString, long m)
{
    fp          x;
    char        ch;
    long        i, len, n; // n is cycle length
    mb          num, den, temp1, temp2;
    mb          ten=10;
    fp          tenf=10;
    long        dpIndex=-1;
    long        myBlockPrec, newBlockPrec;
    
    if(!checkInputString(inString))
        return false;
    
    // check for 'e' or 'E'
    len = strlen(inString);
    for(i=0;i<len;++i)
    {
        ch = inString[i];
        if(ch=='e' || ch=='E')
        {
            z = 0;
            return false;
        }
    }
    
    // get cycle length
    // find decimal point index
    for(i=0;i<len;++i)
    {
        if(inString[i]=='.')
        {
            dpIndex = i;
            break;
        }
    }
    if(dpIndex==-1)
    {
        z = 0;
        return false;
    }
    // cycle begins at dpIndex + m, so
    n = len - (dpIndex + m + 1);
    // 8 - (1 + 2 + 1) = 4
    myBlockPrec = getBlockPrec();
    newBlockPrec = len/8 + 1;
    if(newBlockPrec<2)
        newBlockPrec = 2;
    equate(x, inString);
    equate(temp1, x*pow(tenf, (double)(m+n)));
    equate(temp2, x*pow(tenf, (double)m));
    num = temp1 - temp2;
    den = power(ten, m+n) - power(ten, m);
    z.num = num;
    z.den = den;
    reduce(z.num, z.den);
    
    setBlockPrec(myBlockPrec);
    return true;
}/* conv */

bf conv(const char *inString, long m)
{
    bf  z;
    
    conv(z, inString, m);
    return z;
        
}/* conv */
