/*
 *  bf.cpp
 *  fp
 *
 *  Created by Robert Delaney on 4/13/13.
 *  Copyright 2013 __Bob Delaney's Science Software_. All rights reserved.
 *
 */

#include "bf.h"

/*
 finds greatest common divisor of x,y and divides it out
 */
static void reduce(mb& x, mb& y)
{
	mb	factor;
	
	//if(x==0 || y==0)
	//	return;
	
	factor = gcd(abs(x), abs(y));
	
	x = x/factor;
	y = y/factor;
	
}/* reduce */

// Constructor
bf::bf()
{
    num.n = num.nn = 0;
    num.b = NULL;
    
    den.n = den.nn = 1;
    den.b = (UINT32*)malloc(sizeof(UINT32));
    den.b[0] = 1;
    
}

// Destructor
bf::~bf()
{
    free((*this).num.b);
    (*this).num.b = NULL;
    free((*this).den.b);
    (*this).den.b = NULL;
}

bf::bf(const char *inString)
{
	bfConvFromStr(*this, inString);
}

bf::bf(const mb& x)
{
	num = x;
	den = 1;
}

bf::bf(const mb& x, const mb& y)
{
	if(!y.n)
	{
		num = 0;
		den = 1;
		return;
	}
		
	num = x;
	den = y;
	if(den.n<0)
	{
		den.n = -den.n;
		num.n = -num.n;
	}
	reduce(num,den);
}

bf::bf(int x)
{
	num = x;
	den = 1;
}

bf::bf(int x, int y)
{
	if(y==0)
	{
		num = 0;
		den = 1;
		return;
	}
	num = x;
	den = y;
	if(den.n<0)
	{
		den.n = -den.n;
		num.n = -num.n;
	}
	reduce(num,den);
}

bf bf::operator- ()
{
	bf		z;
	
	z.num = (*this).num;
	z.den = (*this).den;
	z.num = -z.num;
	return z;
}


bf bf::operator- () const
{
	bf		z;
	
	z.num = (*this).num;
	z.den = (*this).den;
	z.num = -z.num;
	return z;
}

bf& bf::operator= (const bf& x)
{
    if(this==&x)
        return *this;
    
    
    free(num.b);
    num.n = num.nn = 0;
    num.b = NULL;
        
    free(den.b);
    den.n = den.nn = 0;
    den.b = NULL;
    
	num = x.num;
	den = x.den;
	if(!den)
		den = 1;
	
	return *this;
}

bf& bf::operator= (const mb& x)
{
    mb      xt;
    
    xt = x;
    // worry about x being num or den of this
    free(num.b);
    num.n = num.nn = 0;
    num.b = NULL;
    
    free(den.b);
    den.n = den.nn = 0;
    den.b = NULL;
    
	num = xt;
	den = 1;
	
	return *this;
}

bf& bf::operator= (double x)
{
    free(num.b);
    num.n = num.nn = 0;
    num.b = NULL;
    
    free(den.b);
    den.n = den.nn = 0;
    den.b = NULL;
    
	num = x;
	den = 1;
	
	return *this;
}

bool bf::operator> (const bf& y)
{
	
	if(compare(*this, y)==1)
		return true;
	
	return false;
}

bool bf::operator>= (const bf& y)
{
	
	if(!(compare(*this, y)==-1))
		return true;
	
	return false;
}

bool bf::operator== (const bf& y)
{
	
	if(!compare(*this, y))
		return true;
	
	return false;
}

bool bf::operator!= (const bf& y)
{
	
	if(!compare(*this, y))
		return false;
	
	return true;
}

bool bf::operator> (const mb& y)
{
	
	if(compare(*this, y)==1)
		return true;
	
	return false;
}

bool bf::operator>= (const mb& y)
{
	
	if(!(compare(*this, y)==-1))
		return true;
	
	return false;
}

bool bf::operator== (const mb& y)
{
	
	if(!compare(*this, y))
		return true;
	
	return false;
}

bool bf::operator!= (const mb& y)
{
	
	if(!compare(*this, y))
		return false;
	
	return true;
}


bool bf::operator> (int y)
{
	
	if(compare(*this, y)==1)
		return true;
	
	return false;
}

bool bf::operator>= (int y)
{
	
	if(!(compare(*this, y)==-1))
		return true;
	
	return false;
}

bool bf::operator== (int y)
{
	
	if(!compare(*this, y))
		return true;
	
	return false;
}

bool bf::operator!= (int y)
{
	
	if(!compare(*this, y))
		return false;
	
	return true;
}

bool bf::operator! ()
{
	
	if(!(*this).num.n)
		return true;
	
	return false;
}

bool bf::operator<= (const bf& y)
{
	
	if(!(compare(*this, y)==1))
		return true;
	
	return false;
}

bool bf::operator< (const bf& y)
{
	
	if(compare(*this, y)==-1)
		return true;
	
	return false;
}

bool bf::operator> (const bf& y) const
{
	
	if(compare(*this, y)==1)
		return true;
	
	return false;
}

bool bf::operator>= (const bf& y) const
{
	
	if(!(compare(*this, y)==-1))
		return true;
	
	return false;
}

bool bf::operator== (const bf& y) const
{
	
	if(!compare(*this, y))
		return true;
	
	return false;
}

bool bf::operator!= (const bf& y) const
{
	
	if(!compare(*this, y))
		return false;
	
	return true;
}

bool bf::operator! () const
{
	
	if(!(*this).num.n)
		return true;
	
	return false;
}

bool bf::operator<= (const bf& y) const
{
	
	if(!(compare(*this, y)==1))
		return true;
	
	return false;
}

bool bf::operator< (const bf& y) const
{
	
	if(compare(*this, y)==-1)
		return true;
	
	return false;
}

bool bf::operator<= (const mb& y)
{
	
	if(!(compare(*this, y)==1))
		return true;
	
	return false;
}

bool bf::operator< (const mb& y)
{
	
	if(compare(*this, y)==-1)
		return true;
	
	return false;
}

bool bf::operator> (const mb& y) const
{
	
	if(compare(*this, y)==1)
		return true;
	
	return false;
}

bool bf::operator>= (const mb& y) const
{
	
	if(!(compare(*this, y)==-1))
		return true;
	
	return false;
}

bool bf::operator== (const mb& y) const
{
	
	if(!compare(*this, y))
		return true;
	
	return false;
}

bool bf::operator!= (const mb& y) const
{
	
	if(!compare(*this, y))
		return false;
	
	return true;
}


bool bf::operator<= (const mb& y) const
{
	
	if(!(compare(*this, y)==1))
		return true;
	
	return false;
}

bool bf::operator< (const mb& y) const
{
	
	if(compare(*this, y)==-1)
		return true;
	
	return false;
}


bf bf::operator+ (const bf& y)
{
	bf		z;
	
	add(z, *this, y);
	
	return z;
}

bf bf::operator- (const bf& y)
{
	bf		z;
	
	sub(z, *this, y);
	
	return z;
}

bf bf::operator* (const bf& y)
{
	bf		z;
	
	mul(z, *this, y);
	
	return z;
}

bf bf::operator/ (const bf& y)
{
	bf		z;
	
	div(z, *this, y);
	
	return z;
}

bf bf::operator+ (const bf& y) const
{
	bf		z;
	
	add(z, *this, y);
	
	return z;
}

bf bf::operator- (const bf& y) const
{
	bf		z;
	
	sub(z, *this, y);
	
	return z;
}

bf bf::operator* (const bf& y) const
{
	bf		z;
	
	mul(z, *this, y);
	
	return z;
}

bf bf::operator/ (const bf& y) const
{
	bf		z;
	
	div(z, *this, y);
	
	return z;
}

bf bf::operator+ (const mb& y)
{
	bf		z;
	
	add(z, *this, y);
	
	return z;
}

bf bf::operator- (const mb& y)
{
	bf		z;
	
	sub(z, *this, y);
	
	return z;
}

bf bf::operator* (const mb& y)
{
	bf		z;
	
	mul(z, *this, y);
	
	return z;
}

bf bf::operator/ (const mb& y)
{
	bf		z;
	
	div(z, *this, y);
	
	return z;
}

bf bf::operator+ (const mb& y) const
{
	bf		z;
	
	add(z, *this, y);
	
	return z;
}

bf bf::operator- (const mb& y) const
{
	bf		z;
	
	sub(z, *this, y);
	
	return z;
}

bf bf::operator* (const mb& y) const
{
	bf		z;
	
	mul(z, *this, y);
	
	return z;
}

bf bf::operator/ (const mb& y) const
{
	bf		z;
	
	div(z, *this, y);
	
	return z;
}


bf& bf::operator+= (const bf& y)
{
	add(*this, *this, y);
	
	return *this;
}

bf& bf::operator-= (const bf& y)
{
	sub(*this, *this, y);
	
	return *this;
}

bf& bf::operator*= (const bf& y)
{
	mul(*this, *this, y);
	
	return *this;
}

bf& bf::operator/= (const bf& y)
{
	div(*this, *this, y);
	
	return *this;
}

bf& bf::operator+= (const mb& y)
{
	add(*this, *this, y);
	
	return *this;
}

bf& bf::operator-= (const mb& y)
{
	sub(*this, *this, y);
	
	return *this;
}

bf& bf::operator*= (const mb& y)
{
	mul(*this, *this, y);
	
	return *this;
}

bf& bf::operator/= (const mb& y)
{
	div(*this, *this, y);
	
	return *this;
}

bf bf::operator+ (int y)
{
	bf		z;
	
	add(z, *this, y);
	
	return z;
}

bf bf::operator- (int y)
{
	bf		z;
	
	sub(z, *this, y);
	
	return z;
}

bf bf::operator* (int y)
{
	bf		z;
	
	mul(z, *this, y);
	
	return z;
}

bf bf::operator/ (int y)
{
	bf		z;
	
	div(z, *this, y);
	
	return z;
}

bf bf::operator+ (int y) const
{
	bf		z;
	
	add(z, *this, y);
	
	return z;
}

bf bf::operator- (int y) const
{
	bf		z;
	
	sub(z, *this, y);
	
	return z;
}

bf bf::operator* (int y) const
{
	bf		z;
	
	mul(z, *this, y);
	
	return z;
}

bf bf::operator/ (int y) const
{
	bf		z;
	
	div(z, *this, y);
	
	return z;
}

bf operator+ (int x, const bf& y)
{
	bf		z;
	
	add(z, x, y);
	
	return z;
}

bf operator- (int x, const bf& y)
{
	bf		z;
	
	sub(z, x, y);
	
	return z;
}

bf operator* (int x, const bf& y)
{
	bf		z;
	
	mul(z, x, y);
	
	return z;
}

bf operator/ (int x, const bf& y)
{
	bf		z;
	
	div(z, x, y);
	
	return z;
}


bf operator+ (const mb& x, const bf& y)
{
	bf		z;
	
	add(z, x, y);
	
	return z;
}

bf operator- (const mb& x, const bf& y)
{
	bf		z;
	
	sub(z, x, y);
	
	return z;
}

bf operator* (const mb& x, const bf& y)
{
	bf		z;
	
	mul(z, x, y);
	
	return z;
}

bf operator/ (const mb& x, const bf& y)
{
	bf		z;
	
	div(z, x, y);
	
	return z;
}


ostream& operator <<(ostream &s, const bf& x)
{
	char	*xString;
	
	bfConvToStr(xString, x);
	s << xString;
	
	free(xString);
	
	return s;
}


istream& operator >>(istream &s, bf& x)
{
	char	xStr[512]; // increase if needed
	
	s.width(512); // increase if needed
	
	s >> xStr;
	
	if(!bfConvFromStr(x, xStr))
		cerr << "conversion error!" << endl;
	
	return s;
}

