/* Gray_Binary.cpp */

#include "Gray_Binary.h"

/*
	http://www.faqs.org/faqs/ai-faq/genetic/part6/section-1.html
	
	The algorithm for converting between the binary-reflected  Gray  code
	described above  and  the  standard  binary  code  turns  out  to  be
	surprisingly simple to state.  First label the bits of a binary-coded
	string B[i], where larger i's represent more  significant  bits,  and
	similarly label the corresponding Gray-coded string G[i].  We convert
	one to the other as follows:  Copy the most  significant  bit.   Then
	for each smaller i  do  either  G[i] = XOR(B[i+1], B[i])---to convert
	binary to  Gray---or B[i] = XOR(B[i+1], G[i])---to  convert  Gray  to
	binary.
*/

void BinaryToGray(int* G, int* B, int n)
{
	int		i;
	
	G[n] = B[n]; // copy the high-order bit
	
	for(i=n-1;i>=0;i--)
		G[i] = (B[i+1]^B[i]); // XOR
	
}/* BinaryToGray */


void GrayToBinary(int* B, int* G, int n)
{
	int		i;
	
	B[n] = G[n]; // copy the high-order bit
	
	for(i=n-1;i>=0;i--)
		B[i] = (B[i+1]^G[i]); // XOR
	
}/* GrayToBinary */
