//
//  mbMath.hpp
//  fp64
//
//  Created by Bob Delaney on 12/4/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#ifndef mbMath_hpp
#define mbMath_hpp

//#include <stdio.h>

#endif /* mbMath_hpp */

#include "mb.hpp"
#include "mbConv.hpp"

long nlz(UINT64 x);
long numLowOrderZeroBits(UINT64 x);
long Lg2(const mb& x);
long alignLeft(mb& x);
mb abs(const mb& x);
void mbNormalize(mb& x);
long compare(const mb& x, const mb& y);
long compare(const mb& x, int y);
long compare(const mb& x, long y);
void mbShiftLeft(mb& z, const mb& x, long numBits);
mb mbShiftLeft(const mb& x, long numBits);
void mbShiftRight(mb& z, const mb& x, long numBits);
mb mbShiftRight(const mb& x, long numBits);
void add(mb& z, const mb& x, const mb& y);
void sub(mb& z, const mb& x, const mb& y);
void mul(mb& z, const mb& x, const mb& y);
UINT64 shortDiv(mb& z, const mb& x, const mb& y);
long numLeftZeroBiits(UINT64 x);
void divAbs(mb& z, mb& r, const mb& x, const mb& y);
mb div(mb& z, const mb& x, const mb& y);
void add(mb& z, const mb& x, double y);
void sub(mb& z, const mb& x, double y);
void mul(mb& z, const mb& x, double y);
void div(mb& z, const mb& x, double y);
mb divRem(mb& z, const mb& x, double y);
void add(mb& z, double x, const mb& y);
void sub(mb& z, double x, const mb& y);
void mul(mb& z, double x, const mb& y);
void div(mb& z, double x, const mb& y);
mb divRe(mb& z, double x, const mb& y);
long NumBits(long x);
long NumBits(UINT64 x);
long NumBits(const mb& x);
void sqrt(mb& z, const mb& x);
mb sqrt(const mb& x);
void myModulus(mb& z, const mb& x, const mb& y, bool isSym);
void myModulus(mb& z, const mb& x, double y, bool isSym);
void myModulus(mb& z, double x, const mb& y, bool isSym);
mb myModulus(const mb& x, const mb& y, bool isSym);
mb myModulus(const mb& x, double y, bool isSym);
mb myModulus(double x, const mb& y, bool isSym);
void gcd(mb& z, const mb& x, const mb& y);
mb gcd(const mb& x, const mb& y);
void extendedGCD(mb& x, mb& y, mb& gcd, const mb& a, const mb& b);
void lcm(mb& z, const mb& x, const mb& y);
mb lcm(const mb& x, const mb& y);
void nthRoot(mb& z, const mb& x, long n);
mb nthRoot(const mb& x, long n);
bool power(mb& z, const mb& x, long y);
mb power(const mb& x, long y);
long numDigits(const mb& x);

