//
//  mbConv.cpp
//  fp64
//
//  Created by Bob Delaney on 12/2/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#include "mbConv.hpp"
#include "mbMath.hpp"
#include "fpConv.hpp"
#include <stdlib.h>
#include <string.h>

static void coutHex(const mb& x)
{
    long    i;
    
    cout << "sign = " << x.s << endl;
    
    for(i=0;i<x.n;++i)
        cout << hex << x.b[i] << endl;
    cout << dec << endl;
    
}/* coutHex(mb) */

void myFree(mb& x)
{
    free(x.b);
    x.b = NULL;
    x.n = 0;
    x.s = true;
    
}/* myFree(mb) */


// DecStrtoHexStr converts unsigned zString in place to a hex string
static bool DecStrtoHexStr(char* decStr)
{
    long                iChar, jByte, k, length, numBytes;
    unsigned char       ch1, ch2, ten=10;
    long                carry, temp, hundred=100;
    char                *hlookup = "0123456789ABCDEF", ch;
    
    length = strlen(decStr);
    
    if(length==0)
        return false;
    
    if(length==1)
    {
        if(decStr[0]>='0' && decStr[0]<='9')
            return true;
        else
            return false;
    }
    
    // collapse the string into numerical bytes, each byte formed from two
    // adjacent chars, starting on the right
    // the final half of the string is then the number in base 100
    iChar = jByte = length-1;
    
    while(iChar>=0)
    {
        if(iChar>0)
        {
            ch1 = decStr[iChar-1];
            ch2 = decStr[iChar];
            if(!(ch1>='0' && ch1<='9'))
                return false;
            if(!(ch2>='0' && ch2<='9'))
                return false;
            decStr[jByte--] = ten*(ch1-'0') + (ch2-'0');
        }
        else
        {
            ch2 = decStr[iChar];
            if(!(ch2>='0' && ch2<='9'))
                return false;
            decStr[jByte--] = (ch2-'0');
        }
        iChar-=2;
    }
    
    // coming out jByte+1 indexes the leading numerical byte, the last is at length-1
    
    iChar = 0; // indexes where low order hex digit will go; they will be in reverse order
    jByte++;   // now indexes leading numerical byte
    numBytes = length - jByte;
    
    while(numBytes>0)
    {
        temp = decStr[jByte];
        for(k=jByte;k<length;k++)
        {
            // get low-order 4 bits of temp
            carry = (temp & 0xF);
            if(k==length-1)
            {
                decStr[k] = (temp>>4); // new byte value after dividing by sixteen
                decStr[iChar] = hlookup[carry]; // must be after previous line
                iChar++;
            }
            else
            {
                decStr[k] = (temp>>4); // new byte value after dividing by sixteen
                temp = hundred*carry + decStr[k+1];
            }
        }
        if(decStr[jByte]==0 || iChar==length)
        {
            jByte++;
            numBytes--;
        }
    }
    
    decStr[iChar] = 0;
    
    // reverse the chars
    length = strlen(decStr);
    for(k=0;k<length/2;k++)
    {
        ch = decStr[k];
        decStr[k] = decStr[length-1-k];
        decStr[length-1-k] = ch;
    }
    
    return true;
    
}/* DecStrtoHexStr */

static void HexStrtoDecStr(string& z, const string myHexString, bool sign)
{
    long            iChar, jByte, k, length, numBytes;
    long            carry, temp, temp1, ten=10, sixteen=16;
    char            *decStr;
    char            *hexStr;
    char            *dlookup = "0123456789", ch;
    string          myDecString;
    const char      *myHexStringCon;
    
    myHexStringCon = myHexString.c_str();
    length = strlen(myHexStringCon);
    hexStr = (char*)malloc((length+1)*sizeof(char));
    hexStr[0] = 0;
    strcpy(hexStr, myHexStringCon);
    
    if(length==0)
    {
        decStr = (char*)malloc(sizeof(char));
        if(!decStr)
            exit(1);
        decStr[0] = 0;
        z = decStr;
        return;
    }
    
    // since F->15 the worst case requires 2 dec digits per hexit
    
    decStr = (char*)malloc((2*length+10)*sizeof(char)); // don't free in this method!
    if(!decStr)
        exit(1);
    
    // we don't collapse the string, but we do have to get the numerical bytes for base 16
    for(k=0;k<length;k++)
    {
        ch = hexStr[k];
        if(!(ch>='0' && ch<='9') && !((ch>='A' && ch<='F') || (ch>='a' && ch<='f')))
        {
            decStr[0] = 0;
            return;
        }
        
        if(ch>='0' && ch<='9')
            hexStr[k] = (ch - '0');
        
        if(ch>='A' && ch<='F')
            hexStr[k] = ten + (ch - 'A');
        
        if(ch>='a' && ch<='f')
            hexStr[k] = ten + (ch - 'a');
    }
    
    numBytes = length;
    iChar = 0;
    jByte = 0;
    
    while(numBytes>0)
    {
        temp = hexStr[jByte];
        for(k=jByte;k<length;k++)
        {
            // divide temp by 10 and get carry (0 to 9)
            temp1 = temp/ten;
            carry = temp - ten*temp1;
            hexStr[k] = temp1;  // new byte value after dividing by ten
            if(k==length-1)
            {
                decStr[iChar] = dlookup[carry];
                iChar++;
            }
            else
            {
                temp = sixteen*carry + hexStr[k+1];
            }
        }
        if(hexStr[jByte]==0)
        {
            jByte++;
            numBytes--;
        }
    }
    
    decStr[iChar] = 0;
    
    // reverse the chars
    length = strlen(decStr);
    for(k=0;k<length/2;k++)
    {
        ch = decStr[k];
        decStr[k] = decStr[length-1-k];
        decStr[length-1-k] = ch;
    }
    decStr[length] = 0;
    if(!sign)
    {
        // need to insert - sign
        char    ch, ch1;
        
        ch = decStr[0];
        decStr[0] = '-';
        for(k=1;k<length;++k)
        {
            ch1 = decStr[k];
            decStr[k] = ch;
            ch = ch1;
        }
        decStr[length] = ch;
        decStr[length+1] = 0;
    }
    z = decStr;
    free(decStr);
    
}/* HexStrtoDecStr */

static char* HexStrtoDecStr(const string myHexString, bool sign)
{
    long            iChar, jByte, k, length, numBytes;
    long            carry, temp, temp1, ten=10, sixteen=16;
    char            *decStr;
    char            *hexStr;
    char            *dlookup = "0123456789", ch;
    //string          myDecString;
    const char      *myHexStringCon;
    
    myHexStringCon = myHexString.c_str();
    length = strlen(myHexStringCon);
    hexStr = (char*)malloc((length+1)*sizeof(char));
    hexStr[0] = 0;
    strcpy(hexStr, myHexStringCon);
    
    if(length==0)
    {
        decStr = (char*)malloc(sizeof(char));
        if(!decStr)
            exit(1);
        decStr[0] = 0;
        return decStr;
    }
    
    // since F->15 the worst case requires 2 dec digits per hexit
    
    decStr = (char*)malloc((2*length+10)*sizeof(char)); // don't free in this method!
    if(!decStr)
        exit(1);
    
    // we don't collapse the string, but we do have to get the numerical bytes for base 16
    for(k=0;k<length;k++)
    {
        ch = hexStr[k];
        if(!(ch>='0' && ch<='9') && !((ch>='A' && ch<='F') || (ch>='a' && ch<='f')))
        {
            decStr[0] = 0;
            return decStr;
        }
        
        if(ch>='0' && ch<='9')
            hexStr[k] = (ch - '0');
        
        if(ch>='A' && ch<='F')
            hexStr[k] = ten + (ch - 'A');
        
        if(ch>='a' && ch<='f')
            hexStr[k] = ten + (ch - 'a');
    }
    
    numBytes = length;
    iChar = 0;
    jByte = 0;
    
    while(numBytes>0)
    {
        temp = hexStr[jByte];
        for(k=jByte;k<length;k++)
        {
            // divide temp by 10 and get carry (0 to 9)
            temp1 = temp/ten;
            carry = temp - ten*temp1;
            hexStr[k] = temp1;  // new byte value after dividing by ten
            if(k==length-1)
            {
                decStr[iChar] = dlookup[carry];
                iChar++;
            }
            else
            {
                temp = sixteen*carry + hexStr[k+1];
            }
        }
        if(hexStr[jByte]==0)
        {
            jByte++;
            numBytes--;
        }
    }
    
    decStr[iChar] = 0;
    
    // reverse the chars
    length = strlen(decStr);
    for(k=0;k<length/2;k++)
    {
        ch = decStr[k];
        decStr[k] = decStr[length-1-k];
        decStr[length-1-k] = ch;
    }
    decStr[length] = 0;
    if(!sign)
    {
        // need to insert - sign
        char    ch, ch1;
        
        ch = decStr[0];
        decStr[0] = '-';
        for(k=1;k<length;++k)
        {
            ch1 = decStr[k];
            decStr[k] = ch;
            ch = ch1;
        }
        decStr[length] = ch;
        decStr[length+1] = 0;
    }
    return decStr;
    
}/* HexStrtoDecStr */

void init(mb& x)
{
    x.b = NULL;
    x.n = 0;
    x.s = true;
}

void init(mb& z, long n)
{
    mb      zt;
    
    zt.n = n;
    zt.s = true;
    zt.b = (UINT64*)malloc(zt.n*sizeof(UINT64));
    if(!zt.b)
        exit(1);
    
    z = zt;
    
}/* init(mb, n) */
  
// conv converts an unsigned integer C string to an mb;
// Basically we are converting to base 2^64. We do this by first converting to hex, then convert the hex string to blocks in mb
bool conv(mb& z, const char* inString)
{
    long        length, numBlocks, lowNumHexits;
    char        hexBlock[17], *decString, ch;
    long        i, j, decStart;
    bool        isNegative;
    
    length = strlen(inString);
    if(!length)
    {
        z = 0;
        return false;
    }
    // check only valid chars ion inString
    for(i=0;i<length;++i)
    {
        ch = inString[i];
        if(!(ch=='+' || ch=='-' || (ch>='0' && ch<='9')))
            return false;
    }
    
    // get first char to get sign
    ch = inString[0];
    if(ch=='-')
    {
        isNegative = true;
        decStart = 1;
    }
    else
    {
        isNegative = false;
        decStart = 0;
    }
    
    // check that rest has only numbers
    for(i=decStart;i<length;++i)
    {
        ch = inString[i];
        if(!(ch>='0' && ch<='9'))
            return false;
    }
    
    decString = (char*)malloc((length+1)*sizeof(char));
    strcpy(decString, inString);
    // if isNegative=true we need to move down
    if(isNegative)
    {
        for(i=0;i<length;++i)
            decString[i] = decString[i+1];
    }
    
    if(!DecStrtoHexStr(decString))
    {
        free(decString);
        return false;
    }
    // decString now is in hex
    length = strlen(decString);
    // calculate the number of blocks needed, each block can hold 64 bits or 16 hexits
    numBlocks = length/16;
    lowNumHexits = length-16*numBlocks;
    
    if(lowNumHexits>0)
        numBlocks++;
    
    z.n = numBlocks;
    if(isNegative)
        z.s = false;
    else
        z.s = true;
    
    z.b = (UINT64*)malloc(z.n*sizeof(UINT64));
    
    // fill blocks from high order to low order
    // if lowNumHexits>0 fill high order special
    j = 0; // index to hex zString
    
    if(lowNumHexits>0)
    {
        for(i=0;i<lowNumHexits;i++)
            hexBlock[i] = decString[j++];
        
        hexBlock[lowNumHexits] = 0;
        
        // convert hexBlock to UINT64
        if(sscanf(hexBlock,"%lX", &z.b[numBlocks-1])==0)
        {
            free(decString);
            free(z.b);
            z.b = NULL;
            z.n = 0;
            z.s = true;
            return false;
        }
        
        numBlocks--;
    }
    
    hexBlock[16] = 0; // always
    
    while(numBlocks>0)
    {
        for(i=0;i<16;i++)
            hexBlock[i] = decString[j++];
        
        // convert hexBlock to UINT64
        
        if(sscanf(hexBlock,"%lX", &z.b[numBlocks-1])==0)
        {
            free(decString);
            free(z.b);
            z.b = NULL;
            z.n = 0;
            z.s = true;
            return false;
        }
        numBlocks--;
    }

    free(decString);
    return true;
    
}/* conv(mb, string) */

// if necessary, leading zeroes are inserted so we have 16 hex characters
static void padZeroes(char *hexString)
{
    long        i, length;
    char        temp[17];
    
    length = strlen(hexString);
    if(length==16)
        return;
    // we need 16-length zeroes in front
    temp[0] = 0;
    strcpy(temp, hexString);
    hexString[0] = 0;
    for(i=0;i<16-length;++i)
        strcat(hexString, "0");
    strcat(hexString, temp);
    
}/* padZeroes */

// uses HexToDec
void conv(string& z, const mb& x)
{
    char        hexBlock[17];
    char        *hexString, ch, ch1;
    long        i, j, length;
    string      hexStr;
    
    if(x.b==NULL)
        return;
    
    // x.n is the number of hex blocks to put into hexString
    // each block goes to 16 hex characters (or less)
    hexString = (char*)malloc((16*x.n+1)*sizeof(char));
    hexString[0] = 0;
    // use blocks from high to low
    // but must account for leading zeroes in the hex word!
    sprintf(hexBlock, "%lx", x.b[x.n-1]);
    strcat(hexString, hexBlock);
    for(i=x.n-2;i>=0;--i)
    {
        sprintf(hexBlock, "%lx", x.b[i]);
        length = strlen(hexBlock);
        for(j=0;j<16-length;++j)
            strcat(hexString, "0");
        
        strcat(hexString, hexBlock);
    }
    hexStr = hexString;
    
    HexStrtoDecStr(z, hexStr, x.s);
    
    free(hexString);
    
}/* conv(string, mb) */

// uses HexToDec
char* conv(const mb& x)
{
    char        hexBlock[17];
    char        *hexString, ch, ch1;
    long        i, j, length;
    string      hexStr;
    
    if(x.b==NULL)
        return NULL;
    
    // x.n is the number of hex blocks to put into hexString
    // each block goes to 16 hex characters (or less)
    hexString = (char*)malloc((16*x.n+1)*sizeof(char));
    hexString[0] = 0;
    // use blocks from high to low
    // but must account for leading zeroes in the hex word!
    sprintf(hexBlock, "%lx", x.b[x.n-1]);
    strcat(hexString, hexBlock);
    for(i=x.n-2;i>=0;--i)
    {
        sprintf(hexBlock, "%lx", x.b[i]);
        length = strlen(hexBlock);
        for(j=0;j<16-length;++j)
            strcat(hexString, "0");
        
        strcat(hexString, hexBlock);
    }
    hexStr = hexString;
    
    hexString = HexStrtoDecStr(hexStr, x.s);
    
    return hexString;
    
}/* conv(mb) */

void conv(mb& z, const mb& x)
{
    long    i;

    myFree(z);
    init(z, x.n);
    for(i=0;i<z.n;++i)
        z.b[i] = x.b[i];
    z.s = x.s;
    
}/* conv(mb, mb) */

void conv(mb& z, int x)
{
    mb      zt;
    
    zt.n = 1;
    zt.b = (UINT64*)malloc(zt.n*sizeof(UINT64));
    zt.b[0] = abs(x);
    if(x>=0)
        zt .s = true;
    else
        zt.s = false;
    
    z = zt;
    
}/* conv(mb, int) */

void conv(mb& z, long x)
{
    mb      zt;
    
    zt.n = 1;
    zt.b = (UINT64*)malloc(zt.n*sizeof(UINT64));
    zt.b[0] = abs(x);
    if(x>=0)
        zt .s = true;
    else
        zt.s= false;
    
    z = zt;
    
}/* conv(mb, long) */

void conv(mb& z, UINT64 x)
{
    mb  zt;
    
    zt.n = 1;
    zt.b = (UINT64*)malloc(zt.n*sizeof(UINT64));
    zt.b[0] = x;
    zt.s = true;
    z = zt;
    
}/* conv(mb, UINT64) */

void conv(mb& z, const fp& x)
{
    long    eSave;
    
    z = x.i;
    eSave = x.e;
    if(eSave>=0)
        mbShiftLeft(z, z, eSave);
    else
        mbShiftRight(z, z, abs(eSave));
    
}/* conv(mb, fp) */

void conv(mb& z, double x)
{
    fp      xfp;
    
    conv(xfp, x);
    conv(z, xfp);
    
}/* conv(mb, double) */

void conv(long& z, const mb& x)
{
    if(x.n>1)
    {
        z = 0;
        return;
    }
    z = x.b[0];
    if(!x.s)
        z = -z;
}/* conv(long, mb) */
