//
//  mb.hpp
//  fp64
//
//  Created by Bob Delaney on 12/2/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#ifndef mb_hpp
#define mb_hpp

#include <stdio.h>
#include <iostream>

#endif /* mb_hpp */

#pragma once

#define blockBits 64
#define UINT64 unsigned long
#define UINT128 unsigned __int128
//#define UINT128 unsigned long long
#define INT128 __int128
//#define INT128 long long

using namespace std;

class mb
{
    public:
    long         n;  // number of blocks
    UINT64       *b; // b[0] is low order block; b[n-1] is high order block
    bool                s;  // algebraic sign, true = +, false = -
    
    mb();
    mb(const char*);
    mb(int);
    mb(long);
    mb(double);
    
    ~mb();
    
    mb operator- ();
    mb operator- () const;
    mb& operator= (const mb&);
    mb& operator= (const char*);
    mb& operator= (double);
    mb& operator= (int);
    mb& operator= (long);
    mb& operator= (UINT64);
    
    bool operator! ();
    bool operator< (const mb&);
    bool operator<= (const mb&);
    bool operator> (const mb&);
    bool operator>= (const mb&);
    bool operator== (const mb&);
    bool operator!= (const mb&);
    
    bool operator! () const;
    bool operator< (const mb&) const;
    bool operator<= (const mb&) const;
    bool operator> (const mb&) const;
    bool operator>= (const mb&) const;
    bool operator== (const mb&) const;
    bool operator!= (const mb&) const;
    
    bool operator== (int);
    bool operator== (long);
    bool operator!= (int);
    bool operator!= (long);
    
    bool operator== (int) const;
    bool operator== (long) const;
    bool operator!= (int) const;
    bool operator!= (long) const;
    
    mb operator<< (long);
    mb operator>> (long);
    
    mb operator% (const mb&);
    mb operator% (double);
    mb operator% (const mb&) const;
    mb operator% (double) const;
    
    mb operator+ (const mb&);
    mb operator- (const mb&);
    mb operator* (const mb&);
    mb operator/ (const mb&);
    mb operator+ (const mb&) const;
    mb operator- (const mb&) const;
    mb operator* (const mb&) const;
    mb operator/ (const mb&) const;
    mb& operator+= (const mb&);
    mb& operator-= (const mb&);
    mb& operator*= (const mb&);
    mb& operator/= (const mb&);
    
    mb operator+ (double);
    mb operator- (double);
    mb operator* (double);
    mb operator/ (double);
    
    mb& operator+= (double);
    mb& operator-= (double);
    mb& operator*= (double);
    mb& operator/= (double);
    
    
    
    
    friend ostream& operator <<(ostream &s,const mb& x);
    friend istream& operator >>(istream &s, mb& x);
};

mb operator+ (double, const mb&);
mb operator- (double, const mb&);
mb operator* (double, const mb&);
mb operator/ (double, const mb&);

