//
//  mb.cpp
//  fp64
//
//  Created by Bob Delaney on 12/2/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#include <stdio.h>
#include <stdlib.h>
#include "mb.hpp"
#include "fpConv.hpp"
#include "mbConv.hpp"
#include "mbMath.hpp"

using namespace std;

// Constructor
mb::mb()
{
    n = 0;
    b = NULL;
    s = true;
}

// Destructor
mb::~mb()
{
    free(b);
    b = NULL;
    n = 0;
    s = true;
}

mb::mb(const char* x)
{
    conv(*this, x);
}

mb::mb(int x)
{
    n = 1;
    b = (UINT64*)malloc(n*sizeof(UINT64));
    b[0] = abs(x);
    if(x>=0)
        s = true;
    else
        s= false;
}

mb::mb(long x)
{
    n = 1;
    b = (UINT64*)malloc(n*sizeof(UINT64));
    b[0] = abs(x);
    if(x>=0)
        s = true;
    else
        s= false;
}

mb mb::operator- ()
{
    mb        z;
    
    conv(z, *this);
    z.s = !z.s;
    return z;
}

mb mb::operator- () const
{
    mb        z;
    
    conv(z, *this);
    z.s = !z.s;
    return z;
}

mb& mb::operator= (const mb& x)
{
    long    i;
    
    if(this==&x)
        return *this;
    
    free(b);
    n = x.n;
    s = x.s;
    b = (UINT64*)malloc(x.n*sizeof(UINT64));
    if(!b)
        exit(1);
    for(i=0;i<n;++i)
        b[i] = x.b[i];
    
    return *this;
}

mb& mb::operator= (const char* x)
{
    free(b);
    conv(*this, x);
    return *this;
}

mb& mb::operator= (int x)
{
    free(b);
    n = 1;
    b = (UINT64*)malloc(n*sizeof(UINT64));
    b[0] = abs(x);
    if(x>=0)
        s = true;
    else
        s = false;
    
    return *this;
}

mb& mb::operator= (UINT64 x)
{
    free(b);
    n = 1;
    s = true;
    b = (UINT64*)malloc(n*sizeof(UINT64));
    b[0] = x;
    
    return *this;
}

mb& mb::operator= (long x)
{
    free(b);
    n = 1;
    b = (UINT64*)malloc(n*sizeof(UINT64));
    b[0] = abs(x);
    if(x>=0)
        s = true;
    else
        s = false;
    return *this;
}

bool mb::operator! ()
{
    if(!compare(*this, 0))
        return true;
    
    return false;
}

bool mb::operator< (const mb& y)
{
    if(compare(*this, y)==-1)
        return true;
    
    return false;
}

bool mb::operator<= (const mb& y)
{
    if(!(compare(*this, y)==1))
        return true;
    
    return false;
}

bool mb::operator> (const mb& y)
{
    if(compare(*this, y)==1)
        return true;
    
    return false;
}

bool mb::operator>= (const mb& y)
{
    if(!(compare(*this, y)==-1))
        return true;
    
    return false;
}

bool mb::operator== (const mb& y)
{
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool mb::operator!= (const mb& y)
{
    if(!compare(*this, y))
        return false;
    
    return true;
}

bool mb::operator! () const
{
    if(!compare(*this, 0))
        return true;
    
    return false;
}

bool mb::operator< (const mb& y) const
{
    if(compare(*this, y)==-1)
        return true;
    
    return false;
}

bool mb::operator<= (const mb& y) const
{
    if(!(compare(*this, y)==1))
        return true;
    
    return false;
}

bool mb::operator> (const mb& y) const
{
    if(compare(*this, y)==1)
        return true;
    
    return false;
}

bool mb::operator>= (const mb& y) const
{
    if(!(compare(*this, y)==-1))
        return true;
    
    return false;
}

bool mb::operator== (const mb& y) const
{
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool mb::operator!= (const mb& y) const
{
    if(!compare(*this, y))
        return false;
    
    return true;
}

bool mb::operator== (int y)
{
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool mb::operator== (long y)
{
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool mb::operator!= (int y)
{
    if(!compare(*this, y))
        return false;
    
    return true;
}

bool mb::operator!= (long y)
{
    if(!compare(*this, y))
        return false;
    
    return true;
}

bool mb::operator== (int y) const
{
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool mb::operator== (long y) const
{
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool mb::operator!= (int y) const
{
    if(!compare(*this, y))
        return false;
    
    return true;
}

bool mb::operator!= (long y) const
{
    if(!compare(*this, y))
        return false;
    
    return true;
}

mb mb::operator<< (long y)
{
    mb        z;
    
    mbShiftLeft(z, *this, y);
    
    return z;
}

mb mb::operator>> (long y)
{
    mb        z;
    
    mbShiftRight(z, *this, y);
    
    return z;
}

mb mb::operator% (const mb& y)
{
    mb        z;
    
    myModulus(z, *this, y, false);
    
    return z;
}


mb mb::operator% (double y)
{
    mb        z;
    
    myModulus(z, *this, y);
    
    return z;
}

mb mb::operator% (const mb& y) const
{
    mb        z;
    
    myModulus(z, *this, y, false);
    
    return z;
}

mb mb::operator% (double y) const
{
    mb        z;
    
    myModulus(z, *this, y);
    
    return z;
}

mb mb::operator+ (const mb& y)
{
    mb        z;
    
    add(z, *this, y);
    
    return z;
}

mb mb::operator- (const mb& y)
{
    mb        z;
    
    sub(z, *this, y);
    
    return z;
}

mb mb::operator* (const mb& y)
{
    mb        z;
    
    mul(z, *this, y);
    
    return z;
}

mb mb::operator/ (const mb& y)
{
    mb        z;
    
    div(z, *this, y);
    
    return z;
}

mb mb::operator+ (const mb& y) const
{
    mb        z;
    
    add(z, *this, y);
    
    return z;
}

mb mb::operator- (const mb& y) const
{
    mb        z;
    
    sub(z, *this, y);
    
    return z;
}

mb mb::operator* (const mb& y) const
{
    mb        z;
    
    mul(z, *this, y);
    
    return z;
}

mb mb::operator/ (const mb& y) const
{
    mb        z;
    
    div(z, *this, y);
    
    return z;
}

mb& mb::operator+= (const mb& y)
{
    add(*this, *this, y);
    
    return *this;
}

mb& mb::operator-= (const mb& y)
{
    sub(*this, *this, y);
    
    return *this;
}

mb& mb::operator*= (const mb& y)
{
    mul(*this, *this, y);
    
    return *this;
}


mb& mb::operator/= (const mb& y)
{
    div(*this, *this, y);
    
    return *this;
}

mb mb::operator+ (double y)
{
    mb        z, ymb;
    
    conv(ymb, y);
    add(z, *this, ymb);
    
    return z;
}

mb mb::operator- (double y)
{
    mb        z, ymb;
    
    conv(ymb, y);
    sub(z, *this, ymb);
    
    return z;
}

mb mb::operator* (double y)
{
    mb        z, ymb;
    
    conv(ymb, y);
    mul(z, *this, ymb);
    
    return z;
}

mb mb::operator/ (double y)
{
    mb        z, ymb;
    
    conv(ymb, y);
    div(z, *this, ymb);
    
    return z;
}

mb& mb::operator+= (double y)
{
    mb      ymb;
    
    conv(ymb, y);
    add(*this, *this, ymb);
    
    return *this;
}

mb& mb::operator-= (double y)
{
    mb      ymb;
    
    conv(ymb, y);
    sub(*this, *this, ymb);
    
    return *this;
}

mb& mb::operator*= (double y)
{
    mb      ymb;
    
    conv(ymb, y);
    mul(*this, *this, ymb);
    
    return *this;
}

mb& mb::operator/= (double y)
{
    mb      ymb;
    
    conv(ymb, y);
    div(*this, *this, ymb);
    
    return *this;
}

ostream& operator <<(ostream &s, const mb& x)
{
    string      xString;
    
    conv(xString, x);
    s << xString;
    
    return s;
}

istream& operator >>(istream &s, mb& x)
{
    string  xStr;
    
    s >> xStr;
    if(!conv(x, xStr.c_str()))
        cerr << "conversion error!" << endl;
    
    return s;
}

mb operator+ (double x, const mb& y)
{
    mb        z;
    mb        xmb;
    
    conv(xmb, x);
    add(z, xmb, y);
    
    return z;
}

mb operator- (double x, const mb& y)
{
    mb        z;
    mb        xmb;
    
    conv(xmb, x);
    sub(z, xmb, y);
    
    return z;
}

mb operator* (double x, const mb& y)
{
    mb        z;
    mb        xmb;
    
    conv(xmb, x);
    mul(z, xmb, y);
    
    return z;
}

mb operator/ (double x, const mb& y)
{
    mb        z;
    mb        xmb;
    
    conv(xmb, x);
    div(z, xmb, y);
    
    return z;
}
