//
//  main.cpp
//  fp64
//
//  Created by Bob Delaney on 11/30/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#include <iostream>
#include "fp.hpp"
#include "fpMath.hpp"
#include "fpConv.hpp"
#include "fpFuncs.hpp"
#include "mbMath.hpp"
#include "myGammaFunctions.hpp"

extern long outPrec;
extern long blockPrec;
extern long decPrec;

static void coutHex1(const mb& x)
{
    char        hexBlock[17];
    char        *hexString, ch, ch1;
    long        i, j, length;
    
    if(x.b==NULL)
        return;
    
    // x.n is the number of hex blocks to put into hexString
    // each block goes to 16 hex characters (or less)
    hexString = (char*)malloc((16*x.n+1)*sizeof(char));
    hexString[0] = 0;
    // use blocks from high to low
    // but must account for leading zeroes in the hex word!
    sprintf(hexBlock, "%lx", x.b[x.n-1]);
    strcat(hexString, hexBlock);
    for(i=x.n-2;i>=0;--i)
    {
        sprintf(hexBlock, "%lx", x.b[i]);
        length = strlen(hexBlock);
        for(j=0;j<16-length;++j)
            strcat(hexString, "0");
        
        strcat(hexString, hexBlock);
    }
    
    cout << "n = " << x.n << endl;
    cout << "sign = " << x.s << endl;
    cout << "hexString = " << hexString << endl;
    
}/* coutHex1 */

static void myGamma(fp& z, const fp& x, long a)
{
    fp      zt;
    
    //blockPrec++;
    GammaSpouge(zt, x, a);
    z = zt;
    //blockPrec--;
}

int main(int argc, const char * argv[])
{
    fp      x, y, z, a;
    long    aInt;
    string  xString;
    
    setUserPrec(16);
    setOutPrec(16);
    
    cout << blockPrec << endl;
    return 0;
    
    x = "10000.5";
    aInt = 15; // x=1 aInt= 30 p = 32
    GammaSpouge(z, x, aInt);
    cout << "x! = " << z << endl;
    Gamma(y, x+1);
    cout << "x! = " << y << endl;
    return 0;
}
