//
//  fpMath.hpp
//  fp64
//
//  Created by Bob Delaney on 12/10/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#ifndef fpMath_hpp
#define fpMath_hpp

#include <stdio.h>

#endif /* fpMath_hpp */

#include <stdlib.h>
#include "fp.hpp"

using namespace std;

long getDecPrec();
long getBlockPrec();
void setUserPrec(long prec);
long getUserPrec();
void setOutPrec(long prec);
long getOutPrec();
bool isItInteger(const fp& x);
bool isItEven(const fp& x);
long to_long(const fp& x);
void floor(fp& z, const fp& x);
fp floor(const fp& x);
void ceil(fp& z, const fp& x);
fp ceil(const fp& x);
void removeTrailingZeroes(fp& z, const fp& x);
fp abs(const fp& x);
long compare(const fp& x, const fp& y);
//long NumBits(long x);
//long NumBits(UINT64 x);
long Lg2(const fp& x);
void fpShiftLeft(fp& z, const fp& x, long numBits);
void fpShiftRight(fp& z, const fp& x, long numBits);
void fpShiftLeftmb(fp& z, const fp& x, long numBits);
void fpShiftRightmb(fp& z, const fp& x, long numBits);
void fpNormalize(fp& x);
void add(fp& z, const fp& x, const fp& y);
void sub(fp& z, const fp& x, const fp& y);
void mul(fp& z, const fp& x, const fp& y);
bool div(fp& z, const fp& x, const fp& y);
void add(fp& z, const fp& x, double y);
void sub(fp& z, const fp& x, double y);
void mul(fp& z, const fp& x, double y);
void div(fp& z, const fp& x, double y);
void add(fp& z, double x, const fp& y);
void sub(fp& z, double x, const fp& y);
void mul(fp& z, double x, const fp& y);
void div(fp& z, double x, const fp& y);
bool power(fp& z, const fp& x, long y);
fp power(const fp& x, long y);
bool pow(fp& z, const fp& x, const fp& y);
fp pow(const fp& x, const fp& y);
void pow(fp& z, const fp& x, double  y);
fp pow(const fp&x, double y);

