//
//  fpConv.cpp
//  fp64
//
//  Created by Bob Delaney on 12/10/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#include <string.h>
#include "fpConv.hpp"
#include "mbConv.hpp"
#include "mbMath.hpp"
#include "fpMath.hpp"
#include "fpFuncs.hpp"

extern long blockPrec;
extern long decPrec;
extern long outPrec;

using namespace std;
// after verifying inString
// we work on inString to form fpString
// to the two forms
// (-)xxx...xxx (no decimal
// (-)xxx...xxxeyyyy (no decimal)
// will be static

static void coutHex(const mb& x)
{
    long    i;
    
    cout << "sign = " << x.s << endl;
    
    for(i=0;i<x.n;++i)
        cout << hex << x.b[i] << endl;
    cout << dec << endl;
    
}/* coutHex(mb) */

static void coutHex(const fp& x)
{
    cout << dec << "e = " << x.e << endl;
    coutHex(x.i);
    
}/* coutHex(fp) */

static void coutHex1(const mb& x)
{
    char        hexBlock[17];
    char        *hexString, ch, ch1;
    long        i, j, length;
    
    if(x.b==NULL)
        return;
    
    // x.n is the number of hex blocks to put into hexString
    // each block goes to 16 hex characters (or less)
    hexString = (char*)malloc((16*x.n+1)*sizeof(char));
    hexString[0] = 0;
    // use blocks from high to low
    // but must account for leading zeroes in the hex word!
    sprintf(hexBlock, "%lx", x.b[x.n-1]);
    strcat(hexString, hexBlock);
    for(i=x.n-2;i>=0;--i)
    {
        sprintf(hexBlock, "%lx", x.b[i]);
        length = strlen(hexBlock);
        for(j=0;j<16-length;++j)
            strcat(hexString, "0");
        
        strcat(hexString, hexBlock);
    }
    
    cout << "n = " << x.n << endl;
    cout << "sign = " << x.s << endl;
    cout << "hexString = " << hexString << endl;
    
}/* coutHex1 */

static void coutHex1(const fp& x)
{
    cout << "e = " << x.e << endl;
    coutHex1(x.i);
    
}/* coutHex1 */

void myFree(fp& x)
{
    myFree(x.i);
    x.e = 0;
    
}/* myFree */

void init(fp& x)
{
    x.i.b = NULL;
    x.i.n = 0;
    x.i.s = true;
    x.e = 0;
}

void init(fp& z, long n)
{
    fp      zt;
    
    init(zt.i, n);
    zt.e = 0;
    
    z = zt;
    
}/* init(fp, long) */

void conv(fp& z, const fp& x)
{
    fp      zt;
    long    i;
    
    init(zt.i, x.i.n);
    zt.i.s = x.i.s;
    zt.e = x.e;
    for(i=0;i<zt.i.n;++i)
        zt.i.b[i] = x.i.b[i];
    z = zt;

}/* conv(fp, fp) */

void conv(fp& z, int x)
{
    z.i = x;
    z.e = 0;
    
}/* conv(fp, long) */

void conv(fp& z, long x)
{
    z.i = x;
    z.e = 0;
    
}/* conv(fp, long) */

void conv(fp& z, const mb& x)
{
    z.i = x;
    z.e = 0;
    
}/* conv(fp, mb) */

bool conv(fp& z, double x)
{
    char        dataString[100], ch;
    long        i, j, len, eIndex, zeroCount;
    string      outString;
    
    if(!x)
    {
        z = 0;
        return true;
    }
    
    sprintf(dataString, "%.15e", x); // will allow up to 15 sig figs
    
    // for say 2, we'll see 2.00000000000000e+00 so we need to remove trailing zeroes
    //find 'e'
    len = strlen(dataString);
    
    for(i=0;i<len;i++)
    {
        if(dataString[i]=='e')
            break;
    }
    eIndex = i;
    
    // count continuous zeroes to left of e
    
    zeroCount = 0;
    ch = dataString[--i];
    while(ch=='0' && i>0)
    {
        zeroCount++;
        ch = dataString[--i];
    }
    // i now points to first non '0' as come in from right
    
    // move the exp stuff down to just after where i points, that's a move of eIndex-(i+1)
    
    for(j=eIndex;j<=len;j++)
        dataString[i+1+j-eIndex] = dataString[j];
    
    outString = dataString;
    
    return conv(z, outString);
    
}/* conv(fp, double) */

bool checkInputString(const string inStr)
{
    char            *myString, *manString, *expString, ch;
    long            length, i, index;
    bool            isExp;
    const char      *inStrCon;
    char            *inString;
    
    inStrCon = inStr.c_str();
    length = strlen(inStrCon);
    if(!length)
        return false;
    
    inString = (char*)malloc((length+1)*sizeof(char));
    inString[0] = 0;
    strcpy(inString, inStrCon);
    // check for obvious
    for(i=0;i<length;i++)
    {
        ch = inString[i];
        if(!(ch==',' || ch=='+' || ch=='-' || ch=='e' || ch=='E' || ch=='.' || (ch>='0' && ch<='9')))
        {
            free(inString);
            return false;
        }

    }
    
    myString = (char*)malloc((length+1)*sizeof(char));
    
    // remove spaces
    index = 0;
    for(i=0;i<length;i++)
    {
        ch = inString[i];
        if(!(ch==' '))
        {
            myString[index] = ch;
            index++;
        }
        
    }
    myString[index] = 0;
    
    length = strlen(myString);
    if(!length)
    {
        free(inString);
        free(myString);
        return false;
    }
    
    // is there exponent?
    isExp = false;
    index = 0;
    for(i=0;i<length;i++)
    {
        index = i;
        ch = myString[i];
        if(ch=='e' || ch=='E')
        {
            isExp = true;
            break;
        }
    }
    
    // if there is exponent, there must be a number in front of it
    if(isExp && index==0)
    {
        free(inString);
        free(myString);
        return false;
    }
    
    if(isExp)
    {
        ch = myString[index-1];
        if(!((ch>='0' && ch<='9') || ch=='.'))
        {
            free(inString);
            free(myString);
            return false;
        }
        if(ch=='.' && index==1)
        {
            free(inString);
            free(myString);
            return false;
        }
        if(ch=='.')  // must be a digit before it; index must be at least 2
        {
            if(index<2)
            {
                free(inString);
                free(myString);
                return false;
            }
            
            ch = myString[index-2];
            if(!(ch>='0' && ch<='9'))
            {
                free(inString);
                free(myString);
                return false;
            }
        }
    }
    
    manString = (char*)malloc((length+1)*sizeof(char));
    if(isExp)
    {
        for(i=0;i<=index-1;i++)
            manString[i] = myString[i];
        manString[index] = 0;
    }
    else
    {
        for(i=0;i<length;i++)
            manString[i] = myString[i];
        manString[length] = 0;
    }
    
    // check manString, may have only one sign in front, so it's sign or digit
    length = strlen(manString);
    for(i=1;i<length;i++)
    {
        ch = manString[i];
        if(ch=='+' || ch=='-')
        {
            free(inString);
            free(manString);
            free(myString);
            return false;
        }
    }
    
    // can have at most one decimal point
    long    count;
    count = 0;
    for(i=1;i<length;i++)
    {
        if(manString[i]=='.')
            count++;
    }
    
    if(count>1)
    {
        free(inString);
        free(manString);
        free(myString);
        return false;
    }
    
    free(manString);
    
    if(!isExp)
    {
        free(inString);
        free(myString);
        return true;
    }
    
    // check expString
    length = strlen(myString);
    expString = (char*)malloc((length+1)*sizeof(char));
    
    for(i=index+1;i<length;i++)
    {
        expString[i-index-1] = myString[i];
    }
    expString[length-index-1] = 0;
    
    // check expString, may have only one sign in front, so it's sign or digit
    // expString cannot have decimal point
    if(expString[0]=='.')
    {
        free(inString);
        free(expString);
        free(myString);
        return false;
    }
    
    length = strlen(expString);
    for(i=1;i<length;i++)
    {
        ch = expString[i];
        if(ch=='+' || ch=='-' || ch=='e' || ch=='E' || ch=='.')
        {
            free(inString);
            free(expString);
            free(myString);
            return false;
        }
    }
    
    free(inString);
    free(expString);
    free(myString);
    return true;
    
}/* checkInputString */


bool conv(fp& z, const string inStr)
{
    fp              p;
    fp              ten=10;
    long            length, i, j, ie, id, decExp;
    char            ch, expString[30], *fpString;
    bool            isNegative;
    
    length = strlen(inStr.c_str());
    if(!length)
    {
        z = 0;
        return false;
    }
    fpString = (char*)malloc((length+1)*sizeof(char));
    fpString[0] = 0;
    strcpy(fpString, inStr.c_str());
    if(!checkInputString(fpString))
        return false;
    
    // remove comma(s)
    j = 0;
    for(i=0;i<length;++i)
    {
        ch = fpString[i];
        if(ch!=',')
            fpString[j++] = ch;
    }
    fpString[j] = 0;
    length = strlen(fpString);
    
    decExp = 0;
    ie = 0;
    // find e or E
    for(i=0;i<=length;i++)
    {
        ie = i;
        ch = fpString[i];
        if(ch=='e' || ch=='E')
            break;
    }
    
    i = ie; // being cautious
    
    if(ch=='e' || ch=='E')
    {
        // have exponent, put it in expString; i points to e or E
        j = 0;
        ch = fpString[++i];
        while(j<30 && ch)
        {
            expString[j++] = ch;
            ch = fpString[++i];
        }
        
        expString[j] = 0;
        
        if(!(sscanf(expString, "%ld", &decExp)==1))
        {
            free(fpString);
            return false;
        }
        
        // strip off exponent part
        fpString[ie] = 0;
        length = strlen(fpString);
    }
    id = 0;
    // does fpString have a decimal point?
    for(i=0;i<=length;i++)
    {
        id = i;
        ch = fpString[i];
        if(ch=='.')
            break;
    }
    
    if(ch=='.')
    {
        // yes, there is a decimal point pointed to by id
        // for each number to its right we decrement decExp
        i = id + 1;
        ch = fpString[i];
        while(ch>='0' && ch<='9')  // only goes once through
        {
            fpString[i-1] = ch;
            ch = fpString[++i];
            decExp--;
        }
        fpString[i-1] = 0;
    }
    
    // now fpString should be without exponent or decimal point, so we get the initial integer part of z, but it may be negative. To convert ity must be positive
    isNegative = false;
    if(fpString[0]=='-')
    {
        isNegative = true;
        length = strlen(fpString);
        for(i=0;i<length;++i)
            fpString[i] = fpString[i+1];
    }
    
    if(!conv(z.i, fpString))
    {
        free(fpString);
        return false;
    }
    
    z.e = 0;
    if(isNegative)
        z.i.s = false;
    
    // now we need to use the dec exponent
    if(!power(p, ten, decExp))
    {
        free(fpString);
        return false;
    }
    
    mul(z, z, p); // this uses blockPrec!
    removeTrailingZeroes(z, z);
    free(fpString);
    
    return true;
    
}/* conv(fp, string) */

void conv(string& xString, const fp& x, long myDecPrec)
{
    xString = fpToStr(x, myDecPrec);
    
}/* conv(string, fp) */
/*
void conv(mb& z, const fp& x)
{
    long    eSave;
    
    z = x.i;
    eSave = x.e;
    if(eSave>=0)
        mbShiftLeft(z, z, eSave);
    else
        mbShiftRight(z, z, abs(eSave));
   
}*//* conv(mb, fp) */

// can x be converted to a long?
bool conv(long& z, const fp& x)
{
    mb      zmb;
    fp      zfp;
    
    if(x.i==0)
    {
        z = 0;
        return true;
    }
    
    if(x.i.n>1)
        return false;
    
    conv(zmb, x);
    if(zmb.n>1)
        return false;
    
    if(zmb.b[0]>0xFFFFFFFFFFFFFFF)
        return false;
    
    zfp = zmb;
    if(compare(zfp, x))
        return false;
    
    z = zmb.b[0];
    if(!x.i.s)
        z = -z;
    
    return true;
    
}/* conv(long, fp) */

// follows NTL method, gives "pretty" output
string fpToStr(const fp& x, long myDecPrec)
{
    fp      xt, ten=10, xMan;
    string  outString, xManStr;
    char    *xString, *xManString, expStr[255];
    const char    *xManConString;
    long    bp, p, logtenxInt, xDecExp, xDecExp1;
    long    i, j, length;
    fp      temp;
    bool    isNegative;
    long    eSave;
    long    extra;
    long    index, numTrailZeroes;
    char    *xString1;
   
    if(x.i.s)
        isNegative = false;
    else
        isNegative = true;
 
    if(x.i==0)
    {
        xString = (char*)malloc(2*sizeof(char));
        xString[0] = '0';
        xString[1] = 0;
        outString = xString;
        free(xString);
        return outString;
    }
    
    xt = x;
    xt.i.s = true;
    
    // only low precision is necessary to get integer part of log to base ten of x
    bp = blockPrec;
    p = decPrec;
    blockPrec = 2;
    decPrec = 32;
    div(temp, log(xt), log(ten));
    logtenxInt = to_long(floor(temp));
    xDecExp = logtenxInt - myDecPrec - 1;
    blockPrec = bp + 1;
    decPrec = 16*blockPrec;
    mul(xMan, xt, power(ten, -xDecExp));
    // so must round during shifting
    blockPrec = bp;
    decPrec = p;
    
    if(xMan.e>0)
    {
        eSave = xMan.e;
        mbShiftLeft(xMan.i, xMan.i, eSave);
        xMan.e = 0;
    }
    else
    {
        eSave = abs(xMan.e);
        mbShiftRight(xMan.i, xMan.i, eSave);
        xMan.e = 0;
    }
    
    length = numDigits(xMan.i);
    // xMan.i as a base 10 integer is one or two digits longer than decPrec, so add 5 or 50 to round
    
    if(length>myDecPrec)
    {
        if(length>(myDecPrec+1))
            xMan.i+=50;
        else
            xMan.i+=5;
    }
    xString1 = conv(xMan.i);
    length = strlen(xString1);
    extra = length - myDecPrec;
    if(extra>0)
    {
        length-=extra;
        xString1[length] = 0;
        xDecExp+=extra;
    }
    // remove trailing zeroes
    numTrailZeroes = 0;
    for(i=length-1;i>=0;i--)
    {
        index = i;
        if(xString1[i]=='0')
            numTrailZeroes++;
        else
            break;
    }
    length-=numTrailZeroes;
    xString1[length] = 0;
    xDecExp+=numTrailZeroes;
    
    xString = (char*)malloc((length+30)*sizeof(char));
    xString[0] = 0;
    
    xDecExp1 = xDecExp + length - 1;
    j = 0;
    if(abs(xDecExp1)>4)
    {
        // (-)x.xx e
        if(isNegative)
            xString[j++] = '-';
        xString[j++] = xString1[0];
        xString[j++] = '.';
        for(i=1;i<length;++i)
            xString[j++] = xString1[i];
        xString[j++] = 'e';
        xString[j] = 0;
        sprintf(expStr, "%ld", xDecExp1);
        strcat(xString, expStr);
        outString = xString;
        free(xString1);
        free(xString);
        return outString;
    }
    // now abs(xDecExp1)<=4
    if(!xDecExp1)
    {
        // (-)x.xxx
        if(isNegative)
            xString[j++] = '-';
        xString[j++] = xString1[0];
        xString[j++] = '.';
        for(i=1;i<length;++i)
            xString[j++] = xString1[i];
        xString[j] = 0;
        outString = xString;
        free(xString1);
        free(xString);
        return outString;
    }
    
    if(xDecExp1>0)
    {
        // (-)xxx.xxx or xxx000.
        if(isNegative)
            xString[j++] = '-';
        if(length<=xDecExp1)
        {
            // add zeroes
            for(i=0;i<length;++i)
                xString[j++] = xString1[i];
            for(i=0;i<xDecExp1-length+1;++i)
                xString[j++] = '0';
            xString[j++] = '.';
            xString[j] = 0;
            outString = xString;
            free(xString1);
            free(xString);
            return outString;
        }
        // now length > xDecExp1
        // (-)xxx.xxx dp is at xDecExp1 + 1
        for(i=0;i<xDecExp1+1;++i)
            xString[j++] = xString1[i];
        xString[j++] = '.';
        for(i=xDecExp1+1;i<length;++i)
            xString[j++] = xString1[i];
        xString[j] = 0;
        outString = xString;
        free(xString1);
        free(xString);
        return outString;
    }
    // now xDecExp1<0
    // (-)0.00xxx  there are abs(xDecExp1)-1 zeroes after dp
    if(isNegative)
        xString[j++] = '-';
    xString[j++] = '0';
    xString[j++] = '.';
    for(i=0;i<abs(xDecExp1)-1;++i)
        xString[j++] = '0';
    for(i=0;i<length;++i)
        xString[j++] = xString1[i];
    xString[j] = 0;
    outString = xString;
    free(xString1);
    free(xString);
    return outString;
    
}/* fpToStr */

void conv(double& z, const fp& x)
{
    string      xString;
    
    conv(xString, x, 16);
    if(!sscanf(xString.c_str(), "%lf", &z))
        z = 0;
}/* conv(double, fp) */

void conv(string& xString, const fp& x)
{
    xString = fpToStr(x, outPrec);
    
}/* conv(string, fp) */
