//
//  fp.hpp
//  fp64
//
//  Created by Bob Delaney on 12/10/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#ifndef fp_hpp
#define fp_hpp

#include <stdio.h>

#endif /* fp_hpp */

#pragma once

#include "mb.hpp"

class fp
{
public:
    mb          i; // signed integer of unlimited length
    long        e; // exponent of 2, so fp number = i x 2^e
    
    fp();
    fp(const char*);
    fp(const string);
    fp(int);
    fp(long);
    fp(double);
    
    
    ~fp();
    
    fp operator- ();
    fp operator- () const;
    fp& operator= (const char*);
    fp& operator= (char*);
    fp& operator= (const string);
    fp& operator= (const fp&);
    fp& operator= (const mb&);
    fp& operator= (int);
    fp& operator= (long);
    fp& operator= (double);
    
    bool operator> (const fp&);
    bool operator>= (const fp&);
    bool operator== (const fp&);
    bool operator!= (const fp&);
    bool operator! ();
    bool operator<= (const fp&);
    bool operator< (const fp&);
    
    bool operator> (const fp&) const;
    bool operator>= (const fp&) const;
    bool operator== (const fp&) const;
    bool operator!= (const fp&) const;
    bool operator! () const;
    bool operator<= (const fp&) const;
    bool operator< (const fp&) const;
    
    bool operator> (const mb&);
    bool operator>= (const mb&);
    bool operator== (const mb&);
    bool operator!= (const mb&);
    bool operator<= (const mb&);
    bool operator< (const mb&);
    
    bool operator> (const mb&) const;
    bool operator>= (const mb&) const;
    bool operator== (const mb&) const;
    bool operator!= (const mb&) const;
    bool operator<= (const mb&) const;
    bool operator< (const mb&) const;
    
    bool operator> (double);
    bool operator>= (double);
    bool operator== (double);
    bool operator!= (double);
    bool operator<= (double);
    bool operator< (double);
    
    bool operator> (double) const;
    bool operator>= (double) const;
    bool operator== (double) const;
    bool operator!= (double) const;
    bool operator<= (double) const;
    bool operator< (double) const;
    
    fp operator+ (const fp&);
    fp operator- (const fp&);
    fp operator* (const fp&);
    fp operator/ (const fp&);
    
    fp operator+ (const fp&) const;
    fp operator- (const fp&) const;
    fp operator* (const fp&) const;
    fp operator/ (const fp&) const;
    
    fp& operator+= (const fp&);
    fp& operator-= (const fp&);
    fp& operator*= (const fp&);
    fp& operator/= (const fp&);
    
    fp operator+ (const mb&);
    fp operator- (const mb&);
    fp operator* (const mb&);
    fp operator/ (const mb&);
    
    fp operator+ (const mb&) const;
    fp operator- (const mb&) const;
    fp operator* (const mb&) const;
    fp operator/ (const mb&) const;
    
    fp& operator+= (const mb&);
    fp& operator-= (const mb&);
    fp& operator*= (const mb&);
    fp& operator/= (const mb&);
    
    
    fp operator+ (double);
    fp operator- (double);
    fp operator* (double);
    fp operator/ (double);
    
    fp operator+ (double) const;
    fp operator- (double) const;
    fp operator* (double) const;
    fp operator/ (double) const;
    
    fp& operator+= (double);
    fp& operator-= (double);
    fp& operator*= (double);
    fp& operator/= (double);

    friend ostream& operator <<(ostream &s,const fp& x);
    friend istream& operator >>(istream &s, fp& x);
    
};

fp operator+ (const mb&, const fp&);
fp operator- (const mb&, const fp&);
fp operator* (const mb&, const fp&);
fp operator/ (const mb&, const fp&);

fp operator+ (double, const fp&);
fp operator- (double, const fp&);
fp operator* (double, const fp&);
fp operator/ (double, const fp&);

