//
//  fp.cpp
//  fp64
//
//  Created by Bob Delaney on 12/10/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#include "fp.hpp"
#include "fpConv.hpp"
#include "fpMath.hpp"

extern long outPrec;

// Constructor
fp::fp()
{
    i.n = 0;
    i.b = NULL;
    i.s = true;
    e = 0;
}

//Destructor
fp::~fp()
{
    // see if needs code
    free((*this).i.b);
    (*this).i.b = NULL;
    (*this).i.n = 0;
    (*this).e = 0;
}

fp::fp(const char *inString)
{
    string   x;
    x = inString;
    conv(*this, x);
}

fp::fp(const string inString)
{
    conv(*this, inString);
}

fp::fp(int x)
{
    conv(*this, x);
}

fp::fp(long x)
{
    conv(*this, x);
}

fp::fp(double x)
{
    conv(*this, x);
}

fp fp::operator- ()
{
    fp        z;
    
    conv(z, *this);
    z.i.s = !z.i.s;
    return z;
}

fp fp::operator- () const
{
    fp        z;
    
    conv(z, *this);
    if(z.i.s)
        z.i.s = false;
    else
        z.i.s = true;
    
    return z;
}

fp& fp::operator= (const char* x)
{
    string  xt;
    
    free(i.b);
    xt = x;
    conv(*this, xt);
    return *this;
}

fp& fp::operator= (char* x)
{
    string  xt;
    
    free(i.b);
    xt = x;
    conv(*this, xt);
    return *this;
}

fp& fp::operator= (const string x)
{
    free(i.b);
    conv(*this, x);
    return *this;
}

fp& fp::operator= (const fp& x)
{
    long    j;
    
    if(this==&x)
        return *this;
    
    free(i.b);
    i.b = (UINT64*)malloc(x.i.n*sizeof(UINT64));
    if(!i.b)
    {
        cout << "fp = fp problem" << endl;
        exit(1);
    }
    
    i.n = x.i.n;
    i.s = x.i.s;
    e = x.e;
    for(j=0;j<i.n;++j)
        i.b[j] = x.i.b[j];
    
    return *this;
}

fp& fp::operator= (const mb& x)
{
    long    j;
    
    free(i.b);
    i.n = x.n;
    i.s = x.s;
    e = 0;
    i.b = (UINT64*)malloc(i.n*sizeof(UINT64));
    for(j=0;j<i.n;++j)
        i.b[j] = x.b[j];
    
    return *this;
}

fp& fp::operator= (int x)
{
    free(i.b);
    i.n = 1;
    e = 0;
    if(x>=0)
        i.s = true;
    else
        i.s = false;
    i.b = (UINT64*)malloc(i.n*sizeof(UINT64));
    i.b[0] = abs(x);
    
    return *this;
}

fp& fp::operator= (long x)
{
    free(i.b);
    i.n = 1;
    e = 0;
    if(x>=0)
        i.s = true;
    else
        i.s = false;
    i.b = (UINT64*)malloc(i.n*sizeof(UINT64));
    i.b[0] = abs(x);
    return *this;
}

fp& fp::operator= (double x)
{
    free(i.b);
    conv(*this, x);
    return *this;
}

bool fp::operator> (const fp& y)
{
    
    if(compare(*this, y)==1)
        return true;
    
    return false;
}

bool fp::operator>= (const fp& y)
{
    
    if(!(compare(*this, y)==-1))
        return true;
    
    return false;
}

bool fp::operator== (const fp& y)
{
    
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool fp::operator!= (const fp& y)
{
    
    if(!compare(*this, y))
        return false;
    
    return true;
}

bool fp::operator! ()
{
    if(!i.n)
        return true;
    
    return false;
}

bool fp::operator<= (const fp& y)
{
    if(!(compare(*this, y)==1))
        return true;
    
    return false;
}

bool fp::operator< (const fp& y)
{
    if(compare(*this, y)==-1)
        return true;
    
    return false;
}

bool fp::operator> (const fp& y) const
{
    if(compare(*this, y)==1)
        return true;
    
    return false;
}

bool fp::operator>= (const fp& y) const
{
    if(!(compare(*this, y)==-1))
        return true;
    
    return false;
}

bool fp::operator== (const fp& y) const
{
    if(!compare(*this, y))
        return true;
    
    return false;
}

bool fp::operator!= (const fp& y) const
{
    if(!compare(*this, y))
        return false;
    
    return true;
}

bool fp::operator! () const
{
    if(i==0)
        return true;
    
    return false;
}

bool fp::operator<= (const fp& y) const
{
    if(!(compare(*this, y)==1))
        return true;
    
    return false;
}

bool fp::operator< (const fp& y) const
{
    if(compare(*this, y)==-1)
        return true;
    
    return false;
}

bool fp::operator> (const mb& y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==1)
        return true;
    
    return false;
}

bool fp::operator>= (const mb& y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==-1))
        return true;
    
    return false;
}

bool fp::operator== (const mb& y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return true;
    
    return false;
}

bool fp::operator!= (const mb& y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return false;
    
    return true;
}

bool fp::operator<= (const mb& y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==1))
        return true;
    
    return false;
}

bool fp::operator< (const mb& y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==-1)
        return true;
    
    return false;
}

bool fp::operator> (const mb& y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==1)
        return true;
    
    return false;
}

bool fp::operator>= (const mb& y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==-1))
        return true;
    
    return false;
}

bool fp::operator== (const mb& y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return true;
    
    return false;
}

bool fp::operator!= (const mb& y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return false;
    
    return true;
}

bool fp::operator<= (const mb& y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==1))
        return true;
    
    return false;
}

bool fp::operator< (const mb& y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==-1)
        return true;
    
    return false;
}

bool fp::operator> (double y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==1)
        return true;
    
    return false;
}

bool fp::operator>= (double y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==-1))
        return true;
    
    return false;
}

bool fp::operator== (double y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return true;
    
    return false;
}

bool fp::operator!= (double y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return false;
    
    return true;
}

bool fp::operator<= (double y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==1))
        return true;
    
    return false;
}

bool fp::operator< (double y)
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==-1)
        return true;
    
    return false;
}

bool fp::operator> (double y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==1)
        return true;
    
    return false;
}

bool fp::operator>= (double y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==-1))
        return true;
    
    return false;
}

bool fp::operator== (double y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return true;
    
    return false;
}

bool fp::operator!= (double y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!compare(*this, yfp))
        return false;
    
    return true;
}

bool fp::operator<= (double y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(!(compare(*this, yfp)==1))
        return true;
    
    return false;
}

bool fp::operator< (double y) const
{
    fp        yfp;
    
    conv(yfp, y);
    
    if(compare(*this, yfp)==-1)
        return true;
    
    return false;
}

fp fp::operator+ (const fp& y)
{
    fp        z;
    
    add(z, *this, y);
    
    return z;
}

fp fp::operator- (const fp& y)
{
    fp        z;
    
    sub(z, *this, y);
    
    return z;
}

fp fp::operator* (const fp& y)
{
    fp        z;
    
    mul(z, *this, y);
    
    return z;
}

fp fp::operator/ (const fp& y)
{
    fp        z;
    
    div(z, *this, y);
    
    return z;
}


fp fp::operator+ (const fp& y) const
{
    fp        z;
    
    add(z, *this, y);
    
    return z;
}

fp fp::operator- (const fp& y) const
{
    fp        z;
    
    sub(z, *this, y);
    
    return z;
}

fp fp::operator* (const fp& y) const
{
    fp        z;
    
    mul(z, *this, y);
    
    return z;
}

fp fp::operator/ (const fp& y) const
{
    fp        z;
    
    div(z, *this, y);
    
    return z;
}


fp& fp::operator+= (const fp& y)
{
    add(*this, *this, y);
    
    return *this;
}

fp& fp::operator-= (const fp& y)
{
    sub(*this, *this, y);
    
    return *this;
}

fp& fp::operator*= (const fp& y)
{
    mul(*this, *this, y);
    
    return *this;
}

fp& fp::operator/= (const fp& y)
{
    div(*this, *this, y);
    
    return *this;
}


fp fp::operator+ (const mb& y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    add(z, *this, yfp);
    
    return z;
}

fp fp::operator- (const mb& y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    sub(z, *this, yfp);
    
    return z;
}

fp fp::operator* (const mb& y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    mul(z, *this, yfp);
    
    return z;
}

fp fp::operator/ (const mb& y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    div(z, *this, yfp);
    
    return z;
}

fp fp::operator+ (double y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    add(z, *this, y);
    
    return z;
}

fp fp::operator- (double y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    sub(z, *this, y);
    
    return z;
}

fp fp::operator* (double y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    mul(z, *this, y);
    
    return z;
}

fp fp::operator/ (double y)
{
    fp        z, yfp;
    
    conv(yfp, y);
    div(z, *this, y);
    
    return z;
}


fp fp::operator+ (double y) const
{
    fp        z, yfp;
    
    conv(yfp, y);
    add(z, *this, y);
    
    return z;
}

fp fp::operator- (double y) const
{
    fp        z, yfp;
    
    conv(yfp, y);
    sub(z, *this, y);
    
    return z;
}

fp fp::operator* (double y) const
{
    fp        z, yfp;
    
    conv(yfp, y);
    mul(z, *this, y);
    
    return z;
}

fp fp::operator/ (double y) const
{
    fp        z, yfp;
    
    conv(yfp, y);
    div(z, *this, y);
    
    return z;
}


fp& fp::operator+= (double y)
{
    fp      yfp;
    
    conv(yfp, y);
    add(*this, *this, yfp);
    
    return *this;
}

fp& fp::operator-= (double y)
{
    fp      yfp;
    
    conv(yfp, y);
    sub(*this, *this, yfp);
    
    return *this;
}

fp& fp::operator*= (double y)
{
    fp      yfp;
    
    conv(yfp, y);
    mul(*this, *this, yfp);
    
    return *this;
}

fp& fp::operator/= (double y)
{
    fp      yfp;
    
    conv(yfp, y);
    div(*this, *this, yfp);
    
    return *this;
}


ostream& operator <<(ostream &s, const fp& x)
{
    string      xString;
    
    conv(xString, x, outPrec);
    s << xString.c_str();
    
    return s;
}

istream& operator >>(istream &s, fp& x)
{
    string  xStr;
    
    s >> xStr;
    if(!conv(x, xStr))
        cerr << "conversion error!" << endl;
    
    return s;
}

fp operator+ (const mb& x, const fp& y)
{
    fp        z, xfp;

    conv(xfp, x);
    add(z, xfp, y);
    
    return z;
}

fp operator- (const mb& x, const fp& y)
{
    fp        z, xfp;
    
    conv(xfp, x);
    sub(z, xfp, y);
    
    return z;
}

fp operator* (const mb& x, const fp& y)
{
    fp        z, xfp;
    
    conv(xfp, x);
    mul(z, xfp, y);
    
    return z;
}

fp operator/ (const mb& x, const fp& y)
{
    fp        z, xfp;
    
    conv(xfp, x);
    div(z, xfp, y);
    
    return z;
}


fp operator+ (double x, const fp& y)
{
    fp        z, xfp;
    
    conv(xfp, x);
    add(z, xfp, y);
    
    return z;
}

fp operator- (double x, const fp& y)
{
    fp        z, xfp;
    
    conv(xfp, x);
    sub(z, xfp, y);
    
    return z;
}

fp operator* (double x, const fp& y)
{
    fp        z, xfp;
    
    conv(xfp, x);
    mul(z, xfp, y);
    
    return z;
}

fp operator/ (double x, const fp& y)
{
    fp        z, xfp;
    
    conv(xfp, x);
    div(z, xfp, y);
    
    return z;
}
