/*
 *  test.cpp
 *  fp
 *
 *  Created by Robert Delaney on 4/28/09.
 *  Copyright 2009 __Bob Delaney's Science Software__. All rights reserved.
 *
 */

extern long blockPrec;
//extern long decPrec;

#include "fp.h"
#include "fpFuncs.h"
#include "test.h"
#include "matfp.hpp"
#include "matfpMath.hpp"

matfp testmatfp(matfp& x)
{
    matfp   xt, x1, y="2,3;4,5";
    
    x1 = x;
    add(xt, x, y);
    
    return xt;
    
}/* testmatfp */

static void mymbShiftRight(mb& z, const mb& x, INT32 numBits)
{
	static mb			s;
	INT32				restBits; // num bits more than in initial n blocks
	UINT32				bv1,bv2; // upper block bits
	INT32				i, numWholeBlocks;
	INT32				xSign;
	
	if(!x.n)
	{
		z = 0;
		return;
	}
	
	if(!numBits)
	{
		equate(z, x);
		return;
	}
	
	//cout << "x = " << x << endl;  // 3484491437235564951492251881442656925508426935146852374130 / 2^138 = 99999999899999.99999 problem is input x
	//cout << "numBits = " << numBits << endl;
	
	
	if(x.n>0)
		xSign = 1;
	else
		xSign = -1;
	
	numBits = abs(numBits);
	
	numWholeBlocks = numBits/blockBits;
	restBits = numBits - numWholeBlocks*blockBits;
	
	s.n = abs(x.n) - numWholeBlocks;
	if(s.n<=0)
	{
		z = 0;
		return;
	}
	
	updateWithCare(s);
	
	// x -> s shifting down by numWholeBlocks
	for(i=0;i<s.n;i++)
		s.b[i] = x.b[i+numWholeBlocks];
	
	//cout << "s block shift = " << s << endl; // 10239999999897599999 / 2^10 = 9999999999899999.9990234375 so already have problem since restBits = 10
	//cout << "restBits = " << restBits << endl; // restBits = 10
	
	if(restBits)
	{
		bv1 = 0; // will shift zeroes into initial high part of s
		for(i=s.n-1;i>=0;i--)
		{
			bv2 = (s.b[i]<<(blockBits-restBits)); // low restBits part of s.b[i] shifted to high
			s.b[i] = bv1 + (s.b[i]>>restBits);
			bv1 = bv2;
		}
	}
	
	while(s.n>0 && s.b[s.n-1]==0)
		s.n--;
	
	//cout << "s up = " << s << endl;
	
	if(!s.n)
		update(s);
	
	//cout << "s = " << s << endl;
	
	equate(z, s);
	
	z.n = xSign*abs(z.n);
	
}/* mbShiftRight */

static void mymbShiftLeft(mb& z, const mb& x, INT32 numBits)
{
	static mb			s;
	INT32				restBits; // num bits more than in initial n blocks
	UINT32				bv1,bv2; // hold shift bits
	INT32				i, numWholeBlocks;
	INT32				xSign;
	
	if(!x.n)
	{
		z = 0;
		return;
	}
	
	if(!numBits)
	{
		equate(z, x);
		return;
	}
	
	if(x.n>0)
		xSign = 1;
	else
		xSign = -1;
	
	numBits = abs(numBits);
	
	s.n = numWholeBlocks = numBits/blockBits;
	restBits = numBits - s.n*blockBits;
	
	s.n+=abs(x.n); // needed number of s blocks
	
	if(!restBits)
	{
		updateWithCare(s);
		// copy x blocks into s blocks moving numWholeBlocks up
		for(i=abs(x.n)-1;i>=0;i--)
			s.b[i+numWholeBlocks] = x.b[i];
		// zero the rest
		for(i=numWholeBlocks-1;i>=0;i--)
			s.b[i] = 0;
		//cout << "s top = " << s << endl;
		equate(z, s);
		z.n = xSign*abs(z.n);
		return;
	}
	
	// now restBits>0
	
	s.n++; // need another block
	updateWithCare(s);
	// need to zero that highest block!
	s.b[s.n-1] = 0;
	// note that this is identical to above!
	
	// copy x blocks into upper blocks except for the highest
	for(i=abs(x.n)-1;i>=0;i--)
		s.b[i+numWholeBlocks] = x.b[i];
	
	// zero the rest
	for(i=numWholeBlocks-1;i>=0;i--)
		s.b[i] = 0;
	
	// now we must shift left the upper abs(x.n)+1 blocks by restBits
	bv1 = 0;
	for(i=0;i<abs(x.n)+1;i++)
	{
		bv2 = (s.b[i+numWholeBlocks]>>(blockBits-restBits)); // high restBits part shifted to low
		s.b[i+numWholeBlocks] = bv1 + (s.b[i+numWholeBlocks]<<restBits);
		bv1 = bv2;
	}
	
	//cout << "s = " << s << endl;
	
	mbNormalize(s); // the uppermost block might be zero
	
	//cout << "s = " << s << endl;
	
	equate(z, s);
	
	z.n = xSign*abs(z.n);
	
}/* mbShiftLeft */


static void myfpNormalize(fp& x)
{
	static fp			one;  // one(1.) gives recursive error
	static UINT64		mask1; // 0x100000000
	static UINT64		mask2; // 0xFFFFFFFF
	static bool			initGood=false;
	INT32				numBlocks, numZeroBlocks, numZeroBits, bitsShift;
	bool				isAllFs, isNegative;
	INT32				i;
	UINT64				cx, carry;
	
	if(!initGood)
	{
		one.i.n = one.i.nn = 1;
		one.e = 0;
		one.i.b = (UINT32*)malloc(one.i.nn*sizeof(UINT32));
		if(!one.i.b)
			exit(1);
		one.i.b[0] = 1;
		mask1 = 1;
		mask1 = (mask1<<32);
		mask2 = mask1 - 1;
		initGood = true;
	}
	
	if(x.i.n==0)
	{
		x.e = 0;
		return;
	}
	
	// remove leading zero blocks
	if(x.i.n<0)
	{
		isNegative = true;
		x.i.n = -x.i.n;
	}
	else
		isNegative = false;
	
	while(x.i.n>0 && x.i.b[x.i.n-1]==0)
		x.i.n--;
	
	if(!x.i.n)
		update(x.i);
	
	if(x.i.n==0)
	{
		x.e = 0;
		return;
	}
	
	if(x.i.n<=blockPrec)
	{
		if(isNegative)
			x.i.n = -x.i.n;
		return;
	}
	
	// shift left to get largest high order block
	
	numZeroBits = alignLeft(x.i);
	x.e-=numZeroBits;
	
	// remove trailing zero blocks
	numZeroBlocks = 0;
	for(i=0;i<x.i.n;i++)
	{
		if(!x.i.b[i])
			numZeroBlocks++;
		else
			break;
	}
	
	if(numZeroBlocks)
	{
		bitsShift = blockBits*numZeroBlocks;
		mbShiftRight(x.i, x.i, bitsShift);
		x.e+=bitsShift;
	}
	
	if(x.i.n==0)
	{
		x.e = 0;
		return;
	}
	
	if(x.i.n<=blockPrec)
	{
		if(isNegative)
			x.i.n = -x.i.n;
		return;
	}
	
	// now x.i.n>blockPrec so we need to round up and trim
	// but have to worry about the leading blocks some or all
	// being FFFFFFFF.
	// the lowest block just below the blockPrec ones has index x.i.n-blockPrec-1
	// if its value is >0x7FFFFFFF we need to round, else just trim
	cx = x.i.b[x.i.n-blockPrec-1];
	if(cx>0x7FFFFFFF)
	{
		// special case of all blockPrec values being FFFFFFFF
		isAllFs = true;
		for(i=x.i.n-1;i>=x.i.n-blockPrec;i--)
			if(x.i.b[i]!=mask2)
			{
				isAllFs = false;
				break;
			}
		if(isAllFs)
		{
			x.e+=(blockBits*(x.i.n));
			x.i.n = 1;
			x.i.b[0] = 1;
			if(isNegative)
				x.i.n = -x.i.n;
			return;
		}
		// now must add 1 to blockPrec part
		carry = 1;
		for(i=x.i.n-blockPrec;i<x.i.n;i++)
		{
			cx = x.i.b[i];
			cx = cx + carry;
			carry = ((cx & mask1)>>32);
			x.i.b[i] = (cx & mask2);
			if(!carry)
				break;
		}
		// trim trailing zeroes
		numZeroBlocks = 0;
		for(i=0;i<x.i.n;i++)
		{
			if(!x.i.b[i])
				numZeroBlocks++;
			else
				break;
		}
		
		if(numZeroBlocks)
		{
			bitsShift = blockBits*numZeroBlocks;
			mbShiftRight(x.i, x.i, bitsShift);
			x.e+=bitsShift;
		}
		
		if(x.i.n==0)
		{
			x.e = 0;
			return;
		}
	}
	
	// now trim if necessary
	numBlocks = x.i.n - blockPrec;
	if(numBlocks>0)
	{
		bitsShift = blockBits*numBlocks;
		mbShiftRight(x.i, x.i, bitsShift);
		x.e+=bitsShift;
	}
	
	if(isNegative)
		x.i.n = -x.i.n;
	
}/* fpNormalize */

// z = x*y
static void myMul(fp& z, const fp& x, const fp& y)
{
		
	mul(z.i, x.i, y.i);
	z.e = x.e + y.e;
	myfpNormalize(z);
	
	//cout << "x.i = " << x.i << endl;
	//cout << "y.i = " << y.i << endl;
	//cout << "z = " << z << endl; // z = 9.9999999999e15 which is ok
	
	
	
	return;
	
}/* mul */


// rounds xString to decPrec and returns "nice" string for fp x
static char* FormRoundedfpString(const char* xString, INT32 xDecExp, bool isNegative, INT32 myDecPrec)
{
	INT32		i, length, myLength, carry, index, numTrailZeroes;
	char		*myxString, ch, *outStr, expStr[255];
	
	
	
	if(myDecPrec<=0)
	{
		myxString = (char*)malloc(2*sizeof(char));
		myxString[0] = '0';
		myxString[1] = 0;
		return myxString;
	}
	
	length = strlen(xString);
	
	myxString = (char*)malloc((myDecPrec+3)*sizeof(char));  // leave one leading space for carry of 1 and use one more digit than decPrec for rounding
	myxString[0] = '0';
	for(i=0;i<=myDecPrec && i<length;i++)
	{
		index = i;
		myxString[i+1] = xString[i];
	}
	myxString[index+2] = 0;
	
	if(index<myDecPrec)  // don't change xDecExp
		for(i=0;i<(index+2);i++)
			myxString[i] = myxString[i+1];
	else
	{
		myLength = strlen(myxString); // should be myDecPrec+2
		carry = 1;
		for(i=myLength-1;i>=1;i--)
		{
			index = i;
			ch = myxString[i] + carry;
			if(ch>'9')
				myxString[i] = '0';
			else
			{
				myxString[i] = ch;
				break;
			}
		}
		
		if(index==1 && ch==':')
		{
			myxString[0] = '1';
			myxString[1] = 0;
			xDecExp+=(length-1);
		}
		else
		{
			// move one to left
			for(i=0;i<myDecPrec;i++)
				myxString[i] = myxString[i+1];
			myxString[myDecPrec] = 0;
			// we have gone from length to a lower length of myDecPrec, so xDecExp should be increasrd by length-nyDecPrec
			xDecExp+=(length-myDecPrec);
		}
	}
	
	length = strlen(myxString);
	
	// need to trim trailing zeroes, but watch out for all zeroes
	numTrailZeroes = 0;
	for(i=length-1;i>=0;i--)
	{
		index = i;
		if(myxString[i]=='0')
			numTrailZeroes++;
		else
			break;
	}
	
	if(numTrailZeroes>0)
	{
		// index points to the left of first zero
		myxString[index+1] = 0;
		xDecExp+=(length-index-1);
		if(myxString[0]=='0' && index==1)
		{
			return myxString;
		}
	}
	
	length = strlen(myxString);
	
	outStr = (char*)malloc((myDecPrec+35)*sizeof(char));
	outStr[0] = 0;
	
	if(xDecExp>3 || xDecExp<-length-3)
	{
		// use scientific notation
		
		if(isNegative)
		{
			strcpy(outStr, "-");
			outStr[1] = myxString[0];
			outStr[2] = 0;
		}
		else
		{
			outStr[0] = myxString[0];
			outStr[1] = 0;
		}
		
		strcat(outStr, ".");
		strcat(outStr, myxString+1);
		strcat(outStr, "e");
		sprintf(expStr, "%ld", xDecExp+length-1);
		strcat(outStr, expStr);
	}
	else
	{
		if(xDecExp>=0)
		{
			if(isNegative)
				strcpy(outStr, "-");
			else
				outStr[0] = 0;
			
			strcat(outStr, myxString);
			for(i=0;i<xDecExp;i++)
				strcat(outStr, "0");
		}
		else
		{
			if(xDecExp<=-length)
			{
				if(isNegative)
					strcpy(outStr, "-");
				else
					outStr[0] = 0;
				
				strcat(outStr, "0.");
				for (i = 0; i < -length-xDecExp; i++)
   					strcat(outStr, "0");
				strcat(outStr, myxString);
			}
			else
			{
				if(isNegative)
					strcpy(outStr, "-");
				else
					outStr[0] = 0;
				
				expStr[1] = 0;
				for(i=0;i<length+xDecExp;i++)
				{
					expStr[0] = myxString[i];
					strcat(outStr, expStr);
				}
				strcat(outStr, ".");
				for(i=length+xDecExp;i<length;i++)
				{
					expStr[0] = myxString[i];
					strcat(outStr, expStr);
				}
			}
		}
	}
	
	free(myxString);
	
	return outStr;
	
}/* FormRoundedfpString */


char* myfpToStr(const fp& x, long myDecPrec)
{
	fp		xt, ten=10, xMan;
	char	*xString, *xManString;
	INT32	bp, logtenxInt, xDecExp;
	bool	isNegative;
	
	if(!x.i.n)
	{
		xString = (char*)malloc(2*sizeof(char));
		xString[0] = '0';
		xString[1] = 0;
		return xString;
	}
	
	xt = x;
	isNegative = false;
	if(xt.i.n<0)
	{
		xt.i.n = -xt.i.n;
		isNegative = true;
	}
	
	// only low precision is necessary to get integer part of log to base ten of x
	bp = blockPrec;
	blockPrec = 3;
	
	logtenxInt = to_long(floor(log(xt)/log(ten)));
	
	xDecExp = logtenxInt - myDecPrec;
	
	blockPrec = bp + 1;
	
	myMul(xMan, xt, pow(ten, -xDecExp));
	
	blockPrec = bp;
	
	if(xMan.e>0)
	{
		mymbShiftLeft(xMan.i, xMan.i, xMan.e);
		xMan.e = 0;
	}
	else
	{
		mymbShiftRight(xMan.i, xMan.i, abs(xMan.e));
		xMan.e = 0;
		
	}
	
	xManString = mb2Str(xMan.i);
	
	xString = FormRoundedfpString(xManString, xDecExp, isNegative, myDecPrec);
	
	free(xManString);
	
	return xString;
	
}/* myfpToStr */


