/*
 *  polyMath.h
 *  fp
 *
 *  Created by Robert Delaney on 5/17/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#pragma once

#include "matq.h"
#include "fpComplex.h"

void init(poly& z);
void init(poly& z, INT32 deg);
void myFree(poly& x);
void myFree(poly*& x, INT32 numPolys);
void polyAdjust(poly& x);
void polyNormalize(poly& z, const poly& x);
poly polyNormalize(const poly& x);
poly polyReduce(const poly& x);
int compare(const poly& x, const poly& y);
void polyOverZ(poly& z, const poly& x);
poly polyOverZ(const poly& x);
void polyDeriv(poly& z, const poly& x);
poly polyDeriv(const poly& x);
void polyEval(bf& z, const poly& f, const bf& x);
bf polyEval(const poly& f, const bf& x);
void add(poly& z, const poly& x, const poly& y);
void sub(poly& z, const poly& x, const poly& y);
void mul(poly& z, const poly& x, const poly& y);
void divEuclid(poly& q, poly& r, const poly& x, const poly& y);
void divEuclid(poly& q, poly& r, const poly& x, const poly& y, const mb& p);
void divEuclid(poly& q, poly& r, const poly& x, const poly& y, double p);
void div(poly& z, const poly& x, const poly& y);
void div(poly& z, const poly& x, const poly& y, double p);
void add(poly& z, const poly& x, const bf& y);
void sub(poly& z, const poly& x, const bf& y);
void mul(poly& z, const poly& x, const bf& y);
void div(poly& z, const poly& x, const bf& y);
void add(poly& z, const bf& x, const poly& y);
void sub(poly& z, const bf& x, const poly& y);
void mul(poly& z, const bf& x, const poly& y);
void div(poly& z, const bf& x, const poly& y);
mb lcd(const poly& x);
void gcd(poly& z, const poly& x, const poly& y);
poly gcd(const poly& x, const poly& y);
void makeMonic(poly& z, const poly& x, double p);
void makeMonic(poly& z, const poly& x, const mb& p);
void xTon(poly& z, int n);
poly xTon(int n);
void gcd(poly& z, const poly& x, const poly& y, double p);
poly gcd(const poly& x, const poly& y, double p);
void gcd(poly& z, const poly& f, const poly& g, const mb& p);
poly gcd(const poly& f, const poly& g, const mb& p);
poly gcdYun(const poly& x, const poly& y, double q);
void polyModPoly(poly& z, const poly& x, const poly& y);
poly polyModPoly(const poly& x, const poly& y);
void polyModPolyModq(poly& z, const poly& x, const poly& y, double q);
poly polyModPolyModq(const poly& x, const poly& y, double q);
void polyModPolyModq(poly& z, const poly& x, const poly& y, const mb& q);
poly polyModPolyModq(const poly& x, const poly& y, const mb& q);
poly polyMod(const poly& x, const mb& q);
void polyModPoly(poly& z, const poly& x, double q);
poly polyMod(const poly& x, double q);
void polyPow(poly& z, const poly& x, INT32 p);
poly polyPow(const poly& x, INT32 p);
void polyPowModq(poly& z, const poly& x, INT32 p, double q);
poly polyPowModq(const poly& x, INT32 p, double q);
void polyPowerMod(poly& z, const poly& x, INT32 p, const poly& y);
void polyPowerModPolyModq(poly& z, const poly& x, INT32 p, const poly& y, double q);
poly polyPowerMod(const poly& x, INT32 p, const poly& y);
poly polyPowerModPolyModq(const poly& x, INT32 p, const poly& y, double q);
void polyPowerModPoly(poly& z, const poly& x, const mb& p, const poly& y);
poly polyPowerModPoly(const poly& x, const mb& p, const poly& y);
void polyPowerModPolyModq(poly& z, const poly& x, const mb& p, const poly& y, const mb& q);
poly polyPowerModPolyModq(const poly& x, const mb& p, const poly& y, const mb& q);
void convNullVectorsToPolys(poly*& z, const matq& x, double q);
void primesDivide(int*& z, int& count, int n);
void primesDivide(mb*& z, int& count, const mb& n);
bool isPolyReducible(const poly& x, double p);
bool isPolyReducible(const poly& f, const mb& p);
void genPolyCyclicGroup(poly*& z, const poly& x, double p);
void genPolyCyclicGroup(char*& zString, const poly& x, double p);
bool isPolyIntMonic(const poly& x);
bool isPolyInteger(const poly& x);
bool polyZechLogs(int*& z, const poly& x, double p);
bool polyZechLogs(poly& z, const poly& x, double p);
bool findPolyRoots(fpComplex*& root, fpComplex*& Parray, const poly& x, bool doRoundToZero);
bool findPolyRoots(char*& zString, const poly& x, bool doRoundToZero);

