/*
 *  polyConv.cpp
 *  fp
 *
 *  Created by Robert Delaney on 4/27/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#include "polyConv.h"
#include "stringUtils.h"
#include "mb2Str.h"
#include "polyMath.h"
#include "bfConv.h"

static bf getTheFraction(const char *theField)
{
	bf		z;
	char	*fracStr, ch;
	int	i, length, index;
	
	length = strlen(theField);
	if(!length)
		return z;
	
	fracStr = (char*)malloc((length+1)*sizeof(char));
	
	for(i=0;i<length;i++)
	{
		index = i;
		ch = theField[i];
		if(!(ch=='/'))
			fracStr[i]= ch;
		else {
			break;
		}
	}
	if(ch=='/')
		fracStr[index] = 0;
	else {
		fracStr[index+1] = 0;
	}

	mbConvFromStr(z.num, fracStr);
	if(index==(length-1))
	{
		z.den = 1;
		free(fracStr);
		return z;
	}
	
	for(i=index+1;i<length;i++)
	{
		fracStr[i-index-1] = theField[i];
	}
	fracStr[length-index-1] = 0;
	
	mbConvFromStr(z.den, fracStr);
	
	free(fracStr);
	
	return z;
	
}/* getTheFraction */

// polyStr of form "coeff 0, coeff 1, ... , coeff deg"
bool polyConvFromString(poly& z, const char *polyStr)
{
	char	*theField;
	int	i;
	
	if(!polyStr || !strlen(polyStr))
		return false;
	
	z.deg = CountFields(polyStr, ",") - 1;
    init(z, z.deg);
	
	for(i=0;i<=z.deg;i++)
	{
		theField = NthField(polyStr, ",", i+1);
		z.array[i] = getTheFraction(theField);
		free(theField);
		if(!z.array[i].den)
			return false;
	}
	
	z = polyNormalize(z); // if user puts in high order zeroes!

	return true;
	
}/* polyConvFromString */


void polyConvToString(char*& xString, const poly& x)
{
	char	*numString, *denString;
	int	i, numLength, denLength, currLength;
	
	if(x.deg<0 || x.array==NULL)
	{
        xString = (char*)malloc(5*sizeof(char));
        xString[0] = 'N';
        xString[1] = 'U';
        xString[2] = 'L';
        xString[3] = 'L';
        xString[4] = 0;
		return;
	}
	
	currLength = 1;
	xString = (char*)malloc(currLength*sizeof(char));
	xString[0] = 0;
	
	i = 0;
	numString = mb2Str(x.array[i].num);
	numLength = strlen(numString);
	if(x.array[i].den!=1)
	{
		denString = mb2Str(x.array[i].den);
		denLength = strlen(denString);
		currLength = currLength + numLength + denLength + 3; // 3 is for ", " and "/"
		xString = (char*)realloc(xString, currLength);
		if(xString==NULL)
			return;
		strcpy(xString, numString);
		free(numString);
		strcat(xString, "/");
		strcat(xString, denString);
		free(denString);
	}
	else
	{
		currLength = currLength + numLength + 2; // 2 is for ", "
		xString = (char*)realloc(xString, currLength);
		if(xString==NULL)
			return;
		strcpy(xString, numString);
		free(numString);
	}
	
	for(i=1;i<=x.deg;i++)
	{
		numString = mb2Str(x.array[i].num);
		numLength = strlen(numString);
		if(x.array[i].den!=1)
		{
			denString = mb2Str(x.array[i].den);
			denLength = strlen(denString);
			currLength = currLength + numLength + denLength + 3; // 3 is for ", " and "/"
			xString = (char*)realloc(xString, currLength);
			if(xString==NULL)
				return;
			strcat(xString, ", ");
			strcat(xString, numString);
			free(numString);
			strcat(xString, "/");
			strcat(xString, denString);
			free(denString);
		}
		else
		{
			currLength = currLength + numLength + 2; // 2 is for ", "
			xString = (char*)realloc(xString, currLength);
			if(xString==NULL)
				return;
			strcat(xString, ", ");
			strcat(xString, numString);
			free(numString);
		}

	}
	
}/* polyConvToString */

// converts 1, 1/2, 2, 1 to x^3 + 2x^2 + 1/2 x + 1
void polyConvToxString(char*& xString, const poly& x)
{
    char    *numString, *denString, expString[8];
    int    i, numLength, denLength, currLength;
    
    if(x.deg<0 || x.array==NULL)
    {
        xString = (char*)malloc(5*sizeof(char));
        xString[0] = 'N';
        xString[1] = 'U';
        xString[2] = 'L';
        xString[3] = 'L';
        xString[4] = 0;
        return;
    }
    
    // bfConvToStr(char*& bfStr, const bf& x)
    if(!x.deg)
    {
        bfConvToStr(xString, x.array[0]);
        return;
    }
    
    currLength = 1;
    xString = (char*)malloc(currLength*sizeof(char));
    xString[0] = 0;

    i = x.deg;
    numString = mb2Str(x.array[i].num);
    numLength = strlen(numString);
    if(x.array[i].den!=1)
    {
        denString = mb2Str(x.array[i].den);
        denLength = strlen(denString);
        currLength = currLength + numLength + denLength + 8; // 8 is for " x^e" and "/"
        xString = (char*)realloc(xString, currLength);
        if(xString==NULL)
            return;
        strcpy(xString, numString);
        free(numString);
        strcat(xString, "/");
        strcat(xString, denString);
        free(denString);
        if(i!=1)
        {
            strcat(xString, " x^");
            sprintf(expString, "%d", i);
            strcat(xString, expString);
        }
        else
            strcat(xString, " x");
    }
    else
    {
        currLength = currLength + numLength + 8;
        xString = (char*)realloc(xString, currLength);
        if(xString==NULL)
            return;
        if(abs(x.array[i].num)==1)
        {
            if(x.array[i].num<0.)
                strcpy(xString, "-");
        }
        else
        {
            strcpy(xString, numString);
        }
        free(numString);
        if(i!=1)
        {
            strcat(xString, " x^");
            sprintf(expString, "%d", i);
            strcat(xString, expString);
        }
        else
            strcat(xString, " x");
    }
    
    for(i=x.deg-1;i>0;i--)
    {
        if(!x.array[i].num)
            continue;
        
        numString = mb2Str(x.array[i].num);
        numLength = strlen(numString);
        if(x.array[i].den!=1)
        {
            denString = mb2Str(x.array[i].den);
            denLength = strlen(denString);
            currLength = currLength + numLength + denLength + 12; // 12 is for " x^e " and "/" and " + ", assume e<5 digits
            xString = (char*)realloc(xString, currLength);
            if(xString==NULL)
                return;
            //strcat(xString, " ");
            if(x.array[i].num>0.)
            {
                strcat(xString, " + ");
                strcat(xString, numString);
            }
            else
            {
                strcat(xString, " - ");
                free(numString);
                numString = mb2Str(abs(x.array[i].num));
                strcat(xString, numString);
            }
            free(numString);
            strcat(xString, "/");
            strcat(xString, denString);
            free(denString);
            if(i>1)
            {
                strcat(xString, " x^");
                sprintf(expString, "%d", i);
                strcat(xString, expString);
            }
            else
            {
                strcat(xString, " x");
            }
        }
        else  // now den=1
        {
            currLength = currLength + numLength + 9;
            xString = (char*)realloc(xString, currLength);
            if(xString==NULL)
                return;
            if(x.array[i].num>0.)
                strcat(xString, " + ");
            else
                strcat(xString, " - ");
            
            if(abs(x.array[i].num)==1)
            {
                if(i>1)
                {
                    strcat(xString, "x^");
                    sprintf(expString, "%d", i);
                    strcat(xString, expString);
                }
                else
                {
                    strcat(xString, "x");
                }
            }
            else // now coeff. > 1
            {
                free(numString);
                numString = mb2Str(abs(x.array[i].num));
                strcat(xString, numString);
                if(i!=1)
                {
                    strcat(xString, "x^");
                    sprintf(expString, "%d", i);
                    strcat(xString, expString);
                }
                else
                    strcat(xString, "x");
            }
        }
    }

    i = 0;
    if(x.array[i].num!=0.)
   {
       if(x.array[i].num>0.)
           strcat(xString, " + ");
       else
           strcat(xString, " - ");
       
       numString = mb2Str(abs(x.array[i].num));
       strcat(xString, numString);
       if(x.array[i].den!=1)
       {
           strcat(xString, "/");
           free(numString);
           numString = mb2Str(x.array[i].den);
           strcat(xString, numString);
       }
   }
    
    // if first char is a space, we need to move one char left
    if(xString[0]==' ')
    {
        currLength = strlen(xString);
        for(i=0;i<currLength;++i)
            xString[i] = xString[i+1];
    }
    
    
    
}/* polyConvToxString */

// 0: c ; 1: x ; 2: +x, -x ; 3: +cx, -cx ; 4: x^e ; 5: +x^e , -x^e ; 6: +cx^e, -cx^e
static bool doTerm(bf& coeff, int& power, char *term, int coeffStrLen)
{
    int     i, j, len;
    bool    isX, isCaret, isNum;
    char    ch, *coeffStr, powerStr[100000];
    
    len = strlen(term);
    if(!len)
        return false;
    
    // is there a caret?
    isCaret = false;
    for(i=0;i<len;++i)
    {
        if(term[i]=='^')
        {
            isCaret = true;
            break;
        }
    }
    
    // is there an x?
    isX = false;
    for(i=0;i<len;++i)
    {
        if(term[i]=='x')
        {
            isX = true;
            break;
        }
    }
    
    //is there a number before x
    if(isX)
    {
        isNum = false;
        for(i=0;i<len;++i)
        {
            ch = term[i];
            
            if(ch=='x')
                break;
            
            if(ch>='0' && ch<='9')
            {
                isNum = true;
                break;
            }
        }
    }
    
    if(!isX)
    {
        // term is for power = 0
        power = 0;
        if(bfConvFromStr(coeff, term))
            return true;
        return false;
    }
    
    coeffStr = (char*)malloc((coeffStrLen+1)*sizeof(char));
    
    // term has an x
    ch = term[0];
    if(ch=='x')
    {
        // candidates: 1: x,; 4:x^e
        if(isCaret)
        {
            // theCase = 4  x^e
            coeff = 1;
            i = 0;
            j = 2; // points to e
            while(j<len)
                powerStr[i++] = term[j++];
            powerStr[i] = 0;
            free(coeffStr);
            if(sscanf(powerStr, "%d", &power))
                return true;
            return false;
        }
        else
        {
            // theCase = 1  x
            coeff = 1;
            power = 1;
            free(coeffStr);
            return true;
        } // if(ch=='x'
    }
    
    if((ch=='+' || ch=='-') && !isCaret && !isNum)
    {
        // theCase = 2  +x, -x
        if(ch=='+')
        {
            coeff = 1;
            power = 1;
            free(coeffStr);
            return true;
        }
        coeff = -1;
        power = 1;
        free(coeffStr);
        return true;
    }
    
    if((ch=='+' || ch=='-') && isCaret && !isNum)
    {
        // theCase = 5 +x^e , -x^e
        if(ch=='+')
            coeff = 1;
        else
            coeff = -1;
        
        i = 0;
        j = 3; // points to e
        while(j<len)
            powerStr[i++] = term[j++];
        powerStr[i] = 0;
        free(coeffStr);
        if(sscanf(powerStr, "%d", &power))
            return true;
        return false;
    }
    
    if(isCaret)
    {
        // theCase = 6  +cx^e, -cx^e
        i = 0;
        j = 0;
        ch = term[j++];
        while(!(ch=='x'))
        {
            coeffStr[i++] = ch;
            ch = term[j++];
        }
        coeffStr[i] = 0;
        
        if(!bfConvFromStr(coeff, coeffStr))
        {
            free(coeffStr);
            return false;
        }
        
        i = 0;
        j++; //j points to e
        while(j<len)
            powerStr[i++] = term[j++];
        powerStr[i] = 0;
        free(coeffStr);
        if(sscanf(powerStr, "%d", &power))
            return true;
        return false;
    }
    
    // theCase = 3  +cx, -cx
    power = 1;
    i = 0;
    j = 0;
    ch = term[j++];
    while(!(ch=='x'))
    {
        coeffStr[i++] = ch;
        ch = term[j++];
    }
    coeffStr[i] = 0;
    
    if(!bfConvFromStr(coeff, coeffStr))
    {
        free(coeffStr);
        return false;
    }
    free(coeffStr);
    return true;
    
}/* doTerm */

// expects input of form 2x^2 - 1/2 x + 3 say in any order
bool polyConvFromxString(poly& z, const char *polyStr)
{
    int     i, j, len, power, maxPower, exp;
    char    ch, *term, *cleanStr;
    bool    isDone;
    bf      coeff;
    bf      temp;
    
    len = strlen(polyStr);
    if(!len)
    {
        init(z, 0);
        z.array[0] = 0;
        return true;
    }
    
    cleanStr = (char*)malloc((len+1)*sizeof(char));
    j = 0;
    for(i=0;i<len;++i)
    {
        ch = polyStr[i];
        if(!(ch==' ' || ch=='(' || ch==')'))
            cleanStr[j++] = ch;
    }
    cleanStr[j] = 0;
    
    len = strlen(cleanStr);
    
    term = (char*)malloc((len+1)*sizeof(char));
    
    // get maxPower
    maxPower = 0;
    isDone = false;
    j = 0;
    while(!isDone)
    {
        i = 0;
        ch = cleanStr[j++];
        term[i++] = ch; // get leading +, -, x, digit
        ch = cleanStr[j++];
        while(!(ch=='+' || ch=='-' || ch==0))
        {
            term[i++] = ch;
            ch = cleanStr[j++];
        }
        term[i] = 0;
        if(!doTerm(coeff, power, term, len))
            return false;
        if(power>maxPower)
            maxPower = power;
        if(ch==0)
            isDone = true;
        j--; // so points to '+' or '-'
    }
    
    // now have maxPower
    init(z, maxPower);
    for(i=0;i<=z.deg;++i)
        z.array[i] = 0;
    isDone = false;
    j = 0;
    while(!isDone)
    {
        i = 0;
        ch = cleanStr[j++];
        term[i++] = ch; // get leading +, -, x, digit
        ch = cleanStr[j++];
        while(!(ch=='+' || ch=='-' || ch==0))
        {
            term[i++] = ch;
            ch = cleanStr[j++];
        }
        term[i] = 0;
        if(!doTerm(coeff, power, term, len))
            return false;
        exp = power;
        z.array[exp]+=coeff; // must use exp not power, weird!
        if(ch==0)
            isDone = true;
        j--; // so points to '+' or '-'
    }
    return true;
    
}/* polyConvFromxString */
