/*
 *  poly.h
 *  fp
 *
 *  Created by Robert Delaney on 4/27/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#pragma once

#include "bf.h"
//#include "polyConv.h"

class poly
{
public:
	bf			*array; // inited to deg+1 in size
	
	INT32		deg;  // degree of polynomial, if deg<0 have null polynomial
	
	poly();
	poly(const char*);
	
	~poly();
	
	poly operator- ();
	poly operator- () const;
	poly& operator= (const poly&);
	poly& operator= (const bf&);
	poly& operator= (const mb&);
	poly& operator= (double);
	
	bool operator== (const poly&);
	bool operator!= (const poly&);
	bool operator== (INT32);
	bool operator!= (INT32);
    
    bool operator== (const poly&) const;
    bool operator!= (const poly&) const;
    bool operator== (INT32) const;
    bool operator!= (INT32) const;
	
	poly operator+ (const poly&);
	poly operator- (const poly&);
	poly operator* (const poly&);
	poly operator/ (const poly&);  // discards remainder polynomial
    
	poly operator+ (const poly&) const;
	poly operator- (const poly&) const;
	poly operator* (const poly&) const;
	poly operator/ (const poly&) const;  // discards remainder polynomial
	
	poly operator+ (const bf&);
	poly operator- (const bf&);
	poly operator* (const bf&);
	poly operator/ (const bf&);
	
	poly operator+ (const bf&) const;
	poly operator- (const bf&) const;
	poly operator* (const bf&) const;
	poly operator/ (const bf&) const;
	
	poly operator+ (const mb&);
	poly operator- (const mb&);
	poly operator* (const mb&);
	poly operator/ (const mb&);
	
	poly operator+ (const mb&) const;
	poly operator- (const mb&) const;
	poly operator* (const mb&) const;
	poly operator/ (const mb&) const;
	
	poly operator+ (double); // coerce double to mb
	poly operator- (double);
	poly operator* (double);
	poly operator/ (double);
	
	poly operator+ (double) const;
	poly operator- (double) const;
	poly operator* (double) const;
	poly operator/ (double) const;
	
	poly operator+ (int);
	poly operator- (int);
	poly operator* (int);
	poly operator/ (int);
	
	poly operator+ (int) const;
	poly operator- (int) const;
	poly operator* (int) const;
	poly operator/ (int) const;
    
    poly operator% (const mb&);
    poly operator% (const mb&) const;
	
	poly operator% (double);
	poly operator% (double) const;
	
	friend ostream& operator <<(ostream &s, const poly& x);
	friend istream& operator >>(istream &s, poly& x);

};

poly operator+ (const bf&, const poly&);
poly operator- (const bf&, const poly&);
poly operator* (const bf&, const poly&);
poly operator/ (const bf&, const poly&); // gives zero polynomial if poly deg>0

poly operator+ (const mb&, const poly&);
poly operator- (const mb&, const poly&);
poly operator* (const mb&, const poly&);
poly operator/ (const mb&, const poly&); // gives zero polynomial if poly deg>0

poly operator+ (int, const poly&);
poly operator- (int, const poly&);
poly operator* (int, const poly&);
poly operator/ (int, const poly&);

poly operator+ (double, const poly&);
poly operator- (double, const poly&);
poly operator* (double, const poly&);
poly operator/ (double, const poly&);

