/*
 *  matqMath.h
 *  fp
 *
 *  Created by Robert Delaney on 5/28/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#pragma once

#include "poly.h"
#include "matc.hpp"

void myFree(matq& x);
void myFree(matq* z, int numMats);
INT32 matqCompare(const matq& x, const matq& y);
void add(matq& z, const matq& x, const matq& y);;
void sub(matq& z, const matq& x, const matq& y);;
void mul(matq& z, const matq& x, const matq& y);
void mul(matq& z, const matq& x, const bf& y);
void mul(matq& z, const matq& x, double y);
void div(matq& z, const matq& x, const matq& y);
void matqUnit(matq& z, INT32 n);
matq matqUnit(INT32 n);
void transpose(matq& z, const matq& x);
matq transpose(const matq& x);
bool trace(bf& z, const matq& x);
bf trace(const matq& x);
void matqRowAugment(matq& z, const matq& x, const matq& y);
matq matqRowAugment(const matq& x, const matq& y);
void matqColAugment(matq& z, const matq& x, const matq& y);
matq matqColAugment(const matq& x, const matq& y);
void matqGaussElim(matq& z, INT32& swapParity, const matq& x);
bool matqGaussElim(matq& z, INT32& swapParity, const char *xString);
//void matqGaussElim(matq& z, const matq& x, double q);
void matqGaussElimModq(matq& z, INT32& swapParity, const matq& x, INT32 q);
void matqReduce(matq& z, const matq& x);
void matqReduceModp(matq& z, const matq& x, double p);
void matqNullSpace(INT32& numNV, matq& nullVectors, const matq& x);
bool matqNullSpace(INT32& numNV, matq& nullVectors, const char *xString);
void matqNullSpaceModq(INT32& numNV, matq& nullVectors, const matq& x, INT32 q);
bool matqInvert(matq& z, bf& det, const matq& x);
matq matqInvert(bf& det, const matq& x);
bool matqInvertModp(matq& z, bf& det, const matq& x, double p);
matq matqInvertModp(bf& det, const matq& x, double p);
void matqMod(matq& z, const matq& x, const mb& q);
void matqMod(matq& z, const matq& x, double q);
bool power(matq& z, const matq& x, INT32 y);
bool powerMod(matq& z, const matq& x, const mb& y, const mb& q);
//bool permutationMatrix(const matq& A, matq& P, INT32& swapParity);
bool LUdecomp(const matq& A, matq& P, matq& L, matq& U, INT32& swapParity);
bf matqDet(const matq& A);
void inv(matq& z, bf& determinant, const matq& x);
matq inv(const matq& x);
bf determinant(const matq& x);
void genRandIntMatOverp(matq& z, int nr, int nc, double p);
matq genRandIntMatOverp(int nr, int nc, double p);
bool isDiag(const matq& x);
bf genMatrixSeed(matq& seed, int m, double p);
void genMatrixGroup(matq*& z, int& numMats, int m, int p);
bool isGroupField(matq& table, const matq* x, int numMats, int p);
void countMatrixGroups(int& countkm, int& countLess, int& countMore, int numTrials, int m, double p);
int comparInt(const void* a, const void* b);
void findMatrixGroupOrders(int*& order, int*& freq, int& numOrders, int numTrials, int m, double p);
void numInverts(mb& z, int m, mb& p);
mb numInverts(int m, mb& p);
bool genMatrixCyclicGroup(matq*& z, const matq x, double p);
bool matrixZechLogs(int*& z, const matq& x, double p);
bool charPoly(poly& z, const matq& x);
long matqRank(const matq& x);
void matqEigenvectors(matc& eigenvectors, matc& eigenvalues, long*& algMultiplicity, long*& geoMultiplicity, const matq& x, long myDecPrec, const fp& zeroSet);
