/*
 *  matq.h
 *  fp
 *
 *  Created by Robert Delaney on 5/28/13.
 *  Copyright 2013 Bob Delaney's Science Software. All rights reserved.
 *
 */

#pragma once

#include "bf.h"
#include "matmbConv.hpp"

// class for matrices with bf elements
class matq
{
public:
	INT32		nr; // number of rows
	
	INT32		nc; // number of columns
	
	bf			**array; // holds matrix
	
	matq();
	
	matq(const char*);
    matq(INT32, INT32);
	
	~matq();
	
	matq operator- ();
	matq operator- () const;
	matq& operator= (const matq&);
    matq& operator= (const matmb&);
	
	bool operator== (const matq&);
	bool operator!= (const matq&);
	bool operator! ();
	
	bool operator== (const matq&) const;
	bool operator!= (const matq&) const;
	bool operator! () const;
	
	matq operator+ (const matq&);
	matq operator- (const matq&);
	matq operator* (const matq&);
	matq operator/ (const matq&);
	
	matq operator+ (const matq&) const;
	matq operator- (const matq&) const;
	matq operator* (const matq&) const;
	matq operator/ (const matq&) const;
	
	matq operator+ (const bf&);
	matq operator- (const bf&);
	matq operator* (const bf&);
	matq operator/ (const bf&);
	
	matq operator+ (const bf&) const;
	matq operator- (const bf&) const;
	matq operator* (const bf&) const;
	matq operator/ (const bf&) const;
	
	matq operator+ (const mb&);
	matq operator- (const mb&);
	matq operator* (const mb&);
	matq operator/ (const mb&);
	
	matq operator+ (const mb&) const;
	matq operator- (const mb&) const;
	matq operator* (const mb&) const;
	matq operator/ (const mb&) const;
	
	matq operator+ (double);
	matq operator- (double);
	matq operator* (double);
	matq operator/ (double);
	
	matq operator+ (double) const;
	matq operator- (double) const;
	matq operator* (double) const;
	matq operator/ (double) const;
	
	matq operator% (const mb&);
	matq operator% (double);
	matq operator% (const mb&) const;
	//matq operator% (double) const;
	
	friend ostream& operator <<(ostream &s, const matq& x);
	friend istream& operator >>(istream &s, matq& x);
};

matq operator+ (const bf&, const matq&);
matq operator- (const bf&, const matq&);
matq operator* (const bf&, const matq&);
matq operator/ (const bf&, const matq&);

matq operator+ (double, const matq&);
matq operator- (double, const matq&);
matq operator* (double, const matq&);
matq operator/ (double, const matq&);

