//
//  matmbMath.hpp
//  fp
//
//  Created by Robert Delaney on 9/9/17.
//
//

#ifndef matmbMath_hpp
#define matmbMath_hpp

#include <stdio.h>

#endif /* matmbMath_hpp */

#pragma once

#include "matq.h"
#include "matmb.hpp"

INT32 matqCompare(const matmb& x, const matmb& y);
void add(matmb& z, const matmb& x, const matmb& y);;
void sub(matmb& z, const matmb& x, const matmb& y);;
void mul(matmb& z, const matmb& x, const matmb& y);
void mul(matmb& z, const matmb& x, const mb& y);
void mul(matmb& z, const matmb& x, double y);
mb lcdMatmb(const matq& x);
void div(matmb& z, const matmb& x, const mb& y);
void div(matmb& z, const matmb& x, const matmb& y, mb& LCD);
void matmbUnit(matmb& z, INT32 n);
matmb matmbUnit(INT32 n);
void transpose(matmb& z, const matmb& x);
matmb transpose(const matmb& x);
bool trace(mb& z, const matmb& x);
mb trace(const matmb& x);
void matmbRowAugment(matmb& z, const matmb& x, const matmb& y);
matmb matmbRowAugment(const matmb& x, const matmb& y);
void matmbColAugment(matmb& z, const matmb& x, const matmb& y);
matmb matmbColAugment(const matmb& x, const matmb& y);
bool matmbInvert(matmb& z, mb& det, const matmb& x, mb& LCD);
matmb matmbInvert(mb& det, const matmb& x, mb& LCD);
void matmbMod(matmb& z, const matmb& x, const mb& q);
void matmbMod(matmb& z, const matmb& x, double q);
bool power(matmb& z, const matmb& x, INT32 y);
bool powerMod(matmb& z, const matmb& x, const mb& y, const mb& q);
