//
//  matmbConv.cpp
//  fp
//
//  Created by Robert Delaney on 9/9/17.
//
//

#include "matmbConv.hpp"
#include "string.h"
#include "stringUtils.h"
#include "mbConv.h"
#include <stdio.h>      /* printf, scanf, NULL */
#include <stdlib.h>     /* malloc, free, rand */

static char* matNULL()
{
    char    *z;
    
    z = (char*)malloc(5*sizeof(char));
    strcpy(z, "NULL");
    return z;
    
}/* matNULL */

void init(matmb& z, INT32 nr, INT32 nc)
{
    INT32   i, j;
    z.nr = nr;
    z.nc = nc;
    z.array = (mb**)malloc(z.nr*sizeof(mb*));
    for(i=0;i<z.nr;i++)
        z.array[i] = (mb*)malloc(z.nc*sizeof(mb));
    
    for(i=0;i<z.nr;i++)
        for(j=0;j<z.nc;j++)
        {
            init(z.array[i][j]);
        }
    
}/* init */

// fills matrix with mb integers
// in xString row elements seperated by commas and rows seperated by semicolons
bool matmbConvFromStr(matmb& z, const char *xString)
{
    INT32		i, j, k;
    char		*rowString, *numString;
    char		*zString, ch;
    INT32		length, nr, nc;
    
    length = strlen(xString);
    
    if(!xString || !length)
    {
        z.nr = z.nc = 0;
        z.array = NULL;
        return false;
    }
    
    zString = (char*)malloc((length+1)*sizeof(char));
    zString[0] = 0;
    
    strcpy(zString, xString);
    
    // trim non-numerics from end of xtString
    i = length - 1;
    ch = zString[i];
    while((ch<'0' || ch>'9') && i>0)
    {
        ch = zString[--i];
    }
    zString[i+1] = 0;
    
    nr = CountFields(zString, ";");
    
    rowString = NthField(zString, ";", 1);
    
    nc = CountFields(rowString, ",");
    
    init(z, nr, nc);
    
    for(i=0;i<nr;i++)
    {
        for(j=0;j<nc;j++)
        {
            numString = NthField(rowString, ",", j+1);
            if(!mbConvFromStr(z.array[i][j], numString))
            {
                for(k=0;k<nr;k++)
                    free(z.array[k]);
                free(z.array);
                z.nr = z.nc = 0;
                z.array = NULL;
                return false;
            }
            free(numString);
        }
        
        free(rowString);
        if(i<(nr-1))
            rowString = NthField(zString, ";", i+2);
    }
    
    free(zString);
    
    return true;
    
}/* matmbConvFromStr */


void matmbConvToStr(char*& matmbStr, const matmb& x)
{
    INT32		i, j;
    char		*numStr;
    INT32		allNumLen;
    
    
    if(!&x)
    {
        matmbStr = matNULL();
        return;
    }
    
    allNumLen = 0;
    
    for(i=0;i<x.nr;i++)
        for(j=0;j<x.nc;j++)
        {
            mbConvToStr(numStr, x.array[i][j]);
            allNumLen = allNumLen + strlen(numStr);
            free(numStr);
        }
    // account for commas, spaces, and semicolons
    allNumLen = allNumLen + x.nr*x.nc + x.nr + 20;
    matmbStr = (char*)malloc(allNumLen*sizeof(char));
    matmbStr[0] = 0;
    
    for(i=0;i<x.nr;i++)
    {
        for(j=0;j<x.nc;j++)
        {
            mbConvToStr(numStr, x.array[i][j]);
            strcat(matmbStr, numStr);
            if(j<(x.nc-1))
                strcat(matmbStr, ",");
            free(numStr);
        }
        if(i<(x.nr-1))
            strcat(matmbStr, ";");
    }
    
}/* matmbConvToStr */
