//
//  matmb.hpp
//  fp
//
//  Created by Robert Delaney on 9/9/17.
//
//

#ifndef matmb_hpp
#define matmb_hpp

#include <stdio.h>

#endif /* matmb_hpp */

#pragma once

#include "mb.h"

// class for matrices with mb elements
class matmb
{
public:
    INT32		nr; // number of rows
    
    INT32		nc; // number of columns
    
    mb			**array; // holds matrix
    
    matmb();
    
    matmb(const char*);
    matmb(INT32, INT32);
    
    ~matmb();
    
    matmb operator- ();
    matmb operator- () const;
    matmb& operator= (const matmb&);
    
    bool operator== (const matmb&);
    bool operator!= (const matmb&);
    bool operator! ();
    
    bool operator== (const matmb&) const;
    bool operator!= (const matmb&) const;
    bool operator! () const;
    
    matmb operator+ (const matmb&);
    matmb operator- (const matmb&);
    matmb operator* (const matmb&);
    matmb operator/ (const matmb&);
    
    matmb operator+ (const matmb&) const;
    matmb operator- (const matmb&) const;
    matmb operator* (const matmb&) const;
    matmb operator/ (const matmb&) const;
    
    matmb operator+ (const mb&);
    matmb operator- (const mb&);
    matmb operator* (const mb&);
    matmb operator/ (const mb&);
    
    matmb operator+ (const mb&) const;
    matmb operator- (const mb&) const;
    matmb operator* (const mb&) const;
    matmb operator/ (const mb&) const;
    
    matmb operator+ (double);
    matmb operator- (double);
    matmb operator* (double);
    matmb operator/ (double);
    
    matmb operator+ (double) const;
    matmb operator- (double) const;
    matmb operator* (double) const;
    matmb operator/ (double) const;
    
    matmb operator% (const mb&);
    matmb operator% (double);
    matmb operator% (const mb&) const;
    //matmb operator% (double) const;
    
    friend ostream& operator <<(ostream &s, const matmb& x);
    friend istream& operator >>(istream &s, matmb& x);
};

matmb operator+ (const mb&, const matmb&);
matmb operator- (const mb&, const matmb&);
matmb operator* (const mb&, const matmb&);
matmb operator/ (const mb&, const matmb&);

matmb operator+ (double, const matmb&);
matmb operator- (double, const matmb&);
matmb operator* (double, const matmb&);
matmb operator/ (double, const matmb&);
