/*
 *  fpComplex.h
 *  fp
 *
 *  Created by Robert Delaney on 11/7/09.
 *  Copyright 2009 Bob Delaney's Science Software. All rights reserved.
 *
 */

#pragma once

#include "fp.h"
#include "bf.h"

typedef struct
{
    double				Re;
    double				Im;
    
} Complex;

class fpComplex
{
public:
	
	fp		re;
	fp		im;
	
	fpComplex();
	fpComplex(const char*, const char*);
	fpComplex(const char*);
	fpComplex(const fp&, const fp&);
	fpComplex(double);
	fpComplex(double, double);
	
	~fpComplex();
	
	fpComplex operator- ();
	fpComplex operator- () const;
	fpComplex& operator= (const fpComplex&);
	fpComplex& operator= (const char*);
	fpComplex& operator= (const fp&);
	fpComplex& operator= (const mb&);
    fpComplex& operator= (const bf&);
	fpComplex& operator= (double);
    fpComplex& operator= (const Complex&);
	
	bool operator== (const fpComplex&);
	bool operator!= (const fpComplex&);
	bool operator! ();
	bool operator== (const fpComplex&) const;
	bool operator!= (const fpComplex&) const;
	bool operator! () const;
	
	bool operator== (const fp&);
	bool operator!= (const fp&);
	
	bool operator== (const fp&) const;
	bool operator!= (const fp&) const;
	
	bool operator== (const mb&);
	bool operator!= (const mb&);
	
	bool operator== (const mb&) const;
	bool operator!= (const mb&) const;
	
	bool operator== (double);
	bool operator!= (double);
	
	bool operator== (double) const;
	bool operator!= (double) const;
	
	fpComplex operator+ (const fpComplex&);
	fpComplex operator- (const fpComplex&);
	fpComplex operator* (const fpComplex&);
	fpComplex operator/ (const fpComplex&);
	
	fpComplex operator+ (const fpComplex&) const;
	fpComplex operator- (const fpComplex&) const;
	fpComplex operator* (const fpComplex&) const;
	fpComplex operator/ (const fpComplex&) const;
	
	fpComplex& operator+= (const fpComplex&);
	fpComplex& operator-= (const fpComplex&);
	fpComplex& operator*= (const fpComplex&);
	fpComplex& operator/= (const fpComplex&);
	
	fpComplex operator+ (const fp&);
	fpComplex operator- (const fp&);
	fpComplex operator* (const fp&);
	fpComplex operator/ (const fp&);
	
	fpComplex operator+ (const fp&) const;
	fpComplex operator- (const fp&) const;
	fpComplex operator* (const fp&) const;
	fpComplex operator/ (const fp&) const;
	
	fpComplex& operator+= (const fp&);
	fpComplex& operator-= (const fp&);
	fpComplex& operator*= (const fp&);
	fpComplex& operator/= (const fp&);
	
	fpComplex operator+ (const mb&);
	fpComplex operator- (const mb&);
	fpComplex operator* (const mb&);
	fpComplex operator/ (const mb&);
	
	fpComplex operator+ (const mb&) const;
	fpComplex operator- (const mb&) const;
	fpComplex operator* (const mb&) const;
	fpComplex operator/ (const mb&) const;
	
	fpComplex& operator+= (const mb&);
	fpComplex& operator-= (const mb&);
	fpComplex& operator*= (const mb&);
	fpComplex& operator/= (const mb&);
	
	fpComplex operator+ (double);
	fpComplex operator- (double);
	fpComplex operator* (double);
	fpComplex operator/ (double);
	
	fpComplex operator+ (double) const;
	fpComplex operator- (double) const;
	fpComplex operator* (double) const;
	fpComplex operator/ (double) const;
	
	fpComplex& operator+= (double);
	fpComplex& operator-= (double);
	fpComplex& operator*= (double);
	fpComplex& operator/= (double);
	
	friend ostream& operator <<(ostream &s, const fpComplex& x);
};

fpComplex operator+ (const fp&, const fpComplex&);
fpComplex operator- (const fp&, const fpComplex&);
fpComplex operator* (const fp&, const fpComplex&);
fpComplex operator/ (const fp&, const fpComplex&);

fpComplex operator+ (const mb&, const fpComplex&);
fpComplex operator- (const mb&, const fpComplex&);
fpComplex operator* (const mb&, const fpComplex&);
fpComplex operator/ (const mb&, const fpComplex&);

fpComplex operator+ (double, const fpComplex&);
fpComplex operator- (double, const fpComplex&);
fpComplex operator* (double, const fpComplex&);
fpComplex operator/ (double, const fpComplex&);

/*
typedef struct
{
	fpComplex 		c;
	
} BigComplexData;
*/

#include "fpComplexConv.h"
#include "fpComplexMath.h"
#include "fpComplexFuncs.h"
#include "GammaFunctionsC.h"
