/*
 *  bf.h
 *  fp
 *
 *  Created by Robert Delaney on 4/13/13.
 *  Copyright 2013 __Bob Delaney's Science Software_. All rights reserved.
 *
 */

#pragma once

#include "mb.h"

class bf
{
public:
	mb		num;
	mb		den;
	
	bf();
	bf(const char*);
	bf(const mb&);
	bf(const mb&,const mb&);
	bf(int);
	bf(int,int);
	
	~bf();
	
	bf operator- ();
	bf operator- () const;
	bf& operator= (const bf&);
	bf& operator= (const mb&);
	bf& operator= (double);
	
	bool operator> (const bf&);
	bool operator>= (const bf&);
	bool operator== (const bf&);
	bool operator!= (const bf&);
	bool operator> (const mb&);
	bool operator>= (const mb&);
	bool operator== (const mb&);
	bool operator!= (const mb&);
	bool operator> (int);
	bool operator>= (int);
	bool operator== (int);
	bool operator!= (int);
	bool operator! ();
	bool operator<= (const bf&);
	bool operator< (const bf&);
	bool operator> (const bf&) const;
	bool operator>= (const bf&) const;
	bool operator== (const bf&) const;
	bool operator!= (const bf&) const;
	bool operator! () const;
	bool operator<= (const bf&) const;
	bool operator< (const bf&) const;
	
	bool operator<= (const mb&);
	bool operator< (const mb&);
	bool operator> (const mb&) const;
	bool operator>= (const mb&) const;
	bool operator== (const mb&) const;
	bool operator!= (const mb&) const;
	bool operator<= (const mb&) const;
	bool operator< (const mb&) const;
	
	bf operator+ (const bf&);
	bf operator- (const bf&);
	bf operator* (const bf&);
	bf operator/ (const bf&);
	
	bf operator+ (const bf&) const;
	bf operator- (const bf&) const;
	bf operator* (const bf&) const;
	bf operator/ (const bf&) const;
	
	bf operator+ (const mb&);
	bf operator- (const mb&);
	bf operator* (const mb&);
	bf operator/ (const mb&);
	
	bf operator+ (const mb&) const;
	bf operator- (const mb&) const;
	bf operator* (const mb&) const;
	bf operator/ (const mb&) const;
	
	bf& operator+= (const bf&);
	bf& operator-= (const bf&);
	bf& operator*= (const bf&);
	bf& operator/= (const bf&);
	
	bf& operator+= (const mb&);
	bf& operator-= (const mb&);
	bf& operator*= (const mb&);
	bf& operator/= (const mb&);
	
	bf operator+ (int);
	bf operator- (int);
	bf operator* (int);
	bf operator/ (int);
	
	bf operator+ (int) const;
	bf operator- (int) const;
	bf operator* (int) const;
	bf operator/ (int) const;
	
	friend ostream& operator <<(ostream &s,const bf& x);
	friend istream& operator >>(istream &s, bf& x);
	
};

bf operator+ (int,const bf&);
bf operator- (int, const bf&);
bf operator* (int, const bf&);
bf operator/ (int, const bf&);

bf operator+ (const mb&, const bf&);
bf operator- (const mb&, const bf&);
bf operator* (const mb&, const bf&);
bf operator/ (const mb&, const bf&);


#include "mbMath.h"
#include "bfMath.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include "mbConv.h"
#include "bfConv.h"

