/* DealWithGray.cpp */

#include "DealWithGray.h"
#include "Gray_Binary.h"
#include "BaseFromBase.h"
#include <string.h>
#include <stdlib.h>

char* DealWithGray(char* inStr, int baseTo, int baseFrom, int numPlaces, bool isUpperCase)
{
	char	*outStr;
	int		length, *G, *B, i;
	int		isGood;
	
	if(!(baseTo==1 || baseFrom==1))
		return BaseFromBase(inStr, baseTo, baseFrom, numPlaces, isUpperCase);
	
	if(baseTo==1 && baseFrom==1)
	{
		length = strlen(inStr);
		outStr = (char*)malloc((length+1)*sizeof(char));
		strcpy(outStr, inStr);
		return outStr;
	}
	
	// we can't allow a decimal point
	length = strlen(inStr);
	isGood = 1;
	for(i=0;i<length;i++)
		if(inStr[i]=='.')
		{
			isGood = 0;
			break;
		}
			
	if(!isGood)
	{
		outStr = (char*)malloc(sizeof(char));
		outStr[0] = 0;
		return outStr;
	}
	
	if(baseTo==1)
	{
		// baseFrom is not 1
		baseTo = 2;
		outStr = BaseFromBase(inStr, baseTo, baseFrom, numPlaces, isUpperCase);
		if(outStr[0]==0)
			return outStr;
		length = strlen(outStr);
		G = (int*)malloc(length*sizeof(int));
		B = (int*)malloc(length*sizeof(int));
		for(i=0;i<length;i++)
			B[length-1-i] = outStr[i]-0x30;
		BinaryToGray(G, B, length-1);
		for(i=0;i<length;i++)
			outStr[length-1-i] = G[i]+0x30;
		outStr[length] = 0;
		free(G);
		free(B);
		return outStr;
	}
	
	// now baseFrom=1 and baseTo is not 1
	// we need to convert the from string to binary, but we first must check
	// it's a legal Gray string
	
	length = strlen(inStr);
	if(length==0)
	{
		outStr = (char*)malloc(sizeof(char));
		outStr[0] = 0;
		return outStr;
	}
	
	isGood = 1;
	for(i=0;i<length;i++)
		if(!(inStr[i]==0x30 || inStr[i]==0x31))
		{
			isGood = 0;
			break;
		}
	
	if(!isGood)
	{
		outStr = (char*)malloc(sizeof(char));
		outStr[0] = 0;
		return outStr;
	}
			
	G = (int*)malloc(length*sizeof(int));
	B = (int*)malloc(length*sizeof(int));
	
	for(i=0;i<length;i++)
		G[length-1-i] = inStr[i]-0x30;
	
	GrayToBinary(B, G, length-1);
	
	for(i=0;i<length;i++)
		inStr[length-1-i] = B[i]+0x30;
	inStr[length] = 0;
	
	baseFrom = 2;
	
	return BaseFromBase(inStr, baseTo, baseFrom, numPlaces, isUpperCase);
	
}/* DealWithGray */