
#include "fp.h"

static INT32 Min(INT32 x, INT32 y)
{
    if(x>y)
        return y;
    
    return x;
    
}/* Min */

static INT32 Max(INT32 x, INT32 y)
{
    if(x>y)
        return x;
    
    return y;
    
}/* Max */

static void mbAddAbsNew(mb& z, const mb& x, const mb& y)
{
    mb              zt;
    unsigned int    carry;
    int             i, comp;
    
    if(x.n==0 && y.n==0)
    {
        z = 0;
        return;
    }
    
    if(!x.n)
    {
        z = y;
        z.n = abs(z.n);
        return;
    }
    
    if(!y.n)
    {
        z = x;
        z.n = abs(z.n);
        return;
    }
    
    comp = mbCompareAbs(x, y);
    if(comp>=0)
    {
        // x>=y, so we add y into z = x initially
        // create zt with abs(x.n)+1 blocks in case there is a carry into last block
        zt.n = zt.nn = abs(x.n) + 1;
        zt.b = (UINT32*)malloc(zt.n*sizeof(UINT32));
        // copy x into zt
        for(i=0;i<abs(x.n);++i)
            zt.b[i] = x.b[i];
        zt.b[zt.n-1] = 0;
        // add y into zt
        carry = 0;
        for(i=0;i<abs(y.n);++i)
        {
            zt.b[i]+=(y.b[i]+carry);
            if(zt.b[i]<x.b[i] || zt.b[i]<y.b[i])
                carry = 1;
            else
                carry = 0;
        }
        if(carry==0)
        {
            // we're done
            zt.n-=1;
            z = zt;
            return;
        }
        // now propagate the carry to the rest of zt
        for(i=abs(y.n);i<zt.n;++i)
        {
            zt.b[i]+=carry;
            if(zt.b[i]==0)
                carry = 1;
            else
            {
                // we're done
                if(zt.b[z.n-1]==0)
                    zt.n-=1;
                z = zt;
                return;
            }
        }
    }
    
    //x<y so we add x into z = y initially
    // create zt with abs(x.n)+1 blocks in case there is a carry into last block
    zt.n = zt.nn = abs(y.n) + 1;
    zt.b = (UINT32*)malloc(zt.n*sizeof(UINT32));
    // copy y into zt
    for(i=0;i<abs(y.n);++i)
        zt.b[i] = y.b[i];
    zt.b[zt.n-1] = 0;
    // add x into zt
    carry = 0;
    for(i=0;i<abs(x.n);++i)
    {
        zt.b[i]+=(x.b[i]+carry);
        if(zt.b[i]<x.b[i] || zt.b[i]<y.b[i])
            carry = 1;
        else
            carry = 0;
    }
    if(carry==0)
    {
        // we're done
        zt.n-=1;
        z = zt;
        return;
    }
    // now propagate the carry to the rest of zt
    for(i=abs(x.n);i<zt.n;++i)
    {
        zt.b[i]+=carry;
        if(zt.b[i]==0)
            carry = 1;
        else
        {
            // we're done
            if(zt.b[z.n-1]==0)
                zt.n-=1;
            z = zt;
            return;
        }
    }
}/* mbAddAbsNew */

static void mbAddAbs(mb& z, const mb& x, const mb& y)
{
    static mb            zt;
    INT32                i, minNumBlocks;
    UINT32                carry;
    
    if(x.n==0 && y.n==0)
    {
        z = 0;
        return;
    }
    
    if(!x.n)
    {
        equate(z, y);
        z.n = abs(z.n);
        return;
    }
    
    if(!y.n)
    {
        equate(z, x);
        z.n = abs(z.n);
        return;
    }
    
    // zt.n is one more than max of abs(x.n) and abs(y.n) in case of non-zero carry
    zt.n = 1 + Max(abs(x.n), abs(y.n));
    minNumBlocks = Min(abs(x.n), abs(y.n));
    
    updateWithCare(zt);
    
    carry = 0;
    for(i=0;i<minNumBlocks;i++)
    {
        zt.b[i] = x.b[i] + y.b[i] + carry;
        if(!carry)
        {
            if(zt.b[i]<x.b[i])
                carry = 1;
            else
                carry = 0;
        }
        else
        {
            if(zt.b[i]<=x.b[i])
                carry = 1;
            else
                carry = 0;
        }
    }
    
    if(abs(x.n)>abs(y.n))
        for(i=minNumBlocks;i<abs(x.n);i++)
        {
            zt.b[i] = x.b[i] + carry;
            if(!carry)
            {
                carry = 0;
            }
            else
            {
                if(zt.b[i]<=x.b[i])
                    carry = 1;
                else
                    carry = 0;
            }
        }
    
    if(abs(y.n)>abs(x.n))
        for(i=minNumBlocks;i<abs(y.n);i++)
        {
            zt.b[i] = y.b[i] + carry;
            if(!carry)
            {
                carry = 0;
            }
            else
            {
                if(zt.b[i]<=y.b[i])
                    carry = 1;
                else
                    carry = 0;
            }
        }
    
    if(carry)
        zt.b[zt.n-1] = carry;
    else
        zt.n--;
    
    equate(z, zt);
    
}/* mbAddAbs */

using namespace std;
// new addAbs
int main (int argc, char * const argv[])
{
    mb          x="123456789123456789", y="123456789123456789", z="0";
    clock_t     t;
    long        i;
    
    t = clock();
    for(i=0;i<1000000;++i)
    mbAddAbsNew(z, x, z);
    t = clock() - t;
    cout << z << endl;
    cout << "time = " << (double)t / CLOCKS_PER_SEC << " sec" << endl << endl;
    
    init(z, "0");
    t = clock();
    for(i=0;i<1000000;++i)
        mbAddAbs(z, x, z);
    t = clock() - t;
    cout << z << endl;
    cout << "time = " << (double)t / CLOCKS_PER_SEC << " sec" << endl;
    
    return 0;
}
/*
 123456912580245912456789
 time = 0.676332 sec
 
 123456912580245912456789
 time = 0.288116 sec
 Program ended with exit code: 0
 switched z, z, y to z, x, z
 123456912580245912456789
 time = 0.574447 sec
 
 123456912580245912456789
 time = 0.308582 sec
 Program ended with exit code: 0
 123456789123456789000000
 time = 0.596315 sec
 
 123456789123456789000000
 time = 0.250098 sec
 Program ended with exit code: 0
 123456789123456789000000
 time = 0.527022 sec
 
 123456789123456789000000
 time = 0.26327 sec
 Program ended with exit code: 0
 
 switched procedures
 123456789123456789000000
 time = 0.303479 sec
 
 123456789123456789000000
 time = 0.580088 sec
 Program ended with exit code: 0
 */
