/* myTypedef.h */

#pragma once

#define blockBits 32

/*
#define UINT16 unsigned short
#define INT32 long
#define UINT32 unsigned long
#define UINT64 unsigned long long
 */


 #define INT8 char
 #define UINT8 unsigned char
 #define INT16 short
 #define UINT16 unsigned short
 #define INT32 int
 #define UINT32 unsigned int
 #define INT64 long long int
 #define UINT64 unsigned long long int

#include "fp.h"

typedef struct
{
	double				Re;
	double				Im;
	
} Complex;

typedef struct
{
	double			**array;
	INT32			nr;	// number of rows
	INT32			nc;	// number of columns
	
} MatrixData;

typedef struct
{
	Complex			**array;
	INT32			nr;	// number of rows
	INT32			nc;	// number of columns
	
} ComplexMatrixData;

/*
typedef struct
{
	INT32				nn; // number of blocks malloced
	
	INT32				n;  // abs(n) = number of blocks; sign of n = sign of fp number
	// if n = 0 then mb = 0, b is not instantiated
	UINT32 				*b;  // b[0] is low order block; b[n-1] is high order block
	
} mb;

typedef struct
{
	mb					i; // signed integer of unlimited length
	
	INT32				e; // exponent of 2, so fp number = i x 2^e
	
}fp;
*/

typedef struct
{
	fp		Re;
	fp		Im;
	
} ExtComplex;


typedef struct
{
	INT32			n; // degree of polynomial
	Complex			*coeff; // coeff[n+1], coeff[0] is constant term, coeff[n] is X x^n
	
} Polynomial;

typedef Complex *ComplexPtr;
typedef	Complex	**ComplexPtr2;
typedef	Complex	***ComplexPtr3;
typedef	int	*longPtr;
