/*
 *  mbMath.h
 *  fp
 *
 *  Created by Robert Delaney on 4/24/09.
 *  Copyright 2009 __Bob Delaney's Science Software__. All rights reserved.
 *
 */

#pragma once

INT32 countOnes(UINT32 x);
INT32 compareBitsUINT32(UINT32 x, UINT32 y, INT32 maxPos);
INT32 mbCompareBits(const mb& x, const mb& y, INT32 lowBitIndex, INT32 highBitIndex);
INT32 getBit(UINT32 x, INT32 bitIndex);
UINT32 clearBit(UINT32 x, INT32 bitIndex);
UINT32 setBit(UINT32 x, INT32 bitIndex);
INT32 mbGetBit(const mb& x, INT32 bitIndex);
mb mbSetBit(const mb& x, INT32 bitIndex);
mb mbClearBit(const mb& x, INT32 bitIndex);
mb mbFlipBit(const mb& x, INT32 bitIndex);
INT32 mbCountOnes(const mb& x);
bool isItEven(const mb& x);
bool isItSquare(mb& z, const mb& x);
mb abs(const mb& x);
void updateWithCare(mb& x);
void update(mb& x);
void mbNormalize(mb& z);
INT32 alignLeft(mb& x);
void mulByScalarAbs(mb& z, const mb& x, UINT32 y);
INT32 mbCompareAbs(const mb& x, const mb& y);
void mbShiftLeft(mb& z, const mb& x, INT32 numBits);
void mbShiftRight(mb& z, const mb& x, INT32 numBits);
INT32 compare(const mb& x, const mb& y);
mb twosComplement(const mb& x, INT32 numBlocks);
mb twosComplement(const mb& x);
mb mbAnd(const mb& x, const mb& y);
mb mbAnd(const mb& x, INT32 y);
mb mbOr(const mb& x, const mb& y);
mb mbOr(const mb& x, INT32 y);
mb mbXor(const mb& x, const mb& y);
mb mbXor(const mb& x, INT32 y);
void add(mb& z, const mb& x, const mb& y);
void add(mb& z, const mb& x, INT32 y);
void add(mb& z, INT32 x, const mb& y);
void add(mb& z, const mb& x, double y);
void add(mb& z, double x, const mb& y);
void sub(mb& z, const mb& x, const mb& y);
void sub(mb& z, const mb& x, INT32 y);
void sub(mb& z, INT32 x, const mb& y);
void sub(mb& z, const mb& x, double y);
void sub(mb& z, double x, const mb& y);
void mul(mb& z, const mb& x, const mb& y);
void mul(mb& z, const mb& x, INT32 y);
void mul(mb& z, INT32 x, const mb& y);
void mul(mb& z, const mb& x, double y);
void mul(mb& z, double x, const mb& y);
UINT32 mbShortDiv(mb& z, const mb& x, const mb& y);
UINT32 mbShortDiv(mb& z, const mb& x, UINT32 y);
bool div(mb& z, const mb& x, const mb& y);
bool div(mb& z, const mb& x, INT32 y);
bool div(mb& z, INT32 x, const mb& y);
bool div(mb& z, const mb& x, double y);
bool div(mb& z, double x, const mb& y);
bool divRem(mb& z, mb& rem, const mb& x, const mb& y);
bool divRem(mb& z, mb& rem, const mb& x, INT32 y);
bool divRem(mb& z, mb& rem, INT32 x, const mb& y);
bool divRem(mb& z, mb& rem, const mb& x, double y);
bool divRem(mb& z, mb& rem, double x, const mb& y);
void sqr(mb& z, const mb& x);
mb sqr(const mb& x);
void sqrt(mb& z, const mb& x);
mb sqrt(const mb& x);
bool power(mb& z, const mb& x, INT32 y);
bool power(mb& z, const mb& x, const mb& y);
mb power(const mb& x, INT32 y);
mb power(const mb& x, const mb& y);
INT32 NumBits(const mb& x);
INT32 Lg2(const mb& x);
void log(double& z, const mb& x);
double log(const mb& x);
void gcd(mb& z, const mb& x, const mb& y);
mb gcd(const mb& x, const mb& y);
void extendedGCD(mb& x, mb& y, mb& gcd, const mb& a, const mb& b);
void nthRoot(mb& z, const mb& x, INT32 n);
mb nthRoot(const mb& x, INT32 n);
void factorial(mb& z, const mb& x);
mb factorial(const mb& x);
bool binomial(mb& z, const mb& n, const mb& r);
mb binomial(const mb& n, const mb& r);
bool binomial(mb& z, const mb& n, INT32 r);
mb binomial(const mb& n, INT32 r);
bool binomial(mb& z, INT32 n, const mb& r);
mb binomial(INT32 n, const mb& r);
bool binomial(mb& z, INT32 n, INT32 r);
mb binomial(INT32 n, INT32 r);
