//
//  matfp.hpp
//  fp
//
//  Created by Robert Delaney on 2/1/17.
//
//

#pragma once

#ifndef matfp_hpp
#define matfp_hpp

#include <stdio.h>
#include "fp.h"

#endif /* matfp_hpp */



// class for matrices with fp elements
class matfp
{
public:
    INT32		nr; // number of rowsbf
    
    INT32		nc; // number of columnsbf
    
    fp			**array; // holds matrix
    
    matfp();
    
    matfp(const char*);
    
    ~matfp();
    
    matfp operator- ();
    matfp operator- () const;
    matfp& operator= (const matfp&);
    
    bool operator== (const matfp&);
    bool operator!= (const matfp&);
    bool operator! ();
    
    bool operator== (const matfp&) const;
    bool operator!= (const matfp&) const;
    bool operator! () const;
    
    matfp operator+ (const matfp&);
    matfp operator- (const matfp&);
    matfp operator* (const matfp&);
    matfp operator/ (const matfp&);
    
    matfp operator+ (const matfp&) const;
    matfp operator- (const matfp&) const;
    matfp operator* (const matfp&) const;
    matfp operator/ (const matfp&) const;
    
    matfp operator+ (const fp&);
    matfp operator- (const fp&);
    matfp operator* (const fp&);
    matfp operator/ (const fp&);
    
    matfp operator+ (const fp&) const;
    matfp operator- (const fp&) const;
    matfp operator* (const fp&) const;
    matfp operator/ (const fp&) const;
    
    matfp operator+ (const mb&);
    matfp operator- (const mb&);
    matfp operator* (const mb&);
    matfp operator/ (const mb&);
    
    matfp operator+ (const mb&) const;
    matfp operator- (const mb&) const;
    matfp operator* (const mb&) const;
    matfp operator/ (const mb&) const;
    
    matfp operator+ (const double);
    matfp operator- (const double);
    matfp operator* (const double);
    matfp operator/ (const double);
    
    matfp operator+ (const double&) const;
    matfp operator- (const double&) const;
    matfp operator* (const double&) const;
    matfp operator/ (const double&) const;
    
    friend ostream& operator <<(ostream &s, const matfp& x);
    friend istream& operator >>(istream &s, matfp& x);

};

matfp operator+ (const fp&, const matfp&);
matfp operator- (const fp&, const matfp&);
matfp operator* (const fp&, const matfp&);
matfp operator/ (const fp&, const matfp&);

matfp operator+ (const mb&, const matfp&);
matfp operator- (const mb&, const matfp&);
matfp operator* (const mb&, const matfp&);
matfp operator/ (const mb&, const matfp&);

matfp operator+ (double, const matfp&);
matfp operator- (double, const matfp&);
matfp operator* (double, const matfp&);
matfp operator/ (double, const matfp&);

