//
//  matcMath.hpp
//  fp
//
//  Created by Robert Delaney on 2/2/17.
//
//

#ifndef matcMath_hpp
#define matcMath_hpp

#include <stdio.h>

#endif /* matcMath_hpp */

#include "matc.hpp"
#include "matfp.hpp"

void add(matc& z, const matc& x, const matc& y);
void add(matc& z, const matc& x, const matfp& y);
void add(matc& z, const matfp& x, const matc& y);
void sub(matc& z, const matc& x, const matc& y);
void sub(matc& z, const matc& x, const matfp& y);
void sub(matc& z, const matfp& x, const matc& y);
void mul(matc& z, const matc& x, const matc& y);
void mul(matc& z, const matc& x, const matfp& y);
void mul(matc& z, const matfp& x, const matc& y);
void mul(matc& z, const matc& x, const fp& y);
void mul(matc& z, const fp& x, const matc& y);
void div(matc& z, const matc& x, const fp& y);
void mul(matc& z, const matc& x, const mb& y);
void mul(matc& z, const mb& x, const matc& y);
void div(matc& z, const matc& x, const mb& y);
void mul(matc& z, const matc& x, double y);
void mul(matc& z, const double x, const matc& y);
void div(matc& z, const matc& x, double y);
void matcUnit(matc& z, INT32 n);
matc matcUnit(INT32 n);
void transpose(matc& z, const matc& x);
matc transpose(const matc& x);
bool trace(fpComplex& z, const matc& x);
fpComplex trace(const matc& x);
void matcGaussElim(matc& z, INT32& swapParity, const matc& x);
void matcReduce(matc& z, const matc& x);
void inv(matc& z, fpComplex& determinant, const matc& x);
matc inv(const matc& x);
fpComplex determinant(const matc& x);
