//
//  matc.hpp
//  fp
//
//  Created by Robert Delaney on 2/2/17.
//
//

#pragma once

#ifndef matc_hpp
#define matc_hpp

#include <stdio.h>

#endif /* matc_hpp */

#include "fpComplex.h"

// class for matrices with fpComplex elements
class matc
{
public:
    INT32		nr; // number of rows
    
    INT32		nc; // number of columns
    
    fpComplex	**array; // holds matrix
    
    matc();
    
    matc(const char*);
    
    ~matc();
    
    matc operator- ();
    matc operator- () const;
    matc& operator= (const matc&);
    
    bool operator== (const matc&);
    bool operator!= (const matc&);
    bool operator! ();
    
    bool operator== (const matc&) const;
    bool operator!= (const matc&) const;
    bool operator! () const;
    
    matc operator+ (const matc&);
    matc operator- (const matc&);
    matc operator* (const matc&);
    matc operator/ (const matc&);
    
    matc operator+ (const matc&) const;
    matc operator- (const matc&) const;
    matc operator* (const matc&) const;
    matc operator/ (const matc&) const;
    
    matc operator+ (const fp&);
    matc operator- (const fp&);
    matc operator* (const fp&);
    matc operator/ (const fp&);
    
    matc operator+ (const fp&) const;
    matc operator- (const fp&) const;
    matc operator* (const fp&) const;
    matc operator/ (const fp&) const;
    
    matc operator+ (const mb&);
    matc operator- (const mb&);
    matc operator* (const mb&);
    matc operator/ (const mb&);
    
    matc operator+ (const mb&) const;
    matc operator- (const mb&) const;
    matc operator* (const mb&) const;
    matc operator/ (const mb&) const;
    
    matc operator+ (double);
    matc operator- (double);
    matc operator* (double);
    matc operator/ (double);
    
    
    friend ostream& operator <<(ostream &s, const matc& x);
    friend istream& operator >>(istream &s, matc& x);
    
};

matc operator+ (const fp&, const matc&);
matc operator- (const fp&, const matc&);
matc operator* (const fp&, const matc&);
matc operator/ (const fp&, const matc&);

matc operator+ (const mb&, const matc&);
matc operator- (const mb&, const matc&);
matc operator* (const mb&, const matc&);
matc operator/ (const mb&, const matc&);

matc operator+ (double, const matc&);
matc operator- (double, const matc&);
matc operator* (double, const matc&);
matc operator/ (double, const matc&);

