/* Complex.cp */


#include "Complex.h"
#include <math.h>

bool isEqualZero(Complex& z)
{
	if(z.Re==0 && z.Im==0)
		return true;
	else
		return false;
	
}/* isEqualZero */


bool isEqual(Complex& z, Complex& x)
{
	if(z.Re==x.Re && z.Im==x.Im)
		return true;
	else
		return false;
		
}/* isEqual */

/*
void convC_EC(Complex& z, ExtComplex& x)
{
	convEToDouble(z.Re, x.Re);
	convEToDouble(z.Im, x.Im);

}*//* convC_EC */


void assignZeroC(Complex& z)
{
	z.Re = 0;
	z.Im = 0;
	
}/* assignZeroC */


void EquateC_C(Complex& z, const Complex& x)
{
	z.Re = x.Re;
	z.Im = x.Im;
	
}/* EquateC_C */


double AbsC(Complex& z)
{
	return sqrt(z.Re*z.Re + z.Im*z.Im);

}/* AbsC */


void Add(Complex& z, const Complex& x, const Complex& y)
{
	z.Re = x.Re + y.Re;
	z.Im = x.Im + y.Im;
	
}/* Add */


void Sub(Complex& z, const Complex& x, const Complex& y)
{
	z.Re = x.Re - y.Re;
	z.Im = x.Im - y.Im;
	
}/* Sub */


void Mul(Complex& z, const Complex& x, const Complex& y)
{
	double		ac, bd;
	
	if(x.Re!=0 && x.Im!=0 && y.Re!=0 && y.Im!=0)
	{
		ac = x.Re*y.Re;
		bd = x.Im*y.Im;
		
		// the order here is important since z might be the same as x or y
		z.Im = (x.Re + x.Im)*(y.Re + y.Im) - ac - bd;
		z.Re = ac - bd;
		return;
	}
	
	if(x.Re==0)
	{
		ac = -x.Im*y.Im;
		z.Im = x.Im*y.Re;
		z.Re = ac;
		return;
	}
	
	if(x.Im==0)
	{
		ac = x.Re*y.Re;
		z.Im = x.Re*y.Im;
		z.Re = ac;
		return;
	}
	
	if(y.Re==0)
	{
		ac = -x.Im*y.Im;
		z.Im = x.Re*y.Im;
		z.Re = ac;
		return;
	}
	
	if(y.Im==0)
	{
		ac = x.Re*y.Re;
		z.Im = x.Im*y.Re;
		z.Re = ac;
		return;
	}
	
}/* Mul */


void Div(Complex& z, const Complex& x, const Complex& y)
{
	double		ac, bd, den;
	
	if(y.Re==0 && y.Im==0)
	{
		z.Re = NAN;
		z.Im = NAN;
		return;
	}
	
	if(x.Im==0 && y.Im==0)
	{
		z.Re = x.Re/y.Re;
		z.Im = 0;
		return;
	}
	
	if(x.Re==0 && y.Re==0)
	{
		z.Re = x.Im/y.Im;
		z.Im = 0;
		return;
	}
	
	if(x.Re==0 && y.Im==0)
	{
		z.Re = 0;
		z.Im = x.Im/y.Re;
		return;
	}
	
	if(x.Im==0 && y.Re==0)
	{
		z.Re = 0;
		z.Im = -x.Re/y.Im;
		return;
	}
	
	den = y.Re*y.Re + y.Im*y.Im;
	
	ac = x.Re*y.Re;
	bd = x.Im*y.Im;
	
	// the order here is important since z might be the same as x or y
	z.Im = ((x.Re + x.Im)*(y.Re - y.Im) - ac + bd)/den;
	z.Re = (ac + bd)/den;
	
}/* Div */