// rb_plugin.h
//
// This file is part of the REALbasic plugin API.  Include this file
// at the top of your plugin source files.
//
//  1997-2002 REAL Software Inc. -- All Rights Reserved
// See file "Plug-in License SDK.txt" for details.

#ifndef RB_PLUGIN_H
#define RB_PLUGIN_H

#if defined(MPW_CPLUS) || defined(MPW_C)
	#include <Types.h>
	#include <MacTypes.h>
	#include <QDOffscreen.h>
	#include <Events.h>
	#include <Files.h>
	#include <AppleEvents.h>
	#include <Controls.h>
	#include <Movies.h>
	#include <Appearance.h>
#endif // MPW

#if !WIN32 || !defined( __cplusplus )
	#define QT_NAMESPACE
#else
	#define QT_NAMESPACE QT::
#endif

#include "REALplugin.h"

// picture types and description
enum {
	pictureUnknown,
	pictureMacintoshPICT,
	pictureMacintoshCICN,
	pictureMacintoshIconSuite,
	pictureMacintoshGWorld,
	pictureWin32DIB,		// a HDIB, use GlobalLock on it
	pictureGdkPixmap,
	pictureWin32Bitmap,		// a HBITMAP, but really a DIBSECTION, use GetObject on it
	pictureCGBitmapContext,
};

struct REALpictureDescription
{
	long pictureType;
	void *pictureData;
	long width, height, depth;			// Plugin authors can now get depth and transparency info (5.0)
	Boolean transparent;
};
typedef struct REALpictureDescription REALpictureDescription;

// Sound types and description
enum {
	soundUnknown,
	soundMacintoshSnd
};

struct REALsoundDescription
{
	long soundType;
	void *soundData;
};
typedef struct REALsoundDescription REALsoundDescription;

// handy macros
#define ControlData(defn, instance, typeName, data) typeName *data = (typeName *) REALGetControlData(instance, &defn)
#define ClassData(defn, instance, typeName, data) typeName *data = (typeName *) REALGetClassData(instance, &defn)

// socket constants
#define socketEventConnect 1
#define socketEventError 2
#define socketEventDataReceived 4
#define socketEventSendComplete 8

// pixel types
enum RBPixelType
{
	kRBPixelRGB24 = 1,			// 3 bytes/pixel: Red, Green, Blue
	kRBPixelBGR24,				// 3 bytes/pixel: Blue, Green, Red
	kRBPixelXRGB32,				// 4 bytes/pixel: Unused, Red, Green, Blue
	kRBPixelBGRX32				// 4 bytes/pixel: Blue, Green, Red, Unused
};
typedef enum RBPixelType RBPixelType;

#if FLAT_C_PLUGIN_HEADERS && defined( __cplusplus )
	extern "C" {
#endif

// You can use these methods to register a global structure
// or enumeration in much the same way you can register 
// global methods.  Note: be careful when adding anything
// to the global namespace as it could cause conflicts.  Use
// these methods with extreme caution.
void REALRegisterStructure( REALstructure *defn );
void REALRegisterEnum( REALenum *defn );

typedef void (*BackgroundTaskProc)(void *data);
long REALRegisterBackgroundTask( BackgroundTaskProc proc, unsigned long period, void *data );
void REALUnregisterBackgroundTask( long id );

// **** Autogenerated code from Plugin API Manager follows ****
// *************** Do not edit below this line ****************

#if TARGET_68K || TARGET_PPC
QDGlobals *REALQDGlobals(void);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
int REALallocateMenuID(void);
#endif

Boolean REALinRuntime(void);

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
void REALreleaseMenuID(int id);
#endif

void GraphicsDrawLine(REALgraphics graphicsObject, int x1, int y1, int x2, int y2);

typedef void (*BackgroundTaskProc)(void *data);
long REALRegisterBackgroundTask( BackgroundTaskProc proc, unsigned long period, void *data );
void REALUnregisterBackgroundTask( long id );

void REALRegisterMethod(REALmethodDefinition *defn);

void REALRegisterControl(REALcontrol *defn);

void REALRegisterClassExtension(REALclassDefinition *defn);

void REALRegisterDBEngine(REALdbEngineDefinition *defn);

void REALRegisterDBTable(REALdbTableDefinition *defn);

void REALRegisterDBCursor(REALdbCursorDefinition *defn);

void REALRegisterClass(REALclassDefinition *defn);

const char *REALCString(REALstring str);

const unsigned char *REALPString(REALstring str);

REALstring REALInterpretConstantValue(REALstring value);

REALstring REALDefaultControlFont(void);

REALstring REALDefaultControlCaption(void);

unsigned long REALDefaultControlFontSize(void);

REALstring REALBuildString(const char *contents, int length);

void REALLockObject(REALobject obj);

void REALUnlockObject(REALobject obj);

void REALLockString(REALstring str);

void REALUnlockString(REALstring str);

REALproc REALInterfaceRoutine(REALobject obj, const char *interfaceName, const char *methodName);

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !COCOA
REALpicture REALBuildPictureFromPicHandle(PicHandle pic, Boolean bPassOwnership);
#endif

REALpicture REALBuildPictureFromGWorld(void *world, Boolean bPassOwnership);

REALpicture REALBuildPictureFromPictureDescription(REALpictureDescription *description, Boolean bPassOwnership);

void REALUnlockPictureDescription(REALpicture pic);

void REALLockSoundDescription(REALsound sound, REALsoundDescription *description);

void REALUnlockSoundDescription(REALsound sound);

void REALPictureClearCache(REALpicture pic);

#if TARGET_WIN32
void REALDrawPicturePrimitive(HDC hDC, REALpicture pic, const Rect *rBounds, int bTransparent);
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !COCOA
void REALDrawPicturePrimitive(REALpicture pic, const Rect *rBounds, int bTransparent);
#endif

REALdbCursor REALdbCursorFromDBCursor(dbCursor *cursor, REALdbCursorDefinition *defn);

REALdbDatabase REALdbDatabaseFromDBDatabase(dbDatabase *database, REALdbEngineDefinition *defn);

void *REALGetEventInstance(REALcontrolInstance instance, REALevent *event);

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !COCOA
void REALRegisterEventFilter(REALEventCallback callback, long param);
#endif

void *REALGetControlData(REALcontrolInstance instance, REALcontrol *defn);

void *REALGetClassData(REALobject instance, REALclassDefinition *defn);

void REALGetControlBounds(REALcontrolInstance instance, Rect *rBounds);

long REALGetControlVisible(REALcontrolInstance instance);

Boolean REALGetControlEnabled(REALcontrolInstance instance);

void REALSetControlVisible(REALcontrolInstance instance, unsigned long visible);

REALgraphics REALGetControlGraphics(REALcontrolInstance instance);

#if TARGET_WIN32
int REALGetWin32Charset(void);
#endif

#if TARGET_WIN32 || UNIX_ANSI
REALfolderItem REALFolderItemFromPath(const char *path);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_COCOA
REALfolderItem REALFolderItemFromFSSpec(const FSSpec *spec);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_COCOA
Boolean REALFSSpecFromFolderItem(FSSpec *spec, REALfolderItem item);
#endif

REALstring REALpathFromFolderItem(REALfolderItem item);

#if TARGET_WIN32
HDC REALGraphicsDC(REALgraphics context);
#endif

#if TARGET_WIN32
HWND REALGetControlHWND(REALcontrolInstance control);
#endif

#if COCOA
CGContextRef REALGraphicsCGContext(REALgraphics context);
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !(COCOA)
void REALSelectGraphics(REALgraphics context);
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !COCOA
void REALGraphicsDrawOffscreenMacControl(REALgraphics context, ControlHandle mh);
#endif

void REALInvalidateControl(REALcontrolInstance instance);

void REALInvalidateControlRect(REALcontrolInstance instance, int left, int top, int right, int bottom);

#if TARGET_WIN32
void REALSetSpecialBackground(REALcontrolInstance instance, COLORREF *pcolor);
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !COCOA
void REALSetSpecialBackground(REALcontrolInstance instance);
#endif

REALwindow REALGetControlWindow(REALcontrolInstance instance);

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
REALsound REALBuildSoundFromHandle(Handle sound, Boolean bPassOwnership);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
REALappleEvent REALBuildAppleEvent(const AppleEvent *event, Boolean bPassOwnership);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
REALappleEvent REALBuildAEDescList(const AppleEvent *event, Boolean bPassOwnership);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
REALappleEvent REALBuildAEObjSpecifier(const AppleEvent *event, Boolean bPassOwnership);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
AppleEvent *REALAccessAppleEvent(REALappleEvent event);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
AppleEvent *REALAccessAppleEventReply(REALappleEvent event);
#endif

#if TARGET_COCOA
	NSWindow *REALGetWindowHandle(REALwindow window);
#elif TARGET_68K || TARGET_PPC || TARGET_CARBON
WindowPtr REALGetWindowHandle(REALwindow window);
#endif

#if TARGET_COCOA
	NSView *REALGetControlHandle(REALcontrolInstance control);
#elif TARGET_68K || TARGET_PPC || TARGET_CARBON
ControlHandle REALGetControlHandle(REALcontrolInstance control);
#endif

#if (TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
MenuHandle REALGetPopupMenuHandle(REALpopupMenu popup);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
QT_NAMESPACE MovieController REALgetMoviePlayerController(REALmoviePlayer instance);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
QT_NAMESPACE Movie REALgetMovieMovie(REALmovie instance);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_COCOA
REALmovie REALbuildMovie(QT_NAMESPACE Movie movie, int resRefNum, int bNew);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_COCOA
void REALmarkMovieDirty(REALmovie movie);
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
int REALenterMovies(void);
#endif

REALobject REALnewInstance(const char *className);

void REALMarkSocketUsage(void);

void REALSocketConnect(REALsocket socket, REALstring address, int port);

void REALSocketClose(REALsocket socket);

REALstring REALSocketReadAll(REALsocket socket);

REALstring REALSocketRead(REALsocket socket, int count);

void REALSocketWrite(REALsocket socket, REALstring data);

int REALSocketLastErrorCode(REALsocket socket, int unused);

REALstring REALSocketLookahead(REALsocket socket, int unused);

REALstring REALSocketLocalAddressGetter(REALsocket socket);

void REALSocketPoll(REALsocket socket);

int REALSocketGetEvents(REALsocket socket, int unused);

void REALRegisterDataSourceInterface(const char *szMenuName, REALDataSourceInterfaceProc proc);

void REALRegisterDataSource(const char *szDatasourceName, REALDataSourceProc proc);

void REALDesignAddDataSource(const char *baseName, const char *szDataSourceName, Ptr data, int dataLen);

void REALMessageBox(REALstring text);

#if TARGET_WIN32
REALpicture REALBuildPictureFromDIB(HANDLE hDIB, Boolean bPassOwnership);
#endif

void REALSetControlEnabled(REALcontrolInstance instance, long unused, Boolean enable);

long REALGetControlPosition(REALcontrolInstance instance, long which);

void REALSetControlPosition(REALcontrolInstance instance, long which, long value);

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALRefreshWindow(unsigned long macWindowPtr);
#endif

REALgraphics REALGetPictureGraphics(REALpicture picture);

REALpicture REALNewPicture(long width, long height, long depth);

REALmemoryBlock REALNewMemoryBlock(int bytes);

void*REALMemoryBlockGetPtr(REALmemoryBlock memBlock);

int REALMemoryBlockGetSize(REALmemoryBlock memBlock);

REALmemoryBlock REALPtrToMemoryBlock(void*data);

#if TARGET_WIN32 || X_WINDOW
void REALSetAccelerator(REALcontrolInstance instance, REALstring key);
#endif

double REALGetRBVersion(void);

void REALRaiseException(REALobject exception);

int REALGetArrayUBound(void*array);

int REALGetArrayInt(REALintArray array, int index);

REALstring REALGetArrayString(REALstringArray array, int index);

REALobject REALGetArrayObject(REALobjectArray array, int index);

void REALGetArrayStructure( REALstructureArray array, int index, void *structure );

long REALGetTabPanelVisible(REALcontrolInstance instance);

#if TARGET_WIN32
HWND REALGetControlHandle(REALcontrolInstance control);
#endif

#if TARGET_WIN32
HWND REALGetWindowHandle(REALwindow window);
#endif

Boolean REALGetControlFocus(REALcontrolInstance instance);

void REALSetControlFocus(REALcontrolInstance instance, Boolean focus);

void REALYieldToRB(void);

REALclassRef REALGetClassRef(const char *className);

#if FLAT_C_PLUGIN_HEADERS
	REALobject REALnewInstanceWithClass( REALclassRef classRef );
#else
REALobject REALnewInstance(REALclassRef classRef);
#endif

void REALRegisterInterface(REALinterfaceDefinition *defn);

REALcontrolInstance REALGetControlParent(REALcontrolInstance instance);

REALstring REALGetDBHost(REALdbDatabase db);

REALstring REALGetDBDatabaseName(REALdbDatabase db);

REALstring REALGetDBPassword(REALdbDatabase db);

REALstring REALGetDBUserName(REALdbDatabase db);

dbDatabase *REALGetDBFromREALdbDatabase(REALdbDatabase db);

void REALConstructDBDatabase(REALdbDatabase db, dbDatabase *mydb, REALdbEngineDefinition *engine);

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
void REALSetMovieMovie(REALmovie obj, Movie movie);
#endif

unsigned long REALGetStringEncoding(REALstring str);

void REALSetStringEncoding(REALstring str, unsigned long encoding);

#if TARGET_PPC || TARGET_CARBON || TARGET_COCOA
Boolean REALFSRefFromFolderItem(REALfolderItem f, FSRef*outRef, HFSUniStr255*outName);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_COCOA
	#if FLAT_C_PLUGIN_HEADERS
		REALfolderItem REALFolderItemFromParentFSRef(const FSRef *parent, const HFSUniStr255 *fileName);
	#else
REALfolderItem REALFolderItemFromParentFSRef(const FSRef& parent, const HFSUniStr255& fileName);
#endif
#endif

REALDBConnectionDialogRef REALDBConnectionDialogCreate(void);

void REALDBConnectionDialogAddField(REALDBConnectionDialogRef dialogRef, REALstring label, REALstring defaultText, Boolean maskField);

REALstring REALDBConnectionDialogShow(REALDBConnectionDialogRef dialogRef, REALstring title);

void REALDBConnectionDialogDelete(REALDBConnectionDialogRef dialogRef);

REALstring REALGetControlName(REALcontrolInstance control);

Boolean REALIsHIViewWindow(REALwindow window);

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
REALpicture REALBuildPictureFromBuffer(long width, long height, RBPixelType pixelType, void*buffer, long rowBytes);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
unsigned long REALGetFontEncoding(const char *fontName);
#endif

REALstring REALConvertString(REALstring str, unsigned long encoding);

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
REALpicture REALGetPictureMask(REALpicture pict, Boolean createIfNil);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
Boolean REALInDebugMode(void);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALGraphicsDrawString(REALgraphics graphics, REALstring str, long x, long y, long width);
#endif

#if TARGET_CARBON || TARGET_COCOA
CFStringRef REALGetStringCFString(REALstring str, Boolean stripAmpersands);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_COCOA
void REALGetStringSystemStr(REALstring str, Boolean stripAmpersands, Str255 outStr255);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALGetGraphicsFontStyle(REALgraphics graphics, REALfontStyle*  outStyle);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALSetGraphicsStyle(REALgraphics graphics, REALfontStyle*  styleInfo);
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALStripAmpersands(REALstring*  ioString);
#endif

long REALGraphicsStringWidth(REALgraphics graphics, REALstring str);

long REALGraphicsStringHeight(REALgraphics graphics, REALstring str, long wrapWidth);

long REALGraphicsTextHeight(REALgraphics graphics);

long REALGraphicsTextAscent(REALgraphics graphics);

#if (TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALReleasePopupMenuHandle(REALpopupMenu popup);
#endif

void REALSocketListen(REALsocket socket);

REALfolderItem REALGetProjectFolder(void);

#if X_WINDOW
unsigned long REALGetControlHandle(REALcontrolInstance control);
#endif

#if X_WINDOW
unsigned long REALGraphicsDC(REALgraphics context);
#endif

#if X_WINDOW
void REALDrawPicturePrimitive(REALgraphics context, REALpicture pic, const Rect *rBounds, int bTransparent);
#endif

void REALRegisterModule(REALmoduleDefinition*defn);

void*REALLoadGlobalMethod(const char *module, const char *prototype);

void*REALLoadObjectMethod(REALobject object, const char *prototype);

#if FLAT_C_PLUGIN_HEADERS
	Boolean REALGetPropValueInt64(REALobject object, const char *propName, long long *value);
	Boolean REALGetPropValueUInt64(REALobject object, const char *propName, unsigned long long *value);
	Boolean REALGetPropValueInt32(REALobject object, const char *propName, long *outValue);
	Boolean REALGetPropValueUInt32(REALobject object, const char *propName, unsigned long *value);
	Boolean REALGetPropValueInt16(REALobject object, const char *propName, short *value);
	Boolean REALGetPropValueUInt16(REALobject object, const char *propName, unsigned short *value);
	Boolean REALGetPropValueInt8(REALobject object, const char *propName, char *value);
	Boolean REALGetPropValueUInt8(REALobject object, const char *propName, unsigned char *value);
	Boolean REALGetPropValueDouble(REALobject object, const char *propName, double *outValue);
	Boolean REALGetPropValueSingle(REALobject object, const char *propName, float *value);
	Boolean REALGetPropValueString(REALobject object, const char *propName, REALstring *outValue);
	Boolean REALGetPropValueObject(REALobject object, const char *propName, REALobject *outValue);

	#if TARGET_WIN32
		REALgraphics REALGetControlGraphicsWithDC(REALcontrolInstance instance, HDC dc);
	#endif
#else
	Boolean REALGetPropValue(REALobject object, const char *propName, long *outValue);
	Boolean REALGetPropValue(REALobject object, const char *propName, REALstring *outValue);
	Boolean REALGetPropValue(REALobject object, const char *propName, double *outValue);
	Boolean REALGetPropValue(REALobject object, const char *propName, REALobject *outValue);
	Boolean REALGetPropValue(REALobject object, const char *propName, long long *value);
	Boolean REALGetPropValue(REALobject object, const char *propName, unsigned long long *value);
	Boolean REALGetPropValue(REALobject object, const char *propName, unsigned long *value);
	Boolean REALGetPropValue(REALobject object, const char *propName, unsigned short *value);
	Boolean REALGetPropValue(REALobject object, const char *propName, short *value);
	Boolean REALGetPropValue(REALobject object, const char *propName, unsigned char *value);
	Boolean REALGetPropValue(REALobject object, const char *propName, char *outValue);
	Boolean REALGetPropValue(REALobject object, const char *propName, float *value);

	#if TARGET_WIN32
		REALgraphics REALGetControlGraphics(REALcontrolInstance instance, HDC dc);
	#endif
#endif

void REALSetDBIsConnected(REALdbDatabase database, Boolean connected);

REALobject REALNewVariantString(REALstring value);

REALobject REALNewVariantInteger(long value);

REALobject REALNewVariantDouble(double value);

REALobject REALNewVariantBoolean(Boolean value);

REALobject REALNewVariantColor(long value);

#if FLAT_C_PLUGIN_HEADERS
	Boolean REALSetPropValueInt32(REALobject object, const char *propName, long value);
	Boolean REALSetPropValueString(REALobject object, const char *propName, REALstring value);
	Boolean REALSetPropValueDouble(REALobject object, const char *propName, double value);
	Boolean REALSetPropValueObject(REALobject object, const char *propName, REALobject value);
	Boolean REALSetPropValueBoolean(REALobject object, const char *propName, Boolean value);
	Boolean REALSetPropValueUInt32(REALobject object, const char *propName, unsigned long value);
	Boolean REALSetPropValueUInt64(REALobject object, const char *propName, unsigned long long value);
	Boolean REALSetPropValueInt64(REALobject object, const char *propName, long long value);
	Boolean REALSetPropValueInt16(REALobject object, const char *propName, short value);
	Boolean REALSetPropValueUInt16(REALobject object, const char *propName, unsigned short value);
	Boolean REALSetPropValueInt8(REALobject object, const char *propName, char value);
	Boolean REALSetPropValueUInt8(REALobject object, const char *propName, unsigned char value);
	Boolean REALSetPropValueSingle(REALobject object, const char *propName, float value);
#else
	Boolean REALSetPropValue(REALobject object, const char *propName, long value);
	Boolean REALSetPropValue(REALobject object, const char *propName, REALstring value);
	Boolean REALSetPropValue(REALobject object, const char *propName, double value);
	Boolean REALSetPropValue(REALobject object, const char *propName, REALobject value);
	Boolean REALSetPropValue(REALobject object, const char *propName, unsigned long value);
	Boolean REALSetPropValue(REALobject object, const char *propName, unsigned long long value);
	Boolean REALSetPropValue(REALobject object, const char *propName, long long value);
	Boolean REALSetPropValue(REALobject object, const char *propName, short value);
	Boolean REALSetPropValue(REALobject object, const char *propName, unsigned short value);
	Boolean REALSetPropValue(REALobject object, const char *propName, Boolean value);
	Boolean REALSetPropValue(REALobject object, const char *propName, char value);
	Boolean REALSetPropValueUInt8(REALobject object, const char *propName, unsigned char value);
	Boolean REALSetPropValue(REALobject object, const char *propName, float value);
#endif

#if X_WINDOW
void *REALGraphicsGdkDrawable(REALgraphics context);
#endif

dbCursor *REALGetCursorFromREALdbCursor(REALdbCursor cursor);

Boolean REALLockPictureDescription(REALpicture pic, REALpictureDescription *description, long picType);
#if !FLAT_C_PLUGIN_HEADERS
	void REALLockPictureDescription(REALpicture pic, REALpictureDescription *description);
#else
	void REALLockPictureDescriptionWithNativeType(REALpicture pic, REALpictureDescription *description);	
#endif

#if X_WINDOW
unsigned long REALGetWindowHandle(REALwindow window);
#endif

void REALGetGraphicsOrigin(REALgraphics context, long *originX, long *originY);

void REALSetGraphicsOrigin(REALgraphics context, long originX, long originY);

#if TARGET_CARBON || TARGET_WIN32 || X_WINDOW
void SetClassConsoleSafe(REALclassDefinition def);
#endif

REALobject REALNewVariantUInt32(unsigned long value);

REALobject REALNewVariantInt64(long long value);

REALobject REALNewVariantUInt64(unsigned long long value);

REALobject REALNewVariantSingle(float value);

REALobject REALNewVariantCurrency(REALcurrency value);

// **** Autogenerated code from Plugin API Manager ends here ****
// **************** Do not edit above this line *****************

long REALstringToOSType(REALstring id);

#if FLAT_C_PLUGIN_HEADERS && defined(__cplusplus)
	}
#endif

#endif
