/* stringStuff.cp */

#include "typedef.h"
#include "stringStuff.h"
#include "reduce.h"
#include "fractions.h"
#include "MKS.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>

using namespace std;

static int prec = 7;

void setPrec(int newPrec)
{
	if(newPrec<3)
	{
		prec = 3;
		return;
	}
	
	if(newPrec>15)
	{
		prec = 15;
		return;
	}
	
	prec = newPrec;
	
}/* setPrec */


int getPrec()
{
	return prec;
	
}/* getPrec */



// s1 contains the possibly prefixed unit; s2 contains a possible prefix
// returns false if s1 has the same number of characters as s2, or if s1 has only one character
// returns false if index of first character which doesn't compare is zero or unequal to length of s2
// returns true otherwise
// if it has match to s2 prefix, s1 is returned without the prefix
static bool processMetricUnit(char* s1, char* s2)
{
	long		i, len1, len2;
	
	len1 = strlen(s1);
	if(len1==0)
		return false;
	
	len2 = strlen(s2);
	if(len2>=len1)
		return false;
	
	for(i=0;i<len2;i++)
		if(s1[i]!=s2[i])
			break;
			
	if(i==len2)
	{
		// remove prefix
		for(i=0;i<=len1-len2;i++)
			s1[i] = s1[i+len2];
		
		return true;
	}
		
	return false;

}/*  processMetricUnit */

/*
	returnPrefixValue:
	
	dataString will contain the possibly prefixed unit; it will return without any prefix
	
Prefix:
	
Symbol:
Magnitude:
Meaning (multiply by):

Yotta-
 Y
10^24

Zetta-
 Z
10^21

 Exa-
 E
10^18

 Peta-
 P
10^15

 Tera-
 T
10^12

 Giga-
 G
10^9

 Mega-
 M
10^6

 kilo-
 k
10^3

 hecto-
 h
10^2

 deka-
 da
10

-

 deci-
 d
10^-1

 centi-
 c
10^-2

 milli-
 m
10^-3

 micro-
 u (mu)
10^-6

 nano-
 n
10^-9

 pico-
 p
10^-12

 femto-
 f
10^-15

 atto-
 a
10^-18

 zepto-
 z
10^-21

 yocto-
 y
10^-24

*/
static double returnPrefixValue(char* dataString)
{
	long		i, length;
	
	if(processMetricUnit(dataString, "Yotta") || processMetricUnit(dataString, "Y"))
		return 1e24;

	
	if(processMetricUnit(dataString, "Zetta") || processMetricUnit(dataString, "Z"))
		return 1e21;

	
	if(processMetricUnit(dataString, "Exa") || processMetricUnit(dataString, "E"))
		return 1e18;
	
	
	if(processMetricUnit(dataString, "Peta") || processMetricUnit(dataString, "P"))
		return 1e15;
	
	
	if(processMetricUnit(dataString, "Tera") || processMetricUnit(dataString, "T"))
		return 1e12;
	
	
	if(processMetricUnit(dataString, "Giga") || processMetricUnit(dataString, "G"))
		return 1e9;
	
	
	if(processMetricUnit(dataString, "Mega") || processMetricUnit(dataString, "M"))
		return 1e6;
	
	
	if(processMetricUnit(dataString, "kilo") || processMetricUnit(dataString, "k"))
		return 1e3;
	
	
	if(processMetricUnit(dataString, "hecto") || processMetricUnit(dataString, "h"))
		return 1e2;
	
	
	if(processMetricUnit(dataString, "deka") || processMetricUnit(dataString, "da"))
		return 1e1;
	
	
	if(processMetricUnit(dataString, "deci") || processMetricUnit(dataString, "d"))
		return 1e-1;
	
	
	if(processMetricUnit(dataString, "centi") || processMetricUnit(dataString, "c"))
		return 1e-2;
		
	
	if(processMetricUnit(dataString, "micro"))
		return 1e-6;
		
		
	if(((long)dataString[0])==-62) // RB's  occupies two bytes (-62, -75)
	{
		length = strlen(dataString);
		for(i=0;i<length-1;i++)
			dataString[i] = dataString[i+2];
			
		return 1e-6;
	}
		
	
	if(processMetricUnit(dataString, "milli") || processMetricUnit(dataString, "m"))
		return 1e-3;
	
	
	if(processMetricUnit(dataString, "nano") || processMetricUnit(dataString, "n"))
		return 1e-9;
	
	
	if(processMetricUnit(dataString, "pico") || processMetricUnit(dataString, "p"))
		return 1e-12;
	
	
	if(processMetricUnit(dataString, "femto") || processMetricUnit(dataString, "f"))
		return 1e-15;
	
	
	if(processMetricUnit(dataString, "atto") || processMetricUnit(dataString, "a"))
		return 1e-18;
	
	
	if(processMetricUnit(dataString, "zepto") || processMetricUnit(dataString, "z"))
		return 1e-21;
	
	
	if(processMetricUnit(dataString, "yocto") || processMetricUnit(dataString, "y"))
		return 1e-24;
	
	return 1;
	
}/* returnPrefixValue */


static char* toLowerCase(char* theString)
{
	long		i, length;
	
	length = strlen(theString);
	
	for(i=0;i<length;i++)
	{
		if(theString[i]>='A' && theString[i]<='Z')
			theString[i] = theString[i] + 'a' - 'A';
	}
	
	return theString;
	
}/* toLowerCase */


static bool slashIsNext(char* theString, long index)
{
	char		ch;
	
	// allow leading spaces
	ch = theString[index];
	while(ch==' ')
		ch = theString[++index];
		
	if(ch=='/')
		return true;
	
	return false;
	
}/* slashIsNext */

static bool slashNumberIsNext(char* theString, long index)
{
	char		ch;
	
	// allow leading spaces
	ch = theString[index];
	while(ch==' ')
		ch = theString[++index];
		
	if(ch=='/')
	{
		// is a number next?
		ch = theString[++index];
		while(ch==' ')
			ch = theString[++index];
			
		if(ch>='0' && ch<='9')
			return true;
		else
			return false;
	}
	else
		return false;
	
}/* slashNumberIsNext */


static bool alphaIsNext(char* theString, long index)
{
	char		ch;
	
	// allow leading spaces
	ch = theString[index];
	while(ch==' ')
		ch = theString[++index];
		
	if((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ((long)ch)==-62 || ((long)ch)==-50)  //  and 
		return true;
	
	return false;
	
}/* alphaIsNext */


static bool caretNext(char* theString, long index)
{
	char		ch;
	
	// allow leading spaces
	ch = theString[index];
	while(ch==' ')
		ch = theString[++index];
		
	if(ch=='^')
		return true;
	
	return false;

}/* caretNext */


static bool endOfStringNext(char* theString, long index)
{
	char		ch;
	
	// allow leading spaces
	ch = theString[index];
	while(ch==' ')
		ch = theString[++index];
		
	if(ch==0)
		return true;
	
	return false;
	
}/* endOfStringNext */



static bool signedNumberIsNext(char* theString, long index)
{
	char		ch;
	
	// allow leading spaces
	ch = theString[index];
	while(ch==' ')
		ch = theString[++index];
		
	// allow one + or -
	if(ch=='+' || ch=='-')
		ch = theString[++index];
	
	// allow spaces
	while(ch==' ')
		ch = theString[++index];
		
	// see if it's a number
	if(ch>='0' && ch<='9')
		return true;
	
	return false;
	
}/* signedNumberIsNext */



static bool UnsignedNumberIsNext(char* theString, long index)
{
	char		ch;
	
	// allow leading spaces
	ch = theString[index];
	while(ch==' ')
		ch = theString[++index];
		
	// see if it's a number
	if(ch>='0' && ch<='9')
		return true;
	
	return false;
	
}/* UnsignedNumberIsNext */



/*
	handleNonMetric:
	completely handles the situation for a non-metric unit without prefix
	
*/
static bool handleNonMetric(MKSdata& z, char* theUnit, fract unitFract)
{
	fract			tempFract;
	
	theUnit = toLowerCase(theUnit);
	
	if(strcmp(theUnit, "nauticalmile")==0 || strcmp(theUnit, "nauticalmiles")==0)
	{
		z.value = z.value*pow(1852, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "cubit")==0 || strcmp(theUnit, "cubits")==0)
	{
		z.value = z.value*pow(0.525, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "furlong")==0 || strcmp(theUnit, "furlongs")==0)
	{
		z.value = z.value*pow(201.168, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "smoot")==0 || strcmp(theUnit, "smoots")==0)
	{
		z.value = z.value*pow(1.7018, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "bohr")==0 || strcmp(theUnit, "bohrs")==0)
	{
		z.value = z.value*pow(5.2917720859e-11, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "knot")==0 || strcmp(theUnit, "knots")==0)
	{
		z.value = z.value*pow(.5144444444444444, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		
		return true;
	}
	
	if(strcmp(theUnit, "mph")==0)
	{
		z.value = z.value*pow(.44704, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		
		return true;
	}
	
	
	if(strcmp(theUnit, "gee")==0 || strcmp(theUnit, "gees")==0 || strcmp(theUnit, "grav")==0 || strcmp(theUnit, "gravs")==0)
	{
		
		add(z.unit[0], z.unit[0], unitFract);
		z.value = z.value*pow(9.80665, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "newton")==0 || strcmp(theUnit, "newtons")==0)
	{
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "dyne")==0 || strcmp(theUnit, "dynes")==0)
	{
		z.value = z.value*pow(1e-5, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "meter")==0 || strcmp(theUnit, "meters")==0)
	{
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "kilometer")==0 || strcmp(theUnit, "kilometers")==0)
	{
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "decimeter")==0 || strcmp(theUnit, "decimeters")==0)
	{
		z.value = z.value*pow(1e-1, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "centimeter")==0 || strcmp(theUnit, "centimeters")==0)
	{
		z.value = z.value*pow(1e-2, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "millimeter")==0 || strcmp(theUnit, "millimeters")==0)
	{
		z.value = z.value*pow(1e-3, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "gm")==0 || strcmp(theUnit, "gms")==0 || strcmp(theUnit, "gram")==0 || strcmp(theUnit, "grams")==0)
	{
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "slug")==0 || strcmp(theUnit, "slugs")==0)
	{
		z.value = z.value*pow(14593.9, (double)unitFract.num/unitFract.den);
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "u")==0 || strcmp(theUnit, "amu")==0)
	{
		z.value = z.value*pow(1.66053886e-24, (double)unitFract.num/unitFract.den);
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "coulomb")==0 || strcmp(theUnit, "coulombs")==0)
	{
		add(z.unit[3], z.unit[3], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "e")==0)
	{
		z.value = z.value*pow(1.6021776462e-19, (double)unitFract.num/unitFract.den);
		add(z.unit[3], z.unit[3], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "fd")==0 || strcmp(theUnit, "faraday")==0 || strcmp(theUnit, "faradays")==0)
	{
		z.value = z.value*pow(96485.4127862, (double)unitFract.num/unitFract.den);
		add(z.unit[3], z.unit[3], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "amp")==0 || strcmp(theUnit, "amps")==0 || strcmp(theUnit, "ampere")==0 || strcmp(theUnit, "amperes")==0)
	{
		add(z.unit[3], z.unit[3], unitFract);
		sub(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "farad")==0 || strcmp(theUnit, "farads")==0)
	{
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[1], z.unit[1], tempFract);
		z.value = z.value*pow(1e3, (double)tempFract.num/tempFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "henry")==0 || strcmp(theUnit, "henries")==0)
	{
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "tesla")==0 || strcmp(theUnit, "teslas")==0)
	{
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "gauss")==0)
	{
		z.value = z.value*pow(1e-4, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "kelvin")==0 || strcmp(theUnit, "kelvins")==0 || strcmp(theUnit, "cdeg")==0 || strcmp(theUnit, "cdegs")==0)
	{
		add(z.unit[4], z.unit[4], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "fdeg")==0 || strcmp(theUnit, "fdegs")==0)
	{
		z.value = z.value*pow(5./9., (double)unitFract.num/unitFract.den);
		add(z.unit[4], z.unit[4], unitFract);
		return true;
	}
	

	if(strcmp(theUnit, "dollar")==0 || strcmp(theUnit, "dollars")==0)
	{
		add(z.unit[5], z.unit[5], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "cent")==0 || strcmp(theUnit, "cents")==0)
	{
		z.value = z.value*pow(.01, (double)unitFract.num/unitFract.den);
		add(z.unit[5], z.unit[5], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "micron")==0 || strcmp(theUnit, "microns")==0)
	{
		z.value = z.value*pow(1e-6, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "angstrom")==0 || strcmp(theUnit, "angstroms")==0)
	{
		z.value = z.value*pow(1e-10, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "in")==0 || strcmp(theUnit, "inch")==0 || strcmp(theUnit, "inches")==0)
	{
		z.value = z.value*pow(.0254, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "ft")==0 || strcmp(theUnit, "foot")==0 || strcmp(theUnit, "feet")==0)
	{
		z.value = z.value*pow(.3048, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "yd")==0 || strcmp(theUnit, "yds")==0 ||strcmp(theUnit, "yard")==0 || strcmp(theUnit, "yards")==0)
	{
		z.value = z.value*pow(.9144, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "mi")==0 || strcmp(theUnit, "mile")==0 || strcmp(theUnit, "miles")==0)
	{
		z.value = z.value*pow(1609.344, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "ltyr")==0 || strcmp(theUnit, "ltyrs")==0 || strcmp(theUnit, "lightyear")==0 || strcmp(theUnit, "lightyears")==0)
	{
		z.value = z.value*pow(9.460528404879359e15, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "parsec")==0 || strcmp(theUnit, "parsecs")==0)
	{
		z.value = z.value*pow(3.085678e16, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "au")==0 || strcmp(theUnit, "aus")==0)
	{
		z.value = z.value*pow(1.49597870691e11, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "sec")==0 ||strcmp(theUnit, "secs")==0 || strcmp(theUnit, "second")==0 || strcmp(theUnit, "seconds")==0)
	{
		add(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "min")==0 || strcmp(theUnit, "minute")==0 || strcmp(theUnit, "minutes")==0)
	{
		z.value = z.value*pow(60, (double)unitFract.num/unitFract.den);
		add(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "hr")==0 || strcmp(theUnit, "hrs")==0 || strcmp(theUnit, "hour")==0 || strcmp(theUnit, "hours")==0)
	{
		z.value = z.value*pow(3600, (double)unitFract.num/unitFract.den);
		add(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "day")==0 || strcmp(theUnit, "days")==0)
	{
		z.value = z.value*pow(86400, (double)unitFract.num/unitFract.den);
		add(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "wk")==0 || strcmp(theUnit, "wks")==0 || strcmp(theUnit, "week")==0 || strcmp(theUnit, "weeks")==0)
	{
		z.value = z.value*pow(604800, (double)unitFract.num/unitFract.den);
		add(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "yr")==0 || strcmp(theUnit, "yrs")==0 || strcmp(theUnit, "year")==0 || strcmp(theUnit, "years")==0)
	{
		z.value = z.value*pow(31556925.9747, (double)unitFract.num/unitFract.den);
		add(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "oz")==0 || strcmp(theUnit, "ounce")==0 || strcmp(theUnit, "ounces")==0)
	{
		z.value = z.value*pow(28.349523125, (double)unitFract.num/unitFract.den);
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "lb")==0 || strcmp(theUnit, "lbs")==0 || strcmp(theUnit, "pound")==0 || strcmp(theUnit, "pounds")==0)
	{
		z.value = z.value*pow(453.59237, (double)unitFract.num/unitFract.den);
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "ton")==0 || strcmp(theUnit, "tons")==0)
	{
		z.value = z.value*pow(907184.74, (double)unitFract.num/unitFract.den);
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "tonne")==0 || strcmp(theUnit, "tonnes")==0)
	{
		z.value = z.value*pow(1e6, (double)unitFract.num/unitFract.den);
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "lbf")==0)
	{
		
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(4.44822162e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "kilopound")==0 || strcmp(theUnit, "kilopounds")==0 || strcmp(theUnit, "kip")==0)
	{
		
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(4.44822162e6, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "tonf")==0)
	{
		
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(8896.44324e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}

	
	if(strcmp(theUnit, "kgf")==0)
	{
		
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(9.80665e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "tonnef")==0)
	{
		
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(9.80665e6, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "poundal")==0 || strcmp(theUnit, "poundals")==0)
	{
		
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(0.138254954376e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "pascal")==0 || strcmp(theUnit, "pascals")==0)
	{
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	 
	
	/*
	if(strcmp(theUnit, "mpa")==0 || strcmp(theUnit, "mpascal")==0 || strcmp(theUnit, "mpascals")==0)
	{
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e9, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	*/
	
	
	if(strcmp(theUnit, "atm")==0 || strcmp(theUnit, "atms")==0)
	{
		z.value = z.value*pow(101325, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "bar")==0 || strcmp(theUnit, "bars")==0)
	{
		z.value = z.value*pow(1e5, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "torr")==0 || strcmp(theUnit, "torrs")==0)
	{
		z.value = z.value*pow(133.3223684210526, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "mmmercury")==0 || strcmp(theUnit, "mmhg")==0)
	{
		z.value = z.value*pow(133.3223684210526, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "inmercury")==0 || strcmp(theUnit, "inhg")==0)
	{
		z.value = z.value*pow(3386.388157894736, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "psi")==0)
	{
		z.value = z.value*pow(6.8947573005146e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "ksf")==0)
	{
		z.value = z.value*pow(47880.257, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "ksi")==0)
	{
		z.value = z.value*pow(332.5017847222222, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "deg")==0 || strcmp(theUnit, "degree")==0 || strcmp(theUnit, "degrees")==0)
	{
		z.value = z.value*pow(0.0174532925199433, (double)unitFract.num/unitFract.den);
		add(z.unit[6], z.unit[6], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "arcminute")==0 || strcmp(theUnit, "arcminutes")==0)
	{
		z.value = z.value*pow(2.908882086657216e-4, (double)unitFract.num/unitFract.den);
		add(z.unit[6], z.unit[6], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "arcsecond")==0 || strcmp(theUnit, "arcseconds")==0)
	{
		z.value = z.value*pow(4.84813681109536e-6, (double)unitFract.num/unitFract.den);
		add(z.unit[6], z.unit[6], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "sqdeg")==0 || strcmp(theUnit, "sqdegs")==0)
	{
		z.value = z.value*pow(3.046174197867086e-4, (double)unitFract.num/unitFract.den);
		add(z.unit[7], z.unit[7], unitFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "cd")==0 || strcmp(theUnit, "candela")==0 || strcmp(theUnit, "candelas")==0)
	{
		add(z.unit[8], z.unit[8], unitFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[7], z.unit[7], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "hz")==0 || strcmp(theUnit, "hertz")==0 || strcmp(theUnit, "cps")==0 || strcmp(theUnit, "rps")==0)
	{
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "rpm")==0 || strcmp(theUnit, "cpm")==0)
	{
		z.value = z.value*pow(1./60., (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}

	
	//1 horsepower = 745.699872 Watts
	if(strcmp(theUnit, "hp")==0 || strcmp(theUnit, "horsepower")==0)
	{
		z.value = z.value*pow(745.699872, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -3;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "btu")==0)
	{
		z.value = z.value*pow(1055.05585, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "ev")==0)
	{
		z.value = z.value*pow(1.60217733e-19, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "cal")==0 || strcmp(theUnit, "calorie")==0 || strcmp(theUnit, "calories")==0)
	{
		z.value = z.value*pow(4.184, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "kcal")==0 || strcmp(theUnit, "kilocalorie")==0 || strcmp(theUnit, "kilocalories")==0)
	{
		z.value = z.value*pow(4.184e3, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "tonstnt")==0 || strcmp(theUnit, "tontnt")==0)
	{
		z.value = z.value*pow(4.184e9, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "kilotonstnt")==0 || strcmp(theUnit, "kilotontnt")==0)
	{
		z.value = z.value*pow(4.184e12, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "megatonstnt")==0 || strcmp(theUnit, "megatontnt")==0)
	{
		z.value = z.value*pow(4.184e15, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "gigatonstnt")==0 || strcmp(theUnit, "gigatontnt")==0)
	{
		z.value = z.value*pow(4.184e18, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "acre")==0 || strcmp(theUnit, "acres")==0)
	{
		z.value = z.value*pow(4046.8564224, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "RI")==0 || strcmp(theUnit, "RhodeIsland")==0 || strcmp(theUnit, "RhodeIslands")==0)
	{
		z.value = z.value*pow(4.0e9, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "hectare")==0 || strcmp(theUnit, "hectares")==0)
	{
		z.value = z.value*pow(1e4, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "gal")==0 || strcmp(theUnit, "gallon")==0 || strcmp(theUnit, "gallons")==0)
	{
		z.value = z.value*pow(3.79e-3, (double)unitFract.num/unitFract.den);
		tempFract.num = 3;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "floz")==0)
	{
		z.value = z.value*pow(29.5735295625e-6, (double)unitFract.num/unitFract.den);
		tempFract.num = 3;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "poise")==0 || strcmp(theUnit, "p")==0)
	{
		z.value = z.value*pow(100,(double)unitFract.num/unitFract.den);
		add(z.unit[1], z.unit[1], unitFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "stokes")==0 || strcmp(theUnit, "st")==0)
	{
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	

	return false;

}/* handleNonMetric */


/*
	handleMetric:
	completely handles the situation for a metric unit
	the prefix has been taken care of with returnPrefixValue, so theUnit just holds a metric unit without prefix
	
*/
static bool handleMetric(MKSdata& z, char* theUnit, fract unitFract)
{
	fract			tempFract;

	theUnit = toLowerCase(theUnit);
	
	if(strcmp(theUnit, "m")==0 || strcmp(theUnit, "meter")==0 || strcmp(theUnit, "meters")==0)
	{
		add(z.unit[0], z.unit[0], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "g")==0 || strcmp(theUnit, "gm")==0 || strcmp(theUnit, "gms")==0 || strcmp(theUnit, "gram")==0 || strcmp(theUnit, "grams")==0)
	{
		add(z.unit[1], z.unit[1], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "s")==0 || strcmp(theUnit, "sec")==0 || strcmp(theUnit, "secs")==0 || strcmp(theUnit, "second")==0 || strcmp(theUnit, "seconds")==0)
	{
		add(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "c")==0 || strcmp(theUnit, "coulomb")==0 || strcmp(theUnit, "coulombs")==0)
	{
		add(z.unit[3], z.unit[3], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "k")==0 || strcmp(theUnit, "kelvin")==0 || strcmp(theUnit, "kelvins")==0)
	{
		add(z.unit[4], z.unit[4], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "d")==0 || strcmp(theUnit, "dollar")==0 || strcmp(theUnit, "dollars")==0)
	{
		add(z.unit[5], z.unit[5], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "rad")==0 || strcmp(theUnit, "radian")==0 || strcmp(theUnit, "radians")==0)
	{
		add(z.unit[6], z.unit[6], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "sr")==0 || strcmp(theUnit, "steradian")==0 || strcmp(theUnit, "steradians")==0)
	{
		add(z.unit[7], z.unit[7], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "lm")==0 || strcmp(theUnit, "lumen")==0 || strcmp(theUnit, "lumens")==0)
	{
		add(z.unit[8], z.unit[8], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "a")==0 || strcmp(theUnit, "amp")==0 || strcmp(theUnit, "amps")==0 || strcmp(theUnit, "ampere")==0 || strcmp(theUnit, "amperes")==0)
	{
		add(z.unit[3], z.unit[3], unitFract);
		sub(z.unit[2], z.unit[2], unitFract);
		return true;
	}
	
	if(strcmp(theUnit, "n")==0 || strcmp(theUnit, "newton")==0 || strcmp(theUnit, "newtons")==0)
	{
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "dyne")==0 || strcmp(theUnit, "dynes")==0)
	{
		z.value = z.value*pow(1e-5, (double)unitFract.num/unitFract.den);
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "pascal")==0 || strcmp(theUnit, "pascals")==0)
	{
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "j")==0 || strcmp(theUnit, "joule")==0 || strcmp(theUnit, "joules")==0)
	{
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "w")==0 || strcmp(theUnit, "watt")==0 || strcmp(theUnit, "watts")==0)
	{
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -3;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "v")==0 || strcmp(theUnit, "volt")==0 || strcmp(theUnit, "volts")==0)
	{
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "f")==0 || strcmp(theUnit, "farad")==0 || strcmp(theUnit, "farads")==0)
	{
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[1], z.unit[1], tempFract);
		z.value = z.value*pow(1e3, (double)tempFract.num/tempFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(((long)theUnit[0])==-50 || strcmp(theUnit, "ohm")==0 || strcmp(theUnit, "ohms")==0)
	{
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "h")==0 || strcmp(theUnit, "henry")==0 || strcmp(theUnit, "henries")==0)
	{
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "t")==0 || strcmp(theUnit, "tesla")==0 || strcmp(theUnit, "teslas")==0)
	{
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "wb")==0 || strcmp(theUnit, "weber")==0 || strcmp(theUnit, "webers")==0)
	{
		add(z.unit[0], z.unit[0], unitFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "erg")==0 || strcmp(theUnit, "ergs")==0)
	{
		z.value = z.value*pow(1e-7, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "ev")==0)
	{
		z.value = z.value*pow(1.60217733e-19, (double)unitFract.num/unitFract.den);
		tempFract.num = 2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -2;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}
	
	
	if(strcmp(theUnit, "l")==0 || strcmp(theUnit, "liter")==0 || strcmp(theUnit, "liters")==0)
	{
		z.value = z.value*pow(1e-3, (double)unitFract.num/unitFract.den);
		tempFract.num = 3;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "gauss")==0)
	{
		z.value = z.value*pow(1e-4, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[0], z.unit[0], tempFract);
		add(z.unit[1], z.unit[1], unitFract);
		z.value = z.value*pow(1e3, (double)unitFract.num/unitFract.den);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[3], z.unit[3], tempFract);
		return true;
	}
	
	if(strcmp(theUnit, "hz")==0 || strcmp(theUnit, "hertz")==0 || strcmp(theUnit, "cps")==0)
	{
		tempFract.num = -1;
		tempFract.den = 1;
		mul(tempFract, tempFract, unitFract);
		add(z.unit[2], z.unit[2], tempFract);
		return true;
	}

	
	return false;

}/* handleMetric */




/*
	mergeUnit:
	
	dataString will contain the unit name
	unitFract will contain the fraction exponent
	There will be no spaces or parentheses.
	That data will be merged into z
	The first character of dataString will always be an alphabet character,
	which may be . We have to worry about Windows here.
	We'll allow prefixes.
	We have to worry about non-metric units

*/
static bool mergeUnit(MKSdata& z, char* dataString, fract unitFract)
{
	long		length;
	double		prefixValue;
	char		theUnit[256]; // prefix is never more than two characters
	
	// first we determine if the unit is non-metric, for which we do not allow a prefix
	
	// for each unit, first get the prefix and use returnPrefixValue
	// then strip off the prefix and get the base unit and its exponent,
	// merge with z, then return with proper bool value
	
	length = strlen(dataString);
	if(length==0 || length>255)
		return false;
		
	strcpy(theUnit, dataString);
		
	if(handleNonMetric(z, theUnit, unitFract))
		return true;
	
	// now we know we have metric unit, we use returnPrefixValue which strips off any prefix
	
	strcpy(theUnit, dataString);
	
	prefixValue = returnPrefixValue(theUnit);
	
	// adjust z.value using prefixValue and unitFract
	z.value = z.value*pow(prefixValue, (double)unitFract.num/unitFract.den);
	
	// now theUnit has a metric unit with no prefix
	
	return handleMetric(z, theUnit, unitFract);
	
}/* mergeUnit */



/*
	StrToMKS:
	
	converts C string to a MKSdata struct
	It is assumed that theString contains the value
	and its units, nothing else. No parentheses are allowed, and we parse from left to right.
	For example: 2e-10 m^-1/2 s^2 / kg^-3/2 J^2 (we'll accept spaces and dashes)
	Everything to the right of the second backslash is in the denominator
	Use mergeUnit for each unit and its exponent
 
*/
bool StrToMKS(MKSdata& z, char* theString)
{
	long		i, j, length;
	char		ch;
	char		*dataString, tempString[256];
	bool		inNumerator, isLeadingSpace;
	fract		unitFract;
	
	// initialize
	z.value = 0;
	isLeadingSpace = true;
	
	for(i=0;i<numUnits;i++)
	{
		z.unit[i].num = 0;
		z.unit[i].den = 1;
	}
	
	length = strlen(theString);
	if(length==0)
		return true; // interpret null string as dimensionless zero MKS
	
	// no parentheses allowed
	for(i=0;i<length;i++)
	{
		ch = theString[i];
		if(ch=='(' || ch==')')
			return false;
	}
		
	// skip leading spaces
	i = 0;
	ch = theString[i];
	while(ch==' ')
		ch = theString[++i];
	
	// skip to trailing space
	while(!(ch==' ') && i<length)
		ch = theString[++i];
	// coming out ch is space or 0 and i is its index and so the length to be copied
	
	// i comes out as length to be copied
	if(i==0)
		return true;  // interpret null string as dimensionless zero MKS
		
	dataString = (char *)malloc((length+1)*sizeof(char));
	
	strncpy(dataString, theString, i); // dataString is not null terminated
	dataString[i] = 0;
	
	// scan datastring for unwanted characters, return false if find one
	j = 0;
	ch = dataString[j];
	while(ch=='+' || ch=='-' || ch=='e' || ch=='E' || (ch>='0' && ch<='9') || ch=='.')
		ch = dataString[++j];
	
	if(!(j==i))
		return false;
	
	// get value; this should catch error in numeric part of entry, but it doesn't so I had to do this above
	if(!(sscanf(dataString, "%30lg", &z.value)==1))
	{
		free(dataString);
		return false;
	}
	
	// are their spaces?
	ch = theString[i];
	while(ch==' ' && i<length)
		ch = theString[++i];
	
	if(ch==0)
	{
		// there are no units
		free(dataString);
		return true;
	}
	
	// put the units with exponents into dataString in turn, without spaces or parentheses, and merge them using mergeUnit
	// until we encounter an '/' after a unit (or first before any unit)
	if(ch!='/')
	{
		inNumerator = true;
	}
	else
	{
		inNumerator = false;
		i++;
	}
	
	// we get one unit with each pass
	while(!endOfStringNext(theString, i))
	{
		j = 0;
		
		if(inNumerator)
		{
			if(slashIsNext(theString, i))
			{
				inNumerator = false;
				// are their spaces?
				ch = theString[i];
				while(ch==' ' && i<length)
					ch = theString[++i];
					
				// i points to slash
				i++;
			}
		}
		
		// must be alpha
		if(!alphaIsNext(theString, i))
		{
			free(dataString);
			return false;
		}
		
		ch = theString[i];
		while(ch==' ' && i<length)
			ch = theString[++i];
		while((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ((long)ch)==-62 || ((long)ch)==-75 || ((long)ch)==-50 || ((long)ch)==-87)  // RB's  and 
		{
			dataString[j++] = ch;
			ch = theString[++i];
		}
		dataString[j] = 0; // contains the unit name
		
		// ch now is not alpha
		if(!caretNext(theString, i))
		{
			// we have a unit with a fraction=1
			if(inNumerator)
				unitFract.num = 1;
			else
				unitFract.num = -1;
			
			unitFract.den = 1;
		}
		else
		{
			// we have a caret and a following fraction
			// are their spaces?
			ch = theString[i];
			while(ch==' ' && i<length)
				ch = theString[++i];
				
			// i now points to caret
			i++;
			
			if(!signedNumberIsNext(theString, i))
			{
				free(dataString);
				return false;
			}
			
			j = 0;
			// remove spaces
			ch = theString[i];
			while(ch==' ' && i<length)
				ch = theString[++i];
				
			while(ch=='+' || ch=='-' || (ch>='0' && ch<='9'))
			{
				tempString[j++] = ch;
				ch = theString[++i];
			}
			tempString[j] = 0;  // we have the numerator
			if(!(sscanf(tempString, "%d", &unitFract.num)==1))
			{
				free(dataString);
				return false;
			}
			if(!inNumerator)
				unitFract.num = -unitFract.num;
			
			if(!slashNumberIsNext(theString, i))
				unitFract.den = 1;
			else
			{
				// remove spaces
				ch = theString[i];
				while(ch==' ' && i<length)
					ch = theString[++i];
					
				i++; // past slash
					
				if(!UnsignedNumberIsNext(theString, i))
				{
					free(dataString);
					return false;
				}
				
				j = 0;
				
				// remove spaces
				ch = theString[i];
				while(ch==' ' && i<length)
					ch = theString[++i];
					
				while(ch>='0' && ch<='9')
				{
					tempString[j++] = ch;
					ch = theString[++i];
				}
				tempString[j] = 0;
				if(!(sscanf(tempString, "%d", &unitFract.den)==1))
				{
					free(dataString);
					return false;
				}
			}
		}
		
		 if(!mergeUnit(z, dataString, unitFract))
		 {
			 free(dataString);
			 return false;
		 }

	}
	
	free(dataString);
	
	return true;
	
}/* StrToMKS */


void MKStoStr(char* theString, MKSdata& z)
{
	long		i, length;
	char		dataString[1024];
	bool		isDen;
	char		myFormat[10] = "%.";
	char		myInt[5];
	
	sprintf(myInt, "%d", prec);
	strcat(myFormat, myInt);
	strcat(myFormat, "lg");
	
	isDen = false;
	z.value = z.value*pow(1e-3, (double)z.unit[1].num/z.unit[1].den);
	
	sprintf(theString, myFormat, z.value);  // was "%.7g" then "%30lg" then "%.7lg"
	
	for(i=0;i<numUnits;i++)
	{
		if(z.unit[i].num>=0)
		{
			if(z.unit[i].num!=0)
			{
				if(i==0)
					strcat(theString, " m");
				if(i==1)
					strcat(theString, " kg");
				if(i==2)
					strcat(theString, " s");
				if(i==3)
					strcat(theString, " C");
				if(i==4)
					strcat(theString, " K");
				if(i==5)
					strcat(theString, " D");
				if(i==6)
					strcat(theString, " rad");
				if(i==7)
					strcat(theString, " sr");
				if(i==8)
					strcat(theString, " lm");
				
				if(!(z.unit[i].num==1 && z.unit[i].den==1))
				{
					strcat(theString, "^");
					if(z.unit[i].den==1)
					{
						sprintf(dataString, "%d", z.unit[i].num);
						strcat(theString, dataString);
					}
					else
					{
						sprintf(dataString, "%d/%d", z.unit[i].num, z.unit[i].den);
						strcat(theString, dataString);
					}
				}
			}
		}
		else
			isDen = true;
	}
	
	if(isDen)
	{
		strcat(theString, "/");
		
		for(i=0;i<numUnits;i++)
		{
			if(z.unit[i].num<0)
			{
				if(i==0)
					strcat(theString, "m");
				if(i==1)
					strcat(theString, "kg");
				if(i==2)
					strcat(theString, "s");
				if(i==3)
					strcat(theString, "C");
				if(i==4)
					strcat(theString, "K");
				if(i==5)
					strcat(theString, "D");
				if(i==6)
					strcat(theString, "rad");
				if(i==7)
					strcat(theString, "sr");
				if(i==8)
					strcat(theString, "lm");
				
				if(!(z.unit[i].num==-1 && z.unit[i].den==1))
				{
					strcat(theString, "^");
					if(z.unit[i].den==1)
					{
						sprintf(dataString, "%d ", -z.unit[i].num);
						strcat(theString, dataString);
					}
					else
					{
						sprintf(dataString, "%d/%d ", -z.unit[i].num, z.unit[i].den);
						strcat(theString, dataString);
					}
				}
			}
		}
	}
	
	length = strlen(theString);
	// get rid of final space if there
	if(theString[length-1]==' ')
		theString[length-1] = 0;
	
}/* MKStoStr */

/*
	Here we take the non-null userUnitString and convert it to an MKSdata by using StrToMKS.
	We divide that into z. We check that all the exponents are zero. If so we construct theString easily, and return
	If not we concat theString with the MKS units using MKStoStr (in parentheses)
*/
bool MKStoStr2(char* theString, MKSdata& z, char* userUnitString)
{
	MKSdata			userMKS, y;
	char*			userString;
	long			i, length;
	bool			unitsRemain;
	char			myFormat[10] = "%.";
	char			myInt[5];
	
	sprintf(myInt, "%d", prec);
	strcat(myFormat, myInt);
	strcat(myFormat, "lg ");
	
	length = strlen(userUnitString);
	theString[0] = 0;
	
	if(length==0)
		return false;
	
	if(signedNumberIsNext(userUnitString, 0))
		return false;
	
	userString = (char*)malloc((length+64)*sizeof(char));  // was length + 4
	
	strcpy(userString, "1 ");
	strcat(userString, userUnitString);
	
	if(!StrToMKS(userMKS, userString))
	{
		free(userString);
		return false;
	}
	
	
	
	if(!divMKS(y, z, userMKS))
	{
		free(userString);
		return false;
	}
	
	sprintf(theString, myFormat, y.value);  // now "%.7lg" was "%.15lg "
	strcat(theString, userUnitString);
	
	unitsRemain = false;
	
	for(i=0;i<numUnits;i++)
	{
		if(y.unit[i].num!=0)
		{
			unitsRemain = true;
			break;
		}
	}
	
	if(unitsRemain)
	{
		// put theString in parentheses
		strcpy(userString, "(");
		strcat(userString, theString);
		strcat(userString, ")");
		strcpy(theString, userString);
		y.value = 1;
		MKStoStr(userString, y);
		strcat(theString, " X (");
		strcat(theString, userString);
		strcat(theString, ")");
	}
	
	free(userString);
	return true;
	
}/* MKStoStr2 */


bool StrToFract(fract& z, char* theString)
{
	char		ch;
	long		i, j, length;
	char		numString[255];
	bool		isNegative;
	long		aLong, intPart;
	
	isNegative = false;
	z.num = z.den = 0; // default
	intPart = 0;
	
	length = strlen(theString);
	if(length==0)
		return false;
	
	i = j = 0;
	
	// ignore leading spaces
	ch = ' ';
	while(ch==' ' && i<length)
	{
		ch = theString[i];
		i++;
	}
	
	if(i>=length)
	{
		if(ch==' ' || !(ch>='0' && ch<='9'))
			return false;
	}
	
	// now we can see +, -, or digit, nothing else
	if(!(ch=='+' || ch=='-' || (ch>='0' && ch<='9')))
		return false;
	
	// if + or - we can next see a space or a digit, and nothing else
	if(ch=='+' || ch=='-')
	{
		if(ch=='-')
			isNegative = true;
		
		// eliminate spaces
		ch = theString[i];
		i++;
		while(ch==' ' && i<length)
		{
			ch = theString[i];
			i++;
		}
		
		if(!(ch>='0' && ch<='9'))
			return false;
	}
	
	// get next digits, if they exist, and put into numString
	numString[j] = ch;
	j++;
	while((ch>='0' && ch<='9') && i<length)
	{
		ch = theString[i];
		i++;
		numString[j] = ch;
		j++;
	}
	
	numString[j] = 0; // terminate C string for first number
	j = 0; // ready for next long
	// convert it to aLong
	sscanf(numString, "%d", &aLong);
	
	// see if spaces after first number
	while(ch==' ' && i<length)
	{
		ch = theString[i];
		i++;
	}
	
	if(i>=length)
	{
		if(ch=='/')
			return false;
		z.num = aLong;
		z.den = 1;
		if(isNegative)
			z.num = -z.num;
		return true;
	}
	
	// now if ch='/' then aLong is actually z.num
	// and if ch is a digit, then that starts z.num, and aLong is intPart
	// anything else and we have a bad entry
	
	if(!(ch=='/' || (ch>='0' && ch<='9')))
		return false;
	
	if(ch=='/')
	{
		z.num = aLong;
	}
	else
	{
		intPart = aLong;
		// get all of z.num
		numString[j] = ch;
		j++;
		while((ch>='0' && ch<='9') && i<length)
		{
			ch = theString[i];
			i++;
			numString[j] = ch;
			j++;
		}
		numString[j] = 0;
		j = 0;
		
		// get rid of spaces
		while(ch==' ' && i<length)
		{
			ch = theString[i];
			i++;
		}
		
		// if i>=length we have either just seen a / or no / at all and have a bad entry
		if(i>=length || ch!='/')
			return false;
		
		// we have temp numerator to be modified using intPart
		sscanf(numString, "%d", &aLong);
		z.num = aLong;
	}
	
	// now ch='/', so get rid of spaces
	if(i>=length)
		return false;
	
	ch = theString[i];
	i++;
	while(ch==' ' && i<length)
	{
		ch = theString[i];
		i++;
	}
	
	// now ch must have a digit
	if(!(ch>='0' && ch<='9'))
		return false;
	
	numString[j] = ch;
	j++;
	
	// get all digits
	
	while((ch>='0' && ch<='9') && i<length)
	{
		ch = theString[i];
		i++;
		numString[j] = ch;
		j++;
	}
	numString[j] = 0;
	sscanf(numString, "%d", &aLong);
	if(aLong<=0)
		return false;
		
	z.den = aLong;
	
	if(intPart!=0)
		z.num = z.num + intPart*z.den;
	
	reduce(z.num, z.den);
	
	if(isNegative)
		z.num = -z.num;
	
	return true;
	
}/* StrToFract */
