/* gcd.cp */

/*
	Algorithm B in Knuth98, vol. 2, Sect. 4.5.2
	for greatest common divisor
*/

#include "gcd.h"

static long absL(long x)
{
	if(x<0)
		x = -x;
		
	return x;
	
}/* absL */


long gcd(long x, long y)
{
	long		g, t;
	
	x = absL(x);
	y = absL(y);
	
	g = 1;
	
	while(2*(x/2)==x && 2*(y/2)==y)
	{
		x = (x>>1);
		y = (y>>1);
		g = (g<<1);
	}
	
	// now x or y (or both) are odd
	while(x>0)
	{
		if(2*(x/2)==x)
			x = (x>>1);
		else
		{
			if(2*(y/2)==y)
				y = (y>>1);
			else
			{
				t = absL(x-y)/2;
				if(x<y)
					y = t;
				else
					x = t;
			}
		}
	}
	
	return g*y;
	
}/* gcd */
